/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao008.util.blocoh;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.spedfiscal.EnumConstSpedFiscalTpPropEstoque;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.InventarioSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedfiscal.SpedFiscalConstants;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoH {
    public List getSaldoTodosProdutos(Date dataInventario, Empresa empresa, Short tipoBuscaPlanoConta) throws ExceptionService, SpedWritterException {
        EmpresaContabilidade contabil = this.getEmpresaContabilidade(empresa);
        List result = this.findSaldoTodosProdutosProprio(dataInventario, empresa, contabil, tipoBuscaPlanoConta);
        result.addAll(this.findSaldoTodosProdutosPoderTerceiros(dataInventario, empresa, contabil, tipoBuscaPlanoConta));
        result.addAll(this.findSaldoTodosProdutosPoderInformante(dataInventario, empresa, contabil, tipoBuscaPlanoConta));
        return result;
    }

    private List findSaldoTodosProdutosProprio(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil, Short tipoBuscaPlanoConta) throws ExceptionService {
        List<SaldoEstoqueGeral> saldos = SaldoEstoqueUtilities.findSaldoProdutoLista(null, null, dataInventario, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        ArrayList<InventarioSped> dados = new ArrayList<InventarioSped>();
        Iterator<SaldoEstoqueGeral> iterator = saldos.iterator();
        while (iterator.hasNext()) {
            SaldoEstoqueGeral o;
            SaldoEstoqueGeral h = o = iterator.next();
            InventarioSped r = new InventarioSped();
            Produto p = h.getProduto();
            r.setProduto(p);
            r.setQuantidade(h.getQuantidade());
            r.setVlrItem(h.getValor());
            r.setVlrUnitario(h.getValorMedio());
            r.setIndicadorPropriedade(Short.valueOf(EnumConstSpedFiscalTpPropEstoque.ESTOQUE_PROPRIO_0.getValue()));
            if (tipoBuscaPlanoConta == SpedFiscalConstants.BUSCAR_CADASTRO_EMPRESA) {
                r.setPlanoConta(contabil.getPlanoContaEstProprio());
            } else {
                r.setPlanoConta(p.getPlanoConta());
            }
            dados.add(r);
        }
        return dados;
    }

    public List findSaldoTodosProdutosPoderTerceiros(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil, Short tipoBuscaPlanoConta) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 6, contabil, tipoBuscaPlanoConta);
    }

    private List findSaldoTodosProdutosTerc(Date dataInventario, Empresa empresa, int tpEstoque, EmpresaContabilidade contabil, Short tipoBuscaPlanoConta) throws ExceptionService, SpedWritterException {
        Session s = CoreBdUtil.getInstance().getSession();
        String sql = "select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, ip.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_propria gip on gip.id_grade_item_nota_propria = s.id_grade_item_nota_propria inner join item_nota_propria ip on ip.id_item_nota_propria = gip.id_item_nota_fiscal_propria group by s.id_pessoa, ip.id_produto  union all  select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, it.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_terceiros git on git.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros inner join item_nota_terceiros it on it.id_item_nota_terceiros = git.id_item_nota_terceiros group by s.id_pessoa, it.id_produto";
        NativeQuery q = s.createSQLQuery(sql);
        q.setDate("dataInventario", dataInventario);
        q.setInteger("empresa", empresa.getIdentificador().intValue());
        q.setInteger("tipoEstoque", tpEstoque);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<InventarioSped> dados = new ArrayList<InventarioSped>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            InventarioSped r = new InventarioSped();
            Produto produto = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getProdutoDAO(), ((Integer)h.get("ID_PRODUTO")).longValue());
            r.setProduto(produto);
            r.setQuantidade(Double.valueOf(((BigDecimal)h.get("SUM_QUANTIDADE")).doubleValue()));
            r.setVlrItem(Double.valueOf(((BigDecimal)h.get("SUM_VALOR")).doubleValue()));
            r.setVlrUnitario(Double.valueOf(((BigDecimal)h.get("VALOR_MEDIO")).doubleValue()));
            if (tpEstoque == 2) {
                if (contabil.getPlanoContaEstTercOutros() == null) {
                    throw new SpedWritterException("Primeiro cadastre uma Conta Cont\u00e1bil de Estoque de Terceiros de outros em meu poder.");
                }
                r.setIndicadorPropriedade(Short.valueOf(EnumConstSpedFiscalTpPropEstoque.EST_TERCEIROS_EM_MEU_PODER_2.getValue()));
                r.setPlanoConta(contabil.getPlanoContaEstTercOutros());
            } else {
                if (contabil.getPlanoContaEstTercMeu() == null) {
                    throw new SpedWritterException("Primeiro cadastre uma Conta Cont\u00e1bil de Estoque de Terceiros meu em poder dos outros.");
                }
                r.setIndicadorPropriedade(Short.valueOf(EnumConstSpedFiscalTpPropEstoque.EST_TERCEIROS_EM_PODER_TERCEIROS_1.getValue()));
                r.setPlanoConta(contabil.getPlanoContaEstTercMeu());
            }
            Pessoa p = (Pessoa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPessoa(), ((Integer)h.get("ID_PESSOA")).longValue());
            r.setPessoa(p);
            dados.add(r);
        }
        return dados;
    }

    private List findSaldoTodosProdutosPoderInformante(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil, Short tipoBuscaPlanoConta) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 2, contabil, tipoBuscaPlanoConta);
    }

    private EmpresaContabilidade getEmpresaContabilidade(Empresa empresa) {
        Criteria crit = CoreBdUtil.getInstance().getSession().createCriteria(EmpresaContabilidade.class);
        crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        crit.setMaxResults(1);
        return (EmpresaContabilidade)crit.uniqueResult();
    }
}

