/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao009.util.blocod;

import com.touchcomp.basementor.model.vo.CtrcCargaTransportada;
import com.touchcomp.basementor.model.vo.CtrcColetaEntrega;
import com.touchcomp.basementor.model.vo.CtrcComplConhecimento;
import com.touchcomp.basementor.model.vo.CtrcDocumentosFiscais;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao009.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao009.model2.Reg460;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.BlocoD;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.RegD100;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.RegD130;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.RegD160;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.RegD161;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.RegD162;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocod.RegD190;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoD100CTe {
    public BlocoD getBlocoD100ConhecimentosSaidaTransporte(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD100(this.getConhecimentosSaidaTransporteD100(dataIn, dataFim, emp));
        this.getLivrosFiscaisConhecimentosSaidaD100(b.getRegistrosD100());
        b.setParticipantes(this.getParticipantesConhecimentosSaidaTransporteD100(dataIn, dataFim, emp));
        b.setObsLancFiscal(new ArrayList<Reg460>());
        return b;
    }

    private List getConhecimentosSaidaTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  c.identificador as identificador, c.modeloDocFiscal.codigo as codModDocFiscal, c.situacaoDocumento.codigo as sitDoc, c.clienteTomador.cliente.pessoa.identificador as idPessoa, c.serie as serie, c.numero as numeroCte, c.chaveCte as chaveCte, c.dataEmissao as dataEmissao, tc.codigo as codTipoCte, c.indicadorTipoFrete as indTipoFrete, c.cteVlrImpostos.baseCalcIcms as bcIcms, c.cteVlrImpostos.vrIcms as vrIcms, c.cteVlrImpostos.percRedBaseCalcIcms as vrNaoTributado, c.cteVlrImpostos.vrReceber as valorTotal, c.cteVlrImpostos.vrDesconto as valorDesconto, lv.planoConta.identificador as planoConta from Cte c  left join c.tipoCte tc left join c.livrosFiscais lv where  (c.modeloDocFiscal.codigo=:cod1 or c.modeloDocFiscal.codigo=:cod2) and (cast(c.dataEmissao as date)) between :dataIn and :dataFim and c.empresa=:empresa");
        q.setString("cod1", "57");
        q.setString("cod2", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD100> toRet = new ArrayList<RegD100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD100 r = new RegD100();
            r.setNumeroDoc((Long)h.get("numeroCte"));
            System.out.println("\n\nNr CTRC: " + r.getNumeroDoc().toString());
            r.setChaveNfe((String)h.get("chaveCte"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEmissao"));
            Short tipo = (Short)h.get("codTipoCte");
            if (tipo != null) {
                r.setCodTipoCTe(tipo.toString());
            }
            if ((Short)h.get("indTipoFrete") != null) {
                r.setIndicadorTipoFrete((Short)h.get("indTipoFrete"));
            } else {
                r.setIndicadorTipoFrete((short)9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorBCIcms((double)((Double)h.get("bcIcms")));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorICMS((double)((Double)h.get("vrIcms")));
            r.setValorDoc((double)((Double)h.get("valorTotal")));
            r.setValorTotMercadorias((double)((Double)h.get("valorTotal")));
            r.setIdentificador((Long)h.get("identificador"));
            Long planoConta = (Long)h.get("planoConta");
            r.setPlanoConta(planoConta);
            if (r.getCodModDocFiscal().equals("08")) {
                r.setRegistrosD130(this.getComplConhecimentos(r.getIdentificador()));
                r.setRegistrosD160(this.getCargaTransportada(r.getIdentificador()));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD130> getComplConhecimentos(Long idCte) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  c.ctrc.complConhecimento from Cte c  where   c.identificador = :idCte");
        q.setLong("idCte", idCte.longValue());
        List ret = q.list();
        ArrayList<RegD130> toRet = new ArrayList<RegD130>();
        for (Object o : ret) {
            CtrcComplConhecimento c = (CtrcComplConhecimento)o;
            RegD130 r = new RegD130();
            r.setComplConhecimento(c);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD160> getCargaTransportada(Long idCte) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  c.ctrc.cargaTransportada from Cte c  where   c.identificador = :idCte");
        q.setLong("idCte", idCte.longValue());
        List ret = q.list();
        ArrayList<RegD160> toRet = new ArrayList<RegD160>();
        for (Object o : ret) {
            CtrcCargaTransportada c = (CtrcCargaTransportada)o;
            RegD160 r = new RegD160();
            r.setCargaTransportada(c);
            r.setRegistroD161(this.getColetaEntregaD161(c.getCtrcColetaEntrega()));
            r.setRegistrosD162(this.getDocFisais(c.getCtrcDocFiscais()));
            toRet.add(r);
        }
        return toRet;
    }

    private RegD161 getColetaEntregaD161(CtrcColetaEntrega c) {
        RegD161 r = new RegD161();
        r.setColetaEntrega(c);
        return r;
    }

    private List<RegD162> getDocFisais(List<CtrcDocumentosFiscais> docFiscais) {
        ArrayList<RegD162> toRet = new ArrayList<RegD162>();
        Iterator<CtrcDocumentosFiscais> iterator = docFiscais.iterator();
        while (iterator.hasNext()) {
            CtrcDocumentosFiscais o;
            CtrcDocumentosFiscais c = o = iterator.next();
            RegD162 r = new RegD162();
            r.setDocFiscais(c);
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisConhecimentosSaidaD100(List<RegD100> registrosD100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegD100> iterator = registrosD100.iterator();
        while (iterator.hasNext()) {
            RegD100 o;
            RegD100 regD100 = o = iterator.next();
            Long idNota = regD100.getIdentificador();
            System.out.println("\nLIVRO FISCAL REFERENTE AO CTRC ID: " + idNota + "\n");
            Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcmsIsento) as valorIcmsIsento,  sum(lv.valorIcmsOutros) as valorIcmsOutros, sum(lv.valorIcms) as valorIcms, sum(lv.vrNaoTribIcms) as valorNaoTribIcms from Cte n inner join n.livrosFiscais lv where n.identificador  = :idNota and (n.situacaoDocumento.codigo != :cod2 and n.situacaoDocumento.codigo != :cod3 and n.situacaoDocumento.codigo != :cod4 and n.situacaoDocumento.codigo != :cod5) group by lv.incidenciaIcms.codigo, lv.cfop.codigo,lv.aliquotaIcms");
            q.setLong("idNota", idNota.longValue());
            q.setString("cod2", "02");
            q.setString("cod3", "03");
            q.setString("cod4", "04");
            q.setString("cod5", "05");
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegD190> toRet = new ArrayList<RegD190>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegD190 r = new RegD190();
                r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
                r.setCfop((String)h.get("cfop"));
                r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
                r.setValorOperacao((Double)h.get("valorTotal"));
                r.setBcCalculoIcms((Double)h.get("valorIcmsTributado") + (Double)h.get("valorIcmsIsento") + (Double)h.get("valorIcmsOutros"));
                r.setValorIcms((Double)h.get("valorIcms"));
                r.setValorNaoTribIcms((Double)h.get("valorNaoTribIcms"));
                toRet.add(r);
            }
            regD100.setLivrosFiscais(toRet);
        }
    }

    private List getParticipantesConhecimentosSaidaTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from Cte n  inner join n.clienteTomador u inner join u.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2) and (cast(n.dataEmissao as date)) between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "57");
        q.setString("cod2", "08");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }
}

