/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao009.util.blocok;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.indicadorestoquesped.ConstEnumIndicadorEstoqueSped;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueEscrituradoSped;
import com.touchcomp.basementor.model.vo.IndicadorEstoqueSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementorservice.service.impl.indicadorestoquesped.ServiceIndicadorEstoqueSpedImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocok.BlocoK;
import mentorcore.service.impl.spedfiscal.versao009.model2.blocok.RegK200;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoK {
    public BlocoK getBlocoK230(Empresa empresa, Date dataInicial, Date dataFinal) {
        BlocoK blocoK = new BlocoK();
        blocoK.setRegK200(this.getRegistrosBlocoK230(empresa, dataInicial, dataFinal));
        return null;
    }

    private List<RegK200> getRegistrosBlocoK230(Empresa empresa, Date dataInicial, Date dataFinal) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List getSaldoTodosProdutos(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        List result = this.findSaldoTodosProdutosProprio(dataInventario, empresa);
        result.addAll(this.findSaldoTodosProdutosPoderTerceiros(dataInventario, empresa));
        result.addAll(this.findSaldoTodosProdutosPoderInformante(dataInventario, empresa));
        return result;
    }

    private List findSaldoTodosProdutosProprio(Date dataEstoque, Empresa empresa) throws ExceptionService {
        List<SaldoEstoqueGeral> saldos = SaldoEstoqueUtilities.findSaldoProdutoLista(null, null, dataEstoque, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        ArrayList<EstoqueEscrituradoSped> dados = new ArrayList<EstoqueEscrituradoSped>();
        for (SaldoEstoqueGeral o : saldos) {
            SaldoEstoqueGeral h = o;
            Produto p = h.getProduto();
            if (!this.validarTipoItemSped(p)) continue;
            EstoqueEscrituradoSped r = new EstoqueEscrituradoSped();
            r.setProduto(p);
            r.setQuantidade(h.getQuantidade());
            r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_PROPRIO));
            dados.add(r);
        }
        return dados;
    }

    private IndicadorEstoqueSped getIndicadorSped(ConstEnumIndicadorEstoqueSped tipo) {
        ServiceIndicadorEstoqueSpedImpl serv = (ServiceIndicadorEstoqueSpedImpl)ConfApplicationContext.getBean(ServiceIndicadorEstoqueSpedImpl.class);
        return serv.get(tipo);
    }

    public List findSaldoTodosProdutosPoderTerceiros(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 6);
    }

    private List findSaldoTodosProdutosPoderInformante(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 2);
    }

    private List findSaldoTodosProdutosTerc(Date dataEstoque, Empresa empresa, int tpEstoque) throws ExceptionService, SpedWritterException {
        Session s = CoreBdUtil.getInstance().getSession();
        String sql = "select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, ip.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_propria gip on gip.id_grade_item_nota_propria = s.id_grade_item_nota_propria inner join item_nota_propria ip on ip.id_item_nota_propria = gip.id_item_nota_fiscal_propria group by s.id_pessoa, ip.id_produto  union all  select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, it.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_terceiros git on git.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros inner join item_nota_terceiros it on it.id_item_nota_terceiros = git.id_item_nota_terceiros group by s.id_pessoa, it.id_produto";
        NativeQuery q = s.createSQLQuery(sql);
        q.setDate("dataInventario", dataEstoque);
        q.setInteger("empresa", empresa.getIdentificador().intValue());
        q.setInteger("tipoEstoque", tpEstoque);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<EstoqueEscrituradoSped> dados = new ArrayList<EstoqueEscrituradoSped>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            Produto produto = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getProdutoDAO(), ((Integer)h.get("ID_PRODUTO")).longValue());
            if (!this.validarTipoItemSped(produto)) continue;
            EstoqueEscrituradoSped r = new EstoqueEscrituradoSped();
            r.setProduto(produto);
            r.setQuantidade(Double.valueOf(((BigDecimal)h.get("SUM_QUANTIDADE")).doubleValue()));
            if (tpEstoque == 2) {
                r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_TERCEIROS_EM_MEU_PODER));
            } else {
                r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_PROPRIO_EM_PODER_TERCEIROS));
            }
            Pessoa p = (Pessoa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPessoa(), ((Integer)h.get("ID_PESSOA")).longValue());
            r.setPessoa(p);
            dados.add(r);
        }
        return dados;
    }

    private boolean validarTipoItemSped(Produto p) {
        return p.getTipoIemSped() != null && (p.getTipoIemSped().getCodigo().equals("00") || p.getTipoIemSped().getCodigo().equals("01") || p.getTipoIemSped().getCodigo().equals("02") || p.getTipoIemSped().getCodigo().equals("03") || p.getTipoIemSped().getCodigo().equals("04") || p.getTipoIemSped().getCodigo().equals("05") || p.getTipoIemSped().getCodigo().equals("10"));
    }

    public BlocoK getBlocoK230(SpedFiscal vo) {
        String hql = "select c.from ComunicadoProducao c  inner join c.eventoOsProducao e  where e.dataFechamento <= :dataFinal";
        return null;
    }
}

