/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao010.util.blocok;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.indicadorestoquesped.ConstEnumIndicadorEstoqueSped;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueEscrituradoSped;
import com.touchcomp.basementor.model.vo.IndicadorEstoqueSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.service.impl.indicadorestoquesped.ServiceIndicadorEstoqueSpedImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import mentorcore.service.impl.spedfiscal.versao010.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao010.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao010.model2.Reg210;
import mentorcore.service.impl.spedfiscal.versao010.model2.blocok.BlocoK;
import mentorcore.service.impl.spedfiscal.versao010.model2.blocok.RegK230;
import mentorcore.service.impl.spedfiscal.versao010.model2.blocok.RegK235;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoK {
    public BlocoK getBlocoK230(Empresa empresa, Date dataInicial, Date dataFinal, Short agruparComunicado) {
        BlocoK blocoK = new BlocoK();
        if (agruparComunicado != null && agruparComunicado.equals((short)1)) {
            blocoK.setRegK230(this.getRegistrosBlocoK230AndK235Agrupados(empresa, dataInicial, dataFinal));
        } else {
            blocoK.setRegK230(this.getRegistrosBlocoK230AndK235NaoAgrupados(empresa, dataInicial, dataFinal));
        }
        if (blocoK.getRegK230() != null && !blocoK.getRegK230().isEmpty()) {
            blocoK.getProdutos().addAll(this.getProdutosBlocoK230(empresa, dataInicial, dataFinal));
            blocoK.getProdutosConsumo().addAll(this.getProdutosBlocoK235(empresa, dataInicial, dataFinal));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasBlocoK230(dataInicial, dataFinal, empresa));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasBlocoK235(dataInicial, dataFinal, empresa));
        }
        return blocoK;
    }

    private List<RegK230> getRegistrosBlocoK230AndK235Agrupados(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  sum(i.quantidadeTotal) as QUANTIDADE  from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado)  group by i.produto.identificador";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK230> result = new ArrayList<RegK230>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK230 r = new RegK230();
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setQtdeProducaoAcabada((Double)h.get("QUANTIDADE"));
            r.setRegK235(this.getRegistrosBlocoK235Agrupados(r.getIdProduto(), dataInicial, dataFinal, empresa));
            result.add(r);
        }
        return result;
    }

    private List<RegK235> getRegistrosBlocoK235Agrupados(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produtoSubstituto.identificador as ID_PRODUTO_SUBSTITUTO,  sum(g.quantidade) as QUANTIDADE  from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  and  (ic.produto.tipoIemSped.codigo = :produtoEmProcesso or       ic.produto.tipoIemSped.codigo = :produtoAcabado)  group by      i.produto.identificador,      i.produtoSubstituto.identificador ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK235> result = new ArrayList<RegK235>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK235 r = new RegK235();
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setQtdeConsumida((Double)h.get("QUANTIDADE"));
            r.setIdProdutoSubstituto((Long)h.get("ID_PRODUTO_SUBSTITUTO"));
            r.setDataSaida(dataFinal);
            result.add(r);
        }
        return result;
    }

    public List getSaldoTodosProdutos(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        List result = this.findSaldoTodosProdutosProprio(dataInventario, empresa);
        result.addAll(this.findSaldoTodosProdutosPoderTerceiros(dataInventario, empresa));
        result.addAll(this.findSaldoTodosProdutosPoderInformante(dataInventario, empresa));
        return result;
    }

    private List findSaldoTodosProdutosProprio(Date dataEstoque, Empresa empresa) throws ExceptionService {
        List<SaldoEstoqueGeral> saldos = SaldoEstoqueUtilities.findSaldoProdutoLista(null, null, dataEstoque, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        ArrayList<EstoqueEscrituradoSped> dados = new ArrayList<EstoqueEscrituradoSped>();
        for (SaldoEstoqueGeral o : saldos) {
            SaldoEstoqueGeral h = o;
            Produto p = h.getGradeCor().getProdutoGrade().getProduto();
            if (!this.validarTipoItemSped(p)) continue;
            EstoqueEscrituradoSped r = new EstoqueEscrituradoSped();
            r.setProduto(p);
            r.setQuantidade(h.getQuantidade());
            r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_PROPRIO));
            dados.add(r);
        }
        return dados;
    }

    private IndicadorEstoqueSped getIndicadorSped(ConstEnumIndicadorEstoqueSped tipo) {
        ServiceIndicadorEstoqueSpedImpl serv = (ServiceIndicadorEstoqueSpedImpl)ConfApplicationContext.getBean(ServiceIndicadorEstoqueSpedImpl.class);
        return serv.get(tipo);
    }

    public List findSaldoTodosProdutosPoderTerceiros(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 6);
    }

    private List findSaldoTodosProdutosPoderInformante(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 2);
    }

    private List findSaldoTodosProdutosTerc(Date dataEstoque, Empresa empresa, int tpEstoque) throws ExceptionService, SpedWritterException {
        Session s = CoreBdUtil.getInstance().getSession();
        String sql = "select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, ip.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_propria gip on gip.id_grade_item_nota_propria = s.id_grade_item_nota_propria inner join item_nota_propria ip on ip.id_item_nota_propria = gip.id_item_nota_fiscal_propria group by s.id_pessoa, ip.id_produto  union all  select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, it.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_terceiros git on git.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros inner join item_nota_terceiros it on it.id_item_nota_terceiros = git.id_item_nota_terceiros group by s.id_pessoa, it.id_produto";
        NativeQuery q = s.createSQLQuery(sql);
        q.setDate("dataInventario", dataEstoque);
        q.setInteger("empresa", empresa.getIdentificador().intValue());
        q.setInteger("tipoEstoque", tpEstoque);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<EstoqueEscrituradoSped> dados = new ArrayList<EstoqueEscrituradoSped>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            Produto produto = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getProdutoDAO(), ((Integer)h.get("ID_PRODUTO")).longValue());
            if (!this.validarTipoItemSped(produto)) continue;
            EstoqueEscrituradoSped r = new EstoqueEscrituradoSped();
            r.setProduto(produto);
            r.setQuantidade(Double.valueOf(((BigDecimal)h.get("SUM_QUANTIDADE")).doubleValue()));
            if (tpEstoque == 2) {
                r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_TERCEIROS_EM_MEU_PODER));
            } else {
                r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_PROPRIO_EM_PODER_TERCEIROS));
            }
            Pessoa p = (Pessoa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPessoa(), ((Integer)h.get("ID_PESSOA")).longValue());
            r.setPessoa(p);
            dados.add(r);
        }
        return dados;
    }

    private boolean validarTipoItemSped(Produto p) {
        return p.getTipoIemSped() != null && (p.getTipoIemSped().getCodigo().equals("00") || p.getTipoIemSped().getCodigo().equals("01") || p.getTipoIemSped().getCodigo().equals("02") || p.getTipoIemSped().getCodigo().equals("03") || p.getTipoIemSped().getCodigo().equals("04") || p.getTipoIemSped().getCodigo().equals("05") || p.getTipoIemSped().getCodigo().equals("10"));
    }

    private List<Reg200> getProdutosBlocoK230(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from ItemComunicadoProducao i  left  join i.produto.ncm nc left  join i.produto.genero g inner join i.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            r.getConsumosEspecificosPadronizados().add(this.getRegistro0210(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosBlocoK235(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select distinct  ir.produto.identificador as idProduto, ir.produto.nome as nomeProduto, ir.produto.unidadeMedida.sigla as unidadeMedida, ir.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, ir.produto.aliquotaIcms as aliquotaIcms from ItemRequisicao ir  left  join ir.produto.ncm nc left  join ir.produto.genero g inner join ir.requisicao r inner join r.itemComunicadoProducao ic inner join ic.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa  and (ir.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      ir.produto.tipoIemSped.codigo = :materiaPrima or      ir.produto.tipoIemSped.codigo = :embalagem or      ir.produto.tipoIemSped.codigo = :produtoEmProcesso or      ir.produto.tipoIemSped.codigo = :produtoAcabado or      ir.produto.tipoIemSped.codigo = :subProduto or      ir.produto.tipoIemSped.codigo = :outrosInsumos)  and  (ic.produto.tipoIemSped.codigo = :produtoEmProcesso or       ic.produto.tipoIemSped.codigo = :produtoAcabado)";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            r.getConsumosEspecificosPadronizados().add(this.getRegistro0210(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private List<Reg190> getUnidMedidasBlocoK230(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasBlocoK235(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from ItemRequisicao i inner join i.requisicao r inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos) ");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private Reg210 getRegistro0210(Long idProduto) {
        Reg210 r = new Reg210();
        r.setIdProduto(idProduto);
        r.setQtdeComponente(1.0);
        return r;
    }

    private Collection<? extends Reg210> getProdutosConsumoBlocoK(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select distinct  ir.produto.identificador as idProduto, ic.produto.identificador as idProdutoPai  from ItemRequisicao ir  left  join ir.produto.ncm nc left  join ir.produto.genero g inner join ir.requisicao r inner join r.itemComunicadoProducao ic inner join ic.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa  and (ir.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      ir.produto.tipoIemSped.codigo = :materiaPrima or      ir.produto.tipoIemSped.codigo = :embalagem or      ir.produto.tipoIemSped.codigo = :produtoEmProcesso or      ir.produto.tipoIemSped.codigo = :produtoAcabado or      ir.produto.tipoIemSped.codigo = :subProduto or      ir.produto.tipoIemSped.codigo = :outrosInsumos) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg210> toRet = new ArrayList<Reg210>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg210 r = new Reg210();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setIdProdutoPai((Long)h.get("idProdutoPai"));
            r.setQtdeComponente(1.0);
            r.setQtdePerda(0.0);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegK230> getRegistrosBlocoK230AndK235NaoAgrupados(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.quantidadeTotal as QUANTIDADE,  c.identificador as ID_COMUNICADO, c.dataEntradaSaida as DATA_INICIAL, c.dataFinal as DATA_FINAL from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and (c.dataFinal is null or c.dataFinal between :dataInicial and :dataFinal) and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK230> result = new ArrayList<RegK230>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK230 r = new RegK230();
            r.setDataInicialOP((Date)h.get("DATA_INICIAL"));
            r.setDataFinalOP((Date)h.get("DATA_FINAL"));
            r.setCodIdentificacaoOP((Long)h.get("ID_COMUNICADO"));
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setQtdeProducaoAcabada((Double)h.get("QUANTIDADE"));
            r.setRegK235(this.getRegistrosBlocoK235NaoAgrupados(r.getIdProduto(), dataInicial, dataFinal, empresa, r.getCodIdentificacaoOP()));
            result.add(r);
        }
        return result;
    }

    private List<RegK235> getRegistrosBlocoK235NaoAgrupados(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa, Long idComunicado) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produtoSubstituto.identificador as ID_PRODUTO_SUBSTITUTO,  sum(g.quantidade) as QUANTIDADE, r.dataRequisicao as DATA_REQUISICAO  from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and c.identificador = :idComunicado  and r.dataRequisicao  between :dataInicial and :dataFinal and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  group by      i.produto.identificador,      i.produtoSubstituto.identificador,     r.dataRequisicao ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setLong("idComunicado", idComunicado.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK235> result = new ArrayList<RegK235>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK235 r = new RegK235();
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setQtdeConsumida((Double)h.get("QUANTIDADE"));
            r.setIdProdutoSubstituto((Long)h.get("ID_PRODUTO_SUBSTITUTO"));
            r.setDataSaida((Date)h.get("DATA_REQUISICAO"));
            result.add(r);
        }
        return result;
    }
}

