/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao012.util.bloco1;

import com.touchcomp.basementor.model.vo.AjustesSubApuracaoICMS;
import com.touchcomp.basementor.model.vo.ApuracaoICMS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObrigSubApuracaoIcms;
import com.touchcomp.basementor.model.vo.SubApuracaoICMS;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao012.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Reg1600;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Reg1900;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Reg1910;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Reg1920;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Reg1921;
import mentorcore.service.impl.spedfiscal.versao012.model2.bloco1.Reg1926;
import mentorcore.service.impl.spedfiscal.versao012.util.blocoe.UtilBDSpedFiscalBlocoE;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1 {
    public Bloco1 getReg1600(Date dataIn, Date dataFim, Empresa emp) {
        Bloco1 bloco1 = new Bloco1();
        bloco1.setReg1600(this.getVendasCartaoCredDebReg1600(dataIn, dataFim, emp));
        bloco1.setParticipantes(this.getParticipantesCartaoCredDeb1600(dataIn, dataFim, emp));
        return bloco1;
    }

    private List<Reg1600> getVendasCartaoCredDebReg1600(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p.formasPagCupomFiscal.pessoa.identificador as ID_PESSOA,  sum(p.valor) as VALOR, p.formasPagCupomFiscal.tipoPagamento.codigo as TIPO_CARTAO from PagamentoCupomFiscal p  where p.cupom.dataMovimentacao between :dataIn and :dataFim and p.cupom.empresa  = :empresa and (p.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoDebito or p.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoCredito) group by p.formasPagCupomFiscal.pessoa.identificador, p.formasPagCupomFiscal.tipoPagamento.codigo");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tipoCartaoDebito", (short)2);
        q.setShort("tipoCartaoCredito", (short)6);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1600> aux = new ArrayList<Reg1600>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Reg1600 r = new Reg1600();
            r.setIdParticipante((Long)h.get("ID_PESSOA"));
            Short tipoCartao = (Short)h.get("TIPO_CARTAO");
            if (tipoCartao.equals((short)6)) {
                r.setTotalCredito((Double)h.get("VALOR"));
                r.setTotalDebito(0.0);
            } else {
                r.setTotalDebito((Double)h.get("VALOR"));
                r.setTotalCredito(0.0);
            }
            aux.add(r);
        }
        return aux;
    }

    private List<Reg150> getParticipantesCartaoCredDeb1600(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from PagamentoCupomFiscal pag inner join pag.formasPagCupomFiscal f inner join f.pessoa p  where pag.cupom.dataMovimentacao between :dataIn and :dataFim and pag.cupom.empresa  = :empresa and (pag.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoDebito or pag.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoCredito)");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tipoCartaoDebito", (short)2);
        q.setShort("tipoCartaoCredito", (short)6);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    public Bloco1 getReg1900(Date dataIn, Date dataFim, Empresa emp) {
        Bloco1 bloco1 = new Bloco1();
        List apuracoesIcms = new UtilBDSpedFiscalBlocoE().getApuracoesIcms(dataIn, dataFim, emp);
        for (Object o : apuracoesIcms) {
            ApuracaoICMS ap = (ApuracaoICMS)o;
            for (SubApuracaoICMS s : ap.getSubApuracao()) {
                bloco1.getReg1900().add(this.getBloco1900(s, dataIn, dataFim));
            }
        }
        return bloco1;
    }

    private Reg1900 getBloco1900(SubApuracaoICMS s, Date dataIn, Date dataFim) {
        Reg1900 r = new Reg1900();
        r.setIndicadorApuracao(this.getIndicadorSubApuracao(s));
        r.setDescricaoComplementar(s.getDescricao());
        r.getRegistros1910().add(this.getBloco1910(s, dataIn, dataFim));
        return r;
    }

    private Short getIndicadorSubApuracao(SubApuracaoICMS s) {
        if (s.getIndicadorSubApuracao().equals((short)1)) {
            return (short)3;
        }
        if (s.getIndicadorSubApuracao().equals((short)2)) {
            return (short)4;
        }
        if (s.getIndicadorSubApuracao().equals((short)3)) {
            return (short)5;
        }
        if (s.getIndicadorSubApuracao().equals((short)4)) {
            return (short)6;
        }
        if (s.getIndicadorSubApuracao().equals((short)5)) {
            return (short)7;
        }
        if (s.getIndicadorSubApuracao().equals((short)6)) {
            return (short)8;
        }
        return null;
    }

    private Reg1910 getBloco1910(SubApuracaoICMS s, Date dataIn, Date dataFim) {
        Reg1910 r = new Reg1910();
        r.setDataInicial(dataIn);
        r.setDataFinal(dataFim);
        r.getRegistros1920().add(this.getBloco1920(s));
        return r;
    }

    private Reg1920 getBloco1920(SubApuracaoICMS s) {
        Reg1920 r = new Reg1920();
        r.setValorAjustesCreditos(s.getValorAjustesCreditos());
        r.setValorAjustesDebitos(s.getValorAjustesDebitos());
        r.setValorAjustesEstornosCreditos(s.getValorAjustesEstornosCreditos());
        r.setValorAjustesEstornosDebitos(s.getValorAjustesEstornosDebitos());
        r.setValorCreditosEntrada(s.getValorCreditosEntrada());
        r.setValorDebitosSaida(s.getValorDebitosSaida());
        r.setValorDeducoes(s.getValorDeducoes());
        r.setValorIcmsRecolher(s.getValorIcmsRecolher());
        r.setValorRecolherExtraApuracao(s.getValorRecolherExtraApuracao());
        r.setValorSaldoCredorPeriodoAnterior(s.getValorSaldoCredorPeriodoAnterior());
        r.setValorSaldoCredorTransportar(s.getValorSaldoCredorTransportar());
        r.setValorSaldoDevedor(s.getValorSaldoDevedor());
        r.setRegistros1921(this.getBloco1921(s.getAjustes()));
        r.setRegistros1926(this.getBloco1926(s.getObrigacoes()));
        return r;
    }

    private List<Reg1921> getBloco1921(List<AjustesSubApuracaoICMS> ajustes) {
        ArrayList<Reg1921> lista = new ArrayList<Reg1921>();
        for (AjustesSubApuracaoICMS a : ajustes) {
            Reg1921 r = new Reg1921();
            r.setCodAjuste(a.getTipoAjusteApIcms().getCodigo());
            r.setDescricao(a.getDescricaoCompl());
            r.setValor(a.getValorAjuste());
            lista.add(r);
        }
        return lista;
    }

    private List<Reg1926> getBloco1926(List<ObrigSubApuracaoIcms> obrigacoes) {
        ArrayList<Reg1926> lista = new ArrayList<Reg1926>();
        for (ObrigSubApuracaoIcms o : obrigacoes) {
            Reg1926 r = new Reg1926();
            r.setCodObrigacaoRecolher(o.getObriIcmsRecolher().getCodigo());
            r.setCodigoReceita(o.getCodigoRecolhimento());
            r.setDataVencimento(o.getDataVencimento());
            r.setValor(o.getValor());
            if (o.getProcessoFiscal() != null) {
                r.setNumeroProcesso(o.getProcessoFiscal().getNrProcesso());
                r.setIndicadorProcesso(o.getProcessoFiscal().getTipoProcesso().getCodigo());
                r.setDescricaoProcesso(o.getProcessoFiscal().getDescricao());
            }
            r.setPeriodo(o.getPeriodo());
            r.setDescricaoComplementar(o.getDescricaoComplementar());
            lista.add(r);
        }
        return lista;
    }
}

