/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao012.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao012.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao012.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC400;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC405;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC410;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC420;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC425;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC460;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC470;
import mentorcore.service.impl.spedfiscal.versao012.model2.blococ.RegC490;
import mentorcore.tools.ClearUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC400CupomFiscal {
    public BlocoC getBlocoC400CuponsFiscais(Empresa emp, Date dataIn, Date dataFim, char perfil) {
        BlocoC b = new BlocoC();
        b.setRegistrosC400(this.getEquipamentosFiscaisBlocoC400(dataIn, dataFim, emp));
        if (b.getRegistrosC400() != null && !b.getRegistrosC400().isEmpty()) {
            this.getReducoesZBlocoC405(b.getRegistrosC400(), dataIn, dataFim, emp, perfil);
            b.setProdutos(this.getProdutosCuponsFiscaisBlocoC400(dataIn, dataFim, emp));
            b.setUnidMedidas(this.getUnidMedidasCuponsFiscaisBlocoC400(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegC400> getEquipamentosFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c.modeloDocFiscal.codigo as codModDocFiscal, c.cupom.impressoraFiscal.modeloEcf as modeloImpressora, c.cupom.impressoraFiscal.serie as serieImpressora, c.cupom.impressoraFiscal.identificador as idImpressora from CupomFiscal c where c.cupom.dataEmissao between :dataIn and :dataFim  and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and c.cupom.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC400> toRet = new ArrayList<RegC400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC400 r = new RegC400();
            r.setModeloDocFiscal((String)h.get("codModDocFiscal"));
            r.setModeloECF((String)h.get("modeloImpressora"));
            r.setSerieECF((String)h.get("serieImpressora"));
            r.setIdImpressora((Long)h.get("idImpressora"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getReducoesZBlocoC405(List<RegC400> registrosC400, Date dataIn, Date dataFim, Empresa emp, char perfil) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC400> iterator = registrosC400.iterator();
        while (iterator.hasNext()) {
            RegC400 o;
            RegC400 r = o = iterator.next();
            Long idImpressora = r.getIdImpressora();
            Query q = s.createQuery("select distinct p.dataEmissao as dataEmissao, p.contadorReinicio as contadorReinicio,  p.contadorCRZ as contadorCRZ,  p.ultimoCOO as ultimoCOO, p.valorTotalGeral as valorTotal, p.valorVendaBruta as valorVendaBruta, p.identificador as idReducaoZ,  p.valorCancelamentoICMS as vrCanc, p.valorDescontoICMS as vrDesc, p.valorAcrescimoICMS as vrAcres from ReducaoZ p where p.dataEmissao between :dataIn and :dataFim and p.empresa=:empresa and p.impressoraFiscal.identificador = :idImpressora");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setLong("idImpressora", idImpressora.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegC405> toRet = new ArrayList<RegC405>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegC405 rC405 = new RegC405();
                rC405.setDataMovimento((Date)h.get("dataEmissao"));
                rC405.setContadorCRZ((Long)h.get("contadorCRZ"));
                rC405.setUltimoCOO((Long)h.get("ultimoCOO"));
                rC405.setContadorReinicio((Long)h.get("contadorReinicio"));
                rC405.setValorTotalGeral((Double)h.get("valorTotal"));
                rC405.setValorVendaBruta((Double)h.get("valorVendaBruta"));
                rC405.setIdReducaoZ((Long)h.get("idReducaoZ"));
                rC405.setVrCancelamentoIcms((Double)h.get("vrCanc"));
                rC405.setVrDescontoIcms((Double)h.get("vrDesc"));
                rC405.setVrAcrescimoIcms((Double)h.get("vrAcres"));
                if (rC405.getValorVendaBruta() > 0.0) {
                    this.getPisCofinsRegC410(rC405);
                }
                this.getTotalizadoresParciaisRegC420(rC405, idImpressora, emp, perfil);
                if (perfil == 'A') {
                    this.getCuponsFiscaisRegC460(rC405, idImpressora, emp);
                }
                this.getLivrosFiscaisRegC490(rC405);
                toRet.add(rC405);
            }
            r.setReducoes(toRet);
        }
    }

    private void getPisCofinsRegC410(RegC405 rC405) {
        block0: {
            Session s = CoreBdUtil.getInstance().getSession();
            Long idReducaoZ = rC405.getIdReducaoZ();
            Query q = s.createQuery("select sum(lv.valorPis) as valorPis, sum(lv.valorCofins) as valorCofins from ReducaoZ p  inner join p.livrosFiscais lv where p.identificador = :idReducaoZ");
            q.setLong("idReducaoZ", idReducaoZ.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            Iterator iterator = ret.iterator();
            if (!iterator.hasNext()) break block0;
            Object ob = iterator.next();
            HashMap h = (HashMap)ob;
            RegC410 r = new RegC410();
            r.setVrPis((Double)h.get("valorPis"));
            r.setVrCofins((Double)h.get("valorCofins"));
            rC405.setPisCofins(r);
        }
    }

    private void getTotalizadoresParciaisRegC420(RegC405 r, Long idImpressora, Empresa emp, char perfil) {
        RegC420 reg;
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select i.aliquotaICMS as ALIQUOTA_ICMS, i.tipoTributacaoItemCPFiscal.sigla as SIGLA, sum(i.valorFinal) as VALOR_TOTAL  from ItemCupomFiscal i  where i.cupomFiscal.cupom.impressoraFiscal.identificador = :impressora  and i.cupomFiscal.cupom.dataEmissao = :dataReducao and i.cupomFiscal.cupom.empresa = :empresa and i.cancelado = :cancelado  and i.cupomFiscal.cancelado= :cancelado  group by i.aliquotaICMS, i.tipoTributacaoItemCPFiscal.sigla");
        q.setDate("dataReducao", r.getDataMovimento());
        q.setLong("impressora", idImpressora.longValue());
        q.setEntity("empresa", (Object)emp);
        q.setInteger("cancelado", 0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC420> toRet = new ArrayList<RegC420>();
        int total = 1;
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Double aliq = (Double)h.get("ALIQUOTA_ICMS");
            Double vrTotal = (Double)h.get("VALOR_TOTAL");
            String tribItem = (String)h.get("SIGLA");
            String aliqIcms = aliq.toString();
            RegC420 rC420 = new RegC420();
            if (tribItem.equalsIgnoreCase("TT")) {
                if (aliqIcms.length() <= 3) {
                    rC420.setCodigoTotalizador(ToolString.completaZeros((String)String.valueOf(total), (int)2, (boolean)true) + "T0" + ToolString.completaZeros((String)ClearUtil.refinaAll(aliqIcms), (int)3));
                } else {
                    rC420.setCodigoTotalizador(ToolString.completaZeros((String)String.valueOf(total), (int)2, (boolean)true) + "T" + ToolString.completaZeros((String)ClearUtil.refinaAll(aliqIcms), (int)4));
                }
                rC420.setValor(vrTotal);
                rC420.setNrTotalizador("0" + total);
                rC420.setDescricao("Tributado " + aliqIcms + "%");
                ++total;
            } else {
                rC420.setCodigoTotalizador(tribItem.substring(0, 1) + "1");
                rC420.setValor(vrTotal);
            }
            if (perfil == 'B') {
                rC420.setItens(this.getResumoItensRegC420(r.getDataMovimento(), idImpressora, emp, tribItem, aliq));
            }
            toRet.add(rC420);
        }
        if (r.getVrCancelamentoIcms() != null && r.getVrCancelamentoIcms() > 0.0) {
            reg = new RegC420();
            reg.setCodigoTotalizador("Can-T");
            reg.setValor(r.getVrCancelamentoIcms());
            toRet.add(reg);
        }
        if (r.getVrDescontoIcms() != null && r.getVrDescontoIcms() > 0.0) {
            reg = new RegC420();
            reg.setCodigoTotalizador("DT");
            reg.setValor(r.getVrDescontoIcms());
            toRet.add(reg);
        }
        if (r.getVrAcrescimoIcms() != null && r.getVrAcrescimoIcms() > 0.0) {
            reg = new RegC420();
            reg.setCodigoTotalizador("AT");
            reg.setValor(r.getVrAcrescimoIcms());
            toRet.add(reg);
        }
        r.setTotalizadoresParciais(toRet);
    }

    private void getCuponsFiscaisRegC460(RegC405 rC405, Long idImpressora, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  c.identificador as idCupomFiscal,  c.cupom.nrCOO as nrCupom, c.modeloDocFiscal.codigo as codModeloDocFiscal, c.cancelado as cancelado, c.cupom.dataEmissao as dataEmissao, c.valorTotal as valorTotal, c.valorPis as vrPis, c.valorCofins as vrCofins, c.cpfCliente as cpfCliente, c.nomeCliente as nomeCliente  from CupomFiscal c where c.cupom.dataEmissao = :dataEmissao  and (c.modeloDocFiscal.codigo = :cod1 or  c.modeloDocFiscal.codigo = :cod2) and c.cupom.impressoraFiscal.identificador = :idImpressoraFiscal  and c.cupom.empresa=:empresa");
        q.setDate("dataEmissao", rC405.getDataMovimento());
        q.setLong("idImpressoraFiscal", idImpressora.longValue());
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC460> toRet = new ArrayList<RegC460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC460 r = new RegC460();
            r.setIdCupomFiscal((Long)h.get("idCupomFiscal"));
            r.setCodModDocFiscal((String)h.get("codModeloDocFiscal"));
            r.setCancelado((Short)h.get("cancelado"));
            r.setCpfCnpj((String)h.get("cpfCliente"));
            r.setNomeCliente((String)h.get("nomeCliente"));
            r.setNumeroDoc((Long)h.get("nrCupom"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setItensCupom(this.getItensCupomFiscalRegC470(r));
            toRet.add(r);
        }
        rC405.setCuponsFiscais(toRet);
    }

    private List<RegC470> getItensCupomFiscalRegC470(RegC460 rC460) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select i.identificador as identificador, i.produto.identificador as idProduto, i.quantidadeTotal as quantidade, i.produto.unidadeMedida.sigla as unidMedida, i.valorFinal as valorTotal, i.tributacaoItemProduto.tributacaoItem.incidenciaIcms.codigo as codIncidenciaIcms, i.cfop.codigo as cfop, i.aliquotaICMS as aliquotaIcms, i.vrPis as valorPis, i.vrCofins as valorCofins from ItemCupomFiscal i where i.cupomFiscal.identificador = :idCupomFiscal and i.cancelado = :cancelado ");
        q.setLong("idCupomFiscal", rC460.getIdCupomFiscal().longValue());
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC470> toRet = new ArrayList<RegC470>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC470 r = new RegC470();
            r.setCodItem((Long)h.get("idProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidMedida((String)h.get("unidMedida"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setIncidenciaIcms((String)h.get("codIncidenciaIcms"));
            r.setCfop((String)h.get("cfop"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorCofins((Double)h.get("valorCofins"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisRegC490(RegC405 regC405) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcms) as valorIcms,  obs.obsFaturamento.identificador as obsLivroFiscal from ReducaoZ n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where n.identificador  = :idReducaoZ group by lv.incidenciaIcms.codigo, lv.cfop.codigo, lv.aliquotaIcms, obs.obsFaturamento.identificador");
        q.setLong("idReducaoZ", regC405.getIdReducaoZ().longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC490> toRet = new ArrayList<RegC490>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC490 r = new RegC490();
            r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
            r.setCfop((String)h.get("cfop"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setValorOperacao((Double)h.get("valorTotal"));
            r.setBcCalculoIcms((Double)h.get("valorIcmsTributado"));
            r.setValorIcms((Double)h.get("valorIcms"));
            r.setObservacoesLv((Long)h.get("obsLivroFiscal"));
            toRet.add(r);
        }
        regC405.setLivrosFiscais(toRet);
    }

    public List getResumoItensRegC420(Date dataReducao, Long idImpressora, Empresa emp, String tribItem, Double aliquotaICMS) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p.identificador as ID_PRODUTO, p.unidadeMedida.sigla as SIGLA, sum(i.quantidadeTotal) as QTDE, sum(i.valorFinal) as VALOR, sum(i.vrPis) as VR_PIS, sum(i.vrCofins) as VR_COFINS  from ItemCupomFiscal i  inner join i.produto p where i.cupomFiscal.cupom.impressoraFiscal.identificador = :impressora  and i.cupomFiscal.cupom.dataEmissao = :dataReducao  and i.cupomFiscal.cupom.empresa = :empresa  and i.tipoTributacaoItemCPFiscal.sigla = :sigla and i.cupomFiscal.cancelado = :cancelado and i.cancelado = :cancelado and i.aliquotaICMS = :aliquotaICMS group by p.identificador, p.unidadeMedida.sigla");
        q.setDate("dataReducao", dataReducao);
        q.setLong("impressora", idImpressora.longValue());
        q.setEntity("empresa", (Object)emp);
        q.setString("sigla", tribItem);
        q.setInteger("cancelado", 0);
        q.setDouble("aliquotaICMS", aliquotaICMS.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC425> dados = new ArrayList<RegC425>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC425 r = new RegC425();
            r.setIdProduto((long)((Long)h.get("ID_PRODUTO")));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setQuantidade((double)((Double)h.get("QTDE")));
            r.setValorTotal((double)((Double)h.get("VALOR")));
            if ((Double)h.get("VR_PIS") != null) {
                r.setValorPis((double)((Double)h.get("VR_PIS")));
            } else {
                r.setValorPis(0.0);
            }
            if ((Double)h.get("VR_COFINS") != null) {
                r.setValorCofins((double)((Double)h.get("VR_COFINS")));
            } else {
                r.setValorCofins(0.0);
            }
            dados.add(r);
        }
        return dados;
    }

    private List<Reg200> getProdutosCuponsFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p.identificador as ID_PRODUTO, p.nome as NOME_PRODUTO, p.unidadeMedida.sigla as SIGLA, t.codigo as COD_TIPO_ITEM_SPED, n.codigo as COD_NCM, g.codigo as COD_GENERO, c.codigo as COD_CEST, p.aliquotaIcms as ALIQUOTA_ICMS from ItemCupomFiscal i inner join i.produto p left join p.ncm n left join p.genero g left join p.cest c left join p.tipoIemSped t where (i.cupomFiscal.modeloDocFiscal.codigo=:cod1 or i.cupomFiscal.modeloDocFiscal.codigo=:cod2) and i.cupomFiscal.cupom.dataEmissao between :dataIn and :dataFim and i.cupomFiscal.cupom.empresa =:empresa and i.cupomFiscal.cancelado = :cancelado  and i.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setDescricao((String)h.get("NOME_PRODUTO"));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setTipoItem((String)h.get("COD_TIPO_ITEM_SPED"));
            r.setCodNcm((String)h.get("COD_NCM"));
            r.setCodGenero((String)h.get("COD_GENERO"));
            r.setCodCest((String)h.get("COD_CEST"));
            Double aliq = (Double)h.get("ALIQUOTA_ICMS");
            r.setAliquotaIcms(aliq);
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasCuponsFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao from CupomFiscal n  inner join n.itemCupomFiscal i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2) and n.cupom.dataEmissao between :dataIn and :dataFim and n.cupom.empresa=:empresa and n.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }
}

