/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao013.util.bloco0;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.LogProduto;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao013.SpedFormat013;
import mentorcore.service.impl.spedfiscal.versao013.model.Reg0015;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg205;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg210;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg220;
import mentorcore.service.impl.spedfiscal.versao013.model2.Reg460;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco0 {
    private SpedFormat013 form = new SpedFormat013();

    public EmpresaContabilidade getEmpresaContabilidade(Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getEmpresaContabilidadeDAO().getVOClass());
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.setMaxResults(1);
        return (EmpresaContabilidade)c.uniqueResult();
    }

    public List getAlteracoesParticipante(Long idPessoa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LogPessoa l where l.pessoa.identificador=:idPessoa and l.dataAlteracao  between :dataIn and :dataFim");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        return q.list();
    }

    public List getAlteracoesProduto(Long idProduto, Date dataIn, Date dataFim) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LogProduto l where l.produto.identificador=:idProduto and l.dataFimUtilDesc  between :dataIn and :dataFim and l.identificador=(select max(lp.identificador) from LogProduto lp  where lp.produto.identificador=:idProduto and lp.dataFimUtilDesc between :dataIn and :dataFim)");
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", DateUtil.previousDays(dataFim, 1));
        List ret = q.list();
        ArrayList<Reg205> toRet = new ArrayList<Reg205>();
        for (Object o : ret) {
            LogProduto l = (LogProduto)o;
            if (l.getDataFimUtilDesc() == null) {
                l.setDataFimUtilDesc(dataFim);
                l = this.salvarAtualizarLogProduto(l);
            }
            Reg205 r = new Reg205();
            r.setDescricaoAnterior(l.getConteudoAnterior());
            r.setDataInicial(l.getDataIniUtilDesc());
            r.setDataFinal(l.getDataFimUtilDesc());
            toRet.add(r);
        }
        return toRet;
    }

    public Reg460 getObsLancFiscal(Long idObsFat) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   obs.identificador as idObsLancFiscal, obs.nome as nomeObsLancFiscal  from ObsFaturamento  obs  where obs.identificador = :idObs");
        q.setLong("idObs", idObsFat.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        Reg460 r = new Reg460();
        r.setIdObservacao((Long)h.get("idObsLancFiscal"));
        r.setDescricao((String)h.get("nomeObsLancFiscal"));
        return r;
    }

    public List getAliquotasSTIncrito(Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select u.uf.sigla as UF,  u.inscricaoEstadual as INSCRICAO_ESTADUAL from DadosFiscaisUF u  where u.inscritoEstado=:sim and u.empresa = :empresa");
        q.setShort("sim", (short)1);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg0015> registros = new ArrayList<Reg0015>();
        if (lista != null) {
            for (HashMap h : lista) {
                String uf = (String)h.get("UF");
                String inscEst = (String)h.get("INSCRICAO_ESTADUAL");
                Boolean exists = false;
                for (Reg0015 r : registros) {
                    if (!r.getInscricaoUf().equals(inscEst) || !r.getSiglaUf().equals(uf)) continue;
                    exists = true;
                    break;
                }
                if (exists.booleanValue()) continue;
                Reg0015 r = new Reg0015(uf, inscEst);
                registros.add(r);
            }
        }
        return registros;
    }

    public List<Reg220> getFatoresConversao(String unidadeMedida) {
        ArrayList<Reg220> toRet = new ArrayList<Reg220>();
        Reg220 r = new Reg220();
        r.setFatorConversao(1.0);
        r.setUnidadeMedida(unidadeMedida);
        toRet.add(r);
        return toRet;
    }

    public List getFatoresConversao(String unidadeMedida, Long idProduto, Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      it.fatorConversao as fatorConversao,     it.unidadeMedida.sigla as sigla from ItemNotaTerceiros it  where          it.notaFiscalTerceiros.dataEntrada between :dataIn and :dataFim     and it.notaFiscalTerceiros.empresa = :empresa     and it.produto.identificador = :idProduto     and (it.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod1 or it.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod2  or it.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod3 or it.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod4) ");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg220> toRet = new ArrayList<Reg220>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            String unidade = (String)h.get("sigla");
            if (ToolMethods.isEquals((Object)unidade, (Object)unidadeMedida)) continue;
            Reg220 r = new Reg220();
            r.setFatorConversao((Double)h.get("fatorConversao"));
            r.setUnidadeMedida(unidade);
            toRet.add(r);
        }
        return toRet;
    }

    public Reg150 createReg150FromPessoa(Pessoa p) {
        Reg150 r = new Reg150();
        r.setIdPessoa(p.getIdentificador());
        r.setNomePessoa(p.getNome());
        r.setBairro(p.getEndereco().getBairro());
        r.setCnpj(p.getComplemento().getCnpj());
        r.setCodPais(p.getEndereco().getCidade().getUf().getPais().getCodIbge());
        r.setCodUf(p.getEndereco().getCidade().getUf().getCodIbge());
        r.setCodigoMunicipio(p.getEndereco().getCidade().getCodIbge());
        r.setComplemento(p.getEndereco().getComplemento());
        r.setEndereco(p.getEndereco().getLogradouro());
        r.setInscricaoEstadual(p.getComplemento().getInscEst());
        r.setNumero(p.getEndereco().getNumero());
        r.setSuframa(p.getComplemento().getSuframa());
        return r;
    }

    public Reg200 createReg200FromProduto(Produto p) {
        Reg200 r = new Reg200();
        r.setIdProduto(p.getIdentificador());
        r.setDescricao(p.getNome());
        r.setUnidadeMedida(p.getUnidadeMedida().getSigla());
        r.setTipoItem(p.getTipoIemSped().getCodigo());
        if (p.getNcm() != null && p.getNcm().getCodigo() != null) {
            r.setCodNcm(p.getNcm().getCodigo());
        }
        if (p.getGenero() != null && p.getGenero().getCodigo() != null) {
            r.setCodGenero(p.getGenero().getCodigo());
        }
        r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
        r.setAliquotaIcms(p.getAliquotaIcms());
        if (p.getCest() != null) {
            r.setCodCest(this.form.formatStringClear(p.getCest().getCodigo()));
        }
        return r;
    }

    public Reg190 createReg190FromUnidMedida(UnidadeMedida u) {
        Reg190 r = new Reg190();
        r.setIdUnidMedida(u.getIdentificador());
        r.setCodUnidMedida(u.getSigla());
        r.setDescUnidMedida(u.getDescricao());
        return r;
    }

    private LogProduto salvarAtualizarLogProduto(LogProduto l) throws ExceptionDatabase {
        return (LogProduto)CoreDAOFactory.getInstance().getDAOLogProduto().saveOrUpdate(l);
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    public List<Reg210> getFormulacaoProdutosReg210(Empresa empresa) {
        Reg210 r;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select i.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, i.quantidade as QUANTIDADE,  g.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO_PAI from Produto p  inner join p.gradeFormulaProduto g inner join g.itemGradeFormulaProduto i  where       g.formulacaoPrincipal = :sim and  g.empresa = :empresa and  (g.gradeCor.produtoGrade.produto.tipoIemSped.codigo = :produtoEmProcesso or       g.gradeCor.produtoGrade.produto.tipoIemSped.codigo = :produtoAcabado)";
        Query q = s.createQuery(hql);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg210> lista = new ArrayList<Reg210>();
        for (Object o : ret) {
            h = (HashMap)o;
            r = new Reg210();
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setIdProdutoPai((Long)h.get("ID_PRODUTO_PAI"));
            r.setQtdeComponente((Double)h.get("QUANTIDADE"));
            lista.add(r);
        }
        hql = "select ifp.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, ifp.quantidade as QUANTIDADE,  p.identificador as ID_PRODUTO_PAI from Produto p  inner join p.formulacaoFases f inner join f.itemFormulacaoFases i inner join i.itensFormFasesProdutivas ifp where        f.empresa = :empresa and  (p.tipoIemSped.codigo = :produtoEmProcesso or       p.tipoIemSped.codigo = :produtoAcabado)";
        q = s.createQuery(hql);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object o : ret) {
            h = (HashMap)o;
            r = new Reg210();
            r.setIdProduto((Long)h.get("ID_PRODUTO"));
            r.setIdProdutoPai((Long)h.get("ID_PRODUTO_PAI"));
            r.setQtdeComponente((Double)h.get("QUANTIDADE"));
            lista.add(r);
        }
        return lista;
    }

    public Produto getProdutoPorIdentificador(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" from Produto p where p.identificador = :idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setMaxResults(1);
        return (Produto)q.uniqueResult();
    }
}

