/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao014.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao014.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao014.model2.blococ.RegC100;
import mentorcore.service.impl.spedfiscal.versao014.model2.blococ.RegC190;
import mentorcore.service.impl.spedfiscal.versao014.model2.blococ.RegC191;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC100NFCe {
    public BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, Empresa emp, SpedFiscal vo) throws ExceptionDatabase {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        if (b.getRegistrosC100() != null && !b.getRegistrosC100().isEmpty()) {
            this.getLivrosFiscaisNotasPropriasBlocoC100(b.getRegistrosC100());
        }
        return b;
    }

    private List getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.modeloDocFiscal.codigo                  as codModFiscal,     n.situacaoDocumento.codigo                as sitDoc,     n.serie                                   as serie,     n.numero                                  as numNota,     n.chaveNFCe                               as chaveNfe,     n.dataEmissao                             as dataEmissao,     n.dataEmissao                             as dataEntSai,     n.totalizadores.valorTotalNFe             as valorTotal,     n.totalizadores.valorTotalNFe             as valorProdServ,     cp.tpCondicao                             as tpCond,     n.totalizadores.valorFreteInf             as vlrFrete,     n.totalizadores.valorSeguroInf            as vlrSeguro,     n.totalizadores.valorDescontoInf          as vlrDesconto,     n.totalizadores.valorDespAcessoriasInf    as vlrDespAcess,     n.totalizadores.baseCalculoICMS           as bcIcms,     n.totalizadores.valorTotalICMS            as vlrIcms,     n.totalizadores.valorTotalPIS             as vlrPis,     n.totalizadores.valorTotalCOFINS          as vlrCofins,     n.identificador                           as identificador from NFCe n  left join n.condicoesPagamento cp where      n.modeloDocFiscal.codigo=:cod1 and n.dataEmissao between :dataIn and :dataFim and n.empresa=:empresa and n.status <> 102");
        q.setString("cod1", "65");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc(((Long)h.get("numNota")).intValue());
            System.out.println("Nr NFCe: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setEntSaiNatOP(1);
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            Integer mesEmissao = DateUtil.getMonthFromDate(r.getDataEmissao());
            Integer mesSaida = null;
            if (r.getDataEntSaida() != null) {
                mesSaida = DateUtil.getMonthFromDate(r.getDataEntSaida());
            }
            if (mesEmissao != null && mesSaida != null && mesEmissao != mesSaida) {
                r.setDataEntSaida(null);
            }
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if (h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisNotasPropriasBlocoC100(List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC100> iterator = registrosC100.iterator();
        while (iterator.hasNext()) {
            RegC100 o;
            RegC100 regC100 = o = iterator.next();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select      distinct lv  from NFCe n inner join n.livrosFiscais lv where      n.identificador  = :idNota     and (n.situacaoDocumento.codigo = :codSitDoc1 or           n.situacaoDocumento.codigo = :codSitDoc2 or          n.situacaoDocumento.codigo = :codSitDoc3 or          n.situacaoDocumento.codigo = :codSitDoc4 or          n.situacaoDocumento.codigo = :codSitDoc5 )");
            q.setLong("idNota", idNota.longValue());
            q.setString("codSitDoc1", "00");
            q.setString("codSitDoc2", "01");
            q.setString("codSitDoc3", "06");
            q.setString("codSitDoc4", "07");
            q.setString("codSitDoc5", "08");
            List ret = q.list();
            if (ret == null) continue;
            regC100.setRegC190(this.getRegC190(ret));
        }
    }

    private List getRegC190(List livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (Object ob : livrosFiscais) {
            LivroFiscal h = (LivroFiscal)ob;
            RegC190 r = this.getRegC190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            RegC191 rr = null;
            if (r == null) {
                r = new RegC190();
                rr = new RegC191();
                r.setRegC191(rr);
                toRet.add(r);
            }
            rr = r.getRegC191();
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setBcCalculoIcmsSt(h.getValorBCIcmsSt() + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(h.getValorIcmsSt() + r.getValorIcmsST());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() + r.getValorNaoTribIcms());
            r.setValorIpi(h.getValorIpiIndustria() + h.getValorIpiComercio() + r.getValorIpi());
            rr.setValorFCP(h.getValorFCP() + rr.getValorFCP());
            rr.setValorFCPST(h.getValorFCPSt() + rr.getValorFCPST());
            rr.setValorFCPSTRet(h.getValorFCPStRetido() + rr.getValorFCPSTRet());
        }
        return toRet;
    }

    private RegC190 getRegC190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegC190 r = (RegC190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }
}

