/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao015.util.bloco1;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao015.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao015.model2.bloco1.Reg1350;
import mentorcore.service.impl.spedfiscal.versao015.model2.bloco1.Reg1360;
import mentorcore.service.impl.spedfiscal.versao015.model2.bloco1.Reg1370;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1350 {
    public Bloco1 getReg1350(Empresa emp, Date dataFinal) {
        Bloco1 bloco1 = new Bloco1();
        bloco1.setReg1350(this.getRegistro1350(emp, dataFinal));
        return bloco1;
    }

    private List<Reg1350> getRegistro1350(Empresa emp, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  b.identificador as idBomba, b.serie as serie, b.modelo as modelo, b.fabricante.nome as nomeFabricante, b.tipoMedicao as tipoMedicao from BombaCombustivel b where b.empresa  = :empresa and ((b.ativo = :sim and b.dataCadastro <= :dataFinal) or (b.ativo = :nao and b.dataDesativacao >= :dataFinal))");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1350> bombas = new ArrayList<Reg1350>();
        for (Object ob : lista) {
            HashMap h = (HashMap)ob;
            Long idBomba = (Long)h.get("idBomba");
            String serie = (String)h.get("serie");
            String modelo = (String)h.get("modelo");
            String fabricante = (String)h.get("nomeFabricante");
            Short tipoMedicao = (Short)h.get("tipoMedicao");
            Reg1350 r = new Reg1350();
            r.setIdentificador(idBomba);
            r.setSerieBomba(serie);
            r.setModeloBomba(modelo);
            r.setFabricanteBomba(fabricante);
            r.setTipoMedicao(tipoMedicao.toString());
            r.setReg1360(this.getReg1360(idBomba));
            r.setReg1370(this.getReg1370(idBomba, dataFinal));
            bombas.add(r);
        }
        return bombas;
    }

    private List<Reg1360> getReg1360(Long idBomba) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  b.numeroLacre as numeroLacre, b.dataAplicacao as dataAplicacao  from LacreBombaCombustivel b inner join b.bombaCombustivel bc  where bc.identificador = :idBomba");
        q.setLong("idBomba", idBomba.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1360> lacres = new ArrayList<Reg1360>();
        for (Object ob : lista) {
            HashMap h = (HashMap)ob;
            String nrLacre = (String)h.get("numeroLacre");
            Date dataAplicacao = (Date)h.get("dataAplicacao");
            Reg1360 r = new Reg1360();
            r.setNumeroLacre(nrLacre);
            r.setDataAplicacaoLacre(dataAplicacao);
            lacres.add(r);
        }
        return lacres;
    }

    private List<Reg1370> getReg1370(Long idBomba, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  b.codigo as numeroBico, b.gradeCor.produtoGrade.produto.identificador as idProduto,  b.gradeCor.produtoGrade.produto.codigoAuxiliar as codAuxProduto,  b.tanqueCombustivel.numeroTanque as numeroTanque  from BicoBombaCombustivel b inner join b.bombaCombustivel bc  where bc.identificador = :idBomba and ((b.ativo = :sim) or (b.ativo = :nao and b.dataDesativacao >= :dataFinal))");
        q.setLong("idBomba", idBomba.longValue());
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1370> bicos = new ArrayList<Reg1370>();
        for (Object ob : lista) {
            HashMap h = (HashMap)ob;
            String nrBico = (String)h.get("numeroBico");
            String codAuxProduto = (String)h.get("codAuxProduto");
            Long idProduto = (Long)h.get("idProduto");
            Integer numeroTanque = (Integer)h.get("numeroTanque");
            Reg1370 r = new Reg1370();
            r.setNumeroBico(nrBico);
            r.setNumeroTanque(numeroTanque.toString());
            r.setIdProduto(idProduto);
            r.setCodAuxProduto(codAuxProduto);
            bicos.add(r);
        }
        return bicos;
    }
}

