/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao015.util.bloco1;

import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SpedFiscalOperacaoDebCred;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao015.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao015.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao015.model2.bloco1.Reg1600;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1600 {
    public Bloco1 getReg1600(List<SpedFiscalOperacaoDebCred> operacoes) {
        Bloco1 bloco1 = new Bloco1();
        bloco1.setReg1600(this.getVendasCartaoCredDebReg1600(operacoes));
        bloco1.setParticipantes(this.getParticipantesCartaoCredDeb1600(operacoes));
        return bloco1;
    }

    public List<SpedFiscalOperacaoDebCred> getDadosOperacoesVendasCartaoCreditoDebito(Date dataIn, Date dataFim, Empresa emp) {
        ArrayList<SpedFiscalOperacaoDebCred> lista = new ArrayList<SpedFiscalOperacaoDebCred>();
        this.getDadosNotaFiscalPropriaOperacoesVendasCartaoCreditoDebito(dataIn, dataFim, emp, lista);
        this.getDadosControleCaixaNFCeOperacoesVendasCartaoCreditoDebito(dataIn, dataFim, emp, lista);
        return lista;
    }

    private void getDadosNotaFiscalPropriaOperacoesVendasCartaoCreditoDebito(Date dataIn, Date dataFim, Empresa emp, List<SpedFiscalOperacaoDebCred> lista) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select t.pessoa.identificador as ID_PESSOA,  sum(t.valor) as VALOR, i.tipoPagamentoNFe.codigo as TIPO_CARTAO from NotaFiscalPropria n inner join n.infPagamentoNfPropria i  inner join i.titulos t   where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa  = :empresa  and (i.tipoPagamentoNFe.codigo = :tipoCartaoDebito or i.tipoPagamentoNFe.codigo = :tipoCartaoCredito) and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada) group by t.pessoa.identificador, i.tipoPagamentoNFe.codigo");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("tipoCartaoDebito", "04");
        q.setString("tipoCartaoCredito", "03");
        q.setString("cancelado", "02");
        q.setString("canceladoExt", "03");
        q.setString("denegada", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List retorno = q.list();
        for (Object obj : retorno) {
            HashMap h = (HashMap)obj;
            Long idPessoa = (Long)h.get("ID_PESSOA");
            Double valor = (Double)h.get("VALOR");
            String tipoCartao = (String)h.get("TIPO_CARTAO");
            Boolean achou = false;
            for (SpedFiscalOperacaoDebCred op : lista) {
                if (!ToolMethods.isEquals((Object)op.getPessoaOperadoraDebCred().getIdentificador(), (Object)idPessoa)) continue;
                if (ToolMethods.isEquals((Object)tipoCartao, (Object)"03")) {
                    op.setValorTotalCredito(Double.valueOf(op.getValorTotalCredito() + valor));
                } else {
                    op.setValorTotalDebito(Double.valueOf(op.getValorTotalDebito() + valor));
                }
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            SpedFiscalOperacaoDebCred op = new SpedFiscalOperacaoDebCred();
            op.setPessoaOperadoraDebCred(this.getPessoa(idPessoa));
            if (ToolMethods.isEquals((Object)tipoCartao, (Object)"03")) {
                op.setValorTotalCredito(valor);
            } else {
                op.setValorTotalDebito(valor);
            }
            lista.add(op);
        }
    }

    private void getDadosControleCaixaNFCeOperacoesVendasCartaoCreditoDebito(Date dataIn, Date dataFim, Empresa emp, List<SpedFiscalOperacaoDebCred> lista) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select t.pessoa.identificador as ID_PESSOA,  sum(t.valor) as VALOR, t.meioPagamento.tipoPagamentoNFe.codigo as TIPO_CARTAO from Titulo t   inner join t.meioPagamento m  where t.dataEmissao between :dataIn and :dataFim and t.empresa  = :empresa  and (t.meioPagamento.tipoPagamentoNFe.codigo = :tipoCartaoDebito or t.meioPagamento.tipoPagamentoNFe.codigo = :tipoCartaoCredito) and (t.nfCeControleCaixa is not null or t.apuracaoTitulosCartaoDebCred is not null) group by t.pessoa.identificador, t.meioPagamento.tipoPagamentoNFe.codigo");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("tipoCartaoDebito", "04");
        q.setString("tipoCartaoCredito", "03");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List retorno = q.list();
        for (Object obj : retorno) {
            HashMap h = (HashMap)obj;
            Long idPessoa = (Long)h.get("ID_PESSOA");
            Double valor = (Double)h.get("VALOR");
            String tipoCartao = (String)h.get("TIPO_CARTAO");
            Boolean achou = false;
            for (SpedFiscalOperacaoDebCred op : lista) {
                if (!ToolMethods.isEquals((Object)op.getPessoaOperadoraDebCred().getIdentificador(), (Object)idPessoa)) continue;
                if (ToolMethods.isEquals((Object)tipoCartao, (Object)"03")) {
                    op.setValorTotalCredito(Double.valueOf(op.getValorTotalCredito() + valor));
                } else {
                    op.setValorTotalDebito(Double.valueOf(op.getValorTotalDebito() + valor));
                }
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            SpedFiscalOperacaoDebCred op = new SpedFiscalOperacaoDebCred();
            op.setPessoaOperadoraDebCred(this.getPessoa(idPessoa));
            if (ToolMethods.isEquals((Object)tipoCartao, (Object)"03")) {
                op.setValorTotalCredito(valor);
            } else {
                op.setValorTotalDebito(valor);
            }
            lista.add(op);
        }
    }

    private Pessoa getPessoa(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from Pessoa p where p.identificador = :idPessoa");
        q.setLong("idPessoa", idPessoa.longValue());
        return (Pessoa)q.uniqueResult();
    }

    private List<Reg1600> getVendasCartaoCredDebReg1600(List<SpedFiscalOperacaoDebCred> operacoes) {
        ArrayList<Reg1600> aux = new ArrayList<Reg1600>();
        for (SpedFiscalOperacaoDebCred op : operacoes) {
            Reg1600 r = new Reg1600();
            r.setIdParticipante(op.getPessoaOperadoraDebCred().getIdentificador());
            r.setTotalCredito(op.getValorTotalCredito());
            r.setTotalDebito(op.getValorTotalDebito());
            aux.add(r);
        }
        return aux;
    }

    private List<Reg150> getParticipantesCartaoCredDeb1600(List<SpedFiscalOperacaoDebCred> operacoes) {
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (SpedFiscalOperacaoDebCred op : operacoes) {
            Pessoa p = op.getPessoaOperadoraDebCred();
            Endereco e = p.getEndereco();
            Complemento c = p.getComplemento();
            Reg150 r = new Reg150();
            r.setBairro(e.getBairro());
            r.setCnpj(c.getCnpj());
            r.setCodPais(e.getCidade().getUf().getPais().getCodIbge());
            r.setCodigoMunicipio(e.getCidade().getCodIbge());
            r.setCodUf(e.getCidade().getUf().getCodIbge());
            r.setComplemento(e.getComplemento());
            r.setCpf(c.getCnpj());
            r.setEndereco(e.getLogradouro());
            r.setIdPessoa(p.getIdentificador());
            r.setInscricaoEstadual(c.getInscEst());
            r.setNomePessoa(p.getNome());
            r.setNumero(e.getNumero());
            r.setSuframa(c.getSuframa());
            toRet.add(r);
        }
        return toRet;
    }
}

