/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao016.util.blococ;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OutrasObrigLivroFiscal;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg400;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg450;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg500;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC100;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC101;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC110;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC111;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC112;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC113;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC114;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC170;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC190;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC191;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC195;
import mentorcore.service.impl.spedfiscal.versao016.model2.blococ.RegC197;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC100NotaPropria {
    Boolean utilizaCodAux = false;

    public BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, Empresa emp, SpedFiscal vo, Boolean utilizaCodAux) throws ExceptionDatabase {
        this.utilizaCodAux = utilizaCodAux;
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        if (b.getRegistrosC100() != null && !b.getRegistrosC100().isEmpty()) {
            this.getLivrosFiscaisNotasPropriasBlocoC100Agrupado(b.getRegistrosC100(), dataIn, dataFim, emp);
            b.setParticipantes(this.getParticipantesNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp, b.getRegistrosC100()));
            b.setNaturezaOperacao(this.getNatOperacaoNotaPropriaBlocoC100(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaPropriaBlocoC100(dataIn, dataFim, emp));
            b.setUnidMedidas(this.getUnidMedidasNotaPropriaBlocoC100(dataIn, dataFim, emp, b.getRegistrosC100()));
            if (vo.getGerarBlocoC110().equals((short)1)) {
                b.setObservacoes(this.getInfComplNotasPropriasBlocoC100(b.getRegistrosC100()));
            }
        }
        b.getRegistrosC100().addAll(this.getInutilizacoesNFe(dataIn, dataFim, emp));
        return b;
    }

    private List getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida           as entSai,     n.modeloDocFiscal.codigo                  as codModFiscal,     n.unidadeFatCliente.pessoa.identificador  as idPessoa,     tf.opcao                                  as codTpFrete,     n.situacaoDocumento.codigo                as sitDoc,     n.serie                                   as serie,     n.numeroNota                              as numNota,     n.chaveNFE                                as chaveNfe,     n.dataEmissaoNota                         as dataEmissao,     n.dataEntradaSaida                        as dataEntSai,     n.valoresNfPropria.valorTotal             as valorTotal,     n.valoresNfPropria.valorProduto + n.valoresNfPropria.valorServico as valorProdServ,     cp.tpCondicao                             as tpCond,     n.valoresNfPropria.valorFrete             as vlrFrete,     n.valoresNfPropria.valorSeguro            as vlrSeguro,     n.valoresNfPropria.valorDesconto          as vlrDesconto,     n.valoresNfPropria.valorDespAcess         as vlrDespAcess,     n.valoresNfPropria.valorIcmsTributado     as bcIcms,     n.valoresNfPropria.valorIcms              as vlrIcms,     n.valoresNfPropria.valorIcmsSt            as vlrIcmsSt,     n.valoresNfPropria.bcIcmsSt               as bcIcmsSt,     n.valoresNfPropria.valorIpiIndustria + n.valoresNfPropria.valorIpiComercio      as vlrIpi,     n.valoresNfPropria.valorPis               as vlrPis,     n.valoresNfPropria.valorCofins            as vlrCofins,     n.valoresNfPropria.valorCofinsSt          as vlrCofinsST,     n.valoresNfPropria.valorPisSt             as vlrPisST,     n.valoresNfPropria.valorIcmsDesonerado    as vlrIcmsDesonerado,     n.identificador                           as identificador from NotaFiscalPropria n  left join n.dadosTransNfPropria.tipoFrete tf left join n.condicaoPagamento cp where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Propria: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setEntSaiNatOP(((Short)h.get("entSai")).shortValue());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            Integer mesEmissao = DateUtil.getMonthFromDate(r.getDataEmissao());
            Integer mesSaida = null;
            if (r.getDataEntSaida() != null) {
                mesSaida = DateUtil.getMonthFromDate(r.getDataEntSaida());
            }
            if (mesEmissao != null && mesSaida != null && mesEmissao != mesSaida) {
                r.setDataEntSaida(null);
            }
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT((Double)h.get("vlrIcmsDesonerado"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            if (!this.isDocCancelado(r.getCodSituacaoDoc())) {
                this.getInformacoesComplementares(r);
                if (!r.getCodModDocFiscal().equals("55")) {
                    this.getItensDocumentoNotaPropria(r);
                }
            }
            toRet.add(r);
        }
        return toRet;
    }

    private boolean isDocCancelado(String sitDoc) {
        boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
        return docCancInut;
    }

    private void getItensDocumentoNotaPropria(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select distinct      p.produto.identificador                 as idProduto,     p.numeroItem                            as numeroItem,     p.produto.nome                          as nomeProduto,     p.quantidadeTotal                       as quantidade,     p.unidadeMedida.sigla                   as sigla,     (p.valorUnitario * p.quantidadeTotal)   as valorTotal,     p.valorDesconto                         as valorDesconto,     p.modeloFiscal.movimentacaoFisica       as movimentacaoFisica,     p.incidenciaIcms.codigo                 as codIncidenciaIcms,     p.itemNotaLivroFiscal.cfop.codigo       as cfop,     n.naturezaOperacao.identificador        as idNatOperacao,     p.itemNotaLivroFiscal.vrIcmsTributado   as vrIcmsTrib,     p.itemNotaLivroFiscal.aliquotaIcms      as aliquotaIcms,     p.itemNotaLivroFiscal.vrIcms            as valorIcms,     p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt,     p.itemNotaLivroFiscal.aliquotaIcmsST    as aliquotaIcmsSt,     p.itemNotaLivroFiscal.vrIcmsSt          as valorIcmsSt,     p.incidenciaIpi.codigo                  as codIncidenciaIpi,     p.itemNotaLivroFiscal.vrIpiTributado    as vrIpiTributado,     p.itemNotaLivroFiscal.aliquotaIpi       as aliquotaIpi,     p.itemNotaLivroFiscal.vrIpiIndustria    as vrIpiIndustria,     p.itemNotaLivroFiscal.vrIpiComercio     as vrIpiComercio,     p.incidenciaPisCofins.codigo            as codIncidenciaPisCofins,     (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,     p.itemNotaLivroFiscal.aliquotaPis       as aliquotaPis,     p.itemNotaLivroFiscal.vrPis             as vrPis,     p.itemNotaLivroFiscal.aliquotaCofins    as aliquotaCofins,     p.itemNotaLivroFiscal.vrCofins          as vrCofins,     planoCred.identificador                 as planoContaCred,     planoDeb.identificador                  as planoContaDeb,     n.naturezaOperacao.entradaSaida         as natEntSaida,     p.produto.codigoAuxiliar                as codAux,     p.itemNotaLivroFiscal.vrIcmsDesonerado  as vrIcmsDesonerado from NotaFiscalPropria n inner join n.itensNotaPropria p left join p.planoContaCred planoCred  left join p.planoContaDeb planoDeb  where     n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            if (h.get("movimentacaoFisica") != null) {
                Short movimentacaoFisica = (Short)h.get("movimentacaoFisica");
                if (movimentacaoFisica.equals((short)1)) {
                    r.setMovimentacaoFisica((short)0);
                } else {
                    r.setMovimentacaoFisica((short)1);
                }
            } else {
                r.setMovimentacaoFisica((short)1);
            }
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setValorAbatNT((Double)h.get("vrIcmsDesonerado"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setVlrBCPis((Double)h.get("BCGeral"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setBcCofins((Double)h.get("BCGeral"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((Long)h.get("planoContaCred"));
            r.setPlanoDeb((Long)h.get("planoContaDeb"));
            toRet.add(r);
        }
        regC100.setRegC170(toRet);
    }

    private void getLivrosFiscaisNotasPropriasBlocoC100(List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC100> iterator = registrosC100.iterator();
        while (iterator.hasNext()) {
            RegC100 o;
            RegC100 regC100 = o = iterator.next();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select      distinct lv  from NotaFiscalPropria n inner join n.livrosFiscais lv where      n.identificador  = :idNota     and (n.situacaoDocumento.codigo = :codSitDoc1 or           n.situacaoDocumento.codigo = :codSitDoc2 or          n.situacaoDocumento.codigo = :codSitDoc3 or          n.situacaoDocumento.codigo = :codSitDoc4 or          n.situacaoDocumento.codigo = :codSitDoc5 )");
            q.setLong("idNota", idNota.longValue());
            q.setString("codSitDoc1", "00");
            q.setString("codSitDoc2", "01");
            q.setString("codSitDoc3", "06");
            q.setString("codSitDoc4", "07");
            q.setString("codSitDoc5", "08");
            List ret = q.list();
            if (ret == null) continue;
            regC100.setRegC101(this.getRegC101(ret));
            regC100.setRegC190(this.getRegC190(ret));
            regC100.setRegC195(this.getRegC195(ret));
        }
    }

    private List getRegC190(List livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (Object ob : livrosFiscais) {
            LivroFiscal h = (LivroFiscal)ob;
            RegC190 r = this.getRegC190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            RegC191 rr = null;
            if (r == null) {
                r = new RegC190();
                rr = new RegC191();
                r.setRegC191(rr);
                toRet.add(r);
            }
            rr = r.getRegC191();
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setBcCalculoIcmsSt(h.getValorBCIcmsSt() + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(h.getValorIcmsSt() + r.getValorIcmsST());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() - h.getValorIcmsDesonerado() + r.getValorNaoTribIcms());
            r.setValorIpi(h.getValorIpiIndustria() + h.getValorIpiComercio() + r.getValorIpi());
            rr.setValorFCP(h.getValorFCP() + rr.getValorFCP());
            rr.setValorFCPST(h.getValorFCPSt() + rr.getValorFCPST());
            rr.setValorFCPSTRet(h.getValorFCPStRetido() + rr.getValorFCPSTRet());
        }
        return toRet;
    }

    private RegC190 getRegC190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegC190 r = (RegC190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }

    List getParticipantesNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      p.identificador                     as idPessoa,     p.endereco.numero                   as numero,     p.endereco.logradouro               as logradouro,     p.endereco.complemento              as complemento,     p.endereco.bairro                   as bairro,     p.complemento.cnpj                  as cnpj,     p.complemento.inscEst               as inscEst,     p.complemento.suframa               as suframa,     p.nome                              as nome,     p.endereco.cidade.uf.pais.codIbge   as codPais,     p.endereco.cidade.uf.codIbge        as codUf,     p.endereco.cidade.codIbge           as codCidade from NotaFiscalPropria n inner join n.unidadeFatCliente u inner join u.pessoa p where     (   n.modeloDocFiscal.codigo=:cod1      or n.modeloDocFiscal.codigo=:cod2      or n.modeloDocFiscal.codigo=:cod3      or n.modeloDocFiscal.codigo=:cod4      )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (  n.situacaoDocumento.codigo = :codSitDoc1         or n.situacaoDocumento.codigo = :codSitDoc2         or n.situacaoDocumento.codigo = :codSitDoc3         or n.situacaoDocumento.codigo = :codSitDoc4         or n.situacaoDocumento.codigo = :codSitDoc5         )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private List<Reg400> getNatOperacaoNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     n.naturezaOperacao.identificador as idNatOperacao,     n.naturezaOperacao.descricao     as descNatOperacao from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (        n.situacaoDocumento.codigo = :codSitDoc1     or n.situacaoDocumento.codigo = :codSitDoc2     or n.situacaoDocumento.codigo = :codSitDoc3     or n.situacaoDocumento.codigo = :codSitDoc4     or n.situacaoDocumento.codigo = :codSitDoc5     )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.planoContaCred.identificador             as idPlanoCred,     i.planoContaCred.dataCadastro              as dataCadastroCred,     i.planoContaCred.marca                     as marcaCred,     i.planoContaCred.codigo                    as codContaCred,     i.planoContaCred.descricao                 as descricaoContaCred,     i.planoContaDeb.naturezaOperacaoPC.codigo  as codNatPC from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (         n.situacaoDocumento.codigo = :codSitDoc1      or n.situacaoDocumento.codigo = :codSitDoc2      or n.situacaoDocumento.codigo = :codSitDoc3      or n.situacaoDocumento.codigo = :codSitDoc4      or n.situacaoDocumento.codigo = :codSitDoc5      )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNatPC((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.unidadeMedida.identificador           as idUnidMedida,     i.unidadeMedida.sigla                   as sigla,     i.unidadeMedida.descricao               as descricao,     i.produto.unidadeMedida.identificador   as idUnidMedidaProd,     i.produto.unidadeMedida.sigla           as siglaProd,     i.produto.unidadeMedida.descricao       as descricaoProd from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5     )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        for (RegC100 r100 : registrosC100) {
            if (r100.getRegC195() == null || r100.getRegC195().isEmpty()) continue;
            for (RegC195 r195 : r100.getRegC195()) {
                if (r195.getAjustesLvFiscal() == null || r195.getAjustesLvFiscal().isEmpty()) continue;
                for (RegC197 r197 : r195.getAjustesLvFiscal()) {
                    if (r197.getIdProduto() == null || !(r197.getVlrIcmsIcmsST() > 0.0)) continue;
                    toRet.add((Reg190)this.getUnidMedidaAjustesFiscais(r197.getIdProduto()));
                }
            }
        }
        return toRet;
    }

    private void getInformacoesComplementares(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        Query q = s.createQuery("select n.observacaoIntFiscalNotaFiscalPropria as obsIntFisco  from NotaFiscalPropria n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<ObservacaoIntFiscalNotaFiscalPropria> obsIntFisco = new ArrayList<ObservacaoIntFiscalNotaFiscalPropria>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoIntFiscalNotaFiscalPropria obs = (ObservacaoIntFiscalNotaFiscalPropria)h.get("obsIntFisco");
            obsIntFisco.add(obs);
        }
        q = s.createQuery("select n.observacaoNota as obsNota from NotaFiscalPropria n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        ArrayList<ObservacaoNotaPropria> obsNotaPropria = new ArrayList<ObservacaoNotaPropria>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoNotaPropria obs = (ObservacaoNotaPropria)h.get("obsNota");
            obsNotaPropria.add(obs);
        }
        if (!obsIntFisco.isEmpty() || !obsNotaPropria.isEmpty()) {
            RegC110 r = new RegC110();
            r.setObsIntFiscoNFPropria(obsIntFisco);
            r.setObsNotaPropria(obsNotaPropria);
            toRet.add(r);
        }
        regC100.setRegC110(toRet);
    }

    private void getProcessosReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalPropria n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        regC100.setRegC111(toRet);
    }

    private void getDocArrecadacaoReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.tipoDocArrecadacao.codigo as codDocArrecadacao, p.unidadeFederativa.sigla as uf, p.numeroDocumento as nrDoc, p.codigoAutenticacaoBanc as codAutBanco, p.valorDocArrecadacao as valorDocArrecadacao, p.dataVencimento as dataVencimento, p.dataPagamento as dataPagamento from NotaFiscalPropria n inner join n.docArrecadacaoReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC112> toRet = new ArrayList<RegC112>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC112 r = new RegC112();
            r.setCodigoProc((Short)h.get("codDocArrecadacao"));
            r.setUf((String)h.get("uf"));
            r.setNrDocArrecadacao((String)h.get("nrDoc"));
            r.setCodAutenticacao((String)h.get("codAutBanco"));
            r.setValorDoc((Double)h.get("valorDocArrecadacao"));
            r.setDataPagamento((Date)h.get("dataPagamento"));
            r.setDataVencimento((Date)h.get("dataVencimento"));
            toRet.add(r);
        }
        regC100.setRegC112(toRet);
    }

    private void getDocFiscalReferenciados(RegC100 regC100) {
        Long idNotaRef;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.identificador as idNotaRef from NotaFiscalPropria n inner join n.notaReferenciada p where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            h = (HashMap)ob;
            idNotaRef = (Long)h.get("idNotaRef");
            toRet.addAll(this.getNotasPropriasReferenciadas(idNotaRef));
        }
        q = s.createQuery("select p.identificador as idNotaRef from NotaFiscalPropria n inner join n.notaTerceirosReferenciadas p where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object ob : ret) {
            h = (HashMap)ob;
            idNotaRef = (Long)h.get("idNotaRef");
            toRet.addAll(this.getNotasTerceirosReferenciadas(idNotaRef));
        }
        regC100.setRegC113(toRet);
    }

    private void getCuponsReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.cupomFiscal.modeloDocFiscal.codigo as modDocFiscal, p.cupomFiscal.cupom.impressoraFiscal.serie as serie, p.cupomFiscal.cupom.nrCOO as nrSeq, p.cupomFiscal.cupom.impressoraFiscal.nrSequencialEcf as nrCaixa, p.cupomFiscal.cupom.dataEmissao as dataEmissao from NotaFiscalPropria n inner join n.cuponsReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC114> toRet = new ArrayList<RegC114>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC114 r = new RegC114();
            r.setCodModeloDocFiscal((String)h.get("modDocFiscal"));
            r.setNrSerieFabECF((String)h.get("serie"));
            r.setNrDocumento((Integer)h.get("nrSeq"));
            r.setNrCaixa((Short)h.get("nrCaixa"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        regC100.setRegC114(toRet);
    }

    private List getNotasPropriasReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida                  as entSai,     n.unidadeFatCliente.pessoa.identificador as idPessoa,     n.modeloDocFiscal.codigo                         as codModeloDocFiscal,     n.serie                                          as serie,     n.numeroNota                                     as numeroNota,     n.dataEmissaoNota                                as dataEmissao,     n.chaveNFE                                       as chaveNFe from NotaFiscalPropria n where      n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((Short)h.get("entSai"));
            r.setIndicadorEmitente((short)0);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setChaveNFe((String)h.get("chaveNFe"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getNotasTerceirosReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.unidadeFatFornecedor.pessoa.identificador as idPessoa,     n.modeloDocFiscal.codigo                               as codModeloDocFiscal,     n.serie                                                as serie,     n.numeroNota                                           as numeroNota,     n.dataEmissao                                          as dataEmissao,     n.chaveNFE                                             as chaveNFe from NotaFiscalTerceiros n where      n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((short)0);
            r.setIndicadorEmitente((short)1);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setChaveNFe((String)h.get("chaveNFe"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getInfComplNotasPropriasBlocoC100(List<RegC100> regC100) {
        ArrayList<Reg450> toRet = new ArrayList<Reg450>();
        for (RegC100 o : regC100) {
            Reg450 reg450;
            RegC100 r = o;
            if (r.getRegC110() == null || r.getRegC110().isEmpty()) continue;
            RegC110 regC110 = r.getRegC110().get(0);
            Iterator<ObservacaoNotaPropria> iterator = regC110.getObsNotaPropria().iterator();
            while (iterator.hasNext()) {
                ObservacaoNotaPropria observacaoNotaPropria;
                ObservacaoNotaPropria obsNotaPropria = observacaoNotaPropria = iterator.next();
                reg450 = new Reg450();
                reg450.setIdObservacao(obsNotaPropria.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsNotaPropria.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
            for (ObservacaoNotaPropria observacaoNotaPropria : regC110.getObsIntFiscoNFPropria()) {
                ObservacaoIntFiscalNotaFiscalPropria obsIntFisco = (ObservacaoIntFiscalNotaFiscalPropria)observacaoNotaPropria;
                reg450 = new Reg450();
                reg450.setIdObservacao(obsIntFisco.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsIntFisco.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
        }
        return toRet;
    }

    private Object getProdutoAjustesFiscais(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idProduto, p.nome as nomeProduto, p.unidadeMedida.sigla as unidadeMedida, p.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, p.aliquotaIcms as aliquotaIcms, p.codigoAuxiliar as codAux from Produto p left join p.ncm nc left join p.genero g left join p.cest c where  p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setIdentificador(idProduto);
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            return r;
        }
        return null;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<RegC100> registrosC100) {
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, i.produto.aliquotaIcms as aliquotaIcms, i.produto.codigoAuxiliar as codAux from ItemNotaFiscalPropria i left join i.produto.ncm nc left join i.produto.genero g left join i.produto.cest c where (i.notaFiscalPropria.modeloDocFiscal.codigo=:cod1 or i.notaFiscalPropria.modeloDocFiscal.codigo=:cod2  or i.notaFiscalPropria.modeloDocFiscal.codigo=:cod3)  and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim and i.notaFiscalPropria.empresa=:empresa and (i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1 or  i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2 or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3 or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4 or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5 ) order by i.produto.identificador");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            toRet.add(r);
        }
        for (RegC100 r100 : registrosC100) {
            if (r100.getRegC195() == null || r100.getRegC195().isEmpty()) continue;
            for (RegC195 r195 : r100.getRegC195()) {
                if (r195.getAjustesLvFiscal() == null || r195.getAjustesLvFiscal().isEmpty()) continue;
                for (RegC197 r197 : r195.getAjustesLvFiscal()) {
                    if (r197.getIdProduto() == null || !(r197.getVlrIcmsIcmsST() > 0.0)) continue;
                    toRet.add((Reg200)this.getProdutoAjustesFiscais(r197.getIdProduto()));
                }
            }
        }
        return toRet;
    }

    private RegC101 getRegC101(List livrosFiscais) {
        Double vrIcmsDest = 0.0;
        Double vrIcmsRem = 0.0;
        Double vrFundoPobreza = 0.0;
        for (Object o : livrosFiscais) {
            LivroFiscal lv = (LivroFiscal)o;
            vrIcmsDest = vrIcmsDest + lv.getValorIcmsPartilhaDest();
            vrIcmsRem = vrIcmsRem + lv.getValorIcmsPartilhaRem();
            vrFundoPobreza = vrFundoPobreza + lv.getValorFundoPobreza();
        }
        if (vrIcmsDest > 0.0 || vrIcmsRem > 0.0 || vrFundoPobreza > 0.0) {
            RegC101 r = new RegC101();
            r.setValorIcmsUFDestino(vrIcmsDest);
            r.setValorIcmsUFRemetente(vrIcmsRem);
            r.setValorFundoPobreza(vrFundoPobreza);
            return r;
        }
        return null;
    }

    private List<RegC195> getRegC195(List livrosFiscais) {
        ArrayList<RegC195> lista = new ArrayList<RegC195>();
        for (Object o : livrosFiscais) {
            LivroFiscal lv = (LivroFiscal)o;
            for (ObservacaoLivroFiscal os : lv.getObsLivroFiscal()) {
                boolean achou = false;
                for (RegC195 r : lista) {
                    if (os.getObsFaturamento() == null || r.getIdObservacao() == null || !r.getIdObservacao().equals(os.getObsFaturamento().getIdentificador())) continue;
                    r.getAjustesLvFiscal().addAll(this.getOutrasObrigacoesLivroFiscal(os, r.getAjustesLvFiscal()));
                    achou = true;
                }
                if (achou) continue;
                RegC195 r = new RegC195();
                if (os.getObsFaturamento() != null) {
                    r.setIdObservacao(os.getObsFaturamento().getIdentificador());
                    r.setDescricaoObservacao(os.getObsFaturamento().getNome());
                }
                r.setTextoObs(os.getConteudo());
                r.getAjustesLvFiscal().addAll(this.getOutrasObrigacoesLivroFiscal(os, r.getAjustesLvFiscal()));
                lista.add(r);
            }
        }
        return lista;
    }

    private Collection<? extends RegC197> getOutrasObrigacoesLivroFiscal(ObservacaoLivroFiscal os, List<RegC197> ajustes) {
        ArrayList<RegC197> aux = new ArrayList<RegC197>();
        for (OutrasObrigLivroFiscal out : os.getOutrasObrigLivroFiscal()) {
            Boolean achou = false;
            for (RegC197 r : ajustes) {
                if (!out.getTipoAjusteIcmsDocFiscal().getCodigo().equals(r.getCodTipoAjusteApIcms()) || !out.getProduto().getIdentificador().equals(r.getIdProduto())) continue;
                r.setVlrBCIcmsIcmsST(r.getVlrBCIcmsIcmsST() + out.getVlrBCIcmsIcmsST());
                r.setVlrIcmsIcmsST(r.getVlrIcmsIcmsST() + out.getVlrIcmsIcmsST());
                r.setVlrOutros(r.getVlrOutros() + out.getVlrOutros());
                achou = true;
            }
            if (achou.booleanValue()) continue;
            RegC197 c197 = new RegC197();
            c197.setAliquotaIcms(out.getAliquotaIcms());
            c197.setCodTipoAjusteApIcms(out.getTipoAjusteIcmsDocFiscal().getCodigo());
            c197.setDescricaoComp(out.getDescricaoComp());
            if (out.getProduto() != null) {
                c197.setIdProduto(out.getProduto().getIdentificador());
                c197.setCodAuxProduto(out.getProduto().getCodigoAuxiliar());
            }
            c197.setVlrBCIcmsIcmsST(out.getVlrBCIcmsIcmsST());
            c197.setVlrIcmsIcmsST(out.getVlrIcmsIcmsST());
            c197.setVlrOutros(out.getVlrOutros());
            aux.add(c197);
        }
        return aux;
    }

    private Object getUnidMedidaAjustesFiscais(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     p.unidadeMedida.identificador           as idUnidMedida,     p.unidadeMedida.sigla                   as sigla,     p.unidadeMedida.descricao               as descricao from Produto p  where  p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            return r;
        }
        return null;
    }

    private Collection<? extends RegC100> getInutilizacoesNFe(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.numeroInicial as numeroInicial, n.numeroFinal as numeroFinal, n.serie as serie, n.modeloDocFiscal.codigo as codModeloDocFiscal  from InutilizacaoNumeracaoNFe n  where n.periodo between :dataIn and :dataFim and n.empresa=:empresa and n.status IN(:inutilizacaoHomologada)");
        q.setParameter("inutilizacaoHomologada", (Object)EnumConstNFeStatus.getStatusInutilizadaString());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Integer numeroInicial = (Integer)h.get("numeroInicial");
            Integer numeroFinal = (Integer)h.get("numeroFinal");
            String serie = (String)h.get("serie");
            String modeloDocFiscal = (String)h.get("codModeloDocFiscal");
            for (int i = numeroInicial.intValue(); i <= numeroFinal; ++i) {
                RegC100 r = new RegC100();
                r.setNumeroDoc(i);
                r.setSerie(serie);
                r.setCodSituacaoDoc("05");
                r.setCodModDocFiscal(modeloDocFiscal);
                r.setEntSaiNatOP(1);
                toRet.add(r);
            }
        }
        return toRet;
    }

    private void getLivrosFiscaisNotasPropriasBlocoC100Agrupado(List<RegC100> registrosC100, Date dataIn, Date dataFim, Empresa emp) {
        List<HashMap> dadosLivros = this.getDadosLivroFiscalAgrupado(dataIn, dataFim, emp);
        List<HashMap> dadosAjustesLivros = this.getDadosAjustesLivroFiscalAgrupado(dataIn, dataFim, emp);
        for (RegC100 regC100 : registrosC100) {
            ArrayList<HashMap> livros = new ArrayList<HashMap>();
            for (HashMap h : dadosLivros) {
                Long idNota = (Long)h.get("idNota");
                if (!ToolMethods.isEquals((Object)idNota, (Object)regC100.getIdentificador())) continue;
                Long idLivro = (Long)h.get("idLivro");
                ArrayList<HashMap> ajustes = new ArrayList<HashMap>();
                for (HashMap hh : dadosAjustesLivros) {
                    Long idLivroAjuste = (Long)hh.get("idLivro");
                    if (!ToolMethods.isEquals((Object)idLivroAjuste, (Object)idLivro)) continue;
                    ajustes.add(hh);
                }
                h.put("ajustes", ajustes);
                livros.add(h);
            }
            if (!ToolMethods.isWithData(livros)) continue;
            regC100.setRegC101(this.getRegC101Agrupado(livros));
            regC100.setRegC190(this.getRegC190Agrupado(livros));
            regC100.setRegC195(this.getRegC195Agrupado(livros));
        }
    }

    private List<HashMap> getDadosLivroFiscalAgrupado(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.identificador as idNota, lv.identificador as idLivro, lv.valorIcmsPartilhaDest as valorIcmsPartilhaDest, lv.valorIcmsPartilhaRem  as valorIcmsPartilhaRem, lv.valorFundoPobreza as valorFundoPobreza,  lv.incidenciaIcms.codigo as codIncidenciaIcms, lv.cfop.codigo as  codCfop, lv.aliquotaIcms as aliquotaIcms, lv.valorTotal as valorOperacao, lv.valorIcmsTributado as valorBCIcms, lv.valorIcms as valorIcms, lv.valorBCIcmsSt as valorBCIcmsST, lv.valorIcmsSt as valorIcmsST, (lv.vrNaoTribIcms - lv.valorIcmsDesonerado) as valorNaoTribIcms, (lv.valorIpiIndustria + lv.valorIpiComercio) as valorIpi,  lv.valorFCP as valorFCP, lv.valorFCPSt as valorFCPST, lv.valorFCPStRetido as valorFCPSTRet from NotaFiscalPropria n inner join n.livrosFiscais lv where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or       n.situacaoDocumento.codigo = :codSitDoc2 or      n.situacaoDocumento.codigo = :codSitDoc3 or      n.situacaoDocumento.codigo = :codSitDoc4 or      n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getRegC190Agrupado(List<HashMap> livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (HashMap h : livrosFiscais) {
            String codIncIcms = (String)h.get("codIncidenciaIcms");
            String codCfop = (String)h.get("codCfop");
            Double aliquotaIcms = (Double)h.get("aliquotaIcms");
            Double valorOperacao = (Double)h.get("valorOperacao");
            Double valorBCIcms = (Double)h.get("valorBCIcms");
            Double valorIcms = (Double)h.get("valorIcms");
            Double valorBCIcmsST = (Double)h.get("valorBCIcmsST");
            Double valorIcmsST = (Double)h.get("valorIcmsST");
            Double valorNaoTribIcms = (Double)h.get("valorNaoTribIcms");
            Double valorIpi = (Double)h.get("valorIpi");
            Double valorFCP = (Double)h.get("valorFCP");
            Double valorFCPST = (Double)h.get("valorFCPST");
            Double valorFCPSTRet = (Double)h.get("valorFCPSTRet");
            RegC190 r = this.getRegC190(codIncIcms, codCfop, aliquotaIcms, toRet);
            RegC191 rr = null;
            if (r == null) {
                r = new RegC190();
                rr = new RegC191();
                r.setRegC191(rr);
                toRet.add(r);
            }
            rr = r.getRegC191();
            r.setIncidenciaIcms(codIncIcms);
            r.setCfop(codCfop);
            r.setAliquotaIcms(aliquotaIcms);
            r.setValorOperacao(valorOperacao + r.getValorOperacao());
            r.setBcCalculoIcms(valorBCIcms + r.getBcCalculoIcms());
            r.setValorIcms(valorIcms + r.getValorIcms());
            r.setBcCalculoIcmsSt(valorBCIcmsST + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(valorIcmsST + r.getValorIcmsST());
            r.setValorNaoTribIcms(valorNaoTribIcms + r.getValorNaoTribIcms());
            r.setValorIpi(valorIpi + r.getValorIpi());
            rr.setValorFCP(valorFCP + rr.getValorFCP());
            rr.setValorFCPST(valorFCPST + rr.getValorFCPST());
            rr.setValorFCPSTRet(valorFCPSTRet + rr.getValorFCPSTRet());
        }
        return toRet;
    }

    private RegC101 getRegC101Agrupado(List<HashMap> livrosFiscais) {
        Double vrIcmsDest = 0.0;
        Double vrIcmsRem = 0.0;
        Double vrFundoPobreza = 0.0;
        for (HashMap h : livrosFiscais) {
            vrIcmsDest = vrIcmsDest + (Double)h.get("valorIcmsPartilhaDest");
            vrIcmsRem = vrIcmsRem + (Double)h.get("valorIcmsPartilhaRem");
            vrFundoPobreza = vrFundoPobreza + (Double)h.get("valorFundoPobreza");
        }
        if (vrIcmsDest > 0.0 || vrIcmsRem > 0.0 || vrFundoPobreza > 0.0) {
            RegC101 r = new RegC101();
            r.setValorIcmsUFDestino(vrIcmsDest);
            r.setValorIcmsUFRemetente(vrIcmsRem);
            r.setValorFundoPobreza(vrFundoPobreza);
            return r;
        }
        return null;
    }

    private List<RegC195> getRegC195Agrupado(List<HashMap> livrosFiscais) {
        ArrayList<RegC195> lista = new ArrayList<RegC195>();
        for (HashMap h : livrosFiscais) {
            List ajustes = (List)h.get("ajustes");
            for (HashMap hh : ajustes) {
                Long idObsFaturamento = (Long)hh.get("idObsFaturamento");
                String nomeObsFaturamento = (String)hh.get("nomeObsFaturamento");
                String conteudo = (String)hh.get("conteudo");
                String codTipoAjuste = (String)hh.get("codTipoAjuste");
                String codAuxProduto = (String)hh.get("codAuxiliarProduto");
                Long idProduto = (Long)hh.get("idProduto");
                Double valorIcms = (Double)hh.get("valorIcms");
                Double valorBcIcms = (Double)hh.get("valorBCIcms");
                Double aliquotaIcms = (Double)hh.get("aliquotaIcms");
                Double valorOutros = (Double)hh.get("valorOutros");
                String descricaoComp = "";
                boolean achou = false;
                for (RegC195 r : lista) {
                    if (idObsFaturamento == null || r.getIdObservacao() == null || !r.getIdObservacao().equals(idObsFaturamento)) continue;
                    Boolean achouAjuste = false;
                    for (RegC197 c197 : r.getAjustesLvFiscal()) {
                        String codTipoAjuste2 = c197.getCodTipoAjusteApIcms();
                        Long idProduto2 = c197.getIdProduto();
                        if (!codTipoAjuste.equals(codTipoAjuste2) || !idProduto.equals(idProduto2)) continue;
                        c197.setVlrBCIcmsIcmsST(c197.getVlrBCIcmsIcmsST() + valorBcIcms);
                        c197.setVlrIcmsIcmsST(c197.getVlrIcmsIcmsST() + valorIcms);
                        c197.setVlrOutros(c197.getVlrOutros() + valorOutros);
                        achouAjuste = true;
                    }
                    if (!achouAjuste.booleanValue()) {
                        RegC197 c197 = new RegC197();
                        c197.setAliquotaIcms(aliquotaIcms);
                        c197.setCodTipoAjusteApIcms(codTipoAjuste);
                        c197.setDescricaoComp(descricaoComp);
                        if (idProduto != null) {
                            c197.setIdProduto(idProduto);
                            c197.setCodAuxProduto(codAuxProduto);
                        }
                        c197.setVlrBCIcmsIcmsST(valorBcIcms);
                        c197.setVlrIcmsIcmsST(valorIcms);
                        c197.setVlrOutros(valorOutros);
                        r.getAjustesLvFiscal().add(c197);
                    }
                    achou = true;
                }
                if (achou) continue;
                RegC195 r = new RegC195();
                if (idObsFaturamento != null) {
                    r.setIdObservacao(idObsFaturamento);
                    r.setDescricaoObservacao(nomeObsFaturamento);
                }
                r.setTextoObs(conteudo);
                RegC197 c197 = new RegC197();
                c197.setAliquotaIcms(aliquotaIcms);
                c197.setCodTipoAjusteApIcms(codTipoAjuste);
                c197.setDescricaoComp(descricaoComp);
                if (idProduto != null) {
                    c197.setIdProduto(idProduto);
                    c197.setCodAuxProduto(codAuxProduto);
                }
                c197.setVlrBCIcmsIcmsST(valorBcIcms);
                c197.setVlrIcmsIcmsST(valorIcms);
                c197.setVlrOutros(valorOutros);
                r.getAjustesLvFiscal().add(c197);
                lista.add(r);
            }
        }
        return lista;
    }

    private List<HashMap> getDadosAjustesLivroFiscalAgrupado(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.identificador as idNota, lv.identificador as idLivro, obs.conteudo as conteudo, obs.obsFaturamento.identificador as idObsFaturamento, obs.obsFaturamento.nome as nomeObsFaturamento, obrig.aliquotaIcms as aliquotaIcms, obrig.vlrBCIcmsIcmsST as valorBCIcms, obrig.vlrIcmsIcmsST as valorIcms, obrig.vlrOutros as valorOutros,  obrig.tipoAjusteIcmsDocFiscal.codigo as codTipoAjuste, obrig.produto.identificador as idProduto, obrig.produto.codigoAuxiliar as codAuxiliarProduto, obrig.descricaoComp as descricaoComp  from NotaFiscalPropria n inner join n.livrosFiscais lv  inner join lv.obsLivroFiscal obs inner join obs.outrasObrigLivroFiscal obrig where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or       n.situacaoDocumento.codigo = :codSitDoc2 or      n.situacaoDocumento.codigo = :codSitDoc3 or      n.situacaoDocumento.codigo = :codSitDoc4 or      n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

