/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao016.util.blocoe;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocoe.RegE510;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoE {
    public List getApuracoesIcms(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoICMS p where p.anoMes between :dataIn and :dataFim and p.tipoApuracao=:tp and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tp", (short)0);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List getApuracoesIcmsST(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoICMS p where p.anoMes between :dataIn and :dataFim and p.empresa=:empresa and p.tipoApuracao=:tp");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tp", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List getApuracoesIpi(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoIPI p where p.dataFinal between :dataIn and :dataFim and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public HashMap findDadosNotaPropria(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select       n.unidadeFatCliente.pessoa as PESSOA,     n.serie                            as SERIE,     n.modeloDocFiscal                  as MOD_DOC_FISCAL,     n.numeroNota                       as NUMERO_NOTA,     n.dataEmissaoNota                  as DATA_EMISSAO,     n.chaveNFE                         as CHAVE_NFE from NotaFiscalPropria  n  where      n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        return h;
    }

    public HashMap findDadosNotaTerceiros(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   n.unidadeFatFornecedor.pessoa as PESSOA, n.serie as SERIE, n.modeloDocFiscal as MOD_DOC_FISCAL, n.numeroNota as NUMERO_NOTA, n.dataEmissao as DATA_EMISSAO, n.chaveNFE as CHAVE_NFE  from NotaFiscalTerceiros  n  where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        return h;
    }

    public List getRegistrosE510(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select sum(lv.valorIpiTributado) as VR_IPI_TRIBUTADO,  sum(lv.valorIpiIndustria + lv.valorIpiComercio) as VR_IPI,  sum(lv.valorTotal) as VR_TOTAL,  lv.cfop.codigo as COD_CFOP,  lv.incidenciaIpi.codigo as COD_INC_IPI from LivroFiscal lv  where lv.dataLivro between :dataIn and :dataFim and lv.empresa =   :empresa and lv.cancelado = :nao group by  lv.cfop.codigo, lv.incidenciaIpi.codigo ";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegE510> toRet = new ArrayList<RegE510>();
        if (lista != null && !lista.isEmpty()) {
            for (Object o : lista) {
                HashMap h = (HashMap)o;
                RegE510 r = new RegE510();
                r.setCodCfop((String)h.get("COD_CFOP"));
                r.setCodIncidenciaIpi((String)h.get("COD_INC_IPI"));
                r.setValorBCIpi((Double)h.get("VR_IPI_TRIBUTADO"));
                r.setValorIpi((Double)h.get("VR_IPI"));
                r.setValorContabil((Double)h.get("VR_TOTAL"));
                toRet.add(r);
            }
        }
        return toRet;
    }

    public List getApuracoesIcmsDifal(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoIcmsDifalOrigemDestino p where     p.dataInicial between :dataIn and :dataFim  and p.dataFinal between :dataIn and :dataFim and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }
}

