/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao016.util.blocok;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.indicadorestoquesped.ConstEnumIndicadorEstoqueSped;
import com.touchcomp.basementor.constants.enums.tipoproducaosped.EnumConstTipoProducaoSped;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueEscrituradoSped;
import com.touchcomp.basementor.model.vo.IndicadorEstoqueSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.service.impl.indicadorestoquesped.ServiceIndicadorEstoqueSpedImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao016.model2.Reg210;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.BlocoK;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK230;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK235;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK250;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK255;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK260;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK270;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK275;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK290;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK291;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK292;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK300;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK301;
import mentorcore.service.impl.spedfiscal.versao016.model2.blocok.RegK302;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoK {
    Boolean utilizaCodAux = false;

    public BlocoK getBlocoK230(Empresa empresa, Date dataInicial, Date dataFinal, Short agruparComunicado, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoK blocoK = new BlocoK();
        if (agruparComunicado != null && agruparComunicado.equals((short)1)) {
            blocoK.setRegK230(this.getRegistrosBlocoK230AndK235Agrupados(empresa, dataInicial, dataFinal));
        } else {
            blocoK.setRegK230(this.getRegistrosBlocoK230AndK235NaoAgrupados(empresa, dataInicial, dataFinal));
        }
        if (blocoK.getRegK230() != null && !blocoK.getRegK230().isEmpty()) {
            ArrayList<Short> codigosTipoProducaoSped = new ArrayList<Short>();
            codigosTipoProducaoSped.add(EnumConstTipoProducaoSped.PRODUCAO_INTERNA.value);
            blocoK.getProdutos().addAll(this.getProdutosComunicadoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getProdutosConsumo().addAll(this.getProdutosRequisicaoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasComunicadoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasRequisicaoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
        }
        return blocoK;
    }

    private List<RegK230> getRegistrosBlocoK230AndK235Agrupados(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX, sum(i.quantidadeTotal) as QUANTIDADE  from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      (c.tipoProducaoSped.codigo = :cod1) and  c.dataEntradaSaida between :dataInicial and :dataFinal and  c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado)  group by i.produto.identificador, i.produto.codigoAuxiliar";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setShort("cod1", EnumConstTipoProducaoSped.PRODUCAO_INTERNA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK230> result = new ArrayList<RegK230>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK230 r = new RegK230();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            r.setQtdeProducaoAcabada((Double)h.get("QUANTIDADE"));
            r.setRegK235(this.getRegistrosBlocoK235Agrupados(r.getIdentificador(), dataInicial, dataFinal, empresa));
            result.add(r);
        }
        return result;
    }

    private List<RegK235> getRegistrosBlocoK235Agrupados(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX,  i.produtoSubstituto.identificador as ID_PRODUTO_SUBSTITUTO,  i.produtoSubstituto.codigoAuxiliar as COD_AUX_SUBSTITUTO,  sum(g.quantidade) as QUANTIDADE  from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and (c.tipoProducaoSped.codigo = :cod1 or c.tipoProducaoSped.codigo = :cod5) and  c.dataEntradaSaida between :dataInicial and :dataFinal and  c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  and  (ic.produto.tipoIemSped.codigo = :produtoEmProcesso or       ic.produto.tipoIemSped.codigo = :produtoAcabado)  group by      i.produto.identificador,      i.produto.codigoAuxiliar,      i.produtoSubstituto.identificador,      i.produtoSubstituto.codigoAuxiliar ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setShort("cod1", EnumConstTipoProducaoSped.PRODUCAO_INTERNA.value);
        q.setShort("cod5", EnumConstTipoProducaoSped.PRODUCAO_INTERNA_CONJUNTA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK235> result = new ArrayList<RegK235>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK235 r = new RegK235();
            Long idProd = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProd.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            Long idProdSub = (Long)h.get("ID_PRODUTO_SUBSTITUTO");
            r.setIdProdutoSubstituto(idProdSub.toString());
            String codAuxSub = (String)h.get("COD_AUX_SUBSTITUTO");
            if (this.utilizaCodAux.booleanValue() && codAuxSub != null && !codAuxSub.isEmpty()) {
                r.setIdProdutoSubstituto(codAuxSub);
            }
            r.setQtdeConsumida((Double)h.get("QUANTIDADE"));
            r.setDataSaida(dataFinal);
            result.add(r);
        }
        return result;
    }

    public List getSaldoTodosProdutos(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        ArrayList result = new ArrayList();
        result.addAll(this.findSaldoTodosProdutosProprio(dataInventario, empresa));
        result.addAll(this.findSaldoTodosProdutosPoderTerceiros(dataInventario, empresa));
        result.addAll(this.findSaldoTodosProdutosPoderInformante(dataInventario, empresa));
        return result;
    }

    private List findSaldoTodosProdutosProprio(Date dataEstoque, Empresa empresa) throws ExceptionService {
        List<SaldoEstoqueGeral> saldos = SaldoEstoqueUtilities.findSaldoProdutoLista(null, null, dataEstoque, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        ArrayList<EstoqueEscrituradoSped> dados = new ArrayList<EstoqueEscrituradoSped>();
        for (SaldoEstoqueGeral o : saldos) {
            SaldoEstoqueGeral h = o;
            Produto p = h.getProduto();
            if (!this.validarTipoItemSped(p)) continue;
            EstoqueEscrituradoSped r = new EstoqueEscrituradoSped();
            r.setProduto(p);
            r.setQuantidade(h.getQuantidade());
            r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_PROPRIO));
            dados.add(r);
        }
        return dados;
    }

    private IndicadorEstoqueSped getIndicadorSped(ConstEnumIndicadorEstoqueSped tipo) {
        ServiceIndicadorEstoqueSpedImpl serv = (ServiceIndicadorEstoqueSpedImpl)ConfApplicationContext.getBean(ServiceIndicadorEstoqueSpedImpl.class);
        return serv.get(tipo);
    }

    public List findSaldoTodosProdutosPoderTerceiros(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 6);
    }

    private List findSaldoTodosProdutosPoderInformante(Date dataInventario, Empresa empresa) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 2);
    }

    private List findSaldoTodosProdutosTerc(Date dataEstoque, Empresa empresa, int tpEstoque) throws ExceptionService, SpedWritterException {
        Session s = CoreBdUtil.getInstance().getSession();
        String sql = "select sum(s.qtd_saldo) as sum_quantidade,                 s.id_pessoa as id_pessoa, ip.id_produto as id_produto                 from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s                 inner join grade_item_nota_propria gip on gip.id_grade_item_nota_propria = s.id_grade_item_nota_propria                inner join item_nota_propria ip on ip.id_item_nota_propria = gip.id_item_nota_fiscal_propria                group by s.id_pessoa, ip.id_produto union all                 select sum(s.qtd_saldo) as sum_quantidade,                 s.id_pessoa as id_pessoa, it.id_produto as id_produto                 from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s                 inner join grade_item_nota_terceiros git on git.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros                inner join item_nota_terceiros it on it.id_item_nota_terceiros = git.id_item_nota_terceiros                group by s.id_pessoa, it.id_produto";
        NativeQuery q = s.createSQLQuery(sql);
        q.setDate("dataInventario", dataEstoque);
        q.setInteger("empresa", empresa.getIdentificador().intValue());
        q.setInteger("tipoEstoque", tpEstoque);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<EstoqueEscrituradoSped> dados = new ArrayList<EstoqueEscrituradoSped>();
        HashMap<CallSite, EstoqueEscrituradoSped> temp = new HashMap<CallSite, EstoqueEscrituradoSped>();
        for (Object o : prod) {
            EstoqueEscrituradoSped r;
            HashMap h = (HashMap)o;
            Long idProduto = ((Integer)h.get("ID_PRODUTO")).longValue();
            Produto produto = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getProdutoDAO(), idProduto);
            if (!this.validarTipoItemSped(produto)) continue;
            Double quantidade = (Double)h.get("SUM_QUANTIDADE");
            Long idPessoa = ((Integer)h.get("ID_PESSOA")).longValue();
            if (temp.get(idProduto.toString() + idPessoa.toString()) != null) {
                r = (EstoqueEscrituradoSped)temp.get(idProduto.toString() + idPessoa.toString());
                r.setQuantidade(Double.valueOf(r.getQuantidade() + quantidade));
                continue;
            }
            r = new EstoqueEscrituradoSped();
            r.setProduto(produto);
            r.setQuantidade(quantidade);
            if (tpEstoque == 2) {
                r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_TERCEIROS_EM_MEU_PODER));
            } else {
                r.setIndicadorEstoqueSped(this.getIndicadorSped(ConstEnumIndicadorEstoqueSped.ESTOQUE_PROPRIO_EM_PODER_TERCEIROS));
            }
            Pessoa p = (Pessoa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPessoa(), idPessoa);
            r.setPessoa(p);
            temp.put((CallSite)((Object)(idProduto.toString() + idPessoa.toString())), r);
            dados.add(r);
        }
        return dados;
    }

    private boolean validarTipoItemSped(Produto p) {
        return p != null && p.getTipoIemSped() != null && (p.getTipoIemSped().getCodigo().equals("00") || p.getTipoIemSped().getCodigo().equals("01") || p.getTipoIemSped().getCodigo().equals("02") || p.getTipoIemSped().getCodigo().equals("03") || p.getTipoIemSped().getCodigo().equals("04") || p.getTipoIemSped().getCodigo().equals("05") || p.getTipoIemSped().getCodigo().equals("06") || p.getTipoIemSped().getCodigo().equals("10"));
    }

    private List<Reg200> getProdutosComunicadoBlocoK(Empresa empresa, Date dataInicial, Date dataFinal, List<Short> codigosTipoProcessoSped) {
        Object hql = "select distinct  i.produto.identificador as idProduto, i.produto.codigoAuxiliar as codAux, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, i.produto.aliquotaIcms as aliquotaIcms from ItemComunicadoProducao i  left  join i.produto.ncm nc left  join i.produto.genero g left  join i.produto.cest c inner join i.comunicadoProducao cc  where       cc.dataEntradaSaida between :dataInicial and :dataFinal and  cc.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ";
        if (!codigosTipoProcessoSped.isEmpty()) {
            Integer count = 1;
            hql = (String)hql + " and (";
            for (Short cod : codigosTipoProcessoSped) {
                hql = (String)hql + " cc.tipoProducaoSped.codigo = " + cod;
                if (!count.equals(codigosTipoProcessoSped.size())) {
                    hql = (String)hql + " or ";
                }
                Integer n = count;
                count = count + 1;
            }
            hql = (String)hql + ")";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            r.getConsumosEspecificosPadronizados().add(this.getRegistro0210(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosRequisicaoBlocoK(Empresa empresa, Date dataInicial, Date dataFinal, List<Short> codigosTipoProcessoSped) {
        Object hql = "select distinct  ir.produto.identificador as idProduto, ir.produto.codigoAuxiliar as codAux, ir.produto.nome as nomeProduto, ir.produto.unidadeMedida.sigla as unidadeMedida, ir.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, ir.produto.aliquotaIcms as aliquotaIcms from ItemRequisicao ir  left  join ir.produto.ncm nc left  join ir.produto.genero g left  join ir.produto.cest c inner join ir.requisicao r inner join r.itemComunicadoProducao ic inner join ic.comunicadoProducao cc  where       cc.dataEntradaSaida between :dataInicial and :dataFinal and  cc.empresa = :empresa  and (ir.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      ir.produto.tipoIemSped.codigo = :materiaPrima or      ir.produto.tipoIemSped.codigo = :embalagem or      ir.produto.tipoIemSped.codigo = :produtoEmProcesso or      ir.produto.tipoIemSped.codigo = :produtoAcabado or      ir.produto.tipoIemSped.codigo = :subProduto or      ir.produto.tipoIemSped.codigo = :outrosInsumos)  and  (ic.produto.tipoIemSped.codigo = :produtoEmProcesso or       ic.produto.tipoIemSped.codigo = :produtoAcabado)";
        if (!codigosTipoProcessoSped.isEmpty()) {
            Integer count = 1;
            hql = (String)hql + " and (";
            for (Short cod : codigosTipoProcessoSped) {
                hql = (String)hql + " cc.tipoProducaoSped.codigo = " + cod;
                if (!count.equals(codigosTipoProcessoSped.size())) {
                    hql = (String)hql + " or ";
                }
                Integer n = count;
                count = count + 1;
            }
            hql = (String)hql + ")";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            r.getConsumosEspecificosPadronizados().add(this.getRegistro0210(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private List<Reg190> getUnidMedidasComunicadoBlocoK(Date dataInicial, Date dataFinal, Empresa empresa, List<Short> codigosTipoProcessoSped) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where       c.dataEntradaSaida between :dataInicial and :dataFinal and  c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ";
        if (!codigosTipoProcessoSped.isEmpty()) {
            Integer count = 1;
            hql = (String)hql + " and (";
            for (Short cod : codigosTipoProcessoSped) {
                hql = (String)hql + " c.tipoProducaoSped.codigo = " + cod;
                if (!count.equals(codigosTipoProcessoSped.size())) {
                    hql = (String)hql + " or ";
                }
                Integer n = count;
                count = count + 1;
            }
            hql = (String)hql + ")";
        }
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasRequisicaoBlocoK(Date dataInicial, Date dataFinal, Empresa empresa, List<Short> codigosTipoProcessoSped) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from ItemRequisicao i inner join i.requisicao r inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos) ";
        if (!codigosTipoProcessoSped.isEmpty()) {
            Integer count = 1;
            hql = (String)hql + " and (";
            for (Short cod : codigosTipoProcessoSped) {
                hql = (String)hql + " c.tipoProducaoSped.codigo = " + cod;
                if (!count.equals(codigosTipoProcessoSped.size())) {
                    hql = (String)hql + " or ";
                }
                Integer n = count;
                count = count + 1;
            }
            hql = (String)hql + ")";
        }
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private Reg210 getRegistro0210(Long idProduto) {
        Reg210 r = new Reg210();
        r.setIdProduto(idProduto);
        r.setQtdeComponente(1.0);
        return r;
    }

    private Collection<? extends Reg210> getProdutosConsumoBlocoK(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select distinct  ir.produto.identificador as idProduto, ic.produto.identificador as idProdutoPai  from ItemRequisicao ir  left  join ir.produto.ncm nc left  join ir.produto.genero g inner join ir.requisicao r inner join r.itemComunicadoProducao ic inner join ic.comunicadoProducao c  where      c.tipoComunicadoProducao.gerarBlocoKSpedFiscal = :sim and c.dataEntradaSaida between :dataInicial and :dataFinal and c.empresa = :empresa  and (ir.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      ir.produto.tipoIemSped.codigo = :materiaPrima or      ir.produto.tipoIemSped.codigo = :embalagem or      ir.produto.tipoIemSped.codigo = :produtoEmProcesso or      ir.produto.tipoIemSped.codigo = :produtoAcabado or      ir.produto.tipoIemSped.codigo = :subProduto or      ir.produto.tipoIemSped.codigo = :outrosInsumos) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg210> toRet = new ArrayList<Reg210>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg210 r = new Reg210();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setIdProdutoPai((Long)h.get("idProdutoPai"));
            r.setQtdeComponente(1.0);
            r.setQtdePerda(0.0);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegK230> getRegistrosBlocoK230AndK235NaoAgrupados(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX,  i.quantidadeTotal as QUANTIDADE,  c.identificador as ID_COMUNICADO, c.dataEntradaSaida as DATA_INICIAL, c.dataFinal as DATA_FINAL from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      (c.tipoProducaoSped.codigo = :cod1) and (c.dataFinal is null or c.dataFinal between :dataInicial and :dataFinal) and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setShort("cod1", EnumConstTipoProducaoSped.PRODUCAO_INTERNA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK230> result = new ArrayList<RegK230>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK230 r = new RegK230();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            r.setDataInicialOP((Date)h.get("DATA_INICIAL"));
            r.setDataFinalOP((Date)h.get("DATA_FINAL"));
            r.setCodIdentificacaoOP((Long)h.get("ID_COMUNICADO"));
            r.setQtdeProducaoAcabada((Double)h.get("QUANTIDADE"));
            r.setRegK235(this.getRegistrosBlocoK235NaoAgrupados(r.getIdentificador(), dataInicial, dataFinal, empresa, r.getCodIdentificacaoOP()));
            result.add(r);
        }
        return result;
    }

    private List<RegK235> getRegistrosBlocoK235NaoAgrupados(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa, Long idComunicado) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX,  i.produtoSubstituto.identificador as ID_PRODUTO_SUBSTITUTO,  i.produtoSubstituto.codigoAuxiliar as COD_AUX_SUBSTITUTO,  sum(g.quantidade) as QUANTIDADE, r.dataRequisicao as DATA_REQUISICAO  from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and c.identificador = :idComunicado  and r.dataRequisicao  between :dataInicial and :dataFinal and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  group by      i.produto.identificador,      i.produtoSubstituto.identificador,     i.produto.codigoAuxiliar,      i.produtoSubstituto.codigoAuxiliar,     r.dataRequisicao ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setLong("idComunicado", idComunicado.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK235> result = new ArrayList<RegK235>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK235 r = new RegK235();
            Long idProd = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProd.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            Long idProdSub = (Long)h.get("ID_PRODUTO_SUBSTITUTO");
            r.setIdProdutoSubstituto(idProdSub.toString());
            String codAuxSub = (String)h.get("COD_AUX_SUBSTITUTO");
            if (this.utilizaCodAux.booleanValue() && codAuxSub != null && !codAuxSub.isEmpty()) {
                r.setIdProdutoSubstituto(codAuxSub);
            }
            r.setQtdeConsumida((Double)h.get("QUANTIDADE"));
            r.setDataSaida((Date)h.get("DATA_REQUISICAO"));
            result.add(r);
        }
        return result;
    }

    public BlocoK getBlocoK250(Empresa empresa, Date dataInicial, Date dataFinal, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoK blocoK = new BlocoK();
        blocoK.setRegK250(this.getRegistrosBlocoK250AndK255(empresa, dataInicial, dataFinal));
        if (blocoK.getRegK250() != null && !blocoK.getRegK250().isEmpty()) {
            ArrayList<Short> codigosTipoProducaoSped = new ArrayList<Short>();
            codigosTipoProducaoSped.add(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO.value);
            blocoK.getProdutos().addAll(this.getProdutosComunicadoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getProdutosConsumo().addAll(this.getProdutosRequisicaoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasComunicadoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasRequisicaoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
        }
        return blocoK;
    }

    private List<RegK250> getRegistrosBlocoK250AndK255(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  p.identificador as ID_PRODUTO, p.codigoAuxiliar as COD_AUX,  sum(i.quantidadeTotal) as QUANTIDADE, c.dataFinal as DATA_PRODUCAO from ItemComunicadoProducao i inner join i.produto p   inner join i.comunicadoProducao c  where      (c.tipoProducaoSped.codigo = :cod4) and (c.dataFinal between :dataInicial and :dataFinal) and c.empresa = :empresa and (p.tipoIemSped.codigo = :produtoEmProcesso or      p.tipoIemSped.codigo = :produtoAcabado)  group by      p.identificador,     p.codigoAuxiliar,     c.dataFinal";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setShort("cod4", EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK250> result = new ArrayList<RegK250>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK250 r = new RegK250();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            r.setDataProducao((Date)h.get("DATA_PRODUCAO"));
            r.setQtdeProduzida((Double)h.get("QUANTIDADE"));
            r.setRegK255(this.getRegistrosBlocoK255(r.getIdentificador(), dataInicial, dataFinal, empresa));
            result.add(r);
        }
        return result;
    }

    private List<RegK255> getRegistrosBlocoK255(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select  i.produto.identificador as ID_PRODUTO, i.produto.codigoAuxiliar as COD_AUX,  i.produtoSubstituto.identificador as ID_PRODUTO_SUBSTITUTO,  i.produtoSubstituto.codigoAuxiliar as COD_AUX_SUBSTITUTO,  sum(g.quantidade) as QUANTIDADE, c.dataFinal as DATA_CONSUMO from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and (c.tipoProducaoSped.codigo = :cod4) and  c.dataEntradaSaida between :dataInicial and :dataFinal and  c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  and  (ic.produto.tipoIemSped.codigo = :produtoEmProcesso or       ic.produto.tipoIemSped.codigo = :produtoAcabado)  group by      i.produto.identificador,      i.produtoSubstituto.identificador,     i.produto.codigoAuxiliar,      i.produtoSubstituto.codigoAuxiliar,     c.dataFinal ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setShort("cod4", EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK255> result = new ArrayList<RegK255>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK255 r = new RegK255();
            Long idProd = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProd.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            Long idProdSub = (Long)h.get("ID_PRODUTO_SUBSTITUTO");
            r.setIdProdutoSubstituto(idProdSub.toString());
            String codAuxSub = (String)h.get("COD_AUX_SUBSTITUTO");
            if (this.utilizaCodAux.booleanValue() && codAuxSub != null && !codAuxSub.isEmpty()) {
                r.setIdProdutoSubstituto(codAuxSub);
            }
            r.setQtdeConsumo((Double)h.get("QUANTIDADE"));
            r.setDataConsumo(dataFinal);
            result.add(r);
        }
        return result;
    }

    public BlocoK getBlocoK260(Empresa empresa, Date dataInicial, Date dataFinal, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoK blocoK = new BlocoK();
        blocoK.setRegK260(this.getRegistrosBlocoK260(empresa, dataInicial, dataFinal));
        if (blocoK.getRegK250() != null && !blocoK.getRegK250().isEmpty()) {
            ArrayList<Short> codigosTipoProducaoSped = new ArrayList<Short>();
            codigosTipoProducaoSped.add(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO.value);
            codigosTipoProducaoSped.add(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO_CONJUNTA.value);
            blocoK.getProdutos().addAll(this.getProdutosComunicadoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getProdutosConsumo().addAll(this.getProdutosRequisicaoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasComunicadoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasRequisicaoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
        }
        return blocoK;
    }

    private List<RegK260> getRegistrosBlocoK260(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX, i.quantidadeTotal as QUANTIDADE,  c.identificador as ID_COMUNICADO, c.dataEntradaSaida as DATA_INICIAL, c.dataFinal as DATA_FINAL from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      (c.tipoProducaoSped.codigo = :cod3) and (c.dataEntradaSaida between :dataInicial and :dataFinal) and c.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("cod3", EnumConstTipoProducaoSped.PRODUCAO_INTERNA_REPARO.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK260> result = new ArrayList<RegK260>();
        return result;
    }

    public BlocoK getBlocoK270(Empresa empresa, Date dataInicial, Date dataFinal, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoK blocoK = new BlocoK();
        blocoK.setRegK270(this.getRegistrosBlocoK270(empresa, dataInicial, dataFinal));
        if (blocoK.getRegK270() != null && !blocoK.getRegK270().isEmpty()) {
            blocoK.getProdutos().addAll(this.getProdutosComunicadoBlocoK270(empresa, dataInicial, dataFinal));
            blocoK.getProdutosConsumo().addAll(this.getProdutosRequisicaoBlocoK270(empresa, dataInicial, dataFinal));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidaComunicadoBlocoK270(dataInicial, dataFinal, empresa));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidaRequisicaoBlocoK270(dataInicial, dataFinal, empresa));
        }
        return blocoK;
    }

    private List<RegK270> getRegistrosBlocoK270(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  c.quantidadeAnterior as QTDE_ANTERIOR, c.quantidadeCorrecao as QTDE_CORRECAO, i.produto.identificador as ID_PRODUTO, i.produto.codigoAuxiliar as COD_AUX, cp.identificador as ID_COMUNICADO, cp.dataEntradaSaida as DATA_INICIAL, cp.dataFinal as DATA_FINAL, cp.tipoProducaoSped.codigo as COD_TIPO_PROD_SPED, c.identificador as ID_ITEM_CORRECAO_COMUNICADO from CorrecaoApontItemComProd c inner join c.itemComunicado i  inner join c.correcaoApontCom cac inner join cac.comunicadoProducao cp  inner join cac.correcaoApontamentos ca   where      (ca.dataCorrecao between :dataInicial and :dataFinal) and ca.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK270> result = new ArrayList<RegK270>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK270 r = new RegK270();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            r.setDataInicial((Date)h.get("DATA_INICIAL"));
            r.setDataFinal((Date)h.get("DATA_FINAL"));
            r.setCodIdentificacaoOP((Long)h.get("ID_COMUNICADO"));
            Double qtdeAnterior = (Double)h.get("QTDE_ANTERIOR");
            Double qtdeCorrecao = (Double)h.get("QTDE_CORRECAO");
            Double qtde = qtdeCorrecao - qtdeAnterior;
            if (qtde > 0.0) {
                r.setQtdePositiva(qtde);
            } else {
                r.setQtdeNegativa(qtde * -1.0);
            }
            r.setOrigem(this.getOrigemK270((Short)h.get("COD_TIPO_PROD_SPED")));
            Long idItemCorrecaoComunicado = (Long)h.get("ID_ITEM_CORRECAO_COMUNICADO");
            r.setRegK275(this.getRegistrosBlocoK275(idItemCorrecaoComunicado));
            result.add(r);
        }
        return result;
    }

    private List<RegK275> getRegistrosBlocoK275(Long idItemCorrecaoComunicado) {
        String hql = "select  c.quantidadeAnterior as QTDE_ANTERIOR, c.quantidadeCorrecao as QTDE_CORRECAO, c.produtoOriginal.identificador as ID_PRODUTO, c.produtoOriginal.codigoAuxiliar as COD_AUX, p.identificador as ID_PRODUTO_SUBSTITUTO p.codigoAuxiliar as COD_AUX_SUBSTITUTO from CorrecaoApontItemReq c  left join c.produtoNovo p   where      c.correcaoApontItemProd.identificador = :idItemCorrecaoComunicado";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idItemCorrecaoComunicado", idItemCorrecaoComunicado.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK275> result = new ArrayList<RegK275>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK275 r = new RegK275();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            Long idProdutoSub = (Long)h.get("ID_PRODUTO_SUBSTITUTO");
            r.setIdProdutoSubstituto(idProdutoSub.toString());
            String codAuxSub = (String)h.get("COD_AUX_SUBSTITUTO");
            if (this.utilizaCodAux.booleanValue() && codAuxSub != null && !codAuxSub.isEmpty()) {
                r.setIdProdutoSubstituto(codAux);
            }
            Double qtdeAnterior = (Double)h.get("QTDE_ANTERIOR");
            Double qtdeCorrecao = (Double)h.get("QTDE_CORRECAO");
            Double qtde = qtdeCorrecao - qtdeAnterior;
            if (qtde > 0.0) {
                r.setQtdeCorrecaoPositiva(qtde);
            } else {
                r.setQtdeCorrecaoNegativa(qtde * -1.0);
            }
            result.add(r);
        }
        return result;
    }

    private String getOrigemK270(Short codTipoProducaoSped) {
        if (codTipoProducaoSped.equals(EnumConstTipoProducaoSped.PRODUCAO_INTERNA.value) || codTipoProducaoSped.equals(EnumConstTipoProducaoSped.PRODUCAO_INTERNA.value)) {
            return "1";
        }
        if (codTipoProducaoSped.equals(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO.value) || codTipoProducaoSped.equals(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO_CONJUNTA.value)) {
            return "2";
        }
        if (codTipoProducaoSped.equals(EnumConstTipoProducaoSped.PRODUCAO_INTERNA_REPARO.value)) {
            return "4";
        }
        return "1";
    }

    private Collection<? extends Reg200> getProdutosComunicadoBlocoK270(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select distinct  i.produto.identificador as idProduto, i.produto.codigoAuxiliar as codAux, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, ce.codigo as codCest, i.produto.aliquotaIcms as aliquotaIcms from CorrecaoApontItemComProd c inner join c.itemComunicado i  inner join c.correcaoApontCom cac inner join cac.comunicadoProducao cp  inner join cac.correcaoApontamentos ca   left  join i.produto.ncm nc left  join i.produto.genero g left  join i.produto.cest ce where      (ca.dataCorrecao between :dataInicial and :dataFinal) and ca.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            r.getConsumosEspecificosPadronizados().add(this.getRegistro0210(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private Collection<? extends Reg200> getProdutosRequisicaoBlocoK270(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select distinct  cr.produtoOriginal.identificador as idProduto, cr.produtoOriginal.codigoAuxiliar as codAux, cr.produtoOriginal.nome as nomeProduto, cr.produtoOriginal.unidadeMedida.sigla as unidadeMedida, cr.produtoOriginal.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, ce.codigo as codCest, cr.produtoOriginal.aliquotaIcms as aliquotaIcms from CorrecaoApontItemReq cr inner join cr.correcaoApontItemProd c inner join c.correcaoApontCom cac inner join cac.comunicadoProducao cp  inner join cac.correcaoApontamentos ca   left  join cr.produtoOriginal.ncm nc left  join cr.produtoOriginal.genero g left  join cr.produtoOriginal.cest ce where      (ca.dataCorrecao between :dataInicial and :dataFinal) and ca.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            r.getConsumosEspecificosPadronizados().add(this.getRegistro0210(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private Collection<? extends Reg190> getUnidMedidaComunicadoBlocoK270(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select distinct  i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from CorrecaoApontItemComProd c inner join c.itemComunicado i  inner join c.correcaoApontCom cac inner join cac.comunicadoProducao cp  inner join cac.correcaoApontamentos ca   left  join i.produto.ncm nc left  join i.produto.genero g left  join i.produto.cest ce where      (ca.dataCorrecao between :dataInicial and :dataFinal) and  ca.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private Collection<? extends Reg190> getUnidMedidaRequisicaoBlocoK270(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select distinct  i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao, cr.produtoOriginal.unidadeMedida.identificador as idUnidMedidaProd, cr.produtoOriginal.unidadeMedida.sigla as siglaProd, cr.produtoOriginal.unidadeMedida.descricao as descricaoProd from CorrecaoApontItemReq cr inner join cr.itemRequisicao i  inner join cr.correcaoApontItemProd c inner join c.correcaoApontCom cac inner join cac.comunicadoProducao cp  inner join cac.correcaoApontamentos ca   left  join cr.produtoOriginal.ncm nc left  join cr.produtoOriginal.genero g left  join cr.produtoOriginal.cest ce where      (ca.dataCorrecao between :dataInicial and :dataFinal) and  ca.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    public BlocoK getBlocoK290(Empresa empresa, Date dataInicial, Date dataFinal, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoK blocoK = new BlocoK();
        blocoK.setRegK290(this.getRegistrosBlocoK290(empresa, dataInicial, dataFinal));
        if (blocoK.getRegK290() != null && !blocoK.getRegK290().isEmpty()) {
            ArrayList<Short> codigosTipoProducaoSped = new ArrayList<Short>();
            codigosTipoProducaoSped.add(EnumConstTipoProducaoSped.PRODUCAO_INTERNA_CONJUNTA.value);
            blocoK.getProdutos().addAll(this.getProdutosComunicadoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getProdutosConsumo().addAll(this.getProdutosRequisicaoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasComunicadoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasRequisicaoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
        }
        return blocoK;
    }

    private List<RegK290> getRegistrosBlocoK290(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO, i.produto.codigoAuxiliar as COD_AUX,  i.quantidadeTotal as QUANTIDADE,  c.identificador as ID_COMUNICADO, c.dataEntradaSaida as DATA_INICIAL, c.dataFinal as DATA_FINAL from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      (c.tipoProducaoSped.codigo = :cod5) and (c.dataFinal is null or c.dataFinal between :dataInicial and :dataFinal) and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setShort("cod5", EnumConstTipoProducaoSped.PRODUCAO_INTERNA_CONJUNTA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK290> result = new ArrayList<RegK290>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK290 r = new RegK290();
            r.setDataInicialOP((Date)h.get("DATA_INICIAL"));
            r.setDataFinalOP((Date)h.get("DATA_FINAL"));
            r.setCodIdentificacaoOP((Long)h.get("ID_COMUNICADO"));
            RegK291 rr = new RegK291();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            rr.setIdentificador(idProduto);
            rr.setIdProduto(idProduto.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                rr.setIdProduto(codAux);
            }
            rr.setQtde((Double)h.get("QUANTIDADE"));
            r.getRegK291().add(rr);
            rr.setRegK292(this.getRegistrosBlocoK292(rr.getIdentificador(), dataInicial, dataFinal, empresa, r.getCodIdentificacaoOP()));
            result.add(r);
        }
        return result;
    }

    private List<RegK292> getRegistrosBlocoK292(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa, Long idComunicado) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX, sum(g.quantidade) as QUANTIDADE, from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and c.identificador = :idComunicado  and r.dataRequisicao  between :dataInicial and :dataFinal and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  group by      i.produto.identificador,      i.produto.codigoAuxiliar ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setLong("idComunicado", idComunicado.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK292> result = new ArrayList<RegK292>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK292 r = new RegK292();
            Long idProd = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProd.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            r.setQtde((Double)h.get("QUANTIDADE"));
            result.add(r);
        }
        return result;
    }

    public BlocoK getBlocoK300(Empresa empresa, Date dataInicial, Date dataFinal, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoK blocoK = new BlocoK();
        blocoK.setRegK300(this.getRegistrosBlocoK300(empresa, dataInicial, dataFinal));
        if (blocoK.getRegK300() != null && !blocoK.getRegK300().isEmpty()) {
            ArrayList<Short> codigosTipoProducaoSped = new ArrayList<Short>();
            codigosTipoProducaoSped.add(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO_CONJUNTA.value);
            blocoK.getProdutos().addAll(this.getProdutosComunicadoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getProdutosConsumo().addAll(this.getProdutosRequisicaoBlocoK(empresa, dataInicial, dataFinal, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasComunicadoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
            blocoK.getUnidMedidas().addAll(this.getUnidMedidasRequisicaoBlocoK(dataInicial, dataFinal, empresa, codigosTipoProducaoSped));
        }
        return blocoK;
    }

    private List<RegK300> getRegistrosBlocoK300(Empresa empresa, Date dataInicial, Date dataFinal) {
        String hql = "select  i.produto.identificador as ID_PRODUTO,  i.produto.codigoAuxiliar as COD_AUX, sum(i.quantidadeTotal) as QUANTIDADE, c.dataFinal as DATA_PRODUCAO from ItemComunicadoProducao i  inner join i.comunicadoProducao c  where      (c.tipoProducaoSped.codigo = :cod6) and (c.dataFinal between :dataInicial and :dataFinal) and c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado)  group by      i.produto.identificador,     i.produto.codigoAuxiliar,     c.dataFinal";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setShort("cod6", EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO_CONJUNTA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK300> result = new ArrayList<RegK300>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK300 r = new RegK300();
            r.setDataProducao((Date)h.get("DATA_PRODUCAO"));
            RegK301 rr = new RegK301();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            rr.setIdentificador(idProduto);
            rr.setIdProduto(idProduto.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                rr.setIdProduto(codAux);
            }
            rr.setQtde((Double)h.get("QUANTIDADE"));
            rr.setRegK302(this.getRegistrosBlocoK302(rr.getIdentificador(), dataInicial, dataFinal, empresa));
            result.add(r);
        }
        return result;
    }

    private List<RegK302> getRegistrosBlocoK302(Long idProduto, Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select  i.produto.identificador as ID_PRODUTO, i.produto.codigoAuxiliar as COD_AUX,  sum(g.quantidade) as QUANTIDADE from ItemRequisicao i inner join i.requisicao r inner join i.gradeItemRequisicao g  inner join r.itemComunicadoProducao ic  inner join ic.comunicadoProducao c  where      ic.produto      = :idProduto  and (c.tipoProducaoSped.codigo = :cod6) and  c.dataEntradaSaida between :dataInicial and :dataFinal and  c.empresa = :empresa and (i.produto.tipoIemSped.codigo = :mercadoriaParaRevenda or      i.produto.tipoIemSped.codigo = :materiaPrima or      i.produto.tipoIemSped.codigo = :embalagem or      i.produto.tipoIemSped.codigo = :produtoEmProcesso or      i.produto.tipoIemSped.codigo = :produtoAcabado or      i.produto.tipoIemSped.codigo = :subProduto or      i.produto.tipoIemSped.codigo = :outrosInsumos)  and  (ic.produto.tipoIemSped.codigo = :produtoEmProcesso or       ic.produto.tipoIemSped.codigo = :produtoAcabado)  group by      i.produto.identificador,     i.produto.codigoAuxiliar";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("mercadoriaParaRevenda", "00");
        q.setString("materiaPrima", "01");
        q.setString("embalagem", "02");
        q.setString("produtoEmProcesso", "03");
        q.setString("produtoAcabado", "04");
        q.setString("subProduto", "05");
        q.setString("outrosInsumos", "10");
        q.setShort("cod6", EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO_CONJUNTA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<RegK302> result = new ArrayList<RegK302>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            RegK302 r = new RegK302();
            Long idProd = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProd.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdProduto(codAux);
            }
            r.setQtde((Double)h.get("QUANTIDADE"));
            result.add(r);
        }
        return result;
    }
}

