/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao017.util.bloco1;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.BicoBombaCombustivel;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TanqueCombustivel;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedfiscal.versao017.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao017.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao017.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao017.model2.bloco1.Reg1300;
import mentorcore.service.impl.spedfiscal.versao017.model2.bloco1.Reg1310;
import mentorcore.service.impl.spedfiscal.versao017.model2.bloco1.Reg1320;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1300 {
    private HashMap hashProdutos = new HashMap();
    private HashMap hashTanques = new HashMap();
    private HashMap hashBicos = new HashMap();
    private HashMap hashSaldos = new HashMap();
    private HashMap hashProdutoTanque = new HashMap();
    Boolean utilizaCodAux = false;

    public Bloco1 getReg1300(Date dataIn, Date dataFim, Empresa emp, Boolean utilizaCodAux) throws ExceptionService {
        this.utilizaCodAux = utilizaCodAux;
        Bloco1 bloco1 = new Bloco1();
        List<Reg1310> registros1310 = this.getMedicoesReg1310(dataIn, dataFim, emp);
        List<Reg1300> registros1300 = this.gerarRegistros1300(registros1310);
        bloco1.setReg1300(registros1300);
        bloco1.setProdutos(this.getProdutosReg1300(dataIn, dataFim, emp));
        bloco1.setUnidMedidas(this.getUnidMedidaReg1300(dataIn, dataFim, emp));
        return bloco1;
    }

    private List<HashMap> getDadosReg1300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(n.quantidade) as quantidade,   b.gradeCor.produtoGrade.produto.identificador as idProduto, b.gradeCor.produtoGrade.produto.codigoAuxiliar as codAux, b.tanqueCombustivel.identificador as idTanque, n.controleCaixa.dataAbertura as dataMovimentacao from NFCeEncerranteAbastecimento n inner join n.bico b  where cast(n.controleCaixa.dataAbertura as date) between :dataIn and :dataFim and b.bombaCombustivel.empresa  = :empresa group by  b.gradeCor.produtoGrade.produto.identificador, b.tanqueCombustivel.identificador, n.controleCaixa.dataAbertura, b.gradeCor.produtoGrade.produto.codigoAuxiliar order by b.gradeCor.produtoGrade.produto.identificador, n.controleCaixa.dataAbertura");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    private Produto getProduto(Long idProduto) {
        if (this.hashProdutos.containsKey(idProduto)) {
            return (Produto)this.hashProdutos.get(idProduto);
        }
        Produto p = this.getQueryFromProduto(idProduto);
        this.hashProdutos.put(p.getIdentificador(), p);
        return p;
    }

    private Produto getQueryFromProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from Produto p where p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        return (Produto)q.uniqueResult();
    }

    private TanqueCombustivel getTanqueCombustivel(Long idTanque) {
        if (this.hashTanques.containsKey(idTanque)) {
            return (TanqueCombustivel)this.hashTanques.get(idTanque);
        }
        TanqueCombustivel p = this.getQueryFromTanqueCombustivel(idTanque);
        this.hashTanques.put(p.getIdentificador(), p);
        return p;
    }

    private TanqueCombustivel getQueryFromTanqueCombustivel(Long idTanque) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from TanqueCombustivel p where p.identificador = :idTanque");
        q.setLong("idTanque", idTanque.longValue());
        return (TanqueCombustivel)q.uniqueResult();
    }

    private List<HashMap> getProdutosConverterData(List<HashMap> produtos) {
        ArrayList<HashMap> produtosNovos = new ArrayList<HashMap>();
        for (HashMap h : produtos) {
            Long idProduto = (Long)h.get("idProduto");
            Long idTanque = (Long)h.get("idTanque");
            Date dataMovimentacao = ToolDate.dataSemHora((Date)((Date)h.get("dataMovimentacao")));
            Boolean achou = false;
            for (HashMap h2 : produtosNovos) {
                Long idProduto2 = (Long)h2.get("idProduto");
                Long idTanque2 = (Long)h2.get("idTanque");
                Date dataMovimentacao2 = ToolDate.dataSemHora((Date)((Date)h2.get("dataMovimentacao")));
                if (!ToolMethods.isEquals((Object)idProduto, (Object)idProduto2) || !ToolMethods.isEquals((Object)idTanque, (Object)idTanque2) || !ToolMethods.isEquals((Object)dataMovimentacao, (Object)dataMovimentacao2)) continue;
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            HashMap<String, Comparable<Long>> h2 = new HashMap<String, Comparable<Long>>();
            h2.put("idProduto", idProduto);
            h2.put("idTanque", idTanque);
            h2.put("dataMovimentacao", dataMovimentacao);
            produtosNovos.add(h2);
        }
        return produtosNovos;
    }

    private SaldoEstoqueGeralBasico getSaldoEstoque(Produto produto, Date dataMovimentacao, CentroEstoque centroEstoque, Empresa emp) throws ExceptionService {
        if (this.hashSaldos.containsKey(produto.getIdentificador() + "-" + ToolDate.dateToStr((Date)dataMovimentacao) + "-" + centroEstoque.getIdentificador())) {
            return (SaldoEstoqueGeralBasico)this.hashSaldos.get(produto.getIdentificador() + "-" + ToolDate.dateToStr((Date)dataMovimentacao) + "-" + centroEstoque.getIdentificador());
        }
        SaldoEstoqueGeralBasico s = SaldoEstoqueUtilities.findSaldoGradeCorCentroEstoqueBasico(produto, null, dataMovimentacao, centroEstoque, emp, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), centroEstoque.getTipoEstProprioTerceiros(), null);
        if (s != null) {
            if (this.hashSaldos.containsKey(produto.getIdentificador() + "-" + ToolDate.dateToStr((Date)s.getDataSaldo()) + "-" + centroEstoque.getIdentificador())) {
                return null;
            }
            this.hashSaldos.put(produto.getIdentificador() + "-" + ToolDate.dateToStr((Date)s.getDataSaldo()) + "-" + centroEstoque.getIdentificador(), s);
        }
        return s;
    }

    private Reg1310 gerarRegistro1310(SaldoEstoqueGeralBasico saldoAtual, SaldoEstoqueGeralBasico saldoAnterior, TanqueCombustivel tanque, Produto produto, Date dataMovimentacao) {
        Reg1310 r = new Reg1310();
        r.setNumeroTanque(tanque.getNumeroTanque().toString());
        if (saldoAnterior != null) {
            r.setEstoqueAbertura(saldoAnterior.getQuantidade());
        } else {
            r.setEstoqueAbertura(0.0);
        }
        if (saldoAtual != null) {
            r.setVolumeEntrada(saldoAtual.getQuantidadeEntrada());
        } else {
            r.setVolumeEntrada(0.0);
        }
        r.setVolumeDisponivel(r.getEstoqueAbertura() + r.getVolumeEntrada());
        if (saldoAtual != null) {
            r.setVolumeSaida(saldoAtual.getQuantidadeSaida());
        } else {
            r.setVolumeSaida(0.0);
        }
        r.setEstoqueEscriturado(r.getVolumeDisponivel() - r.getVolumeSaida());
        r.setEstoqueFechamento(r.getEstoqueEscriturado() + r.getValorGanho() - r.getValorPerda());
        r.setIdTanque(tanque.getIdentificador());
        r.setIdCentroEstoque(tanque.getCentroEstoque().getIdentificador());
        r.setDataMovimentacao(dataMovimentacao);
        r.setIdCodAuxProduto(produto.getIdentificador().toString());
        if (this.utilizaCodAux.booleanValue()) {
            r.setIdCodAuxProduto(produto.getCodigoAuxiliar());
        }
        r.setReg1320(this.gerarRegistros1320(dataMovimentacao, tanque.getIdentificador()));
        return r;
    }

    private List<Reg1300> gerarRegistros1300(List<Reg1310> registros1310) {
        ArrayList<Reg1300> registros1300 = new ArrayList<Reg1300>();
        for (Reg1310 reg1310 : registros1310) {
            boolean achou = false;
            for (Reg1300 reg1300 : registros1300) {
                if (!reg1300.getIdCodAuxProduto().equals(reg1310.getIdCodAuxProduto()) || !reg1300.getDataFechamento().equals(reg1310.getDataMovimentacao())) continue;
                reg1300.setEstoqueAbertura(reg1300.getEstoqueAbertura() + reg1310.getEstoqueAbertura());
                reg1300.setVolumeEntrada(reg1300.getVolumeEntrada() + reg1310.getVolumeEntrada());
                reg1300.setVolumeDisponivel(reg1300.getVolumeDisponivel() + reg1310.getVolumeDisponivel());
                reg1300.setVolumeSaida(reg1300.getVolumeSaida() + reg1310.getVolumeSaida());
                reg1300.setEstoqueEscriturado(reg1300.getEstoqueEscriturado() + reg1310.getEstoqueEscriturado());
                reg1300.setEstoqueFechamento(reg1300.getEstoqueFechamento() + reg1310.getEstoqueFechamento());
                reg1300.setValorPerda(reg1300.getValorPerda() + reg1310.getValorPerda());
                reg1300.setValorGanho(reg1300.getValorGanho() + reg1310.getValorGanho());
                reg1300.getReg1310().add(reg1310);
                achou = true;
                break;
            }
            if (achou) continue;
            Reg1300 r = new Reg1300();
            r.setEstoqueAbertura(reg1310.getEstoqueAbertura());
            r.setVolumeEntrada(reg1310.getVolumeEntrada());
            r.setVolumeDisponivel(reg1310.getVolumeDisponivel());
            r.setVolumeSaida(reg1310.getVolumeSaida());
            r.setEstoqueEscriturado(reg1310.getEstoqueEscriturado());
            r.setEstoqueFechamento(reg1310.getEstoqueFechamento());
            r.setIdCodAuxProduto(reg1310.getIdCodAuxProduto());
            r.setDataFechamento(reg1310.getDataMovimentacao());
            r.setValorPerda(reg1310.getValorPerda());
            r.setValorGanho(reg1310.getValorGanho());
            r.getReg1310().add(reg1310);
            registros1300.add(r);
        }
        return registros1300;
    }

    private List<Reg1320> gerarRegistros1320(Date dataMovimentacao, Long idTanque) {
        ArrayList<Reg1320> registros1320 = new ArrayList<Reg1320>();
        List<BicoBombaCombustivel> bicos = this.getBicosBombaCombustivel(idTanque);
        for (BicoBombaCombustivel bico : bicos) {
            Double valorInicial = this.getValorLeituraInicialBico(bico, dataMovimentacao);
            Double valorFinal = this.getValorLeituraFinalBico(bico, dataMovimentacao);
            Reg1320 r = new Reg1320();
            r.setNumeroBico(bico.getCodigo());
            r.setValorAbertura(valorInicial);
            r.setValorFechamento(valorFinal);
            Double volumeVendas = r.getValorFechamento() - r.getValorAbertura() - r.getValorAfericao();
            if (volumeVendas >= 0.0) {
                r.setVolumeVendas(volumeVendas);
            }
            registros1320.add(r);
        }
        return registros1320;
    }

    private List<BicoBombaCombustivel> getBicosBombaCombustivel(Long idTanque) {
        if (this.hashBicos.containsKey(idTanque)) {
            return (List)this.hashBicos.get(idTanque);
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct b  from BicoBombaCombustivel b inner join b.tanqueCombustivel t  where t.identificador = :idTanque and b.ativo = :sim");
        q.setLong("idTanque", idTanque.longValue());
        q.setShort("sim", (short)1);
        List bicos = q.list();
        if (bicos != null && !bicos.isEmpty()) {
            this.hashBicos.put(idTanque, bicos);
        }
        return bicos;
    }

    private Double getValorLeituraInicialBico(BicoBombaCombustivel bico, Date dataMovimentacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct coalesce(min(n.quantidade),0) from NFCeEncerranteAbastecimento n  where n.bico = :bico and n.status = :status and cast(n.controleCaixa.dataAbertura as date) = :data ");
        q.setEntity("bico", (Object)bico);
        q.setShort("status", EnumConstAbertoFechado.ABERTO.getValue());
        q.setDate("data", dataMovimentacao);
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    private Double getValorLeituraFinalBico(BicoBombaCombustivel bico, Date dataMovimentacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct coalesce(max(n.quantidade),0) from NFCeEncerranteAbastecimento n  where n.bico = :bico and n.status = :status and cast(n.controleCaixa.dataAbertura as date) = :data ");
        q.setEntity("bico", (Object)bico);
        q.setShort("status", EnumConstAbertoFechado.FECHADO.getValue());
        q.setDate("data", dataMovimentacao);
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    private List<Reg200> getProdutosReg1300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idProduto, p.nome as nomeProduto, p.unidadeMedida.sigla as unidadeMedida, p.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, p.aliquotaIcms as aliquotaIcms, p.codigoAuxiliar as codAux  from NFCeEncerranteAbastecimento n inner join n.bico b inner join b.gradeCor gc  inner join gc.produtoGrade pg inner join pg.produto p left join p.ncm nc left join p.genero g left join p.cest c where cast(n.controleCaixa.dataAbertura as date) between :dataIn and :dataFim and b.bombaCombustivel.empresa  = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidaReg1300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p.unidadeMedida.identificador   as idUnidMedidaProd,     p.unidadeMedida.sigla           as siglaProd,     p.unidadeMedida.descricao       as descricaoProd from NFCeEncerranteAbastecimento n inner join n.bico b inner join b.gradeCor gc  inner join gc.produtoGrade pg inner join pg.produto p where cast(n.controleCaixa.dataAbertura as date) between :dataIn and :dataFim and b.bombaCombustivel.empresa  = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private List<Reg1310> getMedicoesReg1310(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct m.tanqueCombustivel.identificador as idTanque, m.tanqueCombustivel.numeroTanque as numeroTanque, m.dataMovimentacao as dataMovimentacao, m.quantidadeEstoqueAbertura as qtdeAbertura, m.quantidadeEntradas as qtdeEntrada,  m.quantidadeSaidas as qtdeSaida, m.quantidaEstoqueEscriturado as qtdeEstoqueEscriturado, m.quantidadePerda as qtdePerda,  m.quantidadeGanho as qtdeGanho, m.quantidadeFechamento as qtdeFechamento from MedicaoTanqueCombustivel m where m.dataMovimentacao between :dataInicial and :dataFinal and m.empresa = :empresa");
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataIn);
        q.setDate("dataFinal", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1310> registros1310 = new ArrayList<Reg1310>();
        for (Object ob : lista) {
            HashMap h = (HashMap)ob;
            Date dataMovimentacao = (Date)h.get("dataMovimentacao");
            Integer numeroTanque = (Integer)h.get("numeroTanque");
            Long idTanque = (Long)h.get("idTanque");
            Double qtdeAbertura = (Double)h.get("qtdeAbertura");
            Double qtdeEntrada = (Double)h.get("qtdeEntrada");
            Double qtdeSaida = (Double)h.get("qtdeSaida");
            Double qtdeEstoqueEscriturado = (Double)h.get("qtdeEstoqueEscriturado");
            Double qtdePerda = (Double)h.get("qtdePerda");
            Double qtdeGanho = (Double)h.get("qtdeGanho");
            Double qtdeFechamento = (Double)h.get("qtdeFechamento");
            Reg1310 r = new Reg1310();
            r.setDataMovimentacao(dataMovimentacao);
            r.setIdTanque(idTanque);
            r.setNumeroTanque(numeroTanque.toString());
            r.setEstoqueAbertura(qtdeAbertura);
            r.setVolumeEntrada(qtdeEntrada);
            r.setVolumeDisponivel(qtdeAbertura + qtdeEntrada);
            r.setVolumeSaida(qtdeSaida);
            r.setEstoqueEscriturado(qtdeEstoqueEscriturado);
            r.setValorGanho(qtdeGanho);
            r.setValorPerda(qtdePerda);
            r.setEstoqueFechamento(qtdeFechamento);
            r.setIdCodAuxProduto(this.getProdutosByTanque(idTanque));
            r.setReg1320(this.gerarRegistros1320(dataMovimentacao, idTanque));
            registros1310.add(r);
        }
        return registros1310;
    }

    private String getProdutosByTanque(Long idTanque) {
        if (this.hashProdutoTanque.containsKey(idTanque)) {
            return (String)this.hashProdutoTanque.get(idTanque);
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct b.gradeCor.produtoGrade.produto.identificador as idProduto,  b.gradeCor.produtoGrade.produto.codigoAuxiliar as codigoAuxiliar  from BicoBombaCombustivel b inner join b.tanqueCombustivel t  where t.identificador = :idTanque and b.ativo = :sim");
        q.setLong("idTanque", idTanque.longValue());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        Iterator iterator = lista.iterator();
        if (iterator.hasNext()) {
            Object ob = iterator.next();
            HashMap h = (HashMap)ob;
            Long idProduto = (Long)h.get("idProduto");
            String codigoAuxiliar = (String)h.get("codigoAuxiliar");
            this.hashProdutoTanque.put(idTanque, idProduto.toString());
            if (this.utilizaCodAux.booleanValue()) {
                this.hashProdutoTanque.put(idTanque, codigoAuxiliar);
                return codigoAuxiliar;
            }
            return idProduto.toString();
        }
        return "";
    }
}

