/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao017.util.bloco1;

import com.touchcomp.basementor.constants.enums.configarquivosfiscais.impl.ConstantsEfdIcms1400OutrasEntradas;
import com.touchcomp.basementor.constants.enums.configarquivosfiscais.impl.ConstantsEfdIcms1400PrestacaoServTransporte;
import com.touchcomp.basementor.constants.enums.configarquivosfiscais.impl.ConstantsEfdIcms1400ProdutosAgropecuarios;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ConfigArquivosFiscaisItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.SpedFiscalValorAgregado;
import com.touchcomp.basementor.model.vo.TabIndiceUFParticipacaoMunicipio;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1400 {
    private HashMap hashCidades = new HashMap();
    private HashMap hashTabMunicipio = new HashMap();
    private Long OUTRAS_ENTRADAS_DETALHADAS = 3L;
    private Long PRESTACAO_SERV_TRANSPORTE = 4L;
    private Long PRODUTOS_AGROPECUARIOS = 5L;

    public List<SpedFiscalValorAgregado> getDadosValoresAgregados(Date dataIn, Date dataFim, Empresa emp, OpcoesImpostos op) {
        ArrayList<SpedFiscalValorAgregado> valoresAgregados = new ArrayList<SpedFiscalValorAgregado>();
        this.getTipoProdutosAgropcuarios(dataIn, dataFim, emp, op, valoresAgregados);
        this.getTipoOutrasEntradasDetalhadas(dataIn, dataFim, emp, op, valoresAgregados);
        this.getTipoPrestacaoServicosTransporteNFPropriaSaida(dataIn, dataFim, emp, op, valoresAgregados);
        this.getTipoPrestacaoServicosTransporteNFPropriaEntrada(dataIn, dataFim, emp, op, valoresAgregados);
        this.getTipoPrestacaoServicosTransporteNFTerceirosEntrada(dataIn, dataFim, emp, op, valoresAgregados);
        return valoresAgregados;
    }

    private void getTipoProdutosAgropcuarios(Date dataIn, Date dataFim, Empresa emp, OpcoesImpostos op, List<SpedFiscalValorAgregado> valoresAgregados) {
        if (op.getConfigArqFiscaisReg1400ProdAgropecuarios() != null) {
            String[] entradasSaidas = null;
            String[] ncms = null;
            String[] categoriasPessoas = null;
            String[] cfops = null;
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ProdAgropecuarios().getItensConfig()) {
                String chave = item.getItem();
                String valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor)) continue;
                if (ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400ProdutosAgropecuarios.ENTRADA_SAIDA.getChave())) {
                    entradasSaidas = valor.split(";");
                }
                if (ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400ProdutosAgropecuarios.NCM.getChave())) {
                    ncms = valor.split(";");
                }
                if (ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400ProdutosAgropecuarios.CATEGORIA_PESSOA.getChave())) {
                    categoriasPessoas = valor.split(";");
                }
                if (!ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400ProdutosAgropecuarios.CFOP.getChave())) continue;
                cfops = valor.split(";");
            }
            Object query = "select distinct sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, n.unidadeFatCliente.pessoa.endereco.cidade.codIbgeCompleto as codIBGE  from NotaFiscalPropria n  inner join n.itensNotaPropria i  where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa = :empresa and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada) ";
            if (entradasSaidas != null && entradasSaidas.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : entradasSaidas) {
                    query = cont == 1 ? (String)query + " n.naturezaOperacao.entradaSaida = " + new Short(n) : (String)query + " or n.naturezaOperacao.entradaSaida = " + new Short(n);
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (ncms != null && ncms.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : ncms) {
                    query = cont == 1 ? (String)query + " i.produto.ncm.codigo like   '" + n + "%'" : (String)query + " or i.produto.ncm.codigo like   '" + n + "%'";
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (categoriasPessoas != null && categoriasPessoas.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String idCategoria : categoriasPessoas) {
                    query = cont == 1 ? (String)query + " n.unidadeFatCliente.cliente.faturamento.categoriaPessoa.identificador  = " + idCategoria : (String)query + " or n.unidadeFatCliente.cliente.faturamento.categoriaPessoa.identificador  = " + idCategoria;
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (cfops != null && cfops.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String codCfop : cfops) {
                    query = cont == 1 ? (String)query + " i.itemNotaLivroFiscal.cfop.codigo  = '" + codCfop + "'" : (String)query + " or i.itemNotaLivroFiscal.cfop.codigo  = '" + codCfop + "'";
                    ++cont;
                }
                query = (String)query + ")";
            }
            query = (String)query + " group by n.unidadeFatCliente.pessoa.endereco.cidade.codIbgeCompleto";
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery((String)query);
            q.setString("cancelado", "02");
            q.setString("canceladoExt", "03");
            q.setString("denegada", "04");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            for (Object ob : lista) {
                HashMap h = (HashMap)ob;
                Double valor = (Double)h.get("valorTotal");
                String codIBGE = (String)h.get("codIBGE");
                Boolean achou = false;
                for (SpedFiscalValorAgregado v : valoresAgregados) {
                    if (!ToolMethods.isEquals((Object)v.getCidade().getCodIbgeCompleto(), (Object)codIBGE) || !ToolMethods.isEquals((Object)v.getTabIndiceUFParticipacaoMunicipio().getIdentificador(), (Object)this.PRODUTOS_AGROPECUARIOS)) continue;
                    v.setValor(Double.valueOf(v.getValor() + valor));
                    achou = true;
                }
                if (achou.booleanValue()) continue;
                SpedFiscalValorAgregado v = new SpedFiscalValorAgregado();
                v.setCidade(this.getCidadeFromCodigoIBGECompleto(codIBGE));
                v.setValor(valor);
                v.setTabIndiceUFParticipacaoMunicipio(this.getTabIndiceUFParticipacaoMunicipio(this.PRODUTOS_AGROPECUARIOS));
                valoresAgregados.add(v);
            }
        }
    }

    private void getTipoOutrasEntradasDetalhadas(Date dataIn, Date dataFim, Empresa emp, OpcoesImpostos op, List<SpedFiscalValorAgregado> valoresAgregados) {
        if (op.getConfigArqFiscaisReg1400OutrasEntradas() != null) {
            String[] entradasSaidas = null;
            String[] ncms = null;
            String[] categoriasPessoas = null;
            String[] cfops = null;
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400OutrasEntradas().getItensConfig()) {
                String chave = item.getItem();
                String valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor)) continue;
                if (ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400OutrasEntradas.ENTRADA_SAIDA.getChave())) {
                    entradasSaidas = valor.split(";");
                }
                if (ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400OutrasEntradas.NCM.getChave())) {
                    ncms = valor.split(";");
                }
                if (ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400OutrasEntradas.CATEGORIA_PESSOA.getChave())) {
                    categoriasPessoas = valor.split(";");
                }
                if (!ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400OutrasEntradas.CFOP.getChave())) continue;
                cfops = valor.split(";");
            }
            Object query = "select distinct sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, n.unidadeFatCliente.pessoa.endereco.cidade.codIbgeCompleto as codIBGE  from NotaFiscalPropria n  inner join n.itensNotaPropria i  where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa = :empresa and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada) ";
            if (entradasSaidas != null && entradasSaidas.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : entradasSaidas) {
                    query = cont == 1 ? (String)query + " n.naturezaOperacao.entradaSaida = " + new Short(n) : (String)query + " or n.naturezaOperacao.entradaSaida = " + new Short(n);
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (ncms != null && ncms.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : ncms) {
                    query = cont == 1 ? (String)query + " i.produto.ncm.codigo like   '" + n + "%'" : (String)query + " or i.produto.ncm.codigo like   '" + n + "%'";
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (categoriasPessoas != null && categoriasPessoas.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String idCategoria : categoriasPessoas) {
                    query = cont == 1 ? (String)query + " n.unidadeFatCliente.cliente.faturamento.categoriaPessoa.identificador  = " + idCategoria : (String)query + " or n.unidadeFatCliente.cliente.faturamento.categoriaPessoa.identificador  = " + idCategoria;
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (cfops != null && cfops.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String codCfop : cfops) {
                    query = cont == 1 ? (String)query + " i.itemNotaLivroFiscal.cfop.codigo  = '" + codCfop + "'" : (String)query + " or i.itemNotaLivroFiscal.cfop.codigo  = '" + codCfop + "'";
                    ++cont;
                }
                query = (String)query + ")";
            }
            query = (String)query + " group by n.unidadeFatCliente.pessoa.endereco.cidade.codIbgeCompleto";
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery((String)query);
            q.setString("cancelado", "02");
            q.setString("canceladoExt", "03");
            q.setString("denegada", "04");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            for (Object ob : lista) {
                HashMap h = (HashMap)ob;
                Double valor = (Double)h.get("valorTotal");
                String codIBGE = (String)h.get("codIBGE");
                Boolean achou = false;
                for (SpedFiscalValorAgregado v : valoresAgregados) {
                    if (!ToolMethods.isEquals((Object)v.getCidade().getCodIbgeCompleto(), (Object)codIBGE) || !ToolMethods.isEquals((Object)v.getTabIndiceUFParticipacaoMunicipio().getIdentificador(), (Object)this.OUTRAS_ENTRADAS_DETALHADAS)) continue;
                    v.setValor(Double.valueOf(v.getValor() + valor));
                    achou = true;
                }
                if (achou.booleanValue()) continue;
                SpedFiscalValorAgregado v = new SpedFiscalValorAgregado();
                v.setCidade(this.getCidadeFromCodigoIBGECompleto(codIBGE));
                v.setValor(valor);
                v.setTabIndiceUFParticipacaoMunicipio(this.getTabIndiceUFParticipacaoMunicipio(this.OUTRAS_ENTRADAS_DETALHADAS));
                valoresAgregados.add(v);
            }
        }
    }

    private void getTipoPrestacaoServicosTransporteNFPropriaSaida(Date dataIn, Date dataFim, Empresa emp, OpcoesImpostos op, List<SpedFiscalValorAgregado> valoresAgregados) {
        if (op.getConfigArqFiscaisReg1400ServicosTransporte() != null) {
            String valor;
            String chave;
            String[] freteEmitente = null;
            String[] tipoPessoa = null;
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ServicosTransporte().getItensConfig()) {
                chave = item.getItem();
                valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor) || !ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400PrestacaoServTransporte.TIPO_FRETE_NOTA_PROPRIA.getChave())) continue;
                freteEmitente = valor.split(";");
            }
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ServicosTransporte().getItensConfig()) {
                chave = item.getItem();
                valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor) || !ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400PrestacaoServTransporte.TIPO_PESSOA.getChave())) continue;
                tipoPessoa = valor.split(";");
            }
            Object query = "select distinct sum(c.valorFreteCtrc) as valorTotal, n.empresa.pessoa.endereco.cidade.codIbgeCompleto as codIBGE  from NotaFiscalPropria n  inner join n.dadosTransNfPropria t  inner join n.notaPropriaFreteCtrc c  left join t.transportador tt  where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa = :empresa and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada)  and n.unidadeFatCliente.pessoa.endereco.cidade.uf = :uf and n.unidadeFatCliente.pessoa.endereco.cidade <> n.empresa.pessoa.endereco.cidade and n.naturezaOperacao.entradaSaida = :faturamentoSaida";
            if (freteEmitente != null && freteEmitente.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : freteEmitente) {
                    query = cont == 1 ? (String)query + " (t.tipoFrete.fretePorConta = " + new Short(n) + ")" : (String)query + " (t.tipoFrete.fretePorConta = " + new Short(n) + ")";
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (tipoPessoa != null && tipoPessoa.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : tipoPessoa) {
                    query = cont == 1 ? (String)query + "(tt.pessoa.complemento.tipoPessoa = " + new Short(n) + ")" : (String)query + "(or tt.pessoa.complemento.tipoPessoa = " + new Short(n) + ")";
                    ++cont;
                }
                query = (String)query + ")";
            }
            query = (String)query + " group by n.empresa.pessoa.endereco.cidade.codIbgeCompleto";
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery((String)query);
            q.setString("cancelado", "02");
            q.setString("canceladoExt", "03");
            q.setString("denegada", "04");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setEntity("uf", (Object)emp.getPessoa().getEndereco().getCidade().getUf());
            q.setShort("faturamentoSaida", (short)1);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            for (Object ob : lista) {
                HashMap h = (HashMap)ob;
                Double valor2 = (Double)h.get("valorTotal");
                String codIBGE = (String)h.get("codIBGE");
                Boolean achou = false;
                for (SpedFiscalValorAgregado v : valoresAgregados) {
                    if (!ToolMethods.isEquals((Object)v.getCidade().getCodIbgeCompleto(), (Object)codIBGE) || !ToolMethods.isEquals((Object)v.getTabIndiceUFParticipacaoMunicipio().getIdentificador(), (Object)this.PRESTACAO_SERV_TRANSPORTE)) continue;
                    v.setValor(Double.valueOf(v.getValor() + valor2));
                    achou = true;
                }
                if (achou.booleanValue()) continue;
                SpedFiscalValorAgregado v = new SpedFiscalValorAgregado();
                v.setCidade(this.getCidadeFromCodigoIBGECompleto(codIBGE));
                v.setValor(valor2);
                v.setTabIndiceUFParticipacaoMunicipio(this.getTabIndiceUFParticipacaoMunicipio(this.PRESTACAO_SERV_TRANSPORTE));
                valoresAgregados.add(v);
            }
        }
    }

    private void getTipoPrestacaoServicosTransporteNFPropriaEntrada(Date dataIn, Date dataFim, Empresa emp, OpcoesImpostos op, List<SpedFiscalValorAgregado> valoresAgregados) {
        if (op.getConfigArqFiscaisReg1400ServicosTransporte() != null) {
            String valor;
            String chave;
            String[] freteEmitente = null;
            String[] tipoPessoa = null;
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ServicosTransporte().getItensConfig()) {
                chave = item.getItem();
                valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor) || !ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400PrestacaoServTransporte.TIPO_FRETE_NOTA_TERCEIROS.getChave())) continue;
                freteEmitente = valor.split(";");
            }
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ServicosTransporte().getItensConfig()) {
                chave = item.getItem();
                valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor) || !ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400PrestacaoServTransporte.TIPO_PESSOA.getChave())) continue;
                tipoPessoa = valor.split(";");
            }
            Object query = "select distinct sum(c.valorFreteCtrc) as valorTotal, n.unidadeFatCliente.pessoa.endereco.cidade.codIbgeCompleto as codIBGE  from NotaFiscalPropria n  inner join n.dadosTransNfPropria t  inner join n.notaPropriaFreteCtrc c  left join t.transportador tt  where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa = :empresa and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada)  and n.unidadeFatCliente.pessoa.endereco.cidade.uf = :uf and n.unidadeFatCliente.pessoa.endereco.cidade <> n.empresa.pessoa.endereco.cidade and n.naturezaOperacao.entradaSaida = :faturamentoEntrada";
            if (freteEmitente != null && freteEmitente.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : freteEmitente) {
                    query = cont == 1 ? (String)query + " (t.tipoFrete.fretePorConta = " + new Short(n) + ")" : (String)query + " (t.tipoFrete.fretePorConta = " + new Short(n) + ")";
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (tipoPessoa != null && tipoPessoa.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : tipoPessoa) {
                    query = cont == 1 ? (String)query + "(tt.pessoa.complemento.tipoPessoa = " + new Short(n) + ")" : (String)query + "(or tt.pessoa.complemento.tipoPessoa = " + new Short(n) + ")";
                    ++cont;
                }
                query = (String)query + ")";
            }
            query = (String)query + " group by n.unidadeFatCliente.pessoa.endereco.cidade.codIbgeCompleto";
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery((String)query);
            q.setString("cancelado", "02");
            q.setString("canceladoExt", "03");
            q.setString("denegada", "04");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setEntity("uf", (Object)emp.getPessoa().getEndereco().getCidade().getUf());
            q.setShort("faturamentoEntrada", (short)2);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            for (Object ob : lista) {
                HashMap h = (HashMap)ob;
                Double valor2 = (Double)h.get("valorTotal");
                String codIBGE = (String)h.get("codIBGE");
                Boolean achou = false;
                for (SpedFiscalValorAgregado v : valoresAgregados) {
                    if (!ToolMethods.isEquals((Object)v.getCidade().getCodIbgeCompleto(), (Object)codIBGE) || !ToolMethods.isEquals((Object)v.getTabIndiceUFParticipacaoMunicipio().getIdentificador(), (Object)this.PRESTACAO_SERV_TRANSPORTE)) continue;
                    v.setValor(Double.valueOf(v.getValor() + valor2));
                    achou = true;
                }
                if (achou.booleanValue()) continue;
                SpedFiscalValorAgregado v = new SpedFiscalValorAgregado();
                v.setCidade(this.getCidadeFromCodigoIBGECompleto(codIBGE));
                v.setValor(valor2);
                v.setTabIndiceUFParticipacaoMunicipio(this.getTabIndiceUFParticipacaoMunicipio(this.PRESTACAO_SERV_TRANSPORTE));
                valoresAgregados.add(v);
            }
        }
    }

    private void getTipoPrestacaoServicosTransporteNFTerceirosEntrada(Date dataIn, Date dataFim, Empresa emp, OpcoesImpostos op, List<SpedFiscalValorAgregado> valoresAgregados) {
        if (op.getConfigArqFiscaisReg1400ServicosTransporte() != null) {
            String valor;
            String chave;
            String[] freteDestinatario = null;
            String[] tipoPessoa = null;
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ServicosTransporte().getItensConfig()) {
                chave = item.getItem();
                valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor) || !ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400PrestacaoServTransporte.TIPO_FRETE_NOTA_TERCEIROS.getChave())) continue;
                freteDestinatario = valor.split(";");
            }
            for (ConfigArquivosFiscaisItem item : op.getConfigArqFiscaisReg1400ServicosTransporte().getItensConfig()) {
                chave = item.getItem();
                valor = item.getValor();
                if (!ToolMethods.isStrWithData((String)chave) || !ToolMethods.isStrWithData((String)valor) || !ToolMethods.isEquals((Object)chave, (Object)ConstantsEfdIcms1400PrestacaoServTransporte.TIPO_PESSOA.getChave())) continue;
                tipoPessoa = valor.split(";");
            }
            Object query = "select distinct sum(c.valorFreteCtrc) as valorTotal, n.unidadeFatFornecedor.pessoa.endereco.cidade.codIbgeCompleto as codIBGE  from NotaFiscalTerceiros n  inner join n.notaTerceirosFreteCtrc c where n.dataEntrada between :dataIn and :dataFim and n.empresa = :empresa and n.unidadeFatFornecedor.pessoa.endereco.cidade.uf = :ufEmpresa and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada) and n.unidadeFatFornecedor.pessoa.endereco.cidade <> n.empresa.pessoa.endereco.cidade ";
            if (freteDestinatario != null && freteDestinatario.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : freteDestinatario) {
                    query = cont == 1 ? (String)query + " n.tipoFrete.fretePorConta = " + new Short(n) : (String)query + " or n.tipoFrete.fretePorConta = " + new Short(n);
                    ++cont;
                }
                query = (String)query + ")";
            }
            if (tipoPessoa != null && tipoPessoa.length > 0) {
                int cont = 1;
                query = (String)query + " and  (";
                for (String n : tipoPessoa) {
                    query = cont == 1 ? (String)query + " n.transportador.pessoa.complemento.tipoPessoa = " + new Short(n) : (String)query + " or n.transportador.pessoa.complemento.tipoPessoa = " + new Short(n);
                    ++cont;
                }
                query = (String)query + ")";
            }
            query = (String)query + " group by n.unidadeFatFornecedor.pessoa.endereco.cidade.codIbgeCompleto";
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery((String)query);
            q.setString("cancelado", "02");
            q.setString("canceladoExt", "03");
            q.setString("denegada", "04");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setEntity("ufEmpresa", (Object)emp.getPessoa().getEndereco().getCidade().getUf());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            for (Object ob : lista) {
                HashMap h = (HashMap)ob;
                Double valor2 = (Double)h.get("valorTotal");
                String codIBGE = (String)h.get("codIBGE");
                Boolean achou = false;
                for (SpedFiscalValorAgregado v : valoresAgregados) {
                    if (!ToolMethods.isEquals((Object)v.getCidade().getCodIbgeCompleto(), (Object)codIBGE) || !ToolMethods.isEquals((Object)v.getTabIndiceUFParticipacaoMunicipio().getIdentificador(), (Object)this.PRESTACAO_SERV_TRANSPORTE)) continue;
                    v.setValor(Double.valueOf(v.getValor() + valor2));
                    achou = true;
                }
                if (achou.booleanValue()) continue;
                SpedFiscalValorAgregado v = new SpedFiscalValorAgregado();
                v.setCidade(this.getCidadeFromCodigoIBGECompleto(codIBGE));
                v.setValor(valor2);
                v.setTabIndiceUFParticipacaoMunicipio(this.getTabIndiceUFParticipacaoMunicipio(this.PRESTACAO_SERV_TRANSPORTE));
                valoresAgregados.add(v);
            }
        }
    }

    private Cidade getCidadeFromCodigoIBGECompleto(String codIBGE) {
        if (this.hashCidades.get(codIBGE) != null) {
            return (Cidade)this.hashCidades.get(codIBGE);
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c from Cidade c where c.codIbgeCompleto = :codIbge");
        q.setString("codIbge", codIBGE);
        q.setMaxResults(1);
        Cidade c = (Cidade)q.uniqueResult();
        if (c != null) {
            this.hashCidades.put(codIBGE, c);
        }
        return c;
    }

    private TabIndiceUFParticipacaoMunicipio getTabIndiceUFParticipacaoMunicipio(Long identificador) {
        if (this.hashTabMunicipio.get(identificador) != null) {
            return (TabIndiceUFParticipacaoMunicipio)this.hashTabMunicipio.get(identificador);
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c from TabIndiceUFParticipacaoMunicipio c where c.identificador = :identificador");
        q.setLong("identificador", identificador.longValue());
        q.setMaxResults(1);
        TabIndiceUFParticipacaoMunicipio t = (TabIndiceUFParticipacaoMunicipio)q.uniqueResult();
        if (t != null) {
            this.hashTabMunicipio.put(identificador, t);
        }
        return t;
    }
}

