/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao018.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.OutrasObrigLivroFiscal;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg400;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg450;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg500;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC100;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC101;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC110;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC111;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC113;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC114;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC140;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC141;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC170;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC190;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC191;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC195;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC197;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC100NotaTerceiros {
    Boolean utilizaCodAux = false;
    Short utilizaUnidMedidaComplementar = 0;

    public BlocoC getBlocoC100NotasTerceiros(Date dataIn, Date dataFim, Empresa emp, SpedFiscal vo, Boolean utilizaCodAux) throws ExceptionDatabase {
        this.utilizaCodAux = utilizaCodAux;
        this.utilizaUnidMedidaComplementar = vo.getUtilizarUnidadeXML();
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisTerceirosBloco011B0455(dataIn, dataFim, emp));
        if (b.getRegistrosC100() != null && !b.getRegistrosC100().isEmpty()) {
            this.getLivrosFiscaisNotasTerceirosBlocoC100Agrupado(b.getRegistrosC100(), dataIn, dataFim, emp);
            b.setParticipantes(this.getParticipantesNotasTerceirosBlocoC100(dataIn, dataFim, emp));
            if (vo.getGerarBlocoC110().equals((short)1)) {
                b.setObservacoes(this.getInfComplNotasTerceirosBlocoC100(b.getRegistrosC100()));
            }
            b.setNaturezaOperacao(this.getNatOperacaoNotaTerceirosBlocoC100(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoC100(dataIn, dataFim, emp));
            b.setUnidMedidas(this.getUnidMedidasNotaTerceirosBlocoC100(dataIn, dataFim, emp, b.getRegistrosC100()));
            b.setProdutos(this.getProdutosNotaTerceirosBlocoC100(dataIn, dataFim, emp, b.getRegistrosC100()));
        }
        return b;
    }

    List getNotasFiscaisTerceirosBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, 0 as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.pessoa.identificador as idPessoa, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfTerceiros.valorFrete as vlrFrete, n.valoresNfTerceiros.valorSeguro as vlrSeguro, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorDespAcess as vlrDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorIcmsDesonerado as vlrIcmsDesonerado, n.valoresNfTerceiros.valorIcmsSt as vlrIcmsSt, n.valoresNfTerceiros.bcIcmsSt as bcIcmsSt, n.valoresNfTerceiros.valorIpiIndustria + n.valoresNfTerceiros.valorIPIComercio as vlrIpi, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, n.valoresNfTerceiros.valorCofinsST as vlrCofinsST, n.valoresNfTerceiros.valorPisSt as vlrPisST,  cp.entrada as efetuaEntrada, cp.numeroParcelas as numeroParcelas from NotaFiscalTerceiros n inner join n.livrosFiscais lv  left join n.tipoFrete tf left join n.condicoesPagamento cp where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Terceiros: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(1);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT((Double)h.get("vlrIcmsDesonerado"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setEfetuaEntrada((Integer)h.get("efetuaEntrada"));
            r.setNumParcelas((Integer)h.get("numeroParcelas"));
            if (!this.isDocCancelado(r.getCodSituacaoDoc())) {
                this.getInformacoesComplementares(r);
                this.getFatura(r);
                this.getItensDocumento(r);
            }
            toRet.add(r);
        }
        return toRet;
    }

    private boolean isDocCancelado(String sitDoc) {
        boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
        return docCancInut;
    }

    private void getInformacoesComplementares(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        Query q = s.createQuery("select n.observacoesIntFisco as obsIntFisco  from NotaFiscalTerceiros n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<ObservacaoIntFiscoNFTerceiros> obsIntFisco = new ArrayList<ObservacaoIntFiscoNFTerceiros>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoIntFiscoNFTerceiros obs = (ObservacaoIntFiscoNFTerceiros)h.get("obsIntFisco");
            obsIntFisco.add(obs);
        }
        q = s.createQuery("select n.observacaoNotaTerceiros as obsEstNota from NotaFiscalTerceiros n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        ArrayList<ObservacaoNotaTerceiros> obsEstNota = new ArrayList<ObservacaoNotaTerceiros>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoNotaTerceiros obs = (ObservacaoNotaTerceiros)h.get("obsEstNota");
            obsEstNota.add(obs);
        }
        if (!obsIntFisco.isEmpty() || !obsEstNota.isEmpty()) {
            RegC110 r = new RegC110();
            r.setObsIntFiscoNFTerceiros(obsIntFisco);
            r.setObsNotaTerceiros(obsEstNota);
            toRet.add(r);
        }
        regC100.setRegC110(toRet);
        if (!regC100.getRegC110().isEmpty()) {
            this.getProcessosReferenciados(regC100);
            this.getDocFiscalReferenciados(regC100);
            this.getCuponsReferenciados(regC100);
        }
    }

    private List getInfComplNotasTerceirosBlocoC100(List<RegC100> regC100) {
        ArrayList<Reg450> toRet = new ArrayList<Reg450>();
        for (RegC100 o : regC100) {
            Reg450 reg450;
            RegC100 r = o;
            if (r.getRegC110() == null || r.getRegC110().isEmpty()) continue;
            RegC110 regC110 = r.getRegC110().get(0);
            Iterator<ObservacaoNotaTerceiros> iterator = regC110.getObsNotaTerceiros().iterator();
            while (iterator.hasNext()) {
                ObservacaoNotaTerceiros observacaoNotaTerceiros;
                ObservacaoNotaTerceiros obsEstNota = observacaoNotaTerceiros = iterator.next();
                reg450 = new Reg450();
                reg450.setIdObservacao(obsEstNota.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsEstNota.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
            for (ObservacaoNotaTerceiros observacaoNotaTerceiros : regC110.getObsIntFiscoNFTerceiros()) {
                ObservacaoIntFiscoNFTerceiros obsIntFisco = (ObservacaoIntFiscoNFTerceiros)observacaoNotaTerceiros;
                reg450 = new Reg450();
                reg450.setIdObservacao(obsIntFisco.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsIntFisco.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
        }
        return toRet;
    }

    private void getProcessosReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        regC100.setRegC111(toRet);
    }

    private void getDocFiscalReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.identificador as idNotaRef from NotaFiscalTerceiros n inner join n.notaReferenciada p where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            Long idNotaRef = (Long)h.get("idNotaRef");
            toRet.addAll(this.getNotasPropriasReferenciadas(idNotaRef));
        }
        regC100.setRegC113(toRet);
    }

    private void getCuponsReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.cupomFiscal.modeloDocFiscal.codigo as modDocFiscal, p.cupomFiscal.cupom.impressoraFiscal.serie as serie, p.cupomFiscal.cupom.nrCOO as nrSeq, p.cupomFiscal.cupom.impressoraFiscal.nrSequencialEcf as nrCaixa, p.cupomFiscal.cupom.dataEmissao as dataEmissao from NotaFiscalTerceiros n inner join n.cuponsReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC114> toRet = new ArrayList<RegC114>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC114 r = new RegC114();
            r.setCodModeloDocFiscal((String)h.get("modDocFiscal"));
            r.setNrSerieFabECF((String)h.get("serie"));
            r.setNrDocumento((Integer)h.get("nrSeq"));
            r.setNrCaixa((Short)h.get("nrCaixa"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        regC100.setRegC114(toRet);
    }

    private void getFatura(RegC100 regC100) {
        String codModDocFiscal = regC100.getCodModDocFiscal();
        Integer efetuaEntrada = regC100.getEfetuaEntrada();
        Integer numParcelas = regC100.getNumParcelas();
        if ((codModDocFiscal.equalsIgnoreCase("01") || codModDocFiscal.equalsIgnoreCase("1A")) && efetuaEntrada != null && efetuaEntrada != 1 && numParcelas != null && numParcelas != 1) {
            Session s = CoreBdUtil.getInstance().getSession();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select inf.titulos as titulos from InfPagamentoNfTerceiros inf where inf.notaFiscalTerceiros.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            Double valorTotalTit = 0.0;
            Integer tam = ret.size();
            ArrayList dadosTitulos = new ArrayList();
            for (Object o : ret) {
                Titulo t = (Titulo)o;
                valorTotalTit = valorTotalTit + t.getValor();
                HashMap<String, Comparable<Short>> h = new HashMap<String, Comparable<Short>>();
                h.put("numParcela", t.getNumParcTituloEstnota());
                h.put("dataVencimento", t.getDataVencimento());
                h.put("valorParcela", t.getValor());
                dadosTitulos.add(h);
            }
            RegC140 regC140 = new RegC140();
            regC140.setIndicadorEmitente((short)1);
            regC140.setIndicadorTipoTitulo("00");
            regC140.setNumeroTitulo(idNota);
            regC140.setNumeroParcelas(tam.shortValue());
            regC140.setValorTitulos(valorTotalTit);
            regC140.setRegC141(this.getVencimentoFatura(dadosTitulos));
            regC100.setRegC140(regC140);
        }
    }

    private List getVencimentoFatura(List dadosTitulos) {
        ArrayList<RegC141> toRet = new ArrayList<RegC141>();
        for (Object o : dadosTitulos) {
            HashMap h = (HashMap)o;
            RegC141 regC141 = new RegC141();
            regC141.setDataVencimento((Date)h.get("dataVencimento"));
            regC141.setValorTitulo((Double)h.get("valorParcela"));
            regC141.setNumParcela((Short)h.get("numParcela"));
            toRet.add(regC141);
        }
        return toRet;
    }

    private void getItensDocumento(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select distinct  p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.descricaoComplementar as descricaoComplementar, p.quantidadeTotal as quantidade, p.unidadeMedida.sigla as sigla, p.unidadeMedidaXML as siglaComplementar, (p.valorUnitario * p.quantidadeTotal) as valorTotal, p.itemNotaLivroFiscal.valorStCustoCompTotNota as valorCustoCompoeTotal, p.itemNotaLivroFiscal.vrCustoICMSST as valorCustoICMSST, p.itemNotaLivroFiscal.valorFCPSt as valorFCPSt,  p.itemNotaLivroFiscal.vrIpiObservacao as valorIpiObservacao,  p.valorDesconto as valorDesconto, p.modeloFiscal.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, p.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrIcmsDesonerado as valorIcmsDesonerado, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, planoCred.identificador as planoContaCred, planoDeb.identificador as planoContaDeb, p.naturezaOperacao.entradaSaida as natEntSaida, p.produto.codigoAuxiliar as codAux from ItemNotaTerceiros p left join p.planoContaCred planoCred left join p.planoContaDeb planoDeb where p.notaFiscalTerceiros.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setNumeroItem((Integer)h.get("numeroItem"));
            System.out.println("Item Nr: " + r.getNumeroItem().toString());
            r.setDescricaoComp((String)h.get("nomeProduto"));
            String descricaoComplementar = (String)h.get("descricaoComplementar");
            if (ToolMethods.isStrWithData((String)descricaoComplementar)) {
                r.setDescricaoComp(descricaoComplementar);
            }
            if (h.get("quantidade") != null) {
                r.setQuantidade((Double)h.get("quantidade"));
            } else {
                r.setQuantidade(0.0);
            }
            r.setUnidadeMedida((String)h.get("sigla"));
            String unidMedidaComplementar = (String)h.get("siglaComplementar");
            if (ToolMethods.isStrWithData((String)unidMedidaComplementar) && ToolMethods.isAffirmative((Number)this.utilizaUnidMedidaComplementar)) {
                r.setUnidadeMedida(unidMedidaComplementar);
            }
            r.setValorDesconto((Double)h.get("valorDesconto"));
            if (h.get("movimentacaoFisica") != null) {
                Short movimentacaoFisica = (Short)h.get("movimentacaoFisica");
                if (movimentacaoFisica.equals((short)1)) {
                    r.setMovimentacaoFisica((short)0);
                } else {
                    r.setMovimentacaoFisica((short)1);
                }
            } else {
                r.setMovimentacaoFisica((short)1);
            }
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setValorAbatNT((Double)h.get("valorIcmsDesonerado"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            if (r.getVlrPis() > 0.0) {
                r.setVlrBCPis((Double)h.get("BCGeral"));
            }
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            if (r.getVlrCofins() > 0.0) {
                r.setBcCofins((Double)h.get("BCGeral"));
            }
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((Long)h.get("planoContaCred"));
            r.setPlanoDeb((Long)h.get("planoContaDeb"));
            r.setValorItem((Double)h.get("valorTotal"));
            Short vrCustoCompoeTotal = (Short)h.get("valorCustoCompoeTotal");
            Double valorCustoICMST = (Double)h.get("valorCustoICMSST");
            Double valorFCPST = (Double)h.get("valorFCPSt");
            Double valorIpiObservacao = (Double)h.get("valorIpiObservacao");
            if (ToolMethods.isEquals((Object)vrCustoCompoeTotal, (Object)1)) {
                r.setValorItem(r.getValorItem() + valorCustoICMST);
            }
            r.setValorItem(r.getValorItem() + valorFCPST + valorIpiObservacao);
            toRet.add(r);
        }
        regC100.setRegC170(toRet);
    }

    private List getNotasPropriasReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida                      as entSai,     n.unidadeFatCliente.pessoa.identificador as idPessoa,     n.modeloDocFiscal.codigo                         as codModeloDocFiscal,     n.serie                                          as serie,     n.numeroNota                                     as numeroNota,     n.dataEmissaoNota                                as dataEmissao,     n.chaveNFE                                       as chaveNFe  from NotaFiscalPropria n where      n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((Short)h.get("entSai"));
            r.setIndicadorEmitente((short)0);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setChaveNFe((String)h.get("chaveNFe"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisNotasTerceirosBlocoC100(List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC100> iterator = registrosC100.iterator();
        while (iterator.hasNext()) {
            RegC100 o;
            RegC100 regC100 = o = iterator.next();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select distinct lv from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            regC100.setRegC190(this.getRegC190(ret));
            regC100.setRegC195(this.getRegC195(ret));
        }
    }

    private List getRegC190(List livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (Object ob : livrosFiscais) {
            LivroFiscal h = (LivroFiscal)ob;
            RegC190 r = this.getRegC190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            RegC191 rr = null;
            if (r == null) {
                r = new RegC190();
                rr = new RegC191();
                r.setRegC191(rr);
                toRet.add(r);
            }
            rr = r.getRegC191();
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setBcCalculoIcmsSt(h.getValorBCIcmsSt() + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(h.getValorIcmsSt() + r.getValorIcmsST());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() + r.getValorNaoTribIcms());
            r.setValorIpi(h.getValorIpiIndustria() + h.getValorIpiComercio() + r.getValorIpi());
            rr.setValorFCP(h.getValorFCP() + rr.getValorFCP());
            Boolean compoeFCPST = false;
            String cod = r.getIncidenciaIcms();
            if (cod.trim().length() == 3) {
                if (ToolMethods.isEquals((Object)(cod = cod.substring(1, 3)), (Object)"10") || ToolMethods.isEquals((Object)cod, (Object)"30") || ToolMethods.isEquals((Object)cod, (Object)"70") || ToolMethods.isEquals((Object)cod, (Object)"90")) {
                    compoeFCPST = true;
                }
            } else if (cod.trim().length() == 4 && (ToolMethods.isEquals((Object)(cod = cod.substring(1, 4)), (Object)"201") || ToolMethods.isEquals((Object)cod, (Object)"202") || ToolMethods.isEquals((Object)cod, (Object)"203") || ToolMethods.isEquals((Object)cod, (Object)"900"))) {
                compoeFCPST = true;
            }
            if (!compoeFCPST.booleanValue()) continue;
            rr.setValorFCPST(h.getValorFCPSt() + rr.getValorFCPST());
            rr.setValorFCPSTRet(h.getValorFCPStRetido() + rr.getValorFCPSTRet());
        }
        return toRet;
    }

    List getParticipantesNotasTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalTerceiros n  inner join n.livrosFiscais lv  inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private RegC190 getRegC190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegC190 r = (RegC190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }

    private List<Reg200> getProdutosNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<RegC100> registrosC100) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, i.produto.aliquotaIcms as aliquotaIcms, i.produto.codigoAuxiliar as codAux,  i.unidadeMedidaXML as unidadeMedidaComplementar from ItemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g left join i.produto.cest c where (i.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod1 or i.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod2  or i.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod3 or i.notaFiscalTerceiros.modeloDocFiscal.codigo=:cod4) and i.notaFiscalTerceiros.dataEntrada between :dataIn and :dataFim and i.notaFiscalTerceiros.empresa=:empresa and (i.notaFiscalTerceiros.situacaoDocumento.codigo = :codSitDoc1 or  i.notaFiscalTerceiros.situacaoDocumento.codigo = :codSitDoc2 or i.notaFiscalTerceiros.situacaoDocumento.codigo = :codSitDoc3 or i.notaFiscalTerceiros.situacaoDocumento.codigo = :codSitDoc4 or i.notaFiscalTerceiros.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            if (idProduto.equals(2062L)) {
                System.out.println("teste");
            }
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            String unidMedidaComplementar = (String)h.get("unidadeMedidaComplementar");
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            toRet.add(r);
        }
        for (RegC100 r100 : registrosC100) {
            if (r100.getRegC195() == null || r100.getRegC195().isEmpty()) continue;
            for (RegC195 r195 : r100.getRegC195()) {
                if (r195.getAjustesLvFiscal() == null || r195.getAjustesLvFiscal().isEmpty()) continue;
                for (RegC197 r197 : r195.getAjustesLvFiscal()) {
                    if (r197.getIdProduto() == null || !(r197.getVlrIcmsIcmsST() > 0.0)) continue;
                    toRet.add((Reg200)this.getProdutoAjustesFiscais(r197.getIdProduto()));
                }
            }
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private List<Reg400> getNatOperacaoNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.naturezaOperacao.identificador as idNatOperacao, i.naturezaOperacao.descricao as descNatOperacao from NotaFiscalTerceiros n inner join n.livrosFiscais lv  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalTerceiros n  inner join n.livrosFiscais lv  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNatPC((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedidaXML as siglaComplementar, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalTerceiros n  inner join n.livrosFiscais lv  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            String unidMedidaComplementar = (String)h.get("siglaComplementar");
            if (ToolMethods.isStrWithData((String)unidMedidaComplementar) && ToolMethods.isAffirmative((Number)this.utilizaUnidMedidaComplementar)) {
                r.setCodUnidMedida(unidMedidaComplementar.toUpperCase());
            }
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            String codUnidadeMedidaProd = (String)h.get("siglaProd");
            if (r.getCodUnidMedida() == codUnidadeMedidaProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        for (RegC100 r100 : registrosC100) {
            if (r100.getRegC195() == null || r100.getRegC195().isEmpty()) continue;
            for (RegC195 r195 : r100.getRegC195()) {
                if (r195.getAjustesLvFiscal() == null || r195.getAjustesLvFiscal().isEmpty()) continue;
                for (RegC197 r197 : r195.getAjustesLvFiscal()) {
                    if (r197.getIdProduto() == null) continue;
                    toRet.add((Reg190)this.getUnidMedidaAjustesFiscais(r197.getIdProduto()));
                }
            }
        }
        return toRet;
    }

    private Object getProdutoAjustesFiscais(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idProduto, p.nome as nomeProduto, p.unidadeMedida.sigla as unidadeMedida, p.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, c.codigo as codCest, p.aliquotaIcms as aliquotaIcms, p.codigoAuxiliar as codAux  from Produto p left join p.ncm nc left join p.genero g left join p.cest c where  p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            return r;
        }
        return null;
    }

    private List<RegC195> getRegC195(List livrosFiscais) {
        ArrayList<RegC195> lista = new ArrayList<RegC195>();
        for (Object o : livrosFiscais) {
            LivroFiscal lv = (LivroFiscal)o;
            for (ObservacaoLivroFiscal os : lv.getObsLivroFiscal()) {
                boolean achou = false;
                for (RegC195 r : lista) {
                    if (os.getObsFaturamento() == null || r.getIdObservacao() == null || !r.getIdObservacao().equals(os.getObsFaturamento().getIdentificador())) continue;
                    r.getAjustesLvFiscal().addAll(this.getOutrasObrigacoesLivroFiscal(os, r.getAjustesLvFiscal()));
                    achou = true;
                }
                if (achou) continue;
                RegC195 r = new RegC195();
                if (os.getObsFaturamento() != null) {
                    r.setIdObservacao(os.getObsFaturamento().getIdentificador());
                    r.setDescricaoObservacao(os.getObsFaturamento().getNome());
                }
                r.setTextoObs(os.getConteudo());
                r.getAjustesLvFiscal().addAll(this.getOutrasObrigacoesLivroFiscal(os, r.getAjustesLvFiscal()));
                lista.add(r);
            }
        }
        return lista;
    }

    private Collection<? extends RegC197> getOutrasObrigacoesLivroFiscal(ObservacaoLivroFiscal os, List<RegC197> ajustes) {
        ArrayList<RegC197> aux = new ArrayList<RegC197>();
        for (OutrasObrigLivroFiscal out : os.getOutrasObrigLivroFiscal()) {
            Boolean achou = false;
            for (RegC197 r : ajustes) {
                if (!out.getTipoAjusteIcmsDocFiscal().getCodigo().equals(r.getCodTipoAjusteApIcms()) || !out.getProduto().getIdentificador().equals(r.getIdProduto())) continue;
                r.setVlrBCIcmsIcmsST(r.getVlrBCIcmsIcmsST() + out.getVlrBCIcmsIcmsST());
                r.setVlrIcmsIcmsST(r.getVlrIcmsIcmsST() + out.getVlrIcmsIcmsST());
                r.setVlrOutros(r.getVlrOutros() + out.getVlrOutros());
                achou = true;
            }
            if (achou.booleanValue()) continue;
            RegC197 c197 = new RegC197();
            c197.setAliquotaIcms(out.getAliquotaIcms());
            c197.setCodTipoAjusteApIcms(out.getTipoAjusteIcmsDocFiscal().getCodigo());
            c197.setDescricaoComp(out.getDescricaoComp());
            if (out.getProduto() != null) {
                c197.setIdProduto(out.getProduto().getIdentificador());
                c197.setCodAuxProduto(out.getProduto().getCodigoAuxiliar());
            }
            c197.setVlrBCIcmsIcmsST(out.getVlrBCIcmsIcmsST());
            c197.setVlrIcmsIcmsST(out.getVlrIcmsIcmsST());
            c197.setVlrOutros(out.getVlrOutros());
            aux.add(c197);
        }
        return aux;
    }

    private Object getUnidMedidaAjustesFiscais(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     p.unidadeMedida.identificador           as idUnidMedida,     p.unidadeMedida.sigla                   as sigla,     p.unidadeMedida.descricao               as descricao from Produto p  where  p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            return r;
        }
        return null;
    }

    private void getLivrosFiscaisNotasTerceirosBlocoC100Agrupado(List<RegC100> registrosC100, Date dataIn, Date dataFim, Empresa emp) {
        List<HashMap> dadosLivros = this.getDadosLivroFiscalAgrupado(dataIn, dataFim, emp);
        List<HashMap> dadosAjustesLivros = this.getDadosAjustesLivroFiscalAgrupado(dataIn, dataFim, emp);
        for (RegC100 regC100 : registrosC100) {
            ArrayList<HashMap> livros = new ArrayList<HashMap>();
            for (HashMap h : dadosLivros) {
                Long idNota = (Long)h.get("idNota");
                if (!ToolMethods.isEquals((Object)idNota, (Object)regC100.getIdentificador())) continue;
                Long idLivro = (Long)h.get("idLivro");
                ArrayList<HashMap> ajustes = new ArrayList<HashMap>();
                for (HashMap hh : dadosAjustesLivros) {
                    Long idLivroAjuste = (Long)hh.get("idLivro");
                    if (!ToolMethods.isEquals((Object)idLivroAjuste, (Object)idLivro)) continue;
                    ajustes.add(hh);
                }
                h.put("ajustes", ajustes);
                livros.add(h);
            }
            if (!ToolMethods.isWithData(livros)) continue;
            regC100.setRegC101(this.getRegC101Agrupado(livros));
            regC100.setRegC190(this.getRegC190Agrupado(livros));
            regC100.setRegC195(this.getRegC195Agrupado(livros));
        }
    }

    private List<HashMap> getDadosLivroFiscalAgrupado(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.identificador as idNota, lv.identificador as idLivro, lv.valorIcmsPartilhaDest as valorIcmsPartilhaDest, lv.valorIcmsPartilhaRem  as valorIcmsPartilhaRem, lv.valorFundoPobreza as valorFundoPobreza,  lv.incidenciaIcms.codigo as codIncidenciaIcms, lv.cfop.codigo as  codCfop, lv.aliquotaIcms as aliquotaIcms, lv.valorTotal as valorOperacao, lv.valorIcmsTributado as valorBCIcms, lv.valorIcms as valorIcms, lv.valorBCIcmsSt as valorBCIcmsST, lv.valorIcmsSt as valorIcmsST, (lv.vrNaoTribIcms - lv.valorIcmsDesonerado) as valorNaoTribIcms, (lv.valorIpiIndustria + lv.valorIpiComercio) as valorIpi,  lv.valorFCP as valorFCP, lv.valorFCPSt as valorFCPST, lv.valorFCPStRetido as valorFCPSTRet from NotaFiscalTerceiros n inner join n.livrosFiscais lv where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getRegC190Agrupado(List<HashMap> livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (HashMap h : livrosFiscais) {
            String codIncIcms = (String)h.get("codIncidenciaIcms");
            String codCfop = (String)h.get("codCfop");
            Double aliquotaIcms = (Double)h.get("aliquotaIcms");
            Double valorOperacao = (Double)h.get("valorOperacao");
            Double valorBCIcms = (Double)h.get("valorBCIcms");
            Double valorIcms = (Double)h.get("valorIcms");
            Double valorBCIcmsST = (Double)h.get("valorBCIcmsST");
            Double valorIcmsST = (Double)h.get("valorIcmsST");
            Double valorNaoTribIcms = (Double)h.get("valorNaoTribIcms");
            Double valorIpi = (Double)h.get("valorIpi");
            Double valorFCP = (Double)h.get("valorFCP");
            Double valorFCPST = (Double)h.get("valorFCPST");
            Double valorFCPSTRet = (Double)h.get("valorFCPSTRet");
            RegC190 r = this.getRegC190(codIncIcms, codCfop, aliquotaIcms, toRet);
            RegC191 rr = null;
            if (r == null) {
                r = new RegC190();
                rr = new RegC191();
                r.setRegC191(rr);
                toRet.add(r);
            }
            rr = r.getRegC191();
            r.setIncidenciaIcms(codIncIcms);
            r.setCfop(codCfop);
            r.setAliquotaIcms(aliquotaIcms);
            r.setValorOperacao(valorOperacao + r.getValorOperacao());
            r.setBcCalculoIcms(valorBCIcms + r.getBcCalculoIcms());
            r.setValorIcms(valorIcms + r.getValorIcms());
            r.setBcCalculoIcmsSt(valorBCIcmsST + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(valorIcmsST + r.getValorIcmsST());
            r.setValorNaoTribIcms(valorNaoTribIcms + r.getValorNaoTribIcms());
            r.setValorIpi(valorIpi + r.getValorIpi());
            rr.setValorFCP(valorFCP + rr.getValorFCP());
            Boolean compoeFCPST = false;
            String cod = r.getIncidenciaIcms();
            if (cod.trim().length() == 3) {
                if (ToolMethods.isEquals((Object)(cod = cod.substring(1, 3)), (Object)"10") || ToolMethods.isEquals((Object)cod, (Object)"30") || ToolMethods.isEquals((Object)cod, (Object)"70") || ToolMethods.isEquals((Object)cod, (Object)"90")) {
                    compoeFCPST = true;
                }
            } else if (cod.trim().length() == 4 && (ToolMethods.isEquals((Object)(cod = cod.substring(1, 4)), (Object)"201") || ToolMethods.isEquals((Object)cod, (Object)"202") || ToolMethods.isEquals((Object)cod, (Object)"203") || ToolMethods.isEquals((Object)cod, (Object)"900"))) {
                compoeFCPST = true;
            }
            if (!compoeFCPST.booleanValue()) continue;
            rr.setValorFCPST(valorFCPST + rr.getValorFCPST());
            rr.setValorFCPSTRet(valorFCPSTRet + rr.getValorFCPSTRet());
        }
        return toRet;
    }

    private RegC101 getRegC101Agrupado(List<HashMap> livrosFiscais) {
        Double vrIcmsDest = 0.0;
        Double vrIcmsRem = 0.0;
        Double vrFundoPobreza = 0.0;
        for (HashMap h : livrosFiscais) {
            vrIcmsDest = vrIcmsDest + (Double)h.get("valorIcmsPartilhaDest");
            vrIcmsRem = vrIcmsRem + (Double)h.get("valorIcmsPartilhaRem");
            vrFundoPobreza = vrFundoPobreza + (Double)h.get("valorFundoPobreza");
        }
        if (vrIcmsDest > 0.0 || vrIcmsRem > 0.0 || vrFundoPobreza > 0.0) {
            RegC101 r = new RegC101();
            r.setValorIcmsUFDestino(vrIcmsDest);
            r.setValorIcmsUFRemetente(vrIcmsRem);
            r.setValorFundoPobreza(vrFundoPobreza);
            return r;
        }
        return null;
    }

    private List<RegC195> getRegC195Agrupado(List<HashMap> livrosFiscais) {
        ArrayList<RegC195> lista = new ArrayList<RegC195>();
        for (HashMap h : livrosFiscais) {
            List ajustes = (List)h.get("ajustes");
            for (HashMap hh : ajustes) {
                Long idObsFaturamento = (Long)hh.get("idObsFaturamento");
                String nomeObsFaturamento = (String)hh.get("nomeObsFaturamento");
                String conteudo = (String)hh.get("conteudo");
                String codTipoAjuste = (String)hh.get("codTipoAjuste");
                String codAuxProduto = (String)hh.get("codAuxiliarProduto");
                Long idProduto = (Long)hh.get("idProduto");
                Double valorIcms = (Double)hh.get("valorIcms");
                Double valorBcIcms = (Double)hh.get("valorBCIcms");
                Double aliquotaIcms = (Double)hh.get("aliquotaIcms");
                Double valorOutros = (Double)hh.get("valorOutros");
                String descricaoComp = "";
                boolean achou = false;
                for (RegC195 r : lista) {
                    if (idObsFaturamento == null || r.getIdObservacao() == null || !r.getIdObservacao().equals(idObsFaturamento)) continue;
                    Boolean achouAjuste = false;
                    for (RegC197 c197 : r.getAjustesLvFiscal()) {
                        String codTipoAjuste2 = c197.getCodTipoAjusteApIcms();
                        Long idProduto2 = c197.getIdProduto();
                        if (!codTipoAjuste.equals(codTipoAjuste2) || !idProduto.equals(idProduto2)) continue;
                        c197.setVlrBCIcmsIcmsST(c197.getVlrBCIcmsIcmsST() + valorBcIcms);
                        c197.setVlrIcmsIcmsST(c197.getVlrIcmsIcmsST() + valorIcms);
                        c197.setVlrOutros(c197.getVlrOutros() + valorOutros);
                        achouAjuste = true;
                    }
                    if (!achouAjuste.booleanValue()) {
                        RegC197 c197 = new RegC197();
                        c197.setAliquotaIcms(aliquotaIcms);
                        c197.setCodTipoAjusteApIcms(codTipoAjuste);
                        c197.setDescricaoComp(descricaoComp);
                        if (idProduto != null) {
                            c197.setIdProduto(idProduto);
                            c197.setCodAuxProduto(codAuxProduto);
                        }
                        c197.setVlrBCIcmsIcmsST(valorBcIcms);
                        c197.setVlrIcmsIcmsST(valorIcms);
                        c197.setVlrOutros(valorOutros);
                        r.getAjustesLvFiscal().add(c197);
                    }
                    achou = true;
                }
                if (achou) continue;
                RegC195 r = new RegC195();
                if (idObsFaturamento != null) {
                    r.setIdObservacao(idObsFaturamento);
                    r.setDescricaoObservacao(nomeObsFaturamento);
                }
                r.setTextoObs(conteudo);
                RegC197 c197 = new RegC197();
                c197.setAliquotaIcms(aliquotaIcms);
                c197.setCodTipoAjusteApIcms(codTipoAjuste);
                c197.setDescricaoComp(descricaoComp);
                if (idProduto != null) {
                    c197.setIdProduto(idProduto);
                    c197.setCodAuxProduto(codAuxProduto);
                }
                c197.setVlrBCIcmsIcmsST(valorBcIcms);
                c197.setVlrIcmsIcmsST(valorIcms);
                c197.setVlrOutros(valorOutros);
                r.getAjustesLvFiscal().add(c197);
                lista.add(r);
            }
        }
        return lista;
    }

    private List<HashMap> getDadosAjustesLivroFiscalAgrupado(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.identificador as idNota, lv.identificador as idLivro, obs.conteudo as conteudo, obs.obsFaturamento.identificador as idObsFaturamento, obs.obsFaturamento.nome as nomeObsFaturamento, obrig.aliquotaIcms as aliquotaIcms, obrig.vlrBCIcmsIcmsST as valorBCIcms, obrig.vlrIcmsIcmsST as valorIcms, obrig.vlrOutros as valorOutros,  obrig.tipoAjusteIcmsDocFiscal.codigo as codTipoAjuste, obrig.produto.identificador as idProduto, obrig.produto.codigoAuxiliar as codAuxiliarProduto, obrig.descricaoComp as descricaoComp  from NotaFiscalTerceiros n inner join n.livrosFiscais lv  inner join lv.obsLivroFiscal obs inner join obs.outrasObrigLivroFiscal obrig where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and lv.cancelado = :nao");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

