/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao018.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao018.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC300;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC310;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC320;
import mentorcore.service.impl.spedfiscal.versao018.model2.blococ.RegC321;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC300NotaPropria {
    Boolean utilizaCodAux = false;

    public BlocoC getBlocoC300NotasProprias(Date dataIn, Date dataFim, Empresa emp, Boolean utilizaCodAux) throws ExceptionDatabase {
        this.utilizaCodAux = utilizaCodAux;
        BlocoC b = new BlocoC();
        b.setRegistrosC300(this.getNotasFiscaisPropriasBlocoC300(dataIn, dataFim, emp));
        if (b.getRegistrosC300() != null && !b.getRegistrosC300().isEmpty()) {
            b.setProdutos(this.getProdutosNotaPropriaBlocoC300(dataIn, dataFim, emp));
            b.setUnidMedidas(this.getUnidMedidasNotaPropriaBlocoC300(dataIn, dataFim, emp));
        }
        return b;
    }

    private List getNotasFiscaisPropriasBlocoC300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select      n.modeloDocFiscal.codigo            as codModFiscal,     n.serie                             as serie,     n.numeroNota                        as numeroNota,     n.dataEmissaoNota                   as dataEmissao,     sum(n.valoresNfPropria.valorTotal)  as valorTotal,     sum(n.valoresNfPropria.valorPis)    as valorPis,     sum(n.valoresNfPropria.valorCofins) as valorCofins from NotaFiscalPropria n  where       n.modeloDocFiscal.codigo=:cod1  and n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa=:empresa group by      n.modeloDocFiscal.codigo,     n.serie,     n.dataEmissaoNota,      n.numeroNota");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC300> toRet = new ArrayList<RegC300>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC300 r = new RegC300();
            r.setCodModeloDocFiscal((String)h.get("codModFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setNumDocInicial((Integer)h.get("numeroNota"));
            r.setNumDocFinal((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setRegistrosC310(this.getRegistrosC310(r.getDataEmissao(), emp));
            r.setRegistrosC320(this.getRegistrosC320(r.getDataEmissao(), r.getNumDocInicial(), emp));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC310> getRegistrosC310(Date dataEmissao, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.numeroNota as numeroNota from NotaFiscalPropria n  where          n.modeloDocFiscal.codigo=:cod1     and n.situacaoDocumento.codigo = :codSitDoc     and n.dataEmissaoNota  = :data     and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("codSitDoc", "02");
        q.setDate("data", dataEmissao);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC310> toRet = new ArrayList<RegC310>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC310 r = new RegC310();
            r.setNumDocCanc((Integer)h.get("numeroNota"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC320> getRegistrosC320(Date dataEmissao, Integer numeroNota, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      lv.incidenciaIcms.codigo   as incidenciaIcms,      lv.cfop.codigo             as cfop,     lv.aliquotaIcms            as aliquotaIcms,     sum(lv.valorTotal)         as valorTotal,     sum(lv.valorIcmsTributado) as valorIcmsTributado,      sum(lv.valorIcms)          as valorIcms,     sum(lv.vrNaoTribIcms)      as valorNaoTribIcms  from NotaFiscalPropria n inner join n.livrosFiscais lv where        n.dataEmissaoNota        = :data   and n.empresa                = :empresa   and n.numeroNota             = :numeroNota   and n.modeloDocFiscal.codigo = :codModDocFiscal group by      lv.incidenciaIcms.codigo,      lv.cfop.codigo,     lv.aliquotaIcms");
        q.setDate("data", dataEmissao);
        q.setEntity("empresa", (Object)emp);
        q.setInteger("numeroNota", numeroNota.intValue());
        q.setString("codModDocFiscal", "02");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC320> toRet = new ArrayList<RegC320>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC320 r = new RegC320();
            r.setCodIncidenciaIcms((String)h.get("incidenciaIcms"));
            r.setCfop((String)h.get("cfop"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBCIcms((Double)h.get("valorIcmsTributado"));
            r.setValorIcms((Double)h.get("valorIcms"));
            r.setValorNaoTributado((Double)h.get("valorNaoTribIcms"));
            r.setRegistrosC321(this.getRegistrosC321(dataEmissao, numeroNota, emp, r.getCfop(), r.getCodIncidenciaIcms(), r.getAliquotaIcms()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC321> getRegistrosC321(Date dataEmissao, Integer numerNota, Empresa emp, String codCfop, String codIncidenciaIcms, Double aliquotaIcms) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      i.produto.identificador                      as ID_PRODUTO,     i.produto.codigoAuxiliar                      as COD_AUX,     i.unidadeMedida.sigla                        as SIGLA,     sum(i.quantidadeTotal)                       as QTDE,     sum(i.valorDesconto)                         as VR_DESCONTO,     sum(i.itemNotaLivroFiscal.valorTotal)        as VR_TOTAL,     sum(i.itemNotaLivroFiscal.vrPis)             as VR_PIS,     sum(i.itemNotaLivroFiscal.vrCofins)          as VR_COFINS,     sum(i.itemNotaLivroFiscal.vrIcms)            as VR_ICMS,     sum(i.itemNotaLivroFiscal.vrIcmsTributado)   as VR_BC_ICMS from ItemNotaFiscalPropria i where         i.notaFiscalPropria.dataEmissaoNota        = :data      and i.notaFiscalPropria.empresa                = :empresa     and i.notaFiscalPropria.numeroNota             = :numero     and i.notaFiscalPropria.modeloDocFiscal.codigo = :cod1     and i.itemNotaLivroFiscal.cfop.codigo          = :cfop     and i.incidenciaIcms.codigo                    = :codIncidenciaIcms      and i.itemNotaLivroFiscal.aliquotaIcms         = :aliquotaIcms  group by     i.produto.identificador,     i.produto.codigoAuxiliar,     i.unidadeMedida.sigla");
        q.setDate("data", dataEmissao);
        q.setEntity("empresa", (Object)emp);
        q.setInteger("numero", numerNota.intValue());
        q.setString("cod1", "02");
        q.setString("cfop", codCfop);
        q.setString("codIncidenciaIcms", codIncidenciaIcms);
        q.setDouble("aliquotaIcms", aliquotaIcms.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC321> toRet = new ArrayList<RegC321>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC321 r = new RegC321();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setCodProduto(idProduto.toString());
            String codAux = (String)h.get("COD_AUX");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setCodProduto(codAux);
            }
            r.setUnidMedida((String)h.get("SIGLA"));
            r.setQuantidade((Double)h.get("QTDE"));
            r.setValorItem((Double)h.get("VR_TOTAL"));
            r.setValorDesconto((Double)h.get("VR_DESCONTO"));
            r.setValorBCIcms((Double)h.get("VR_BC_ICMS"));
            r.setValorIcms((Double)h.get("VR_ICMS"));
            r.setValorPis((Double)h.get("VR_PIS"));
            r.setValorCofins((Double)h.get("VR_COFINS"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotaPropriaBlocoC300(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      i.produto.identificador         as idProduto,     i.produto.codigoAuxiliar        as codAux,     i.produto.nome                  as nomeProduto,     i.produto.unidadeMedida.sigla   as unidadeMedida,     i.produto.tipoIemSped.codigo    as codTipoItemSped,     nc.codigo                       as codNcm,     g.codigo                        as codGenero,     c.codigo                        as codCest,     i.produto.aliquotaIcms          as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left  join i.produto.ncm nc left  join i.produto.genero g left  join i.produto.cest c where         n.modeloDocFiscal.codigo = :cod1     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa = :empresa");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto);
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodCest((String)h.get("codCest"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaPropriaBlocoC300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.unidadeMedida.identificador           as idUnidMedida,     i.unidadeMedida.sigla                   as sigla,     i.unidadeMedida.descricao               as descricao,     i.produto.unidadeMedida.identificador   as idUnidMedidaProd,     i.produto.unidadeMedida.sigla           as siglaProd,     i.produto.unidadeMedida.descricao       as descricaoProd from NotaFiscalPropria n inner join n.itensNotaPropria i where         n.modeloDocFiscal.codigo = :cod1     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa = :empresa");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }
}

