/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao019.util.bloco1;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao019.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao019.model2.bloco1.Reg1700;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1700 {
    public Bloco1 getReg1700(Empresa emp, Date dataInicial, Date dataFinal, String nrAutorizacaoDocFiscal) {
        Bloco1 bloco1 = new Bloco1();
        bloco1.setReg1700(this.getRegistro1700(emp, dataInicial, dataFinal, nrAutorizacaoDocFiscal));
        return bloco1;
    }

    private List<Reg1700> getRegistro1700(Empresa emp, Date dataInicial, Date dataFinal, String nrAutorizacaoDocFiscal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(n.numeroNota) as numeroInicial, min(n.numeroNota) as numeroFinal,  n.serie as serie, n.modeloDocFiscal.codigo as modelo, n.periodoEmissaoNFe.tipoEmissaoNfe.codigo as tipoEmissao from NotaFiscalPropria n where n.empresa  = :empresa and n.dataEmissaoNota between :dataInicial and :dataFinal and (n.periodoEmissaoNFe.tipoEmissaoNfe.codigo = :tipoEmissao1 or      n.periodoEmissaoNFe.tipoEmissaoNfe.codigo = :tipoEmissao2) group by   n.serie, n.modeloDocFiscal.codigo, n.periodoEmissaoNFe.tipoEmissaoNfe.codigo");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("tipoEmissao1", EnumConstNFeTipoEmissao.CONTIGENCIA_FSDA.getValue());
        q.setShort("tipoEmissao2", EnumConstNFeTipoEmissao.CONTIGENCIA_EMISSAO_FS.getValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1700> notas = new ArrayList<Reg1700>();
        for (Object ob : lista) {
            HashMap h = (HashMap)ob;
            Integer numeroInicial = (Integer)h.get("numeroInicial");
            Integer numeroFinal = (Integer)h.get("numeroFinal");
            String serie = (String)h.get("serie");
            String modelo = (String)h.get("modelo");
            Short tipoEmissao = (Short)h.get("tipoEmissao");
            Reg1700 r = new Reg1700();
            r.setNumeroInicial(numeroInicial);
            r.setNumeroFinal(numeroFinal);
            r.setSerie(serie);
            r.setCodigoModeloDocFiscal(modelo);
            r.setCodigoDispositivo(this.getCodigoDispositivo(tipoEmissao));
            r.setNrAutorizacaoDocFiscal(nrAutorizacaoDocFiscal);
            notas.add(r);
        }
        return notas;
    }

    private String getCodigoDispositivo(Short tipoEmissao) {
        if (ToolMethods.isEquals((Object)tipoEmissao, (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_FSDA.getValue())) {
            return "01";
        }
        return "02";
    }
}

