/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao019.util.blococ;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao019.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao019.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao019.model2.blococ.RegC500;
import mentorcore.service.impl.spedfiscal.versao019.model2.blococ.RegC590;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC500NotaTerceiros {
    public BlocoC getBlocoC500NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC500(this.getNotasFiscaisTerceirosBloco062928(dataIn, dataFim, emp));
        if (b.getRegistrosC500() != null && !b.getRegistrosC500().isEmpty()) {
            this.getLivrosFiscaisNotasTerceirosBloco062928(b.getRegistrosC500());
            b.setParticipantes(this.getParticipantesNotasTerceirosBloco062928(dataIn, dataFim, emp));
        }
        return b;
    }

    private List getNotasFiscaisTerceirosBloco062928(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador,0 as entSai, n.unidadeFatFornecedor.pessoa.identificador as idPessoa, n.unidadeFatFornecedor.pessoa.complemento.contribuinteEstado as contribuinteIcms, n.unidadeFatFornecedor.pessoa.endereco.cidade.codIbgeCompleto as codIbgeCompleto, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNFe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorDesconto as valorDesconto, n.valoresNfTerceiros.valorDespAcess as valorDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorIcmsSt as vlrIcmsSt, n.valoresNfTerceiros.bcIcmsSt as bcIcmsSt, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, t.codigo as tipoLigacao, g.codigo as grupoTensao, tc.codigo as tipoConsumoEnergia, n.finalidadeEmissao as finalidadeEmissao from NotaFiscalTerceiros n  inner join n.livrosFiscais lv  left join n.tipoLigacaoEnergia t left join n.grupoTensaoEnergia g left join n.tipoConsumoEnergia tc  where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and lv.cancelado = :nao");
        q.setString("cod1", "06");
        q.setString("cod2", "29");
        q.setString("cod3", "28");
        q.setString("cod4", "66");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC500> toRet = new ArrayList<RegC500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC500 r = new RegC500();
            r.setEntSaiNatOP((Integer)h.get("entSai"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setSerie((String)h.get("serie"));
            r.setCodConsumoEnergia((String)h.get("codConsumoEnergia"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(1);
            r.setNumeroDoc((Integer)h.get("numNota"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorDespAcessorias((Double)h.get("valorDespAcess"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setTipoLigacao((String)h.get("tipoLigacao"));
            r.setGrupoTensao((String)h.get("grupoTensao"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setChave((String)h.get("chaveNFe"));
            r.setFinalidadeEmissao((Short)h.get("finalidadeEmissao"));
            Short contribuinteEstado = (Short)h.get("contribuinteIcms");
            if (contribuinteEstado.equals(EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId())) {
                r.setIndicadorDestinatario((short)9);
            } else {
                r.setIndicadorDestinatario(contribuinteEstado);
            }
            r.setCodigoMunicipioDestinatario((String)h.get("codIbgeCompleto"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }

    private void getLivrosFiscaisNotasTerceirosBloco062928(List<RegC500> registrosC500) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC500> iterator = registrosC500.iterator();
        while (iterator.hasNext()) {
            RegC500 o;
            RegC500 regC500 = o = iterator.next();
            Long idNota = regC500.getIdentificador();
            Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcms) as valorIcms, sum(lv.valorBCIcmsSt) as valorBCIcmsSt, sum(lv.valorIcmsSt) as valorIcmsSt, sum(lv.vrNaoTribIcms) as valorNaoTribIcms, obs.obsFaturamento.identificador as obsLivroFiscal from NotaFiscalTerceiros n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where n.identificador  = :idNota group by lv.incidenciaIcms.codigo, lv.cfop.codigo,lv.aliquotaIcms, obs.obsFaturamento.identificador");
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegC590> toRet = new ArrayList<RegC590>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegC590 r = new RegC590();
                r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
                r.setCfop((String)h.get("cfop"));
                r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
                r.setValorOperacao((Double)h.get("valorTotal"));
                r.setBcCalculoIcms((Double)h.get("valorIcmsTributado"));
                r.setValorIcms((Double)h.get("valorIcms"));
                r.setBcCalculoIcmsSt((Double)h.get("valorBCIcmsSt"));
                r.setValorIcmsST((Double)h.get("valorIcmsSt"));
                r.setValorNaoTribIcms((Double)h.get("valorNaoTribIcms"));
                r.setObservacoesLv((Long)h.get("obsLivroFiscal"));
                toRet.add(r);
            }
            regC500.setRegC590(toRet);
        }
    }

    private List getParticipantesNotasTerceirosBloco062928(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.livrosFiscais lv  inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and lv.cancelado = :nao");
        q.setString("cod1", "06");
        q.setString("cod2", "28");
        q.setString("cod3", "29");
        q.setString("cod4", "66");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }
}

