/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao019.util.blocod;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao019.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao019.model2.blocod.BlocoD;
import mentorcore.service.impl.spedfiscal.versao019.model2.blocod.RegD700;
import mentorcore.service.impl.spedfiscal.versao019.model2.blocod.RegD730;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoD700NotaTerceiros {
    public BlocoD getBlocoD700NotasTerceirosTelecomunicacao(Date dataIn, Date dataFim, Empresa emp) {
        BlocoD b = new BlocoD();
        b.setRegistrosD700(this.getNotasTerceirosTelecomD700(dataIn, dataFim, emp));
        if (b.getRegistrosD700() != null && !b.getRegistrosD700().isEmpty()) {
            this.getLivrosFiscaisNotasTerceirosTelecomD700(b.getRegistrosD700());
            b.setParticipantes(this.getParticipantesNotasTerceirosTelecomD700(dataIn, dataFim, emp));
        }
        return b;
    }

    private List getNotasTerceirosTelecomD700(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, n.valoresNfTerceiros.valorDespAcess as vlrDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, t.codigo as codTipoAssinante from NotaFiscalTerceiros n inner join n.livrosFiscais lv  left join n.tipoAssinanteTelefone t where (n.modeloDocFiscal.codigo=:cod1) and  n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and lv.cancelado = :nao");
        q.setString("cod1", "62");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD700> toRet = new ArrayList<RegD700>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD700 r = new RegD700();
            r.setIdentificador((Long)h.get("identificador"));
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("\nNr Nota Terceiros Comunicacao (mod 62): " + r.getNumeroDoc().toString());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setSerie((String)h.get("serie"));
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setCodTipoAssinante((String)h.get("codTipoAssinante"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            Long idPlanoConta = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(idPlanoConta);
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }

    private Long getPlanoContaNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select lv.planoConta.identificador as idPlanoConta from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long pc = (Long)h.get("idPlanoConta");
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    private void getLivrosFiscaisNotasTerceirosTelecomD700(List<RegD700> registrosD700) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegD700> iterator = registrosD700.iterator();
        while (iterator.hasNext()) {
            RegD700 o;
            RegD700 regD700 = o = iterator.next();
            Long idNota = regD700.getIdentificador();
            Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcms) as valorIcms, sum(lv.valorBCIcmsSt) as valorBCIcmsSt, sum(lv.valorIcmsSt) as valorIcmsSt, sum(lv.vrNaoTribIcms) as valorNaoTribIcms, sum(lv.valorFundoPobreza) as valorFundoPobreza, obs.obsFaturamento.identificador as obsLivroFiscal from NotaFiscalTerceiros n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where n.identificador  = :idNota group by lv.incidenciaIcms.codigo, lv.cfop.codigo,lv.aliquotaIcms, obs.obsFaturamento.identificador");
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegD730> toRet = new ArrayList<RegD730>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegD730 r = new RegD730();
                r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
                r.setCfop((String)h.get("cfop"));
                r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
                r.setValorOperacao((Double)h.get("valorTotal"));
                r.setBcCalculoIcms((Double)h.get("valorIcmsTributado"));
                r.setValorIcms((Double)h.get("valorIcms"));
                r.setBcCalculoIcmsSt((Double)h.get("valorBCIcmsSt"));
                r.setValorIcmsST((Double)h.get("valorIcmsSt"));
                r.setValorNaoTribIcms((Double)h.get("valorNaoTribIcms"));
                r.setObservacoesLv((Long)h.get("obsLivroFiscal"));
                r.setValorFundoPobreza((Double)h.get("valorFundoPobreza"));
                toRet.add(r);
            }
            regD700.setLivrosFiscais(toRet);
        }
    }

    private List getParticipantesNotasTerceirosTelecomD700(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n inner join n.livrosFiscais lv   inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and lv.cancelado = :nao");
        q.setString("cod1", "62");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }
}

