/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao020.util.bloco1;

import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SpedFiscalOperacaoPagEletronico;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedfiscal.versao020.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao020.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao020.model2.bloco1.Reg1601;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBloco1601 {
    public List<SpedFiscalOperacaoPagEletronico> getDadosOperacoesVendasPagEletronico(Date dataIn, Date dataFim, Empresa emp, List contasExcluir) {
        ArrayList<SpedFiscalOperacaoPagEletronico> lista = new ArrayList<SpedFiscalOperacaoPagEletronico>();
        this.getDadosNotaFiscalPropriaOperacoesVendasCartaoCreditoDebito(dataIn, dataFim, emp, lista);
        this.getDadosControleCaixaNFCeOperacoesVendasCartaoCreditoDebito(dataIn, dataFim, emp, lista);
        this.getDadosNotaNotaPropriaOutrosPagamentos(dataIn, dataFim, emp, lista, contasExcluir);
        this.getDadosNFCeOutrosPagamentos(dataIn, dataFim, emp, lista);
        return lista;
    }

    private void getDadosNotaFiscalPropriaOperacoesVendasCartaoCreditoDebito(Date dataIn, Date dataFim, Empresa emp, List<SpedFiscalOperacaoPagEletronico> lista) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select t.pessoa.identificador as ID_PESSOA,  sum(t.valor) as VALOR from NotaFiscalPropria n inner join n.infPagamentoNfPropria i  inner join i.titulos t   where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa  = :empresa  and (i.tipoPagamentoNFe.codigo = :tipoCartaoDebito or i.tipoPagamentoNFe.codigo = :tipoCartaoCredito) and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada) group by t.pessoa.identificador");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("tipoCartaoDebito", "04");
        q.setString("tipoCartaoCredito", "03");
        q.setString("cancelado", "02");
        q.setString("canceladoExt", "03");
        q.setString("denegada", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List retorno = q.list();
        for (Object obj : retorno) {
            HashMap h = (HashMap)obj;
            Long idPessoa = (Long)h.get("ID_PESSOA");
            Double valor = (Double)h.get("VALOR");
            Boolean achou = false;
            for (SpedFiscalOperacaoPagEletronico op : lista) {
                if (!ToolMethods.isEquals((Object)op.getPessoaInstituicaoPagamento().getIdentificador(), (Object)idPessoa)) continue;
                op.setValorTotalVendaPrestacaoServicos(Double.valueOf(op.getValorTotalVendaPrestacaoServicos() + valor));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            SpedFiscalOperacaoPagEletronico op = new SpedFiscalOperacaoPagEletronico();
            op.setPessoaInstituicaoPagamento(this.getPessoa(idPessoa));
            op.setValorTotalVendaPrestacaoServicos(valor);
            lista.add(op);
        }
    }

    private void getDadosControleCaixaNFCeOperacoesVendasCartaoCreditoDebito(Date dataIn, Date dataFim, Empresa emp, List<SpedFiscalOperacaoPagEletronico> lista) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select t.pessoa.identificador as ID_PESSOA,  sum(t.valor) as VALOR from Titulo t   inner join t.meioPagamento m  where t.dataEmissao between :dataIn and :dataFim and t.empresa  = :empresa  and (t.meioPagamento.tipoPagamentoNFe.codigo = :tipoCartaoDebito or t.meioPagamento.tipoPagamentoNFe.codigo = :tipoCartaoCredito) and (t.nfCeControleCaixa is not null or t.apuracaoTitulosCartaoDebCred is not null) group by t.pessoa.identificador, t.meioPagamento.tipoPagamentoNFe.codigo");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("tipoCartaoDebito", "04");
        q.setString("tipoCartaoCredito", "03");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List retorno = q.list();
        for (Object obj : retorno) {
            HashMap h = (HashMap)obj;
            Long idPessoa = (Long)h.get("ID_PESSOA");
            Double valor = (Double)h.get("VALOR");
            String tipoCartao = (String)h.get("TIPO_CARTAO");
            Boolean achou = false;
            for (SpedFiscalOperacaoPagEletronico op : lista) {
                if (!ToolMethods.isEquals((Object)op.getPessoaInstituicaoPagamento().getIdentificador(), (Object)idPessoa)) continue;
                op.setValorTotalVendaPrestacaoServicos(Double.valueOf(op.getValorTotalVendaPrestacaoServicos() + valor));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            SpedFiscalOperacaoPagEletronico op = new SpedFiscalOperacaoPagEletronico();
            op.setPessoaInstituicaoPagamento(this.getPessoa(idPessoa));
            op.setValorTotalVendaPrestacaoServicos(valor);
            lista.add(op);
        }
    }

    private Pessoa getPessoa(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from Pessoa p where p.identificador = :idPessoa");
        q.setLong("idPessoa", idPessoa.longValue());
        return (Pessoa)q.uniqueResult();
    }

    public Bloco1 getReg1601(List<SpedFiscalOperacaoPagEletronico> operacoes) {
        Bloco1 bloco1 = new Bloco1();
        bloco1.setReg1601(this.getOperacoesPagEletroncicoReg1601(operacoes));
        bloco1.setParticipantes(this.getParticipantesOperacoesPagEletroncicoReg1601(operacoes));
        return bloco1;
    }

    private List<Reg1601> getOperacoesPagEletroncicoReg1601(List<SpedFiscalOperacaoPagEletronico> operacoes) {
        ArrayList<Reg1601> aux = new ArrayList<Reg1601>();
        for (SpedFiscalOperacaoPagEletronico op : operacoes) {
            Reg1601 r = new Reg1601();
            r.setIdParticipanteInstituicaoPagamento(op.getPessoaInstituicaoPagamento().getIdentificador());
            r.setIdParticipanteIntermediador(op.getPessoaIntermediadorTransacao() != null ? op.getPessoaIntermediadorTransacao().getIdentificador() : null);
            r.setValorTotalVendaPrestacaoServicos(op.getValorTotalVendaPrestacaoServicos());
            r.setValorTotalIss(op.getValorTotalIss());
            r.setValorTotalOutros(op.getValorTotalOutros());
            aux.add(r);
        }
        return aux;
    }

    private List<Reg150> getParticipantesOperacoesPagEletroncicoReg1601(List<SpedFiscalOperacaoPagEletronico> operacoes) {
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (SpedFiscalOperacaoPagEletronico op : operacoes) {
            Reg150 r;
            Complemento c;
            Endereco e;
            Pessoa p = op.getPessoaInstituicaoPagamento();
            if (p != null) {
                e = p.getEndereco();
                c = p.getComplemento();
                r = new Reg150();
                r.setBairro(e.getBairro());
                r.setCnpj(c.getCnpj());
                r.setCodPais(e.getCidade().getUf().getPais().getCodIbge());
                r.setCodigoMunicipio(e.getCidade().getCodIbge());
                r.setCodUf(e.getCidade().getUf().getCodIbge());
                r.setComplemento(e.getComplemento());
                r.setCpf(c.getCnpj());
                r.setEndereco(e.getLogradouro());
                r.setIdPessoa(p.getIdentificador());
                r.setInscricaoEstadual(c.getInscEst());
                r.setNomePessoa(p.getNome());
                r.setNumero(e.getNumero());
                r.setSuframa(c.getSuframa());
                toRet.add(r);
            }
            if ((p = op.getPessoaIntermediadorTransacao()) == null) continue;
            e = p.getEndereco();
            c = p.getComplemento();
            r = new Reg150();
            r.setBairro(e.getBairro());
            r.setCnpj(c.getCnpj());
            r.setCodPais(e.getCidade().getUf().getPais().getCodIbge());
            r.setCodigoMunicipio(e.getCidade().getCodIbge());
            r.setCodUf(e.getCidade().getUf().getCodIbge());
            r.setComplemento(e.getComplemento());
            r.setCpf(c.getCnpj());
            r.setEndereco(e.getLogradouro());
            r.setIdPessoa(p.getIdentificador());
            r.setInscricaoEstadual(c.getInscEst());
            r.setNomePessoa(p.getNome());
            r.setNumero(e.getNumero());
            r.setSuframa(c.getSuframa());
            toRet.add(r);
        }
        return toRet;
    }

    private void getDadosNotaNotaPropriaOutrosPagamentos(Date dataIn, Date dataFim, Empresa emp, List<SpedFiscalOperacaoPagEletronico> lista, List contas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select b.grupoDeBaixaFormas.contaValor.agenciaValor.pessoa.identificador as ID_PESSOA, b.grupoDeBaixaFormas.contaValor.identificador as id_conta, sum(b.totalOperacao) as VALOR from BaixaTitulo b inner join b.titulo t  inner join t.infPagamentoNfPropria i  inner join i.notaFiscalPropria n  where b.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao between :dataIn and :dataFim and b.grupoDeBaixaFormas.contaValor is not null  and n.empresa  = :empresa  and (i.tipoPagamentoNFe.codigo = :tipoCheque or i.tipoPagamentoNFe.codigo = :tipoBoleto   or i.tipoPagamentoNFe.codigo = :tipoDepositoBancario or i.tipoPagamentoNFe.codigo = :tipoPix   or i.tipoPagamentoNFe.codigo = :tipoCarteiraDigital) and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada)";
        if (!contas.isEmpty()) {
            hql = (String)hql + " and b.grupoDeBaixaFormas.contaValor.identificador not in :idContas";
        }
        hql = (String)hql + " group by b.grupoDeBaixaFormas.contaValor.agenciaValor.pessoa.identificador,b.grupoDeBaixaFormas.contaValor.identificador";
        Query q = s.createQuery((String)hql);
        if (!contas.isEmpty()) {
            int tam = contas.size();
            int cont = 0;
            Object ids = "";
            for (Object conta : contas) {
                ContaValores c = (ContaValores)conta;
                ids = (String)ids + c.getIdentificador();
                if (++cont >= tam) continue;
                ids = (String)ids + ",";
            }
            q.setParameter("idContas", (Object)("(" + (String)ids + ")"));
        }
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("tipoCheque", "02");
        q.setString("tipoBoleto", "15");
        q.setString("tipoDepositoBancario", "16");
        q.setString("tipoPix", "17");
        q.setString("tipoCarteiraDigital", "18");
        q.setString("cancelado", "02");
        q.setString("canceladoExt", "03");
        q.setString("denegada", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List retorno = q.list();
        for (Object obj : retorno) {
            HashMap h = (HashMap)obj;
            Long idPessoa = (Long)h.get("ID_PESSOA");
            Double valor = (Double)h.get("VALOR");
            Boolean achou = false;
            for (SpedFiscalOperacaoPagEletronico op : lista) {
                if (!ToolMethods.isEquals((Object)op.getPessoaInstituicaoPagamento().getIdentificador(), (Object)idPessoa)) continue;
                op.setValorTotalVendaPrestacaoServicos(Double.valueOf(op.getValorTotalVendaPrestacaoServicos() + valor));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            SpedFiscalOperacaoPagEletronico op = new SpedFiscalOperacaoPagEletronico();
            op.setPessoaInstituicaoPagamento(this.getPessoa(idPessoa));
            op.setValorTotalVendaPrestacaoServicos(valor);
            lista.add(op);
        }
    }

    private void getDadosNFCeOutrosPagamentos(Date dataIn, Date dataFim, Empresa emp, List<SpedFiscalOperacaoPagEletronico> lista) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select b.grupoDeBaixaFormas.contaValor.agenciaValor.pessoa.identificador as ID_PESSOA,  sum(b.totalOperacao) as VALOR from BaixaTitulo b inner join b.titulo t  inner join t.nfcePagamento i  inner join i.nfce n  where b.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao between :dataIn and :dataFim and b.grupoDeBaixaFormas.contaValor is not null  and n.empresa  = :empresa  and (i.tipoPagamentoNFe.codigo = :tipoCheque or i.tipoPagamentoNFe.codigo = :tipoBoleto   or i.tipoPagamentoNFe.codigo = :tipoDepositoBancario or i.tipoPagamentoNFe.codigo = :tipoPix) and (n.situacaoDocumento.codigo <> :cancelado and n.situacaoDocumento.codigo <> :canceladoExt and n.situacaoDocumento.codigo <> :denegada) group by b.grupoDeBaixaFormas.contaValor.agenciaValor.pessoa.identificador");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("tipoCheque", "02");
        q.setString("tipoBoleto", "15");
        q.setString("tipoDepositoBancario", "16");
        q.setString("tipoPix", "17");
        q.setString("cancelado", "02");
        q.setString("canceladoExt", "03");
        q.setString("denegada", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List retorno = q.list();
        for (Object obj : retorno) {
            HashMap h = (HashMap)obj;
            Long idPessoa = (Long)h.get("ID_PESSOA");
            Double valor = (Double)h.get("VALOR");
            Boolean achou = false;
            for (SpedFiscalOperacaoPagEletronico op : lista) {
                if (!ToolMethods.isEquals((Object)op.getPessoaInstituicaoPagamento().getIdentificador(), (Object)idPessoa)) continue;
                op.setValorTotalVendaPrestacaoServicos(Double.valueOf(op.getValorTotalVendaPrestacaoServicos() + valor));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            SpedFiscalOperacaoPagEletronico op = new SpedFiscalOperacaoPagEletronico();
            op.setPessoaInstituicaoPagamento(this.getPessoa(idPessoa));
            op.setValorTotalVendaPrestacaoServicos(valor);
            lista.add(op);
        }
    }
}

