/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

class UtilSpedPisCofins {
    UtilSpedPisCofins() {
    }

    public Boolean isStatusFinalDocumentos(SpedPisCofins vo) {
        Boolean achou = false;
        achou = this.isStatusFinalNotaPropria(vo);
        if (!achou.booleanValue()) {
            return false;
        }
        achou = this.isStatusFinalNFCe(vo);
        if (!achou.booleanValue()) {
            return false;
        }
        achou = this.isStatusFinalCTe(vo);
        if (!achou.booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean isStatusFinalNotaPropria(SpedPisCofins vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select count(n.identificador)  from NotaFiscalPropria n where n.dataEmissaoNota  between :dataInicial and :dataFinal and n.empresa = :empresa and n.modeloDocFiscal.codigo = :modDocFiscal and ( n.status <> :status1     and n.status <> :status2    and n.status <> :status3    and n.status <> :status4    and n.status <> :status5    and n.status <> :status6    and n.status <> :status7    and n.status <> :status8    and n.status <> :status9)";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", vo.getDataInicial());
        q.setDate("dataFinal", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setString("modDocFiscal", "55");
        q.setShort("status1", EnumConstNFeStatus.DENEGADA.getValue().shortValue());
        q.setShort("status2", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE.getValue().shortValue());
        q.setShort("status3", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue().shortValue());
        q.setShort("status4", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue().shortValue());
        q.setShort("status5", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("status6", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        q.setShort("status7", EnumConstNFeStatus.CANCELADA.getValue().shortValue());
        q.setShort("status8", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().shortValue());
        q.setShort("status9", EnumConstNFeStatus.INUTILIZADA.getValue().shortValue());
        Long count = (Long)q.uniqueResult();
        if (count != null && count > 0L) {
            return false;
        }
        return true;
    }

    private Boolean isStatusFinalNFCe(SpedPisCofins vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select count(n.identificador)  from NFCe n where n.dataEmissao  between :dataInicial and :dataFinal and n.empresa = :empresa and n.modeloDocFiscal.codigo = :modDocFiscal and ( n.status <> :status1     and n.status <> :status2    and n.status <> :status3    and n.status <> :status4    and n.status <> :status5    and n.status <> :status6    and n.status <> :status7    and n.status <> :status8    and n.status <> :status9)";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", vo.getDataInicial());
        q.setDate("dataFinal", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setString("modDocFiscal", "65");
        q.setShort("status1", EnumConstNFeStatus.DENEGADA.getValue().shortValue());
        q.setShort("status2", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE.getValue().shortValue());
        q.setShort("status3", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue().shortValue());
        q.setShort("status4", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue().shortValue());
        q.setShort("status5", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("status6", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        q.setShort("status7", EnumConstNFeStatus.CANCELADA.getValue().shortValue());
        q.setShort("status8", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().shortValue());
        q.setShort("status9", EnumConstNFeStatus.INUTILIZADA.getValue().shortValue());
        Long count = (Long)q.uniqueResult();
        if (count != null && count > 0L) {
            return false;
        }
        return true;
    }

    private Boolean isStatusFinalCTe(SpedPisCofins vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select count(n.identificador)  from Cte n where n.dataEmissao  between :dataInicial and :dataFinal and n.empresa = :empresa and n.modeloDocFiscal.codigo = :modDocFiscal and ( n.cteInfo.status <> :status1     and n.cteInfo.status <> :status2    and n.cteInfo.status <> :status3    and n.cteInfo.status <> :status4    and n.cteInfo.status <> :status5    and n.cteInfo.status <> :status6    and n.cteInfo.status <> :status7    and n.cteInfo.status <> :status8    and n.cteInfo.status <> :status9)";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", vo.getDataInicial());
        q.setDate("dataFinal", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setString("modDocFiscal", "57");
        q.setShort("status1", EnumConstNFeStatus.DENEGADA.getValue().shortValue());
        q.setShort("status2", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE.getValue().shortValue());
        q.setShort("status3", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue().shortValue());
        q.setShort("status4", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue().shortValue());
        q.setShort("status5", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("status6", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        q.setShort("status7", EnumConstNFeStatus.CANCELADA.getValue().shortValue());
        q.setShort("status8", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().shortValue());
        q.setShort("status9", EnumConstNFeStatus.INUTILIZADA.getValue().shortValue());
        Long count = (Long)q.uniqueResult();
        if (count != null && count > 0L) {
            return false;
        }
        return true;
    }
}

