/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao;

import com.touchcomp.basementor.model.vo.BemSpedPisCofins;
import com.touchcomp.basementor.model.vo.DeducoesDiversasSpedPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EstoqueAberturaSpedPisCofins;
import com.touchcomp.basementor.model.vo.LancamentoSpedPisCofins;
import com.touchcomp.basementor.model.vo.LogProduto;
import com.touchcomp.basementor.model.vo.MovBemSpedPisCofins;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.ProcessoFiscal;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import com.touchcomp.basementor.model.vo.TokenObsIntFisco;
import com.touchcomp.basementor.model.vo.TokenObsIntFiscoNFTerceiros;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg140;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg205;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg600;
import mentorcore.service.impl.spedpiscofins.versao.model.RegCNPJ;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA010;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA110;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA111;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA170;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC010;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC111;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC170;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC380;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC381;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC385;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC395;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC396;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC400;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC405;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC481;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC485;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC500;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC501;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC505;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD100;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD101;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD105;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD111;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD200;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD201;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD205;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD500;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD501;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD505;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD509;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF100;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF111;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF120;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF129;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF130;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF139;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF150;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF600;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF700;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class SpedPisCofinsBDConsult {
    private static final String NOTA_TERCEIROS = "NotaFiscalTerceiros";
    private static final String NOTA_PROPRIA = "NotaFiscalPropria";

    public EmpresaContabilidade getEmpresaContabilidade(Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getEmpresaContabilidadeDAO().getVOClass());
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.setMaxResults(1);
        return (EmpresaContabilidade)c.uniqueResult();
    }

    public List getAlteracoesProduto(Long idProduto, Date dataIn, Date dataFim) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LogProduto l where l.produto.identificador=:idProduto and l.dataFimUtilDesc  between :dataIn and :dataFim and l.identificador=(select max(lp.identificador) from LogProduto lp  where lp.produto.identificador=:idProduto and lp.dataFimUtilDesc between :dataIn and :dataFim)");
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", DateUtil.previousDays(dataFim, 1));
        List ret = q.list();
        ArrayList<Reg205> toRet = new ArrayList<Reg205>();
        for (Object o : ret) {
            LogProduto l = (LogProduto)o;
            if (l.getDataFimUtilDesc() == null) {
                l.setDataFimUtilDesc(dataFim);
                l = this.salvarAtualizarLogProduto(l);
            }
            Reg205 r = new Reg205();
            r.setDescricaoAnterior(l.getConteudoAnterior());
            r.setDataInicial(l.getDataIniUtilDesc());
            r.setDataFinal(l.getDataFimUtilDesc());
            toRet.add(r);
        }
        return toRet;
    }

    private LogProduto salvarAtualizarLogProduto(LogProduto l) throws ExceptionDatabase {
        return (LogProduto)CoreDAOFactory.getInstance().getDAOLogProduto().saveOrUpdate(l);
    }

    BlocoA getBlocoA100NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoA b = new BlocoA();
        b.setRegistrosA100(this.getNotasTerceirosBlocoA100(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotasTerceirosBlocoA100(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotasTerceirosBlocoA100(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoA100(dataIn, dataFim, emp));
        b.setUnidMedidas(this.getUnidMedidasNotaTerceirosBlocoA100(dataIn, dataFim, emp));
        return b;
    }

    BlocoA getBlocoA100NotasProprias(Date dataIn, Date dataFim, Empresa emp) {
        BlocoA b = new BlocoA();
        b.setRegistrosA100(this.getNotasPropriasBlocoA100(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotasPropriasBlocoA100(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotasPropriasBlocoA100(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaPropriaBlocoA100(dataIn, dataFim, emp));
        b.setUnidMedidas(this.getUnidMedidasNotasPropriasBlocoA100(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        b.setNatOperacao(this.getNatOperacaoNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        b.setUnidadeMedidas(this.getUnidMedidasNotasPropriasBlocoC100(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaPropriaBlocoC100(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC100NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC010(this.getCnpjFornecedoresNotaTerceirosBlocoC100(dataIn, dataFim, emp));
        this.getParticipantesNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp, b);
        b.setProdutos(this.getProdutosNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp));
        b.setNatOperacao(this.getNatOperacaoNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp));
        b.setUnidadeMedidas(this.getUnidMedidasNotasTerceirosBlocoC100(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoC100(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC380NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC380(this.getNotasFiscaisTerceirosBlocoC380(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotasFiscaisTerceirosBlocoC380(dataIn, dataFim, emp));
        b.setUnidadeMedidas(this.getUnidMedidasNotasFiscaisTerceirosBlocoC380(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC380NotasProprias(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC380(this.getNotasFiscaisPropriasBlocoC380(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC380(dataIn, dataFim, emp));
        b.setUnidadeMedidas(this.getUnidMedidasNotasFiscaisPropriasBlocoC380(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotasFiscaisPropriasBlocoC380(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC395NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC395(this.getNotasFiscaisTerceirosBlocoC395(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotasTerceirosBlocoC395(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotasFiscaisTerceirosBlocoC395(dataIn, dataFim, emp));
        b.setUnidadeMedidas(this.getUnidMedidasNotasFiscaisTerceirosBlocoC395(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoC395(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC400CuponsFiscais(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC400(this.getEquipamentosFiscaisBlocoC400(dataIn, dataFim, emp));
        if (b.getRegistrosC400() != null && !b.getRegistrosC400().isEmpty()) {
            this.getReducoesZBlocoC405(b.getRegistrosC400(), dataIn, dataFim, emp);
            b.setProdutos(this.getProdutosReducoesC400(dataIn, dataFim, emp));
            b.setUnidadeMedidas(this.getUnidMedidasReducoesC400(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasReducoesC400(dataIn, dataFim, emp));
        }
        return b;
    }

    BlocoC getBlocoC500NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC500(this.getNotasFiscaisTerceirosBlocoC500(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotaTerceirosBlocoC500(dataIn, dataFim, emp));
        return b;
    }

    BlocoD getBlocoD100NotasTerceirosTransporte(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD100(this.getNotasTerceirosTransporteBlocoD100(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotasTerceirosTransporteD100(dataIn, dataFim, emp));
        return b;
    }

    BlocoD getBlocoD200CTeSaida(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD200(this.getConhecimentosSaidaD200(dataIn, dataFim, emp));
        return b;
    }

    BlocoD getBlocoD500NotasTerceirosTelecomunicacao(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD500(this.getNotasTerceirosTelecomunicacaoBlocoD500(dataIn, dataFim, emp));
        b.setParticipantes(this.getParticipantesNotasTerceirosTelecomunicacaoD500(dataIn, dataFim, emp));
        return b;
    }

    private List<RegC100> getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.naturezaOperacao.entradaSaida as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissaoNota as dataEmissao, n.dataEntradaSaida as dataEntSai, n.valoresNfPropria.valorTotal as valorTotal, n.valoresNfPropria.valorProduto + n.valoresNfPropria.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfPropria.valorFrete as vlrFrete, n.valoresNfPropria.valorSeguro as vlrSeguro, n.valoresNfPropria.valorDesconto as vlrDesconto, n.valoresNfPropria.valorDespAcess as vlrDespAcess, n.valoresNfPropria.valorIcmsTributado as bcIcms, n.valoresNfPropria.valorIcms as vlrIcms, n.valoresNfPropria.valorIcmsSt as vlrIcmsSt, n.valoresNfPropria.bcIcmsSt as bcIcmsSt, n.valoresNfPropria.valorIpiIndustria as vlrIpi, n.valoresNfPropria.valorPis as vlrPis, n.valoresNfPropria.valorCofins as vlrCofins, n.valoresNfPropria.valorCofinsSt as vlrCofinsST, n.valoresNfPropria.valorPisSt as vlrPisST, n.identificador as identificador from NotaFiscalPropria n  inner join n.dadosTransNfPropria d left join d.tipoFrete tf left join n.condicaoPagamento cp where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            boolean docCancInut;
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Propria: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            if (((Short)h.get("entSai")).equals((short)2)) {
                r.setEntSaiNatOP(0);
            } else {
                r.setEntSaiNatOP(1);
            }
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            if ((Date)h.get("dataEntSai") != null) {
                r.setDataEntSaida((Date)h.get("dataEntSai"));
            } else {
                r.setDataEntSaida(r.getDataEmissao());
            }
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            String sitDoc = r.getCodSituacaoDoc();
            boolean bl = docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (!docCancInut) {
                r.setObservacoes(this.getObservacoesBlocoC100(r.getIdentificador(), NOTA_PROPRIA));
                r.setProcessosReferenciados(this.getProcessosReferenciadosBlocoC100(r.getIdentificador(), NOTA_PROPRIA));
                r.setItensDocumento(this.getItensDocumentoNotaPropriaBlocoC100(r.getIdentificador()));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalPropria n  inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC010> getCnpjFornecedoresNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as cnpj from NotaFiscalTerceiros n  where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC010> toRet = new ArrayList<RegC010>();
        ArrayList temp = new ArrayList();
        ArrayList listaCNPJ = new ArrayList();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC010 r = new RegC010();
            r.setCnpj((String)h.get("cnpj"));
            r.setRegistrosC100(this.getNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp, r.getCnpj()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC100> getNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select 0 as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as cnpj, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfTerceiros.valorFrete as vlrFrete, n.valoresNfTerceiros.valorSeguro as vlrSeguro, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorDespAcess as vlrDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorIcmsSt as vlrIcmsSt, n.valoresNfTerceiros.bcIcmsSt as bcIcmsSt, n.valoresNfTerceiros.valorIpiIndustria as vlrIpi, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, n.valoresNfTerceiros.valorCofinsST as vlrCofinsST, n.valoresNfTerceiros.valorPisSt as vlrPisST, n.identificador as identificador from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.condicoesPagamento cp where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj = :cnpj");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("cnpj", cnpj);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        ArrayList<String> temp = new ArrayList<String>();
        ArrayList<RegCNPJ> listaCNPJ = new ArrayList<RegCNPJ>();
        for (Object o : ret) {
            String sitDoc;
            boolean docCancInut;
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Terceiros: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setEntSaiNatOP(Short.valueOf((short)0).shortValue());
            r.setEntSaiNatOP(0);
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(1);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setCnpj((String)h.get("cnpj"));
            if (!temp.contains(r.getCnpj())) {
                temp.add(r.getCnpj());
                RegCNPJ rc = new RegCNPJ();
                rc.setCnpj(r.getCnpj());
                listaCNPJ.add(rc);
            }
            boolean bl = docCancInut = (sitDoc = r.getCodSituacaoDoc()).equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (!docCancInut) {
                r.setObservacoes(this.getObservacoesBlocoC100(r.getIdentificador(), NOTA_TERCEIROS));
                r.setProcessosReferenciados(this.getProcessosReferenciadosBlocoC100(r.getIdentificador(), NOTA_TERCEIROS));
                r.setItensDocumento(this.getItensDocumentoNotaTerceirosBlocoC100(r.getIdentificador()));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private void getParticipantesNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, BlocoC b) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        ArrayList<Reg140> estabelecimentos = new ArrayList<Reg140>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        b.setParticipantes(participantes);
        b.setEstabelecimentos(estabelecimentos);
    }

    private List<RegC111> getProcessosReferenciadosBlocoC100(Long idNota, String tipoNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from " + tipoNota + " n inner join n.processosReferenciados p where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC170> getItensDocumentoNotaTerceirosBlocoC100(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, sum(g.quantidade) as quantidade, p.unidadeMedida.sigla as sigla, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, g.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, p.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, pDeb.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p  inner join p.grade g left join p.planoContaCred pCred left join p.planoContaDeb pDeb where n.identificador  = :idNota group by  p.numeroItem,  p.produto.identificador, p.produto.nome,  p.unidadeMedida.sigla, p.itemNotaLivroFiscal.valorTotal,  p.valorDesconto,  g.movimentacaoFisica, p.incidenciaIcms.codigo, p.itemNotaLivroFiscal.cfop.codigo, p.naturezaOperacao.identificador, p.itemNotaLivroFiscal.vrIcmsTributado, p.itemNotaLivroFiscal.vrIcms, p.itemNotaLivroFiscal.aliquotaIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST, p.incidenciaIpi.codigo, p.itemNotaLivroFiscal.vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio, p.incidenciaPisCofins.codigo,  (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto), p.itemNotaLivroFiscal.aliquotaPis, p.itemNotaLivroFiscal.vrPis, p.itemNotaLivroFiscal.aliquotaCofins, p.itemNotaLivroFiscal.vrCofins, pCred.codigo, pDeb.codigo, p.naturezaOperacao.entradaSaida order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            if (h.get("movimentacaoFisica") != null) {
                Short movimentacaoFisica = (Short)h.get("movimentacaoFisica");
                if (movimentacaoFisica.equals((short)1)) {
                    r.setMovimentacaoFisica((short)0);
                } else {
                    r.setMovimentacaoFisica((short)1);
                }
            } else {
                r.setMovimentacaoFisica((short)1);
            }
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setVlrBCPis((Double)h.get("BCGeral"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setBcCofins((Double)h.get("BCGeral"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC170> getItensDocumentoNotaPropriaBlocoC100(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, sum(g.quantidade) as quantidade, p.unidadeMedida.sigla as sigla, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, g.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, n.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, pDeb.codigo as planoContaDeb, n.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalPropria n inner join n.itensNotaPropria p inner join p.gradesNotaFiscalPropria g left join p.planoContaCred pCred left join p.planoContaDeb pDeb where n.identificador  = :idNota group by  p.numeroItem,  p.produto.identificador, p.produto.nome,  p.unidadeMedida.sigla, p.itemNotaLivroFiscal.valorTotal,  p.valorDesconto,  g.movimentacaoFisica, p.incidenciaIcms.codigo, p.itemNotaLivroFiscal.cfop.codigo, n.naturezaOperacao.identificador, p.itemNotaLivroFiscal.vrIcmsTributado, p.itemNotaLivroFiscal.vrIcms, p.itemNotaLivroFiscal.aliquotaIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST, p.incidenciaIpi.codigo, p.itemNotaLivroFiscal.vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio, p.incidenciaPisCofins.codigo,  (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto), p.itemNotaLivroFiscal.aliquotaPis, p.itemNotaLivroFiscal.vrPis, p.itemNotaLivroFiscal.aliquotaCofins, p.itemNotaLivroFiscal.vrCofins, pCred.codigo, pDeb.codigo, n.naturezaOperacao.entradaSaida order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setMovimentacaoFisica((Short)h.get("movimentacaoFisica"));
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setVlrBCPis((Double)h.get("BCGeral"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setBcCofins((Double)h.get("BCGeral"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.naturezaOperacao.identificador as idNatOperacao, n.naturezaOperacao.descricao as descNatOperacao from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.naturezaOperacao.identificador as idNatOperacao, i.naturezaOperacao.descricao as descNatOperacao from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC380> getNotasFiscaisTerceirosBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.situacaoDocumento.codigo as situacaoDocumento, sum(n.valoresNfTerceiros.valorTotal) as valorTotal, max(n.numeroNota) as numeroNotaIn, min(n.numeroNota) as numeroNotaFim from NotaFiscalTerceiros n  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa group by n.situacaoDocumento.codigo");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC380> toRet = new ArrayList<RegC380>();
        Double valorTotal = 0.0;
        Double valorCancelado = 0.0;
        Integer numInicial = 9999999;
        Integer numFinal = 0;
        for (Object o : ret) {
            boolean cancelado;
            HashMap h = (HashMap)o;
            String codSitDoc = (String)h.get("situacaoDocumento");
            boolean bl = cancelado = codSitDoc.equals("02") || codSitDoc.equals("03");
            if (cancelado) {
                valorCancelado = valorCancelado + (Double)h.get("valorTotal");
            } else {
                valorTotal = valorTotal + (Double)h.get("valorTotal");
            }
            if ((Integer)h.get("numeroNotaIn") < numInicial) {
                numInicial = (Integer)h.get("numeroNotaIn");
            }
            if ((Integer)h.get("numeroNotaFim") <= numFinal) continue;
            numFinal = (Integer)h.get("numeroNotaFim");
        }
        RegC380 r = new RegC380();
        r.setCodModDocFiscal("02");
        r.setDataInicial(dataIn);
        r.setDataFinal(dataFim);
        r.setNumDocInicial(numInicial);
        r.setNumDocFinal(numFinal);
        r.setValorCancelado(valorCancelado);
        r.setValorTotal(valorTotal);
        toRet.add(r);
        return toRet;
    }

    private List<RegC380> getNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.situacaoDocumento.codigo as situacaoDocumento, sum(n.valoresNfPropria.valorTotal) as valorTotal, max(n.numeroNota) as numeroNotaFim, min(n.numeroNota) as numeroNotaIn from NotaFiscalPropria n  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa group by n.situacaoDocumento.codigo");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC380> toRet = new ArrayList<RegC380>();
        Double valorTotal = 0.0;
        Double valorCancelado = 0.0;
        Integer numInicial = 9999999;
        Integer numFinal = 0;
        for (Object o : ret) {
            boolean cancelado;
            HashMap h = (HashMap)o;
            String codSitDoc = (String)h.get("situacaoDocumento");
            boolean bl = cancelado = codSitDoc.equals("02") || codSitDoc.equals("03");
            if (cancelado) {
                valorCancelado = valorCancelado + (Double)h.get("valorTotal");
            } else {
                valorTotal = valorTotal + (Double)h.get("valorTotal");
            }
            if ((Integer)h.get("numeroNotaIn") < numInicial) {
                numInicial = (Integer)h.get("numeroNotaIn");
            }
            if ((Integer)h.get("numeroNotaFim") <= numFinal) continue;
            numFinal = (Integer)h.get("numeroNotaFim");
        }
        if (ret != null && !ret.isEmpty()) {
            RegC380 r = new RegC380();
            r.setCodModDocFiscal("02");
            r.setDataInicial(dataIn);
            r.setDataFinal(dataFim);
            r.setNumDocInicial(numInicial);
            r.setNumDocFinal(numFinal);
            r.setValorCancelado(valorCancelado);
            r.setValorTotal(valorTotal);
            r.setPis(this.getPisNotasFiscaisBlocoC381(dataIn, dataFim, emp));
            r.setCofins(this.getCofinsNotasFiscaisBlocoC385(dataIn, dataFim, emp));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC381> getPisNotasFiscaisBlocoC381(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  p.identificador as idProduto, i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorItem, sum(i.vrProduto + i.vrServico + i.valorDespAcessoria + i.valorFrete + i.vrSeguro - i.valorDesconto) as valorBcPis, i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis, pc.codigo as planoConta from NotaFiscalPropria n inner join n.itensNotaPropria i inner join i.produto p left join p.planoConta pc  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa  and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)  group by i.incidenciaPisCofins.codigo,  i.itemNotaLivroFiscal.aliquotaPis, p.identificador, pc.codigo";
        Query q = s.createQuery(hql);
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC381> toRet = new ArrayList<RegC381>();
        ArrayList planos = new ArrayList();
        for (Object o : ret) {
            RegC381 r = new RegC381();
            HashMap h = (HashMap)o;
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setCodItem((Long)h.get("idProduto"));
            r.setValorItem((double)((Double)h.get("valorItem")));
            r.setValoBCPis((double)((Double)h.get("valorBcPis")));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((double)((Double)h.get("valorPis")));
            if ((String)h.get("planoConta") != null) {
                r.setCodContaAnalitica((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC385> getCofinsNotasFiscaisBlocoC385(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  p.identificador as idProduto, i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorItem, sum(i.vrProduto + i.vrServico + i.valorDespAcessoria + i.valorFrete + i.vrSeguro - i.valorDesconto) as valorBcCofins, i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, pc.codigo as planoConta from NotaFiscalPropria n inner join n.itensNotaPropria i  inner join i.produto p  left  join p.planoConta pc where (n.modeloDocFiscal.codigo=:cod1) and  n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa=:empresa  and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)  group by i.incidenciaPisCofins.codigo,  i.itemNotaLivroFiscal.aliquotaCofins, p.identificador,  pc.codigo";
        Query q = s.createQuery(hql);
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC385> toRet = new ArrayList<RegC385>();
        for (Object o : ret) {
            RegC385 r = new RegC385();
            HashMap h = (HashMap)o;
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setCodItem((Long)h.get("idProduto"));
            r.setValorItem((double)((Double)h.get("valorItem")));
            r.setValoBCCofins((double)((Double)h.get("valorBcCofins")));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((double)((Double)h.get("valorCofins")));
            if ((String)h.get("planoConta") != null) {
                r.setCodContaAnalitica((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisTerceirosBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1)");
        q.setString("cod1", "02");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)");
        q.setString("cod1", "02");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC395> getNotasFiscaisPropriasBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.identificador as idNota, n.modeloDocFiscal.codigo as codModDocFiscal, n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa, n.serie as serie, n.numeroNota as numeroNota, n.dataEmissaoNota as dataEmissao, n.valoresNfPropria.valorTotal as valorTotal from NotaFiscalPropria n  where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC395> toRet = new ArrayList<RegC395>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC395 r = new RegC395();
            r.setIdentificador((Long)h.get("identificador"));
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setSerie((String)h.get("serie"));
            r.setNumeroNota((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setItensNota(this.getItensNotaPropriaBlocoC396(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC395> getNotasFiscaisTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.identificador as idNota, n.modeloDocFiscal.codigo as codModDocFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.serie as serie, n.numeroNota as numeroNota, n.dataEmissao as dataEmissao, n.valoresNfTerceiros.valorTotal as valorTotal from NotaFiscalTerceiros n  where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissao between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC395> toRet = new ArrayList<RegC395>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC395 r = new RegC395();
            r.setIdentificador((Long)h.get("idNota"));
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setSerie((String)h.get("serie"));
            r.setNumeroNota((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setItensNota(this.getItensNotaTerceirosBlocoC396(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC396> getItensNotaTerceirosBlocoC396(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.produto.identificador as idProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pc.codigo as planoContaCred, pd.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as entSaida, nat.codigo as codBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p left join p.planoContaCred pc left join p.planoContaDeb pd left join p.naturezaBCCredito nat where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC396> toRet = new ArrayList<RegC396>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC396 r = new RegC396();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            r.setEntSaiNatOperacao((Short)h.get("entSaida"));
            r.setCodBCCred((String)h.get("codBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC396> getItensNotaPropriaBlocoC396(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.produto.identificador as idProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pc.codigo as planoContaCred, pd.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as entSaida, nat.codigo as codBCCredito from NotaFiscalPropria n inner join n.itensNotaPropria p left join p.planoContaCred pc left join p.planoContaDeb pd left join p.naturezaBCCredito nat where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC396> toRet = new ArrayList<RegC396>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC396 r = new RegC396();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            r.setEntSaiNatOperacao((Short)h.get("entSaida"));
            r.setCodBCCred((String)h.get("codBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasPropriasBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalPropria n  inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasFiscaisTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            if (r.getIdUnidMedida().equals((Long)h.get("idUnidMedidaProd"))) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC400> getEquipamentosFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c.modeloDocFiscal.codigo as codModDocFiscal, c.cupom.impressoraFiscal.modeloEcf as modeloImpressora, c.cupom.impressoraFiscal.serie as serieImpressora, c.cupom.impressoraFiscal.identificador as idImpressora from CupomFiscal c where c.cupom.dataEmissao between :dataIn and :dataFim  and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and c.cupom.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC400> toRet = new ArrayList<RegC400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC400 r = new RegC400();
            r.setModeloDocFiscal((String)h.get("codModDocFiscal"));
            r.setModeloECF((String)h.get("modeloImpressora"));
            r.setSerieECF((String)h.get("serieImpressora"));
            r.setIdImpressora((Long)h.get("idImpressora"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getReducoesZBlocoC405(List<RegC400> registrosC400, Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC400> iterator = registrosC400.iterator();
        while (iterator.hasNext()) {
            RegC400 o;
            RegC400 r = o = iterator.next();
            Long idImpressora = r.getIdImpressora();
            Query q = s.createQuery("select distinct p.dataEmissao as dataEmissao, p.contadorReinicio as contadorReinicio,  p.contadorCRZ as contadorCRZ,  p.ultimoCOO as ultimoCOO, p.valorTotalGeral as valorTotal, p.valorVendaBruta as valorVendaBruta, p.identificador as idReducaoZ,  p.valorCancelamentoICMS as vrCanc, p.valorDescontoICMS as vrDesc, p.valorAcrescimoICMS as vrAcres from ReducaoZ p where p.dataEmissao between :dataIn and :dataFim and p.empresa=:empresa and p.impressoraFiscal.identificador = :idImpressora");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setLong("idImpressora", idImpressora.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegC405> toRet = new ArrayList<RegC405>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegC405 rC405 = new RegC405();
                rC405.setDataMovimento((Date)h.get("dataEmissao"));
                rC405.setContadorCRZ((Long)h.get("contadorCRZ"));
                rC405.setUltimoCOO((Long)h.get("ultimoCOO"));
                rC405.setContadorReinicio((Long)h.get("contadorReinicio"));
                rC405.setValorTotalGeral((Double)h.get("valorTotal"));
                rC405.setValorVendaBruta((Double)h.get("valorVendaBruta"));
                rC405.setIdReducaoZ((Long)h.get("idReducaoZ"));
                rC405.setVrCancelamentoIcms((Double)h.get("vrCanc"));
                rC405.setVrDescontoIcms((Double)h.get("vrDesc"));
                rC405.setVrAcrescimoIcms((Double)h.get("vrAcres"));
                rC405.setPis(this.getPisBlocoC481(idImpressora, rC405.getDataMovimento()));
                rC405.setCofins(this.getCofinsBlocoC481(idImpressora, rC405.getDataMovimento()));
                toRet.add(rC405);
            }
            r.setReducoes(toRet);
        }
    }

    private List<RegC481> getPisBlocoC481(Long idImpressora, Date dataReducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  i.incidPisCofins.codigo as codIncidenciaPis, sum(i.bcPis) as BcPis, sum(i.valorTotal) as valorTotal, i.aliqPis as aliquotaPis, sum(i.vrPis) as valorPis, p.identificador as idProduto, pc.codigo as planoConta from CupomFiscal c inner join c.itemCupomFiscal i inner join i.produto p left  join p.planoConta pc  where c.cupom.dataEmissao = :dataReducao and c.cupom.impressoraFiscal.identificador = :idImpressora and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and i.cancelado = :cancelado and c.cancelado = :cancelado group by  i.incidPisCofins.codigo,  i.aliqPis, p.identificador, pc.codigo";
        Query q = s.createQuery(hql);
        q.setLong("idImpressora", idImpressora.longValue());
        q.setDate("dataReducao", dataReducao);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC481> toRet = new ArrayList<RegC481>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC481 r = new RegC481();
            r.setCodItem((Long)h.get("idProduto"));
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCPis((Double)h.get("BcPis"));
            if ((String)h.get("planoConta") != null) {
                r.setPlanoCred((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC485> getCofinsBlocoC481(Long idImpressora, Date dataReducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select i.incidPisCofins.codigo as codIncidenciaCofins, sum(i.bcCofins) as BcCofins, sum(i.valorTotal) as valorTotal, i.aliqCofins as aliquotaCofins, sum(i.vrCofins) as valorCofins, p.identificador as idProduto, pc.codigo as planoConta from CupomFiscal c inner join c.itemCupomFiscal i  inner join i.produto p left  join p.planoConta pc where c.cupom.dataEmissao = :dataReducao and c.cupom.impressoraFiscal.identificador = :idImpressora and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and i.cancelado = :cancelado and c.cancelado = :cancelado group by i.incidPisCofins.codigo,  i.aliqCofins, p.identificador, pc.codigo";
        Query q = s.createQuery(hql);
        q.setLong("idImpressora", idImpressora.longValue());
        q.setDate("dataReducao", dataReducao);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC485> toRet = new ArrayList<RegC485>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC485 r = new RegC485();
            r.setCodItem((Long)h.get("idProduto"));
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCCofins((Double)h.get("BcCofins"));
            if ((String)h.get("planoConta") != null) {
                r.setPlanoCred((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosReducoesC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p.identificador as ID_PRODUTO, p.nome as NOME_PRODUTO, p.unidadeMedida.sigla as SIGLA, t.codigo as COD_TIPO_ITEM_SPED, n.codigo as COD_NCM, g.codigo as COD_GENERO, p.aliquotaIcms as ALIQUOTA_ICMS from ItemCupomFiscal i inner join i.produto p left join p.ncm n left join p.genero g left join p.tipoIemSped t where (i.cupomFiscal.modeloDocFiscal.codigo=:cod1 or i.cupomFiscal.modeloDocFiscal.codigo=:cod2) and i.cupomFiscal.cupom.dataEmissao between :dataIn and :dataFim and i.cupomFiscal.cupom.empresa =:empresa and i.cupomFiscal.cancelado = :cancelado  and i.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((long)((Long)h.get("ID_PRODUTO")));
            r.setDescricao((String)h.get("NOME_PRODUTO"));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setTipoItem((String)h.get("COD_TIPO_ITEM_SPED"));
            r.setCodNcm((String)h.get("COD_NCM"));
            r.setCodGenero((String)h.get("COD_GENERO"));
            Double aliq = (Double)h.get("ALIQUOTA_ICMS");
            r.setAliquotaIcms(aliq);
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC500> getNotasFiscaisTerceirosBlocoC500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorIcms as valorIcms, n.valoresNfTerceiros.valorPis as valorPis, n.valoresNfTerceiros.valorCofins as valorCofins, n.identificador as identificador from NotaFiscalTerceiros n where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "06");
        q.setString("cod2", "29");
        q.setString("cod3", "28");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC500> toRet = new ArrayList<RegC500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC500 r = new RegC500();
            r.setIdentificador((Long)h.get("identificador"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setSerie((String)h.get("serie"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setNumeroDoc((Integer)h.get("numNota"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("valorIcms"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setPis(this.getPisBlocoC501(r.getIdentificador()));
            r.setCofins(this.getCofinsBlocoC505(r.getIdentificador()));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }

    private List<RegC501> getPisBlocoC501(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.vrProduto + i.vrSeguro + i.vrServico + i.valorDespAcessoria + i.valorFrete - i.valorDesconto) as BCGeral,  i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis,  nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaPis, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC501> toRet = new ArrayList<RegC501>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC501 r = new RegC501();
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC505> getCofinsBlocoC505(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.vrProduto + i.vrSeguro + i.vrServico + i.valorDespAcessoria + i.valorFrete - i.valorDesconto) as BCGeral,  i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaCofins, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC505> toRet = new ArrayList<RegC505>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC505 r = new RegC505();
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotaTerceirosBlocoC500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "06");
        q.setString("cod2", "28");
        q.setString("cod3", "29");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD100> getNotasTerceirosTransporteBlocoD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct n.identificador as identificador, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, tc.codigo as codigoTipoCte, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, tf.opcao as codTpFrete, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.tipoCte tc where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD100> toRet = new ArrayList<RegD100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD100 r = new RegD100();
            r.setNumeroDoc(((Integer)h.get("numNota")).longValue());
            System.out.println("Nr Nota Terceiros de Transporte: " + r.getNumeroDoc().toString());
            r.setChaveNfe((String)h.get("chaveNfe"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("codigoTipoCte") != null) {
                r.setCodTipoCTe((Short)h.get("codigoTipoCte"));
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete((Short)h.get("codTpFrete"));
            } else {
                r.setIndicadorTipoFrete((short)9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            Reg500 pc = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(pc);
            r.setPis(this.getPisBlocoD101(r.getIdentificador()));
            r.setCofins(this.getCofinsBlocoD105(r.getIdentificador()));
            r.setProcessosReferenciados(this.getProcessosRefBlocoD111(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private Reg500 getPlanoContaNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select lv.planoConta as planoConta from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            PlanoConta pc = (PlanoConta)h.get("planoConta");
            if (pc == null) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(pc.getIdentificador());
            r.setCodigo(pc.getCodigo());
            r.setDescricao(pc.getDescricao());
            r.setDataInclusao(pc.getDataCadastro());
            r.setMarca(pc.getMarca());
            r.setCodNaturezaContaSped(pc.getNaturezaOperacaoPC().getCodigo());
            return r;
        }
        return null;
    }

    List getParticipantesNotasTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD101> getPisBlocoD101(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select n.naturezaFrete.codigo as codNatFrete, i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.vrProduto + i.vrSeguro + i.vrServico + i.valorDespAcessoria + i.valorFrete - i.valorDesconto) as BCGeral,  i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis, nat.codigo as natBcCred from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaPis,  n.naturezaFrete.codigo,nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD101> toRet = new ArrayList<RegD101>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD101 r = new RegD101();
            r.setIndicadorNaturezaFrete((String)h.get("codNatFrete"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPis"));
            r.setNatBcCred((String)h.get("natBcCred"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((Double)h.get("valorPis"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD105> getCofinsBlocoD105(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select n.naturezaFrete.codigo as codNatFrete, i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.vrProduto + i.vrSeguro + i.vrServico + i.valorDespAcessoria + i.valorFrete - i.valorDesconto) as BCGeral,  i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, nat.codigo as natBcCred from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaCofins, n.naturezaFrete.codigo, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD105> toRet = new ArrayList<RegD105>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD105 r = new RegD105();
            r.setNatBcCred((String)h.get("natBcCred"));
            r.setIndicadorNaturezaFrete((String)h.get("codNatFrete"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaCofins"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((Double)h.get("valorCofins"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD111> getProcessosRefBlocoD111(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as origProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD111> toRet = new ArrayList<RegD111>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD111 r = new RegD111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("origProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD500> getNotasTerceirosTelecomunicacaoBlocoD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = null;
        String sql = " select distinct n.id_nota_terceiros from nota_terceiros n  inner join item_nota_terceiros i on i.id_nota_terceiros = n.id_nota_terceiros inner join incidencia_pis_cofins inc on inc.id_incidencia_pis_cofins = i.id_incidencia_pis_cofins inner join modelo_doc_fiscal m on m.id_modelo_doc_fiscal  = n.id_modelo_doc_fiscal where (m.codigo=:cod1 or m.codigo=:cod2) and n.data_entrada_saida between :dataIn and :dataFim and n.id_empresa =:empresa and inc.codigo between :codInicial and :codFinal";
        q = s.createSQLQuery(sql);
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setLong("empresa", emp.getIdentificador().longValue());
        q.setString("codInicial", "50");
        q.setString("codFinal", "56");
        List ret = q.list();
        ArrayList<RegD500> toRet = new ArrayList<RegD500>();
        if (ret != null) {
            for (Object ob : ret) {
                Long idNota = ((Integer)ob).longValue();
                q = s.createQuery("select distinct n.identificador as identificador, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorDesconto as valorDesconto, n.valoresNfTerceiros.valorProduto + n.valorServico as valorProdServ, n.valoresNfTerceiros.valorDespAcess as valorDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as valorIcms, n.valoresNfTerceiros.valorPis as valorPis, n.valoresNfTerceiros.valorCofins as valorCofins from NotaFiscalTerceiros n where n.identificador = :idNota");
                q.setLong("idNota", idNota.longValue());
                q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                ret = q.list();
                for (Object o : ret) {
                    HashMap h = (HashMap)o;
                    RegD500 r = new RegD500();
                    r.setIdentificador((Long)h.get("identificador"));
                    r.setIdParticipante((Long)h.get("idPessoa"));
                    r.setCodModDocFiscal((String)h.get("codModFiscal"));
                    r.setCodSituacaoDoc((String)h.get("sitDoc"));
                    r.setSerie((String)h.get("serie"));
                    r.setDataEmissao((Date)h.get("dataEmissao"));
                    r.setDataEntSaida((Date)h.get("dataEntSai"));
                    r.setNumeroDoc((Integer)h.get("numNota"));
                    r.setValorDoc((Double)h.get("valorTotal"));
                    r.setValorDesconto((Double)h.get("valorDesconto"));
                    r.setValorTotalMercadorias((Double)h.get("valorProdServ"));
                    r.setValorDespAcess((Double)h.get("valorDespAcess"));
                    r.setValorBcIcms((Double)h.get("bcIcms"));
                    r.setValorICMS((Double)h.get("valorIcms"));
                    r.setValorPis((Double)h.get("valorPis"));
                    r.setValorCofins((Double)h.get("valorCofins"));
                    r.setPis(this.getPisBlocoD501(r.getIdentificador()));
                    r.setCofins(this.getCofinsBlocoD505(r.getIdentificador()));
                    r.setProcessosReferenciados(this.getProcessosRefBlocoD509(r.getIdentificador()));
                    ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
                    r.setObsFaturamento(obs);
                    toRet.add(r);
                }
            }
        }
        return toRet;
    }

    private List<RegD501> getPisBlocoD501(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.vrProduto + i.vrSeguro + i.vrServico + i.valorDespAcessoria + i.valorFrete - i.valorDesconto) as BCGeral,  i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis, nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaPis, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD501> toRet = new ArrayList<RegD501>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD501 r = new RegD501();
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPis"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((Double)h.get("valorPis"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD505> getCofinsBlocoD505(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.vrProduto + i.vrSeguro + i.vrServico + i.valorDespAcessoria + i.valorFrete - i.valorDesconto) as BCGeral,  i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaCofins, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD505> toRet = new ArrayList<RegD505>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD505 r = new RegD505();
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaCofins"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD509> getProcessosRefBlocoD509(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as origProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD509> toRet = new ArrayList<RegD509>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD509 r = new RegD509();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("origProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    List getParticipantesNotasTerceirosTelecomunicacaoD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        ArrayList<Reg500> obj = new ArrayList<Reg500>();
        obj.addAll(this.getPlanoContasNotaPropriaFatEntBlocoC100(dataIn, dataFim, emp));
        obj.addAll(this.getPlanoContasNotaPropriaFatSaiBlocoC100(dataIn, dataFim, emp));
        return obj;
    }

    private List<Reg500> getPlanoContasNotaPropriaFatEntBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.naturezaOperacao.entradaSaida=:ent");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setShort("ent", (short)2);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaFatSaiBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaCred.identificador as idPlanoCred, i.planoContaCred.dataCadastro as dataCadastroCred, i.planoContaCred.marca as marcaCred, i.planoContaCred.codigo as codContaCred, i.planoContaCred.descricao as descricaoContaCred, i.planoContaCred.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.naturezaOperacao.entradaSaida=:sai");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setShort("sai", (short)1);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasReducoesC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao from CupomFiscal n  inner join n.itemCupomFiscal i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2) and n.cupom.dataEmissao between :dataIn and :dataFim and n.cupom.empresa=:empresa and n.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD200> getConhecimentosSaidaD200(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.situacaoDocumento.codigo as situacaoDocumento, n.modeloDocFiscal.codigo as codModDocFiscal, sum(n.cteVlrImpostos.vrReceber) as valorTotal, sum(n.cteVlrImpostos.vrDesconto) as valorDesconto, min(n.numero) as numeroIn, max(n.numero) as numeroFim, lv.cfop.codigo as cfop, n.serie as serie,  n.dataEmissao as dataEmissao from Cte n  inner join n.livrosFiscais lv where  n.dataEmissao between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5) group by n.situacaoDocumento.codigo,  n.modeloDocFiscal.codigo, lv.cfop.codigo,  n.serie, n.dataEmissao");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD200> toRet = new ArrayList<RegD200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD200 r = new RegD200();
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setCodSituacaoDocumento((String)h.get("situacaoDocumento"));
            r.setSerie((String)h.get("serie"));
            r.setNumeroInicial((Long)h.get("numeroIn"));
            r.setNumeroFinal((Long)h.get("numeroFim"));
            r.setCfop((String)h.get("cfop"));
            r.setDataRef((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorDescontos((Double)h.get("valorDesconto"));
            this.getPisCofinsConhecimentosSaidaD201(r.getDataRef(), emp, r);
            toRet.add(r);
        }
        return toRet;
    }

    private void getPisCofinsConhecimentosSaidaD201(Date dataRef, Empresa emp, RegD200 regD200) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  n.cteVlrImpostos.incidenciaPis.codigo as codIncidenciaPis, n.cteVlrImpostos.incidenciaCofins.codigo as codIncidenciaCofins, sum(n.cteVlrImpostos.baseCalcPis) as vrBCPis, sum(n.cteVlrImpostos.baseCalcCofins) as vrBCCofins, sum(n.cteVlrImpostos.vrPis) as vrPis, sum(n.cteVlrImpostos.vrCofins) as vrCofins, n.cteVlrImpostos.aliqPis as aliqPis, n.cteVlrImpostos.aliqCofins as aliqCofins, sum(n.cteVlrImpostos.vrReceber) as vrTotal  from Cte n inner join n.livrosFiscais lv where  n.dataEmissao = :dataIn  and n.empresa=:empresa  and lv.cfop.codigo = :codCfop and n.situacaoDocumento.codigo  = :codSitDoc and n.serie = :serie  group by  n.cteVlrImpostos.incidenciaPis.codigo, n.cteVlrImpostos.incidenciaCofins.codigo, n.cteVlrImpostos.aliqPis, n.cteVlrImpostos.aliqCofins ";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataRef);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc", regD200.getCodSituacaoDocumento());
        q.setString("codCfop", regD200.getCfop());
        q.setString("serie", regD200.getSerie());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD201> toRetPis = new ArrayList<RegD201>();
        for (Object o : ret) {
            RegD201 r = new RegD201();
            HashMap h = (HashMap)o;
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPis"));
            r.setValorTotal((double)((Double)h.get("vrTotal")));
            r.setValorPis((double)((Double)h.get("vrPis")));
            r.setValorBcPis((double)((Double)h.get("vrBCPis")));
            r.setAliquotaPis((Double)h.get("aliqPis"));
            toRetPis.add(r);
        }
        regD200.setPis(toRetPis);
        ArrayList<RegD205> toRetCofins = new ArrayList<RegD205>();
        for (Object o : ret) {
            RegD205 r = new RegD205();
            HashMap h = (HashMap)o;
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaCofins"));
            r.setValorTotal((double)((Double)h.get("vrTotal")));
            r.setValorCofins((double)((Double)h.get("vrCofins")));
            r.setValorBcCofins((double)((Double)h.get("vrBCCofins")));
            r.setAliquotaCofins((Double)h.get("aliqCofins"));
            toRetCofins.add(r);
        }
        regD200.setCofins(toRetCofins);
    }

    private List<RegA100> getNotasTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador,0 as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, cp.tpCondicao as tpCond, n.valoresNfTerceiros.valorDesconto as valorDesconto, n.valoresNfTerceiros.valorPis as valorPis, n.valoresNfTerceiros.valorCofins as valorCofins, n.valoresNfTerceiros.valorCofinsST as valorCofinsST, n.valoresNfTerceiros.valorPisSt as valorPisST, n.valoresNfTerceiros.valorIss as valorIss from NotaFiscalTerceiros n  left join n.condicoesPagamento cp where (n.modeloDocFiscal.codigo=:cod1) and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2)  and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "99");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA100> toRet = new ArrayList<RegA100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegA100 r = new RegA100();
            r.setIdentificador((Long)h.get("identificador"));
            r.setTipoOperacao(0);
            r.setIndTipoEmitente(1);
            r.setNumeroDoc((Integer)h.get("numNota"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorCofinsRetido((Double)h.get("valorCofinsST"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorPisRetido((Double)h.get("valorPisST"));
            r.setValorIss((Double)h.get("valorIss"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("valorTotal"));
            r.setObservacoes(this.getObservacoesNotaTerceirosBlocoA110(r.getIdentificador(), NOTA_TERCEIROS));
            r.setProcReferenciados(this.getProcReferenciadosBlocoA111(r.getIdentificador(), NOTA_TERCEIROS));
            r.setItensDocumento(this.getItensNotaTerceirosBlocoA170(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        return participantes;
    }

    private List<RegA170> getItensNotaTerceirosBlocoA170(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, nat.codigo as codNatBcCredito, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pDeb.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p left join p.naturezaBCCredito nat left join p.planoContaDeb pDeb where n.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA170> toRet = new ArrayList<RegA170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA170 r = new RegA170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodBCCredito((String)h.get("codNatBcCredito"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((double)((Double)h.get("BCGeral")));
            r.setValorAliqPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((double)((Double)h.get("vrPis")));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((double)((Double)h.get("BCGeral")));
            r.setValorAliqCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((double)((Double)h.get("vrCofins")));
            r.setCodContaAnalitica((String)h.get("planoContaDeb"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegA100> getNotasPropriasBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, n.naturezaOperacao.entradaSaida as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissaoNota as dataEmissao, n.dataEntradaSaida as dataEntSai, n.valoresNfPropria.valorTotal as valorTotal, cp.tpCondicao as tpCond, n.valoresNfPropria.valorDesconto as valorDesconto, n.valoresNfPropria.valorPis as valorPis, n.valoresNfPropria.valorCofins as valorCofins, n.valoresNfPropria.valorCofinsSt as valorCofinsST, n.valoresNfPropria.valorPisSt as valorPisST, n.valoresNfPropria.valorIss as valorIss from NotaFiscalPropria n  left join n.condicaoPagamento cp where (n.modeloDocFiscal.codigo=:cod1) and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2)  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA100> toRet = new ArrayList<RegA100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegA100 r = new RegA100();
            r.setIdentificador((Long)h.get("identificador"));
            r.setTipoOperacao(1);
            r.setIndTipoEmitente(0);
            r.setNumeroDoc((Integer)h.get("numNota"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorCofinsRetido((Double)h.get("valorCofinsST"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorPisRetido((Double)h.get("valorPisST"));
            r.setValorIss((Double)h.get("valorIss"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("valorTotal"));
            r.setObservacoes(this.getObservacoesNotaTerceirosBlocoA110(r.getIdentificador(), NOTA_PROPRIA));
            r.setProcReferenciados(this.getProcReferenciadosBlocoA111(r.getIdentificador(), NOTA_PROPRIA));
            r.setItensDocumento(this.getItensNotaPropriaBlocoA170(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasPropriasBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from NotaFiscalPropria n  inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        return participantes;
    }

    private List<RegA111> getProcReferenciadosBlocoA111(Long idNota, String tipoNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from " + tipoNota + "  n  inner join n.processosReferenciados p where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA111> toRet = new ArrayList<RegA111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA111 r = new RegA111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegA110> getObservacoesNotaTerceirosBlocoA110(Long idNota, String tipoNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select n.observacoesIntFisco as obsIntFisco from " + tipoNota + " n  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA110> toRet = new ArrayList<RegA110>();
        ArrayList<Long> temp = new ArrayList<Long>();
        if (!tipoNota.equals(NOTA_TERCEIROS)) {
            ObservacaoIntFiscalNotaFiscalPropria ob;
            HashMap h;
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoIntFiscalNotaFiscalPropria)h.get("obsIntFisco");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                Object comp = "";
                for (Object obj : ob.getTokens()) {
                    TokenObsIntFisco t = (TokenObsIntFisco)obj;
                    comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
                }
                RegA110 r = new RegA110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto((String)comp);
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
            hql = "select n.observacaoNota as obsEstNota from " + tipoNota + " n  where n.identificador  = :idNota";
            q = s.createQuery(hql);
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            ret = q.list();
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoNotaPropria)h.get("obsEstNota");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                RegA110 r = new RegA110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto(ob.getConteudo());
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
        } else {
            ObservacaoIntFiscoNFTerceiros ob;
            HashMap h;
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoIntFiscoNFTerceiros)h.get("obsIntFisco");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                Object comp = "";
                for (Object obj : ob.getTokens()) {
                    TokenObsIntFiscoNFTerceiros t = (TokenObsIntFiscoNFTerceiros)obj;
                    comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
                }
                RegA110 r = new RegA110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto((String)comp);
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
            hql = "select n.observacaoNotaTerceiros as obsEstNota from " + tipoNota + " n  where n.identificador  = :idNota";
            q = s.createQuery(hql);
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            ret = q.list();
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoNotaTerceiros)h.get("obsEstNota");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                RegA110 r = new RegA110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto(ob.getConteudo());
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
        }
        return toRet;
    }

    private List<RegA170> getItensNotaPropriaBlocoA170(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, nat.codigo as codNatBcCredito, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, p.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalPropria n inner join n.itensNotaPropria p left join p.naturezaBCCredito nat left join p.planoContaCred pCred where n.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA170> toRet = new ArrayList<RegA170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA170 r = new RegA170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodBCCredito((String)h.get("codNatBcCredito"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((double)((Double)h.get("BCGeral")));
            r.setValorAliqPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((double)((Double)h.get("vrPis")));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((double)((Double)h.get("BCGeral")));
            r.setValorAliqCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((double)((Double)h.get("vrCofins")));
            r.setCodContaAnalitica((String)h.get("planoContaCred"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasPropriasBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaCred.identificador as idPlanoCred, i.planoContaCred.dataCadastro as dataCadastroCred, i.planoContaCred.marca as marcaCred, i.planoContaCred.codigo as codContaCred, i.planoContaCred.descricao as descricaoContaCred, i.planoContaCred.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoCred");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasPropriasBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC110> getObservacoesBlocoC100(Long idNota, String tipoNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String obs = null;
        obs = !tipoNota.equals(NOTA_TERCEIROS) ? "observacaoIntFiscalNotaFiscalPropria" : "observacoesIntFisco";
        String hql = "select distinct n." + obs + " as obsIntFisco from " + tipoNota + " n  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        ArrayList<Long> temp = new ArrayList<Long>();
        if (!tipoNota.equals(NOTA_TERCEIROS)) {
            ObservacaoIntFiscalNotaFiscalPropria ob;
            HashMap h;
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoIntFiscalNotaFiscalPropria)h.get("obsIntFisco");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                Object comp = "";
                for (Object obj : ob.getTokens()) {
                    TokenObsIntFisco t = (TokenObsIntFisco)obj;
                    comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
                }
                RegC110 r = new RegC110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto((String)comp);
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
            hql = "select distinct n.observacaoNota as obsEstNota from " + tipoNota + " n  where n.identificador  = :idNota";
            q = s.createQuery(hql);
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            ret = q.list();
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoNotaPropria)h.get("obsEstNota");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                RegC110 r = new RegC110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto(ob.getConteudo());
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
        } else {
            ObservacaoIntFiscoNFTerceiros ob;
            HashMap h;
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoIntFiscoNFTerceiros)h.get("obsIntFisco");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                Object comp = "";
                for (Object obj : ob.getTokens()) {
                    TokenObsIntFiscoNFTerceiros t = (TokenObsIntFiscoNFTerceiros)obj;
                    comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
                }
                RegC110 r = new RegC110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto((String)comp);
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
            hql = "select distinct n.observacaoNotaTerceiros as obsEstNota from " + tipoNota + " n  where n.identificador  = :idNota";
            q = s.createQuery(hql);
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            ret = q.list();
            for (Object o : ret) {
                h = (HashMap)o;
                ob = (ObservacaoNotaTerceiros)h.get("obsEstNota");
                if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
                RegC110 r = new RegC110();
                r.setDescricao(ob.getObsFaturamento().getNome());
                r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
                r.setTexto(ob.getConteudo());
                toRet.add(r);
                temp.add(ob.getObsFaturamento().getIdentificador());
            }
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)");
        q.setString("cod1", "02");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasFiscaisTerceirosBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)");
        q.setString("cod1", "02");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct pc.identificador as idPlanoConta, pc.marca as marca, pc.descricao as descricao, pc.codigo as codigo, pc.dataCadastro as dataCadastro, pc.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalPropria n inner join n.itensNotaPropria i inner join i.produto p inner join p.planoConta pc  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa  and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5) ";
        Query q = s.createQuery(hql);
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            Reg500 r = new Reg500();
            HashMap h = (HashMap)o;
            r.setIdPlanoContas((Long)h.get("idPlanoConta"));
            r.setDescricao((String)h.get("descricao"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codigo"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            r.setDataInclusao((Date)h.get("dataCadastro"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasReducoesC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct  pc.identificador as idPlanoConta, pc.codigo as codigo, pc.descricao as descricao, pc.marca as marca, pc.dataCadastro as dataCadastro, pc.naturezaOperacaoPC.codigo as codNatPC from CupomFiscal c inner join c.itemCupomFiscal i  inner join i.produto p left  join p.planoConta pc where c.cupom.dataEmissao between :dataIn and :dataFim and c.cupom.empresa =  :emp and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2)";
        Query q = s.createQuery(hql);
        q.setEntity("emp", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg500 r = new Reg500();
            r.setIdPlanoContas((Long)h.get("idPlanoConta"));
            r.setCodigo((String)h.get("codigo"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            r.setDescricao((String)h.get("descricao"));
            r.setMarca((Integer)h.get("marca"));
            r.setDataInclusao((Date)h.get("dataCadastro"));
            toRet.add(r);
        }
        return toRet;
    }

    BlocoF getLancamentosBlocoF100(Empresa emp, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF100(this.getLancamentosBlocoF100(dataIn, dataFim, emp));
        f.setParticipantes(this.getParticipantesLancamentosF100(dataIn, dataFim, emp));
        f.setProdutos(this.getProdutosLancamentosF100(dataIn, dataFim, emp));
        f.setUnidadeMedidas(this.getUnidadeMedidaLancamentosF100(dataIn, dataFim, emp));
        f.setCentroCustos(this.getCentroCustosLancamentosF100(dataIn, dataFim, emp));
        f.setPlanoContas(this.getPlanoContasLancamentosF100(dataIn, dataFim, emp));
        return f;
    }

    private List<RegF100> getLancamentosBlocoF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LancamentoSpedPisCofins l where l.dataOper between :dataIn and :dataFim and l.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        List ret = q.list();
        ArrayList<RegF100> toRet = new ArrayList<RegF100>();
        for (Object o : ret) {
            LancamentoSpedPisCofins l = (LancamentoSpedPisCofins)o;
            RegF100 r = new RegF100();
            r.setIndicadorTipoOperacao(l.getIndOper());
            if (l.getParticipante() != null) {
                r.setIdParticipante(l.getParticipante().getIdentificador());
            }
            if (l.getProduto() != null) {
                r.setIdProduto(l.getProduto().getIdentificador());
            }
            r.setDataOperacao(l.getDataOper());
            r.setVrOperacao(l.getVrOper());
            r.setCodIncidenciaPis(l.getCstPis().getCodigo());
            r.setCodIncidenciaCofins(l.getCstCofins().getCodigo());
            r.setVrPis(l.getVrPis());
            r.setVrCofins(l.getVrCofins());
            r.setVrBcPis(l.getVrBcPis());
            r.setVrBcCofins(l.getVrBcCofins());
            r.setAliquotaCofins(l.getAliqCofins());
            r.setAliquotaPis(l.getAliqPis());
            r.setCodNatBCCredito(l.getNatBcCredito().getCodigo());
            r.setIndicadorOrigemCredito(l.getIndOrigCred());
            r.setDescricaoDocumento(l.getDescDocOper());
            r.setIdentificador(l.getIdentificador());
            r.setProcessosReferenciados(this.getProcessosReferenciadosF100(l.getProcessoFiscal()));
            if (l.getPlanoConta() != null) {
                r.setCodPlanoConta(l.getPlanoConta().getCodigo());
            }
            if (l.getCentroCusto() != null) {
                r.setCodCentroCusto(l.getCentroCusto().getCodigo());
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List getProcessosReferenciadosF100(ProcessoFiscal p) {
        ArrayList<RegF111> toRet = new ArrayList<RegF111>();
        if (p != null) {
            RegF111 r = new RegF111();
            r.setCodOrigem(p.getTipoProcesso().getCodigo());
            r.setNumeroProcesso(p.getNrProcesso());
            toRet.add(r);
        }
        return toRet;
    }

    List getParticipantesLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from LancamentoSpedPisCofins n  inner join n.participante p where  n.dataOper between :dataIn and :dataFim and n.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.identificador as idProduto, i.nome as nomeProduto, i.unidadeMedida.sigla as unidadeMedida, i.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.aliquotaIcms as aliquotaIcms from LancamentoSpedPisCofins n  inner join n.produto i left join i.ncm nc left join i.genero g where  n.dataOper between :dataIn and :dataFim and n.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoConta.identificador as idPlano, i.planoConta.dataCadastro as dataCadastro, i.planoConta.marca as marca, i.planoConta.codigo as codConta, i.planoConta.descricao as descricaoConta, i.planoConta.naturezaOperacaoPC.codigo as codNatPC from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim and i.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlano");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoConta"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codConta"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg600> getCentroCustosLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.centroCusto.identificador as idCentroCusto, i.centroCusto.dataCadastro as dataCadastro, i.centroCusto.codigo as codCentroCusto, i.centroCusto.nome as descricaoCentroCusto from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim and i.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg600> toRet = new ArrayList<Reg600>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCentroCusto = (Long)h.get("idCentroCusto");
            if (idCentroCusto == null || idCentroCusto <= 0L) continue;
            Reg600 r = new Reg600();
            r.setIdCentroCusto(idCentroCusto);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoCentroCusto"));
            r.setCodigo((String)h.get("codCentroCusto"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidadeMedidaLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim and i.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    BlocoF getRegistrosBlocoF120(Empresa emp, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF120(this.getRegistrosBlocoF120(dataIn, dataFim, emp));
        f.setCentroCustos(this.getCentroCustosRegistrosF120(dataIn, dataFim, emp));
        f.setPlanoContas(this.getPlanoContasRegistrosF120(dataIn, dataFim, emp));
        return f;
    }

    private List<RegF120> getRegistrosBlocoF120(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct m as MOV_BEM_PIS_COFINS from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.depreciacaoCiap.periodo between :dataIn and :dataFim and c.depreciacaoCiap.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegF120> toRet = new ArrayList<RegF120>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            MovBemSpedPisCofins m = (MovBemSpedPisCofins)h.get("MOV_BEM_PIS_COFINS");
            BemSpedPisCofins b = m.getBemSpedPisCofins();
            RegF120 r = new RegF120();
            r.setCodNatBcCredito(b.getNaturezaBCCredito().getCodigo());
            r.setCodIdenBemImobilizado(b.getIdenBemImobilizado().getCodigo());
            r.setCodIndUtilizacaoBemImobilizado(b.getIndUtilBemImobilizado().getCodigo());
            r.setCodIndOrigemCredito(b.getIndOrigCredBemPisCofins().getCodigo());
            r.setValorOperacao(m.getVrOperDep());
            r.setParcelaOperNaoBcCred(m.getParcOperNaoBcCred());
            r.setCodIncidenciaPis(b.getCstPis().getCodigo());
            r.setValorBcPis(m.getVrBcPis());
            r.setValorPis(m.getVrPis());
            r.setAliquotaPis(b.getAliquotaPis());
            r.setCodIncidenciaCofins(b.getCstCofins().getCodigo());
            r.setValorBcCofins(m.getVrBcCofins());
            r.setValorCofins(m.getVrCofins());
            r.setAliquotaCofins(b.getAliquotaCofins());
            if (b.getPlanoConta() != null) {
                r.setCodPlanoConta(b.getPlanoConta().getCodigo());
            }
            if (b.getBem().getCentroCusto() != null) {
                r.setCodCentroCusto(b.getBem().getCentroCusto().getCodigo());
            }
            r.setDescricaoBemImobilizado(b.getDescricaoBemImobilizado());
            r.setProcessosReferenciados(this.getProcessosReferenciadosF129(b.getProcessoFiscal()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasRegistrosF120(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.planoConta.identificador as idPlano, m.bemSpedPisCofins.planoConta.dataCadastro as dataCadastro, m.bemSpedPisCofins.planoConta.marca as marca, m.bemSpedPisCofins.planoConta.codigo as codConta, m.bemSpedPisCofins.planoConta.descricao as descricaoConta, m.bemSpedPisCofins.planoConta.naturezaOperacaoPC.codigo as codNatPC from DepreciacaoCiap c inner join c.itemCiapDepreciacaoBaixaBem i inner join i.movBemSpedPisCofins m where c.periodo between :dataIn and :dataFim and c.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlano");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoConta"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codConta"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg600> getCentroCustosRegistrosF120(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.bem.centroCusto.identificador as idCentroCusto, m.bemSpedPisCofins.bem.centroCusto.dataCadastro as dataCadastro, m.bemSpedPisCofins.bem.centroCusto.codigo as codCentroCusto, m.bemSpedPisCofins.bem.centroCusto.nome as descricaoCentroCusto from DepreciacaoCiap c inner join c.itemCiapDepreciacaoBaixaBem i inner join i.movBemSpedPisCofins m where c.periodo between :dataIn and :dataFim and c.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg600> toRet = new ArrayList<Reg600>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCentroCusto = (Long)h.get("idCentroCusto");
            if (idCentroCusto == null || idCentroCusto <= 0L) continue;
            Reg600 r = new Reg600();
            r.setIdCentroCusto(idCentroCusto);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoCentroCusto"));
            r.setCodigo((String)h.get("codCentroCusto"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getProcessosReferenciadosF129(ProcessoFiscal processoFiscal) {
        ArrayList<RegF129> lista = new ArrayList<RegF129>();
        if (processoFiscal != null) {
            RegF129 r = new RegF129();
            r.setCodOrigem(processoFiscal.getTipoProcesso().getCodigo());
            r.setNumeroProcesso(processoFiscal.getNrProcesso());
            lista.add(r);
        }
        return lista;
    }

    BlocoF getRegistrosBlocoF130(Empresa emp, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF130(this.getRegistrosBlocoF130(dataIn, dataFim, emp));
        f.setPlanoContas(this.getPlanoContasRegistrosF130(dataIn, dataFim, emp));
        f.setCentroCustos(this.getCentroCustosRegistrosF130(dataIn, dataFim, emp));
        return f;
    }

    private List<RegF130> getRegistrosBlocoF130(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct m as MOV_BEM_PIS_COFINS from DepreciacaoCiap c inner join c.itemCiapDepreciacaoBaixaBem i inner join i.movBemSpedPisCofins m where c.periodo between :dataIn and :dataFim and c.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegF130> toRet = new ArrayList<RegF130>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            MovBemSpedPisCofins m = (MovBemSpedPisCofins)h.get("MOV_BEM_PIS_COFINS");
            BemSpedPisCofins b = m.getBemSpedPisCofins();
            RegF130 r = new RegF130();
            r.setCodNatBcCredito(b.getNaturezaBCCredito().getCodigo());
            r.setCodIdenBemImobilizado(b.getIdenBemImobilizado().getCodigo());
            r.setCodIndUtilizacaoBemImobilizado(b.getIndUtilBemImobilizado().getCodigo());
            r.setCodIndOrigemCredito(b.getIndOrigCredBemPisCofins().getCodigo());
            r.setValorOperacao(b.getVrOperAquis());
            r.setMesAnoOperacao(b.getMesOperAquis());
            r.setParcelaOperNaoBcCred(m.getParcOperNaoBcCred());
            r.setVrBcCredito(m.getVrBcCred());
            r.setCodIndNrParcelas(b.getIndNrParcela().getCodigo());
            r.setCodIncidenciaPis(b.getCstPis().getCodigo());
            r.setValorBcPis(m.getVrBcPis());
            r.setValorPis(m.getVrPis());
            r.setAliquotaPis(b.getAliquotaPis());
            r.setCodIncidenciaCofins(b.getCstCofins().getCodigo());
            r.setValorBcCofins(m.getVrBcCofins());
            r.setValorCofins(m.getVrCofins());
            r.setAliquotaCofins(b.getAliquotaCofins());
            r.setDescricaoBemImobilizado(b.getDescricaoBemImobilizado());
            r.setProcessosReferenciados(this.getProcessosReferenciadosF139(b.getProcessoFiscal()));
            if (b.getPlanoConta() != null) {
                r.setCodPlanoConta(b.getPlanoConta().getCodigo());
            }
            if (b.getBem().getCentroCusto() != null) {
                r.setCodCentroCusto(b.getBem().getCentroCusto().getCodigo());
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasRegistrosF130(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.planoConta.identificador as idPlano, m.bemSpedPisCofins.planoConta.dataCadastro as dataCadastro, m.bemSpedPisCofins.planoConta.marca as marca, m.bemSpedPisCofins.planoConta.codigo as codConta, m.bemSpedPisCofins.planoConta.descricao as descricaoConta, m.bemSpedPisCofins.planoConta.naturezaOperacaoPC.codigo as codNatPC from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.depreciacaoCiap.periodo between :dataIn and :dataFim and c.depreciacaoCiap.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlano");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoConta"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codConta"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg600> getCentroCustosRegistrosF130(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.bem.centroCusto.identificador as idCentroCusto, m.bemSpedPisCofins.bem.centroCusto.dataCadastro as dataCadastro, m.bemSpedPisCofins.bem.centroCusto.codigo as codCentroCusto, m.bemSpedPisCofins.bem.centroCusto.nome as descricaoCentroCusto from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.depreciacaoCiap.periodo between :dataIn and :dataFim and c.depreciacaoCiap.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg600> toRet = new ArrayList<Reg600>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCentroCusto = (Long)h.get("idCentroCusto");
            if (idCentroCusto == null || idCentroCusto <= 0L) continue;
            Reg600 r = new Reg600();
            r.setIdCentroCusto(idCentroCusto);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoCentroCusto"));
            r.setCodigo((String)h.get("codCentroCusto"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getProcessosReferenciadosF139(ProcessoFiscal processoFiscal) {
        ArrayList<RegF139> lista = new ArrayList<RegF139>();
        if (processoFiscal != null) {
            RegF139 r = new RegF139();
            r.setCodOrigem(processoFiscal.getTipoProcesso().getCodigo());
            r.setNumeroProcesso(processoFiscal.getNrProcesso());
            lista.add(r);
        }
        return lista;
    }

    BlocoF getRegistrosBlocoF150(SpedPisCofins vo) {
        BlocoF f = new BlocoF();
        f.setRegistrosF150(this.getRegBlocoF150(vo));
        return f;
    }

    private List<RegF150> getRegBlocoF150(SpedPisCofins vo) {
        ArrayList<RegF150> dados = new ArrayList<RegF150>();
        if (vo.getRegistrosF150() != null) {
            for (Object o : vo.getRegistrosF150()) {
                EstoqueAberturaSpedPisCofins e = (EstoqueAberturaSpedPisCofins)o;
                RegF150 r = new RegF150();
                r.setAliquotaCofins(e.getAliqCofins());
                r.setAliquotaPis(e.getAliqPis());
                r.setCodIncidenciaCofins(e.getCstCofins().getCodigo());
                r.setCodIncidenciaPis(e.getCstPis().getCodigo());
                r.setCodNatBcCredito("18");
                r.setDescricaoEstoque(e.getDescEst());
                r.setParcelaEstoqueImp(e.getEstImp());
                r.setValorBcEstoque(e.getVrBcEst());
                r.setValorBcMensalEstoque(e.getVrBcMenEst());
                r.setValorCredCofins(e.getVrCredCofins());
                r.setValorCredPis(e.getVrCredPis());
                r.setValorTotalEstoque(e.getVrTotEst());
                Reg500 pc = this.getPlanoContaLancamentoSpedPisCofins(e.getPlanoConta());
                r.setPlanoConta(pc);
                dados.add(r);
            }
        }
        return dados;
    }

    BlocoF getRegistrosBlocoF700(SpedPisCofins vo) {
        BlocoF f = new BlocoF();
        f.setRegistrosF700(this.getRegBlocoF700(vo));
        return f;
    }

    private List<RegF700> getRegBlocoF700(SpedPisCofins vo) {
        ArrayList<RegF700> dados = new ArrayList<RegF700>();
        if (vo.getRegistrosF700() != null) {
            for (Object o : vo.getRegistrosF700()) {
                DeducoesDiversasSpedPisCofins d = (DeducoesDiversasSpedPisCofins)o;
                RegF700 r = new RegF700();
                if (d.getPessoa() != null) {
                    r.setCnpj(d.getPessoa().getComplemento().getCnpj());
                }
                r.setIndNatDeducao(d.getNatDeducao().getCodigo());
                r.setIndOrigDeducao(d.getDedDiversas().getCodigo());
                r.setInformacoes(d.getInfCompl());
                r.setValorBcOperacao(d.getVrBcOper());
                r.setValorDeducaoCofins(d.getVrDedCofins());
                r.setValorDeducaoPis(d.getVrDedPis());
                dados.add(r);
            }
        }
        return dados;
    }

    private Reg500 getPlanoContaLancamentoSpedPisCofins(PlanoConta pc) {
        if (pc != null) {
            Reg500 r = new Reg500();
            r.setIdPlanoContas(pc.getIdentificador());
            r.setCodigo(pc.getCodigo());
            r.setDescricao(pc.getDescricao());
            r.setDataInclusao(pc.getDataCadastro());
            r.setMarca(pc.getMarca());
            r.setCodNaturezaContaSped(pc.getNaturezaOperacaoPC().getCodigo());
            return r;
        }
        return null;
    }

    BlocoF getRegistrosBlocoF600(SpedPisCofins vo) {
        BlocoF b = new BlocoF();
        b.setRegistrosF600(this.getRegBlocoF600(vo));
        return b;
    }

    private List<RegF600> getRegBlocoF600(SpedPisCofins vo) {
        ArrayList<RegF600> dados = new ArrayList<RegF600>();
        return dados;
    }

    List getEmpresas() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from Empresa ");
        return q.list();
    }

    private RegA010 getReg010(Empresa empresa) {
        RegA010 r = new RegA010();
        r.setCnpj(empresa.getPessoa().getComplemento().getCnpj());
        return r;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }
}

