/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsStructureException;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsWritterException;
import mentorcore.service.impl.spedpiscofins.versao.SpedFormat;
import mentorcore.service.impl.spedpiscofins.versao.SpedPisCofinsBDConsult;
import mentorcore.service.impl.spedpiscofins.versao.model.ContadorRegistros;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg205;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg450;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao.model.Reg600;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA110;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA111;
import mentorcore.service.impl.spedpiscofins.versao.model.blocoa.RegA170;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC010;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC111;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC170;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC380;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC381;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC385;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC395;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC396;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC400;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC405;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC481;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC485;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC500;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC501;
import mentorcore.service.impl.spedpiscofins.versao.model.blococ.RegC505;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD100;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD101;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD105;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD111;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD200;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD201;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD205;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD500;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD501;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD505;
import mentorcore.service.impl.spedpiscofins.versao.model.blocod.RegD509;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF100;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF111;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF120;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF129;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF130;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF139;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF150;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF600;
import mentorcore.service.impl.spedpiscofins.versao.model.blocof.RegF700;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.planoconta.UtilityPlanoConta;

public class SpedPisCofinsWritter {
    private SpedFormat form = new SpedFormat();
    private SpedPisCofinsBDConsult cons = new SpedPisCofinsBDConsult();
    private String versao = "002";
    private String endOfRegister = "\r\n";
    private char separator = (char)124;
    private final TLogger logger = TLogger.get(this.getClass());
    private ContadorRegistros cont = new ContadorRegistros();
    private String VERSAO_003 = "003";
    private String VERSAO_002 = "002";
    private char PERFIL_A = (char)65;
    private char PERFIL_B = (char)66;
    private HashMap hashEmpresasProdutos = new HashMap();
    private HashMap hashEmpresasNaturezas = new HashMap();
    private HashMap hashEmpresasUnidades = new HashMap();
    private HashMap hashEmpresasParicipantes = new HashMap();
    private HashMap hashEmpresasObservacoes = new HashMap();
    private HashSet hashEmpresasPlanos = new HashSet();
    private HashSet hashEmpresasCentroCustos = new HashSet();

    public void spedPisCofinsWritter(SpedPisCofins vo, File file) throws SpedPisCofinsWritterException, ExceptionDatabase, ExceptionService, SpedPisCofinsStructureException {
        Date dataIn = vo.getDataInicial();
        Date dataFim = vo.getDataFinal();
        try {
            Empresa emp = vo.getEmpresa();
            String perfil = emp.getEmpresaDados().getPerfilSpedFiscal().getCodigo();
            if (emp.getEmpresaDados().getIndicadorAtividade() == null) {
                throw new SpedPisCofinsWritterException("Primeiro, informe o Indicador de Atividade no cadastro de Empresa.");
            }
            List empresas = vo.getGrupoEmpresa().getEmpresas();
            for (Object o : empresas) {
                Empresa e = (Empresa)o;
                this.hashEmpresasProdutos.put(e, new HashSet());
                this.hashEmpresasNaturezas.put(e, new HashSet());
                this.hashEmpresasUnidades.put(e, new HashSet());
                this.hashEmpresasParicipantes.put(e, new HashSet());
                this.hashEmpresasObservacoes.put(e, new HashSet());
            }
            File blocoA = this.createWritterBlockA(dataIn, dataFim, empresas);
            File blocoC = this.createWritterBlockC(dataIn, dataFim, empresas);
            File blocoD = this.createWritterBlockD(dataIn, dataFim, empresas, perfil.charAt(0));
            File blocoF = this.createWritterBlockF(dataIn, dataFim, empresas, vo);
            File blocoM = this.createWritterBlockM(dataIn, dataFim, emp);
            File bloco0 = this.createWritterBlock0(dataIn, dataFim, emp, vo, empresas);
            File bloco1 = this.createWritterBlock1(dataIn, dataFim, emp);
            File bloco9 = this.createWritterBlock9();
            this.apendToSomeFile(file, dataIn, dataFim, bloco0, blocoA, blocoC, blocoD, blocoF, blocoM, bloco1, bloco9);
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new SpedPisCofinsWritterException("Diret\u00f3rio n\u00e3o encontrado");
        }
    }

    private File createWritterBlock0(Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo, List empresas) throws IOException, ExceptionDatabase, SpedPisCofinsWritterException {
        File f = File.createTempFile("sped_bloco_0", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterReg0000(p, dataIn, dataFim, emp, vo);
        this.writterReg0001(p);
        this.writterReg0100(p, emp);
        this.writterReg0110(p, vo);
        this.writterReg0111(p, vo);
        this.writterReg0140(p, empresas, dataIn, dataFim);
        this.writterReg0500(p);
        this.writterReg0600(p);
        this.writterReg0990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg0000(PrintWriter p, Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo) {
        p.append(this.separator + "0000");
        p.append(this.separator + this.versao);
        p.append(this.separator + String.valueOf(vo.getTipoEscrituracao()));
        if (vo.getIndicadorSituacaoEspecial() != null) {
            p.append(this.separator + String.valueOf(vo.getIndicadorSituacaoEspecial().getCodigo()));
        } else {
            p.append(this.separator);
        }
        if (vo.getReciboAnterior() != null) {
            p.append(this.separator + this.form.formatStringClear(vo.getReciboAnterior(), 41));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatDate(dataIn));
        p.append(this.separator + this.form.formatDate(dataFim));
        p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 100));
        String cnpjCpf = emp.getPessoa().getComplemento().getCnpj();
        cnpjCpf = this.form.clearString(cnpjCpf);
        p.append(this.separator + cnpjCpf);
        p.append(this.separator + emp.getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(this.separator + emp.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + emp.getPessoa().getEndereco().getCidade().getCodIbge());
        p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getSuframa(), 9));
        p.append(this.separator + String.valueOf(vo.getIndicadorNaturezaPessoaJuridica().getCodigo()));
        p.append(this.separator + String.valueOf(emp.getEmpresaDados().getIndicadorAtividade().getCodigo()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0000");
    }

    private void writterReg0001(PrintWriter p) {
        p.append(this.separator + "0001");
        p.append(this.separator + String.valueOf(0));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0001");
    }

    private void writterReg0100(PrintWriter p, Empresa emp) throws SpedPisCofinsWritterException {
        EmpresaContabilidade contabilidade = this.cons.getEmpresaContabilidade(emp);
        Pessoa contador = contabilidade.getPessoa();
        if (contador == null) {
            throw new SpedPisCofinsWritterException("Informe o Contador respons\u00e1vel pela empresa.");
        }
        p.append(this.separator + "0100");
        p.append(this.separator + this.form.formatString(contador.getNome(), 100));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getCnpj(), 11));
        p.append(this.separator + this.form.formatStringClear(contabilidade.getCrc(), 15));
        p.append(this.separator);
        p.append(this.separator + this.form.formatStringClear(contador.getEndereco().getCep(), 8));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getLogradouro(), 60));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getNumero(), 10));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getComplemento(), 60));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getBairro(), 60));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getFone1(), 10));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getFax1(), 10));
        p.append(this.separator + this.form.formatString(this.getEmailAtivo(contador.getComplemento().getEmails())));
        p.append(this.separator + this.form.formatStringClear(contador.getEndereco().getCidade().getUf().getCodIbge() + contador.getEndereco().getCidade().getCodIbge(), 7));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0100");
    }

    private void writterReg0110(PrintWriter p, SpedPisCofins vo) {
        p.append(this.separator + "0110");
        p.append(this.separator + vo.getIndicadorIncidenciaTributaria().getCodigo());
        if (vo.getIndicadorMetodoAprCredito() != null) {
            p.append(this.separator + vo.getIndicadorMetodoAprCredito().getCodigo());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + vo.getIndicadorTipoContribApurada().getCodigo());
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0110");
    }

    private void writterReg0111(PrintWriter p, SpedPisCofins vo) {
        if (vo.getIndicadorMetodoAprCredito().getCodigo().equals("2")) {
            p.append(this.separator + "0111");
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruNcumTribMi()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruNcumNtMi()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruNcumExp()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruCum()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruTotal()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0111");
        }
    }

    private void writterReg0140(PrintWriter p, List empresas, Date dataIn, Date dataFim) throws ExceptionDatabase {
        for (Object o : empresas) {
            Empresa emp = (Empresa)o;
            p.append(this.separator + "0140");
            p.append(this.separator + emp.getIdentificador().toString());
            p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 100));
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getCnpj(), 14));
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getEndereco().getCidade().getUf().getSigla(), 2));
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getInscEst(), 14));
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + emp.getPessoa().getEndereco().getCidade().getCodIbge(), 14));
            if (emp.getPessoa().getComplemento().getInscricaoMunicipal() != null) {
                p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getInscricaoMunicipal()));
            } else {
                p.append(this.separator);
            }
            if (emp.getPessoa().getComplemento().getSuframa() != null) {
                p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getSuframa(), 9));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0140");
            this.writterReg0150(p, emp);
            this.writterReg0190(p, emp);
            this.writterReg0200(p, emp, dataIn, dataFim);
            this.writterReg0400(p, emp);
            this.writterReg0450(p, emp);
        }
    }

    private String getEmailAtivo(List<EmailPessoa> emails) {
        String firstEmail = "";
        String activeEmail = "";
        boolean count = false;
        for (EmailPessoa e : emails) {
            if (!count) {
                firstEmail = e.getEmail();
            }
            if (e.getAtivo() == null || e.getAtivo() != 1) continue;
            activeEmail = e.getEmail();
            break;
        }
        if (activeEmail == null) {
            return firstEmail;
        }
        return activeEmail;
    }

    private void writterReg0150(PrintWriter p, Empresa emp) {
        HashSet h = (HashSet)this.hashEmpresasParicipantes.get(emp);
        for (Object o : h) {
            Reg150 r = (Reg150)o;
            p.append(this.separator + "0150");
            p.append(this.separator + this.form.formatString(r.getIdPessoa().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getNomePessoa(), 100));
            p.append(this.separator + this.form.formatStringClear(r.getCodPais(), 5));
            String cnpjCpf = r.getCnpj();
            cnpjCpf = this.form.clearString(cnpjCpf);
            if (cnpjCpf.trim().length() > 11) {
                p.append(this.separator + cnpjCpf);
                p.append(this.separator);
            } else {
                p.append(this.separator);
                p.append(this.separator + cnpjCpf);
            }
            if (r.getInscricaoEstadual() != null && r.getInscricaoEstadual().trim().length() > 0 && !r.getInscricaoEstadual().trim().equalsIgnoreCase("isento")) {
                p.append(this.separator + this.form.formatStringClear(r.getInscricaoEstadual(), 14));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatStringClear(r.getCodUf() + r.getCodigoMunicipio(), 7));
            if (r.getSuframa() != null && this.form.formatStringClear(r.getSuframa()).trim().length() == 9) {
                p.append(this.separator + this.form.formatStringClear(r.getSuframa(), 9));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatString(r.getEndereco(), 60));
            p.append(this.separator + this.form.formatString(r.getNumero(), 10));
            p.append(this.separator + this.form.formatString(r.getComplemento(), 60));
            p.append(this.separator + this.form.formatString(r.getBairro(), 60));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0150");
        }
    }

    private void writterReg0190(PrintWriter p, Empresa emp) {
        HashSet h = (HashSet)this.hashEmpresasUnidades.get(emp);
        for (Object o : h) {
            Reg190 r = (Reg190)o;
            p.append(this.separator + "0190");
            p.append(this.separator + this.form.formatStringClear(r.getCodUnidMedida(), 6));
            p.append(this.separator + this.form.formatString(r.getDescUnidMedida()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0190");
        }
    }

    private void writterReg0200(PrintWriter p, Empresa emp, Date dataIn, Date dataFim) throws ExceptionDatabase {
        HashSet h = (HashSet)this.hashEmpresasProdutos.get(emp);
        for (Object o : h) {
            Reg200 pr = (Reg200)o;
            p.append(this.separator + "0200");
            p.append(this.separator + pr.getIdProduto().toString());
            p.append(this.separator + this.form.formatString(pr.getDescricao()));
            p.append("" + this.separator);
            p.append("" + this.separator);
            p.append(this.separator + this.form.formatString(pr.getUnidadeMedida(), 6));
            if (pr.getTipoItem() != null) {
                p.append(this.separator + pr.getTipoItem());
            } else {
                p.append(this.separator);
            }
            if (pr.getCodNcm() != null) {
                p.append(this.separator + pr.getCodNcm());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            if (pr.getCodGenero() != null && !pr.getCodGenero().equalsIgnoreCase("0")) {
                p.append(this.separator + pr.getCodGenero());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(pr.getAliquotaIcms(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0200");
            this.writterReg0205(p, pr.getIdProduto(), dataIn, dataFim);
        }
    }

    private void writterReg0205(PrintWriter p, Long idProduto, Date dataIn, Date dataFim) throws ExceptionDatabase {
        List log = this.cons.getAlteracoesProduto(idProduto, dataIn, dataFim);
        for (Object o : log) {
            Reg205 l = (Reg205)o;
            if (l.getDataFinal() == null) {
                l.setDataFinal(dataFim);
            }
            p.append(this.separator + "0205");
            p.append(this.separator + this.form.formatString(l.getDescricaoAnterior()));
            p.append(this.separator + this.form.formatDate(l.getDataInicial()));
            p.append(this.separator + this.form.formatDate(l.getDataFinal()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0205");
        }
    }

    private void writterReg0400(PrintWriter p, Empresa emp) {
        HashSet h = (HashSet)this.hashEmpresasNaturezas.get(emp);
        for (Object o : h) {
            Reg400 r = (Reg400)o;
            p.append(this.separator + "0400");
            p.append(this.separator + this.form.formatStringClear(r.getIdNatOperacao().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getDescricaoNatOperacao()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0400");
        }
    }

    private void writterReg0450(PrintWriter p, Empresa emp) {
        HashSet h = (HashSet)this.hashEmpresasObservacoes.get(emp);
        for (Object o : h) {
            Reg450 r = (Reg450)o;
            p.append(this.separator + "0450");
            p.append(this.separator + this.form.formatStringClear(r.getIdObservacao().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getDescricao()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0450");
        }
    }

    private void writterReg0500(PrintWriter p) {
        for (Object o : this.hashEmpresasPlanos) {
            Reg500 pc = (Reg500)o;
            p.append(this.separator + "0500");
            p.append(this.separator + this.form.formatDate(pc.getDataInclusao()));
            if (pc.getCodNaturezaContaSped() != null) {
                p.append(this.separator + pc.getCodNaturezaContaSped());
            } else {
                p.append(this.separator);
            }
            if (pc.getMarca().intValue() == EnumConstSinteticoAnalitico.SINTETICO.getValueInt()) {
                p.append(this.separator + "S");
            } else {
                p.append(this.separator + "A");
            }
            p.append(this.separator + UtilityPlanoConta.getNivelPlanoConta(pc.getCodigo()).toString());
            p.append(this.separator + this.form.formatStringClear(pc.getCodigo()));
            p.append(this.separator + this.form.formatString(pc.getDescricao(), 60));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0500");
        }
    }

    private void writterReg0600(PrintWriter p) {
        for (Object o : this.hashEmpresasCentroCustos) {
            Reg600 pc = (Reg600)o;
            p.append(this.separator + "0600");
            p.append(this.separator + this.form.formatDate(pc.getDataInclusao()));
            p.append(this.separator + this.form.formatStringClear(pc.getCodigo()));
            p.append(this.separator + this.form.formatString(pc.getDescricao(), 60));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0600");
        }
    }

    private void writterReg0990(PrintWriter p) {
        this.cont.soma1("0990");
        p.append(this.separator + "0990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('0')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlockA(Date dataIn, Date dataFim, List empresas) throws IOException {
        File f = File.createTempFile("sped_bloco_a", ".txt");
        PrintWriter p = new PrintWriter(f);
        boolean flag = false;
        int contador = 1;
        int nrEmpresas = empresas.size();
        for (Object o : empresas) {
            boolean comDados;
            Empresa emp = (Empresa)o;
            BlocoA notasServicoTercA100 = this.cons.getBlocoA100NotasTerceiros(dataIn, dataFim, emp);
            BlocoA notasServicoPropA100 = this.cons.getBlocoA100NotasProprias(dataIn, dataFim, emp);
            boolean bl = comDados = notasServicoTercA100 != null && notasServicoTercA100.getRegistrosA100() != null && !notasServicoTercA100.getRegistrosA100().isEmpty() || notasServicoPropA100 != null && notasServicoPropA100.getRegistrosA100() != null && !notasServicoPropA100.getRegistrosA100().isEmpty();
            if (!flag) {
                flag = this.writerA001(p, comDados, flag, contador, nrEmpresas);
            }
            if (comDados) {
                this.writterA010(p, emp.getPessoa().getComplemento().getCnpj());
                this.gerarBlocoA100(p, notasServicoTercA100, notasServicoPropA100, emp);
            }
            ++contador;
        }
        this.writterA990(p);
        p.flush();
        p.close();
        return f;
    }

    private boolean writerA001(PrintWriter p, boolean dadosInformados, boolean flag, int contador, int nrEmpresas) {
        if (dadosInformados || !dadosInformados && contador == nrEmpresas) {
            int dadosInf = dadosInformados ? 0 : 1;
            p.append(this.separator + "A001");
            p.append(this.separator + String.valueOf(dadosInf));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("A001");
            flag = true;
        }
        return flag;
    }

    private void writterA990(PrintWriter p) {
        this.cont.soma1("A990");
        p.append(this.separator + "A990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('A')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlockC(Date dataIn, Date dataFim, List empresas) throws IOException {
        File f = File.createTempFile("sped_bloco_c", ".txt");
        PrintWriter p = new PrintWriter(f);
        int contador = 1;
        int nrEmpresas = empresas.size();
        boolean flag = false;
        for (Object o : empresas) {
            boolean comDados;
            Empresa emp = (Empresa)o;
            BlocoC notasPropriasC100 = this.cons.getBlocoC100NotasProprias(dataIn, dataFim, emp);
            BlocoC notasTerceirosC100 = this.cons.getBlocoC100NotasTerceiros(dataIn, dataFim, emp);
            BlocoC notasPropriasC380 = this.cons.getBlocoC380NotasProprias(dataIn, dataFim, emp);
            BlocoC notasTerceirosC395 = this.cons.getBlocoC395NotasTerceiros(dataIn, dataFim, emp);
            BlocoC cuponsFiscaisC400 = this.cons.getBlocoC400CuponsFiscais(dataIn, dataFim, emp);
            BlocoC notasTerceirosC500 = this.cons.getBlocoC500NotasTerceiros(dataIn, dataFim, emp);
            boolean bl = comDados = notasPropriasC100 != null && notasPropriasC100.getRegistrosC100() != null && !notasPropriasC100.getRegistrosC100().isEmpty() || notasTerceirosC100 != null && notasTerceirosC100.getRegistrosC010() != null && !notasTerceirosC100.getRegistrosC010().isEmpty() || notasPropriasC380 != null && notasPropriasC380.getRegistrosC380() != null && !notasPropriasC380.getRegistrosC380().isEmpty() || notasTerceirosC395 != null && notasTerceirosC395.getRegistrosC395() != null && !notasTerceirosC395.getRegistrosC395().isEmpty() || cuponsFiscaisC400 != null && cuponsFiscaisC400.getRegistrosC400() != null && !cuponsFiscaisC400.getRegistrosC400().isEmpty() || notasTerceirosC500 != null && notasTerceirosC500.getRegistrosC500() != null && !notasTerceirosC500.getRegistrosC500().isEmpty();
            if (!flag) {
                flag = this.writerC001(p, comDados, flag, contador, nrEmpresas);
            }
            if (comDados) {
                this.writterC010(p, emp.getPessoa().getComplemento().getCnpj());
                this.gerarBlocoC100(p, notasPropriasC100, notasTerceirosC100, emp);
                this.gerarBlocoC380(p, notasPropriasC380, emp);
                this.gerarBlocoC395(p, notasTerceirosC395, emp);
                this.gerarBlocoC400(p, cuponsFiscaisC400, emp);
                this.gerarBlocoC500(p, notasTerceirosC500, emp);
            }
            ++contador;
        }
        this.writterC990(p);
        p.flush();
        p.close();
        return f;
    }

    private boolean writerC001(PrintWriter p, boolean dadosInformados, boolean flag, int contador, int nrEmpresas) {
        if (dadosInformados || !dadosInformados && contador == nrEmpresas) {
            int dadosInf = dadosInformados ? 0 : 1;
            p.append(this.separator + "C001");
            p.append(this.separator + String.valueOf(dadosInf));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C001");
            flag = true;
        }
        return flag;
    }

    private void writterC010(PrintWriter p, String cnpj) {
        p.append(this.separator + "C010");
        p.append(this.separator + this.form.clearString(cnpj));
        p.append(this.separator + "2");
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C010");
    }

    private void writterC990(PrintWriter p) {
        this.cont.soma1("C990");
        p.append(this.separator + "C990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('C')));
        p.append(this.separator + this.endOfRegister);
    }

    private void gerarBlocoC100(PrintWriter p, BlocoC notasProprias, BlocoC notasTerceiros, Empresa emp) {
        if (notasProprias != null) {
            for (Object object : notasProprias.getRegistrosC100()) {
                RegC100 r = (RegC100)object;
                String sitDoc = r.getCodSituacaoDoc();
                boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
                this.writterC100NotasProprias(p, r, docCancInut);
                if (docCancInut) continue;
                this.writterC110(p, r.getObservacoes(), emp);
                this.writterC111(p, r.getProcessosReferenciados());
                this.writterC170(p, r.getItensDocumento(), emp);
            }
            this.putParticpantes(notasProprias.getParticipantes(), emp);
            this.putProdutos(notasProprias.getProdutos(), emp);
            this.putNatOperacao(notasProprias.getNatOperacao(), emp);
            this.putUnidMedida(notasProprias.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
        if (notasTerceiros != null) {
            for (Object object : notasTerceiros.getRegistrosC010()) {
                RegC010 rc = (RegC010)object;
                for (RegC100 ob : rc.getRegistrosC100()) {
                    RegC100 r = ob;
                    String sitDoc = r.getCodSituacaoDoc();
                    boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
                    this.writterC100NotasTerceiros(p, r, docCancInut);
                    if (docCancInut) continue;
                    this.writterC110(p, r.getObservacoes(), emp);
                    this.writterC111(p, r.getProcessosReferenciados());
                    this.writterC170(p, r.getItensDocumento(), emp);
                }
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
            this.putProdutos(notasTerceiros.getProdutos(), emp);
            this.putNatOperacao(notasTerceiros.getNatOperacao(), emp);
            this.putUnidMedida(notasTerceiros.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoC380(PrintWriter p, BlocoC notasProprias, Empresa emp) {
        if (notasProprias != null) {
            Iterator<RegC380> iterator = notasProprias.getRegistrosC380().iterator();
            while (iterator.hasNext()) {
                RegC380 o;
                RegC380 r = o = iterator.next();
                this.writterC380NotasPropriasTerceiros(p, r);
            }
            this.putProdutos(notasProprias.getProdutos(), emp);
            this.putUnidMedida(notasProprias.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
    }

    private void putProdutos(List reg, Empresa emp) {
        HashSet produtos = (HashSet)this.hashEmpresasProdutos.get(emp);
        produtos.addAll(reg);
    }

    private void putParticpantes(List reg, Empresa emp) {
        HashSet participantes = (HashSet)this.hashEmpresasParicipantes.get(emp);
        participantes.addAll(reg);
    }

    private void putNatOperacao(List reg, Empresa emp) {
        HashSet naturOperacao = (HashSet)this.hashEmpresasNaturezas.get(emp);
        naturOperacao.addAll(reg);
    }

    private void putUnidMedida(List reg, Empresa emp) {
        HashSet unid = (HashSet)this.hashEmpresasUnidades.get(emp);
        unid.addAll(reg);
    }

    private void putObservacoes(List reg, Empresa emp) {
        HashSet obs = (HashSet)this.hashEmpresasObservacoes.get(emp);
        obs.addAll(reg);
    }

    private void putPlanoContas(List reg) {
        this.hashEmpresasPlanos.addAll(reg);
    }

    private void putPlanoContas(Reg500 reg500) {
        this.hashEmpresasPlanos.add(reg500);
    }

    private void putCentroCustos(List reg) {
        this.hashEmpresasCentroCustos.addAll(reg);
    }

    private void gerarBlocoC395(PrintWriter p, BlocoC notasTerceiros, Empresa emp) {
        if (notasTerceiros != null) {
            Iterator<RegC395> iterator = notasTerceiros.getRegistrosC395().iterator();
            while (iterator.hasNext()) {
                RegC395 o;
                RegC395 r = o = iterator.next();
                this.writterC395NotasPropriasTerceiros(p, r);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
            this.putProdutos(notasTerceiros.getProdutos(), emp);
            this.putUnidMedida(notasTerceiros.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoC400(PrintWriter p, BlocoC cuponsFiscais, Empresa emp) {
        if (cuponsFiscais != null) {
            Iterator<RegC400> iterator = cuponsFiscais.getRegistrosC400().iterator();
            while (iterator.hasNext()) {
                RegC400 o;
                RegC400 r = o = iterator.next();
                this.writterRegC400ImpressorasFiscais(p, r);
                this.writterRegC405ReducoesZ(p, r.getReducoes());
            }
            this.putProdutos(cuponsFiscais.getProdutos(), emp);
            this.putUnidMedida(cuponsFiscais.getUnidadeMedidas(), emp);
            this.putPlanoContas(cuponsFiscais.getPlanoContas());
        }
    }

    private void writterC100NotasTerceiros(PrintWriter p, RegC100 r, boolean docCancInut) {
        p.append(this.separator + "C100");
        p.append(this.separator + String.valueOf(r.getEntSaiNatOP()));
        p.append(this.separator + String.valueOf(r.getIndTipoEmitente()));
        if (!docCancInut) {
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatStringClear(r.getCodModDocFiscal(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getCodSituacaoDoc(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getSerie(), 3));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumeroDoc())));
        if (r.getChaveNFe() != null && r.getChaveNFe().trim().length() == 44) {
            p.append(this.separator + this.form.formatStringClear(r.getChaveNFe()));
        } else {
            p.append(this.separator);
        }
        if (!docCancInut) {
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndTipoPagamento()));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto()));
            p.append(this.separator + this.form.formatNumber(0.0));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndicadorTipoFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorSeguro()));
            p.append(this.separator + this.form.formatNumber(r.getValorDespAcessorias()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms()));
            p.append(this.separator + this.form.formatNumber(r.getValorICMS()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIpi()));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorPisSt()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofinsSt()));
        } else {
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C100");
    }

    private void writterC100NotasProprias(PrintWriter p, RegC100 r, boolean docCancInut) {
        p.append(this.separator + "C100");
        p.append(this.separator + String.valueOf(r.getEntSaiNatOP()));
        p.append(this.separator + String.valueOf(r.getIndTipoEmitente()));
        if (!docCancInut) {
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatStringClear(r.getCodModDocFiscal(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getCodSituacaoDoc(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getSerie(), 3));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumeroDoc())));
        if (this.versao.equalsIgnoreCase(this.VERSAO_002) && (r.getCodSituacaoDoc().equalsIgnoreCase("02") || r.getCodSituacaoDoc().equalsIgnoreCase("03"))) {
            p.append(this.separator + this.form.formatStringClear(r.getChaveNFe(), 44));
        } else {
            p.append(this.separator + this.form.formatStringClear(r.getChaveNFe(), 44));
        }
        if (!docCancInut) {
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndTipoPagamento()));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto()));
            p.append(this.separator + this.form.formatNumber(0.0));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndicadorTipoFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorSeguro()));
            p.append(this.separator + this.form.formatNumber(r.getValorDespAcessorias()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms()));
            p.append(this.separator + this.form.formatNumber(r.getValorICMS()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIpi()));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorPisSt()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofinsSt()));
        } else {
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C100");
    }

    private void writterC111(PrintWriter p, List<RegC111> processosReferenciados) {
        if (processosReferenciados != null && !processosReferenciados.isEmpty()) {
            Iterator<RegC111> iterator = processosReferenciados.iterator();
            while (iterator.hasNext()) {
                RegC111 o;
                RegC111 r = o = iterator.next();
                p.append(this.separator + "C111");
                p.append(this.separator + this.form.formatString(r.getNumeroProcesso(), 20));
                p.append(this.separator + String.valueOf(r.getCodOrigem()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C111");
            }
        }
    }

    private void writterC170(PrintWriter p, List<RegC170> itensDocumento, Empresa empresa) {
        if (itensDocumento != null && !itensDocumento.isEmpty()) {
            Iterator<RegC170> iterator = itensDocumento.iterator();
            while (iterator.hasNext()) {
                RegC170 o;
                RegC170 in = o = iterator.next();
                p.append(this.separator + "C170");
                if (in.getNumeroItem() != null) {
                    p.append(this.separator + this.form.formatNumberInt((int)in.getNumeroItem()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.form.formatString(in.getCodigoItem().toString(), 60));
                p.append(this.separator + this.form.formatString(in.getDescricaoComp()));
                p.append(this.separator + this.form.formatNumber(in.getQuantidade(), 5));
                p.append(this.separator + this.form.formatString(in.getUnidadeMedida(), 6));
                p.append(this.separator + this.form.formatNumber(in.getValorItem(), 2));
                p.append(this.separator + this.form.formatNumber(in.getValorDesconto(), 2));
                p.append(this.separator + String.valueOf(in.getMovimentacaoFisica()));
                p.append(this.separator + in.getCstIcms());
                p.append(this.separator + this.form.formatStringClear(in.getCfop()));
                p.append(this.separator + this.form.formatStringClear(in.getCodNatOperacao().toString()));
                p.append(this.separator + this.form.formatNumber(in.getValorBCIcms(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqIcms(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrIcms(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrBCIcmsST(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliquotaST(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrIcmsSt(), 2));
                if (empresa.getEmpresaDados().getIndicadorApuracaoIpi() != null && empresa.getEmpresaDados().getIndicadorApuracaoIpi() >= 0 && empresa.getEmpresaDados().getIndicadorApuracaoIpi() <= 1) {
                    p.append(this.separator + String.valueOf(empresa.getEmpresaDados().getIndicadorApuracaoIpi()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + in.getCstIpi());
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(in.getVlrBCIpi(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqIpi(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrIpi(), 2));
                p.append(this.separator + in.getCstPis());
                p.append(this.separator + this.form.formatNumber(in.getVlrBCPis(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqPis(), 2));
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(in.getVlrPis(), 2));
                p.append(this.separator + in.getCstCofins());
                p.append(this.separator + this.form.formatNumber(in.getBcCofins(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqCofins(), 2));
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(in.getVlrCofins(), 2));
                if (in.getEntSaiNatOperacao() == 1) {
                    if (in.getPlanoCred() != null) {
                        p.append(this.separator + this.form.formatStringClear(in.getPlanoCred()));
                    } else {
                        p.append(this.separator);
                    }
                } else if (in.getPlanoDeb() != null) {
                    p.append(this.separator + this.form.formatStringClear(in.getPlanoDeb()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C170");
            }
        }
    }

    private void writterC380NotasPropriasTerceiros(PrintWriter p, RegC380 r) {
        p.append(this.separator + "C380");
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + this.form.formatDate(r.getDataInicial()));
        p.append(this.separator + this.form.formatDate(r.getDataFinal()));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumDocInicial())));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumDocFinal())));
        p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
        p.append(this.separator + this.form.formatNumber(r.getValorCancelado()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C380");
        this.writterC381Pis(p, r.getPis());
        this.writterC385Cofins(p, r.getCofins());
    }

    private void writterC381Pis(PrintWriter p, List<RegC381> pis) {
        Iterator<RegC381> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegC381 o;
            RegC381 r = o = iterator.next();
            p.append(this.separator + "C381");
            p.append(this.separator + r.getCstPis());
            p.append(this.separator + this.form.formatString(r.getCodItem().toString(), 60));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            p.append(this.separator + this.form.formatNumber(r.getValoBCPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            if (r.getCodContaAnalitica() != null) {
                p.append(this.separator + this.form.formatString(r.getCodContaAnalitica(), 60));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C381");
        }
    }

    private void writterC385Cofins(PrintWriter p, List<RegC385> pis) {
        Iterator<RegC385> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegC385 o;
            RegC385 r = o = iterator.next();
            p.append(this.separator + "C385");
            p.append(this.separator + r.getCstCofins());
            p.append(this.separator + this.form.formatString(r.getCodItem().toString(), 60));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            p.append(this.separator + this.form.formatNumber(r.getValoBCCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            if (r.getCodContaAnalitica() != null) {
                p.append(this.separator + this.form.formatString(r.getCodContaAnalitica(), 60));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C385");
        }
    }

    private void writterC395NotasPropriasTerceiros(PrintWriter p, RegC395 r) {
        p.append(this.separator + "C395");
        p.append(this.separator + this.form.formatStringClear(r.getCodModDocFiscal()));
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + this.form.formatStringClear(r.getSerie(), 3));
        p.append(this.separator);
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumeroNota())));
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatNumber((double)r.getValorTotal()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C395");
        this.writterC396ItensNota(p, r.getItensNota());
    }

    private void writterC396ItensNota(PrintWriter p, List<RegC396> itensNota) {
        Iterator<RegC396> iterator = itensNota.iterator();
        while (iterator.hasNext()) {
            RegC396 o;
            RegC396 r = o = iterator.next();
            p.append(this.separator + "C396");
            p.append(this.separator + this.form.formatNumberLong(r.getCodigoItem()));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto()));
            p.append(this.separator + this.form.formatString(r.getCodBCCred()));
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            if (r.getEntSaiNatOperacao() == 1) {
                if (r.getPlanoCred() != null) {
                    p.append(this.separator + this.form.formatStringClear(r.getPlanoCred()));
                } else {
                    p.append(this.separator);
                }
            } else if (r.getPlanoDeb() != null) {
                p.append(this.separator + this.form.formatStringClear(r.getPlanoDeb()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C396");
        }
    }

    private void writterRegC400ImpressorasFiscais(PrintWriter p, RegC400 r) {
        p.append(this.separator + "C400");
        p.append(this.separator + this.form.formatStringClear(r.getModeloDocFiscal()));
        p.append(this.separator + this.form.formatStringClear(r.getModeloECF(), 20));
        p.append(this.separator + this.form.formatStringClear(r.getSerieECF(), 20));
        p.append(this.separator + this.form.formatStringClear(r.getIdImpressora().toString(), 3));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C400");
    }

    private void writterRegC405ReducoesZ(PrintWriter p, List<RegC405> reducoes) {
        Iterator<RegC405> iterator = reducoes.iterator();
        while (iterator.hasNext()) {
            RegC405 o;
            RegC405 r = o = iterator.next();
            p.append(this.separator + "C405");
            p.append(this.separator + this.form.formatDate(r.getDataMovimento()));
            p.append(this.separator + this.form.formatNumberLong(r.getContadorReinicio()));
            p.append(this.separator + this.form.formatNumberLong(r.getContadorCRZ()));
            p.append(this.separator + this.form.formatNumberLong(r.getUltimoCOO()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotalGeral()));
            p.append(this.separator + this.form.formatNumber(r.getValorVendaBruta()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C405");
            this.writterRegC481PisCupons(p, r.getPis());
            this.writterRegC485CofinsCupons(p, r.getCofins());
        }
    }

    private void writterRegC481PisCupons(PrintWriter p, List<RegC481> pis) {
        Iterator<RegC481> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegC481 o;
            RegC481 r = o = iterator.next();
            p.append(this.separator + "C481");
            p.append(this.separator + this.form.formatStringClear(r.getCstPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            p.append(this.separator + this.form.formatNumber(r.getValoBCPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatNumberLong(r.getCodItem()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C481");
        }
    }

    private void writterRegC485CofinsCupons(PrintWriter p, List<RegC485> cofins) {
        Iterator<RegC485> iterator = cofins.iterator();
        while (iterator.hasNext()) {
            RegC485 o;
            RegC485 r = o = iterator.next();
            p.append(this.separator + "C485");
            p.append(this.separator + this.form.formatStringClear(r.getCstCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            p.append(this.separator + this.form.formatNumber(r.getValoBCCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator + this.form.formatNumberLong(r.getCodItem()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C485");
        }
    }

    private void gerarBlocoC500(PrintWriter p, BlocoC notasTerceiros, Empresa emp) {
        if (notasTerceiros != null) {
            Iterator<RegC500> iterator = notasTerceiros.getRegistrosC500().iterator();
            while (iterator.hasNext()) {
                RegC500 o;
                RegC500 regC500 = o = iterator.next();
                this.writterRegC500NotasTerceiros(p, regC500, emp);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        }
    }

    private void writterRegC500NotasTerceiros(PrintWriter p, RegC500 r, Empresa emp) {
        p.append(this.separator + "C500");
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + r.getCodSituacaoDoc());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumberInt(r.getNumeroDoc()));
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
        p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
        if (r.getObsFaturamento() != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            p.append(this.separator + this.form.formatNumberLong(r.getObsFaturamento().getIdentificador()));
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(r.getObsFaturamento().getIdentificador());
            reg450.setDescricao(r.getObsFaturamento().getNome());
            dados.add(reg450);
            this.putObservacoes(dados, emp);
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C500");
        this.writterC501PisNotaTerceiros(p, r.getPis());
        this.writterC505CofinsNotaTerceiros(p, r.getCofins());
    }

    private void writterC501PisNotaTerceiros(PrintWriter p, List<RegC501> pis) {
        Iterator<RegC501> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegC501 o;
            RegC501 r = o = iterator.next();
            p.append(this.separator + "C501");
            p.append(this.separator + this.form.formatStringClear(r.getCstPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            if (r.getNatBCCredito() != null) {
                p.append(this.separator + this.form.formatStringClear(r.getNatBCCredito()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getValoBCPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C501");
        }
    }

    private void writterC505CofinsNotaTerceiros(PrintWriter p, List<RegC505> cofins) {
        Iterator<RegC505> iterator = cofins.iterator();
        while (iterator.hasNext()) {
            RegC505 o;
            RegC505 r = o = iterator.next();
            p.append(this.separator + "C505");
            p.append(this.separator + this.form.formatStringClear(r.getCstCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorItem()));
            if (r.getNatBCCredito() != null) {
                p.append(this.separator + this.form.formatStringClear(r.getNatBCCredito()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getValoBCCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C505");
        }
    }

    private File createWritterBlockD(Date dataIn, Date dataFim, List empresas, char perfil) throws IOException {
        File f = File.createTempFile("sped_bloco_d", ".txt");
        PrintWriter p = new PrintWriter(f);
        int contador = 1;
        int nrEmpresas = empresas.size();
        boolean flag = false;
        for (Object o : empresas) {
            boolean comDados;
            Empresa emp = (Empresa)o;
            BlocoD notasTerceirosD100 = this.cons.getBlocoD100NotasTerceirosTransporte(emp, dataIn, dataFim);
            BlocoD conhecimentosD200 = this.cons.getBlocoD200CTeSaida(emp, dataIn, dataFim);
            BlocoD notasTerceirosD500 = this.cons.getBlocoD500NotasTerceirosTelecomunicacao(emp, dataIn, dataFim);
            boolean bl = comDados = notasTerceirosD100 != null && notasTerceirosD100.getRegistrosD100() != null && !notasTerceirosD100.getRegistrosD100().isEmpty() || notasTerceirosD500 != null && notasTerceirosD500.getRegistrosD500() != null && !notasTerceirosD500.getRegistrosD500().isEmpty() || conhecimentosD200 != null && conhecimentosD200.getRegistrosD200() != null && !conhecimentosD200.getRegistrosD200().isEmpty();
            if (!flag) {
                flag = this.writterRegD001(p, comDados, flag, contador, nrEmpresas);
            }
            if (comDados) {
                this.writterD010(p, emp);
                this.gerarBlocoD100(p, notasTerceirosD100, null, perfil, emp);
                this.gerarBlocoD200(p, conhecimentosD200, emp);
                this.gerarBlocoD500(p, notasTerceirosD500, emp);
            }
            ++contador;
        }
        this.writterD990(p);
        p.flush();
        p.close();
        return f;
    }

    private boolean writterRegD001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas) {
        if (comDados || !comDados && contador == nrEmpresas) {
            p.append(this.separator + "D001");
            p.append(this.separator + String.valueOf(comDados ? 0 : 1));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D001");
            flag = true;
        }
        return flag;
    }

    private void writterD990(PrintWriter p) {
        this.cont.soma1("D990");
        p.append(this.separator + "D990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('D')));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterD010(PrintWriter p, Empresa emp) {
        p.append(this.separator + "D010");
        p.append(this.separator + this.form.clearString(emp.getPessoa().getComplemento().getCnpj()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("D010");
    }

    private void gerarBlocoD100(PrintWriter p, BlocoD notasTerceiros, BlocoD notasProprias, char perfil, Empresa emp) {
        if (notasTerceiros != null) {
            Iterator<RegD100> iterator = notasTerceiros.getRegistrosD100().iterator();
            while (iterator.hasNext()) {
                RegD100 o;
                RegD100 r = o = iterator.next();
                this.writterRegD100NotasTerceiros(p, r, emp);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        }
    }

    private void writterRegD100NotasTerceiros(PrintWriter p, RegD100 r, Empresa emp) {
        p.append(this.separator + "D100");
        p.append(this.separator + "0");
        p.append(this.separator + "1");
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + r.getCodSituacaoDoc());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumberLong(r.getNumeroDoc()));
        if (r.getChaveNfe() != null) {
            p.append(this.separator + r.getChaveNfe());
        }
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
        if (r.getCodTipoCTe() != null) {
            p.append(this.separator + String.valueOf(r.getCodTipoCTe()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
        p.append(this.separator + String.valueOf(r.getIndicadorTipoFrete()));
        p.append(this.separator + this.form.formatNumber(r.getValorTotMercadorias(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        if (r.getObsFaturamento() != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            p.append(this.separator + this.form.formatNumberLong(r.getObsFaturamento().getIdentificador()));
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(r.getObsFaturamento().getIdentificador());
            reg450.setDescricao(r.getObsFaturamento().getNome());
            dados.add(reg450);
            this.putObservacoes(dados, emp);
        } else {
            p.append(this.separator);
        }
        if (r.getPlanoConta() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getPlanoConta().getCodigo(), 60));
            this.hashEmpresasPlanos.add(r.getPlanoConta());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("D100");
        this.writterRegD101Pis(p, r.getPis());
        this.writterRegD105Cofins(p, r.getCofins());
        this.writterRegD111ProcessosRef(p, r.getProcessosReferenciados());
    }

    private void writterRegD101Pis(PrintWriter p, List<RegD101> pis) {
        Iterator<RegD101> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegD101 o;
            RegD101 r = o = iterator.next();
            p.append(this.separator + "D101");
            p.append(this.separator + this.form.formatStringClear(r.getIndicadorNaturezaFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaPis()));
            p.append(this.separator + this.form.formatStringClear(r.getNatBcCred()));
            p.append(this.separator + this.form.formatNumber(r.getValorBcPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D101");
        }
    }

    private void writterRegD105Cofins(PrintWriter p, List<RegD105> cofins) {
        Iterator<RegD105> iterator = cofins.iterator();
        while (iterator.hasNext()) {
            RegD105 o;
            RegD105 r = o = iterator.next();
            p.append(this.separator + "D105");
            p.append(this.separator + this.form.formatStringClear(r.getIndicadorNaturezaFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaCofins()));
            p.append(this.separator + this.form.formatStringClear(r.getNatBcCred()));
            p.append(this.separator + this.form.formatNumber(r.getValorBcCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D105");
        }
    }

    private void writterRegD111ProcessosRef(PrintWriter p, List<RegD111> processosRef) {
        Iterator<RegD111> iterator = processosRef.iterator();
        while (iterator.hasNext()) {
            RegD111 o;
            RegD111 r = o = iterator.next();
            p.append(this.separator + "D111");
            p.append(this.separator + this.form.formatStringClear(r.getNumeroProcesso(), 60));
            p.append(this.separator + this.form.formatStringClear(r.getCodOrigem().toString()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D111");
        }
    }

    private void gerarBlocoD200(PrintWriter p, BlocoD conhecimentos, Empresa emp) {
        if (conhecimentos != null) {
            Iterator<RegD200> iterator = conhecimentos.getRegistrosD200().iterator();
            while (iterator.hasNext()) {
                RegD200 o;
                RegD200 r = o = iterator.next();
                this.writterRegD200Conhecimentos(p, r, emp);
            }
        }
    }

    private void writterRegD200Conhecimentos(PrintWriter p, RegD200 r, Empresa emp) {
        p.append(this.separator + "D200");
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + r.getCodSituacaoDocumento());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumberLong(r.getNumeroInicial()));
        p.append(this.separator + this.form.formatNumberLong(r.getNumeroFinal()));
        p.append(this.separator + this.form.formatStringClear(r.getCfop()));
        p.append(this.separator + this.form.formatDate(r.getDataRef()));
        p.append(this.separator + this.form.formatNumber(r.getValorTotal(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDescontos(), 2));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("D200");
        this.writterRegD201Pis(p, r.getPis());
        this.writterRegD205Cofins(p, r.getCofins());
    }

    private void writterRegD201Pis(PrintWriter p, List<RegD201> pis) {
        Iterator<RegD201> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegD201 o;
            RegD201 r = o = iterator.next();
            p.append(this.separator + "D201");
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            p.append(this.separator + this.form.formatNumber(r.getValorBcPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D201");
        }
    }

    private void writterRegD205Cofins(PrintWriter p, List<RegD205> cofins) {
        Iterator<RegD205> iterator = cofins.iterator();
        while (iterator.hasNext()) {
            RegD205 o;
            RegD205 r = o = iterator.next();
            p.append(this.separator + "D205");
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            p.append(this.separator + this.form.formatNumber(r.getValorBcCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D205");
        }
    }

    private void gerarBlocoD500(PrintWriter p, BlocoD notasTerceiros, Empresa emp) {
        if (notasTerceiros != null) {
            Iterator<RegD500> iterator = notasTerceiros.getRegistrosD500().iterator();
            while (iterator.hasNext()) {
                RegD500 o;
                RegD500 r = o = iterator.next();
                this.writterRegD500NotasTerceiros(p, r, emp);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        }
    }

    private void writterRegD500NotasTerceiros(PrintWriter p, RegD500 r, Empresa emp) {
        p.append(this.separator + "D500");
        p.append(this.separator + "0");
        p.append(this.separator + "1");
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + r.getCodSituacaoDoc());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumberInt(r.getNumeroDoc()));
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
        p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorTotalMercadorias(), 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDespAcess(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorBcIcms(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
        if (r.getObsFaturamento() != null) {
            p.append(this.separator + this.form.formatNumberLong(r.getObsFaturamento().getIdentificador()));
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(r.getObsFaturamento().getIdentificador());
            reg450.setDescricao(r.getObsFaturamento().getNome());
            dados.add(reg450);
            this.putObservacoes(dados, emp);
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("D500");
        this.writterRegD501Pis(p, r.getPis());
        this.writterRegD505Cofins(p, r.getCofins());
        this.writterRegD509ProcessosRef(p, r.getProcessosReferenciados());
    }

    private void writterRegD501Pis(PrintWriter p, List<RegD501> pis) {
        Iterator<RegD501> iterator = pis.iterator();
        while (iterator.hasNext()) {
            RegD501 o;
            RegD501 r = o = iterator.next();
            p.append(this.separator + "D501");
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            if (r.getNatBCCredito() != null) {
                p.append(this.separator + this.form.formatStringClear(r.getNatBCCredito()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getValorBcPis()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D501");
        }
    }

    private void writterRegD505Cofins(PrintWriter p, List<RegD505> cofins) {
        Iterator<RegD505> iterator = cofins.iterator();
        while (iterator.hasNext()) {
            RegD505 o;
            RegD505 r = o = iterator.next();
            p.append(this.separator + "D505");
            p.append(this.separator + this.form.formatStringClear(r.getCodIncidenciaCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            if (r.getNatBCCredito() != null) {
                p.append(this.separator + this.form.formatStringClear(r.getNatBCCredito()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getValorBcCofins()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D505");
        }
    }

    private void writterRegD509ProcessosRef(PrintWriter p, List<RegD509> processosRef) {
        Iterator<RegD509> iterator = processosRef.iterator();
        while (iterator.hasNext()) {
            RegD509 o;
            RegD509 r = o = iterator.next();
            p.append(this.separator + "D509");
            p.append(this.separator + this.form.formatStringClear(r.getNumeroProcesso(), 60));
            p.append(this.separator + this.form.formatStringClear(r.getCodOrigem().toString()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D509");
        }
    }

    private File createWritterBlock9() throws IOException {
        File f = File.createTempFile("sped_bloco_9", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterReg9001(p);
        this.writterReg9900(p);
        this.writterReg9990(p);
        this.writterReg9999(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg9001(PrintWriter p) {
        p.append(this.separator + "9001");
        p.append(this.separator + String.valueOf(0));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("9001");
    }

    private void writterReg9900(PrintWriter p) {
        Set keys = this.cont.getContador().keySet();
        int contador = 0;
        for (Object o : keys) {
            String tk = (String)o;
            Long value = (Long)this.cont.getContador().get(tk);
            this.writterReg9900Aux(p, tk, value);
            ++contador;
        }
        this.cont.somaVarios("9900", contador);
        this.cont.soma1("9900");
        this.cont.soma1("9900");
        this.cont.soma1("9900");
        this.cont.soma1("9990");
        this.cont.soma1("9999");
        this.writterReg9900Aux(p, "9900", this.cont.getNrLinhas("9900"));
        this.writterReg9900Aux(p, "9990", this.cont.getNrLinhas("9990"));
        this.writterReg9900Aux(p, "9999", this.cont.getNrLinhas("9999"));
    }

    private void writterReg9999(PrintWriter p) {
        p.append(this.separator + "9999");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhasTotal()));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterReg9900Aux(PrintWriter p, String tk, Long value) {
        p.append(this.separator + "9900");
        p.append(this.separator + tk);
        p.append(this.separator + String.valueOf(this.form.formatNumberInt(value.intValue())));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterReg9990(PrintWriter p) {
        p.append(this.separator + "9990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('9')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlock1(Date dataIn, Date dataFim, Empresa emp) throws IOException {
        File f = File.createTempFile("sped_bloco_1", ".txt");
        PrintWriter p = new PrintWriter(f);
        boolean comDados = false;
        this.writter1001(p, comDados);
        this.writter1990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writter1001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "1001");
        p.append(this.separator + (comDados ? "0" : "1"));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("1001");
    }

    private void writter1990(PrintWriter p) {
        this.cont.soma1("1990");
        p.append(this.separator + "1990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('1')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlockF(Date dataIn, Date dataFim, List empresas, SpedPisCofins vo) throws IOException {
        File f = File.createTempFile("sped_bloco_f", ".txt");
        PrintWriter p = new PrintWriter(f);
        boolean comDados = false;
        boolean flag = false;
        int contador = 1;
        int nrEmpresas = empresas.size();
        for (Object o : empresas) {
            Empresa emp = (Empresa)o;
            BlocoF blocoF100 = this.cons.getLancamentosBlocoF100(emp, dataIn, dataFim);
            BlocoF blocoF120 = this.cons.getRegistrosBlocoF120(emp, dataIn, dataFim);
            BlocoF blocoF130 = this.cons.getRegistrosBlocoF130(emp, dataIn, dataFim);
            BlocoF blocoF150 = this.cons.getRegistrosBlocoF150(vo);
            BlocoF blocoF600 = this.cons.getRegistrosBlocoF600(vo);
            BlocoF blocoF700 = this.cons.getRegistrosBlocoF700(vo);
            boolean bl = comDados = blocoF100 != null && blocoF100.getRegistrosF100() != null && !blocoF100.getRegistrosF100().isEmpty() || blocoF120 != null && blocoF120.getRegistrosF120() != null && !blocoF120.getRegistrosF120().isEmpty() || blocoF130 != null && blocoF130.getRegistrosF130() != null && !blocoF130.getRegistrosF130().isEmpty() || blocoF150 != null && blocoF150.getRegistrosF150() != null && !blocoF150.getRegistrosF150().isEmpty() || blocoF600 != null && blocoF600.getRegistrosF600() != null && !blocoF600.getRegistrosF600().isEmpty() || blocoF700 != null && blocoF700.getRegistrosF700() != null && !blocoF700.getRegistrosF700().isEmpty();
            if (!flag) {
                flag = this.writterF001(p, comDados, flag, contador, nrEmpresas);
            }
            if (comDados) {
                this.writterF010(p, emp);
                this.gerarBlocoF100(p, blocoF100, emp);
                this.gerarBlocoF120(p, blocoF120, emp);
                this.gerarBlocoF130(p, blocoF130, emp);
                this.gerarBlocoF150(p, blocoF150);
                this.gerarBlocoF600(p, blocoF600);
                this.gerarBlocoF700(p, blocoF700);
            }
            ++contador;
        }
        this.writterF990(p);
        p.flush();
        p.close();
        return f;
    }

    private boolean writterF001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas) {
        if (comDados || !comDados && contador == nrEmpresas) {
            p.append(this.separator + "F001");
            p.append(this.separator + (comDados ? "0" : "1"));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("F001");
            flag = true;
        }
        return flag;
    }

    private void writterF010(PrintWriter p, Empresa emp) {
        p.append(this.separator + "F010");
        p.append(this.separator + this.form.clearString(emp.getPessoa().getComplemento().getCnpj()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F010");
    }

    private void writterF990(PrintWriter p) {
        this.cont.soma1("F990");
        p.append(this.separator + "F990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('F')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlockM(Date dataIn, Date dataFim, Empresa emp) throws IOException {
        File f = File.createTempFile("sped_bloco_m", ".txt");
        PrintWriter p = new PrintWriter(f);
        boolean comDados = false;
        this.writterM001(p, comDados);
        this.writterM990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterM001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "M001");
        p.append(this.separator + (comDados ? "0" : "1"));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("M001");
    }

    private void writterM990(PrintWriter p) {
        this.cont.soma1("M990");
        p.append(this.separator + "M990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('M')));
        p.append(this.separator + this.endOfRegister);
    }

    private void apendToSomeFile(File file, Date dataIn, Date dataFim, File bloco0, File blocoA, File blocoC, File blocoD, File blocoF, File blocoM, File bloco1, File bloco9) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.copy(bloco0, out);
        this.copy(blocoA, out);
        this.copy(blocoC, out);
        this.copy(blocoD, out);
        this.copy(blocoF, out);
        this.copy(blocoM, out);
        this.copy(bloco1, out);
        this.copy(bloco9, out);
        bloco0.delete();
        blocoC.delete();
        bloco9.delete();
        ((OutputStream)out).close();
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private void gerarBlocoA100(PrintWriter p, BlocoA notasTerceiros, BlocoA notasProprias, Empresa emp) {
        RegA100 r;
        RegA100 o;
        Iterator<RegA100> iterator;
        if (notasTerceiros != null) {
            iterator = notasTerceiros.getRegistrosA100().iterator();
            while (iterator.hasNext()) {
                r = o = iterator.next();
                this.writterRegA100NotasPropriasTerceiros(p, r, emp);
            }
        }
        if (notasProprias != null) {
            iterator = notasProprias.getRegistrosA100().iterator();
            while (iterator.hasNext()) {
                r = o = iterator.next();
                this.writterRegA100NotasPropriasTerceiros(p, r, emp);
            }
        }
        this.putProdutos(notasProprias.getProdutos(), emp);
        this.putParticpantes(notasProprias.getParticipantes(), emp);
        this.putUnidMedida(notasProprias.getUnidMedidas(), emp);
        this.putProdutos(notasTerceiros.getProdutos(), emp);
        this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        this.putUnidMedida(notasTerceiros.getUnidMedidas(), emp);
        this.putPlanoContas(notasTerceiros.getPlanoContas());
        this.putPlanoContas(notasProprias.getPlanoContas());
    }

    private void writterRegA100NotasPropriasTerceiros(PrintWriter p, RegA100 r, Empresa emp) {
        p.append(this.separator + "A100");
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getTipoOperacao())));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getIndTipoEmitente())));
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + r.getCodSituacaoDoc());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumeroDoc())));
        p.append(this.separator);
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
        p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getIndTipoPagamento())));
        p.append(this.separator + this.form.formatNumber(r.getValorDesconto()));
        p.append(this.separator + this.form.formatNumber(r.getValorBcPis()));
        p.append(this.separator + this.form.formatNumber(r.getValorPis()));
        p.append(this.separator + this.form.formatNumber(r.getValorBcCofins()));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
        p.append(this.separator + this.form.formatNumber(r.getValorPisRetido()));
        p.append(this.separator + this.form.formatNumber(r.getValorCofinsRetido()));
        p.append(this.separator + this.form.formatNumber(r.getValorIss()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("A100");
        this.writterRegA110Observacoes(p, r.getObservacoes(), emp);
        this.writterRegA111ProcReferenciados(p, r.getProcReferenciados());
        this.writterRegA170Itens(p, r.getItensDocumento());
    }

    private void writterRegA110Observacoes(PrintWriter p, List<RegA110> obs, Empresa emp) {
        ArrayList<Reg450> dados = new ArrayList<Reg450>();
        Iterator<RegA110> iterator = obs.iterator();
        while (iterator.hasNext()) {
            RegA110 o;
            RegA110 r = o = iterator.next();
            p.append(this.separator + "A110");
            p.append(this.separator + this.form.formatNumberLong(r.getIdObservacao()));
            p.append(this.separator + this.form.formatString(r.getTexto()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("A110");
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(r.getIdObservacao());
            reg450.setDescricao(r.getDescricao());
            dados.add(reg450);
        }
        this.putObservacoes(dados, emp);
    }

    private void writterRegA111ProcReferenciados(PrintWriter p, List<RegA111> procReferenciados) {
        Iterator<RegA111> iterator = procReferenciados.iterator();
        while (iterator.hasNext()) {
            RegA111 o;
            RegA111 r = o = iterator.next();
            p.append(this.separator + "A111");
            p.append(this.separator + this.form.formatString(r.getNumeroProcesso(), 15));
            p.append(this.separator + r.getCodOrigem().toString());
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("A111");
        }
    }

    private void writterRegA170Itens(PrintWriter p, List<RegA170> itensDocumento) {
        Iterator<RegA170> iterator = itensDocumento.iterator();
        while (iterator.hasNext()) {
            RegA170 o;
            RegA170 in = o = iterator.next();
            p.append(this.separator + "A170");
            p.append(this.separator + this.form.formatNumberInt((int)in.getNumeroItem()));
            p.append(this.separator + this.form.formatString(in.getCodigoItem().toString(), 60));
            p.append(this.separator + this.form.formatString(in.getDescricaoComp()));
            p.append(this.separator + this.form.formatNumber(in.getValorItem(), 2));
            p.append(this.separator + this.form.formatNumber(in.getValorDesconto(), 2));
            if (in.getCodBCCredito() != null) {
                p.append(this.separator + in.getCodBCCredito());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + "0");
            p.append(this.separator + in.getCodIncidenciaPis());
            p.append(this.separator + this.form.formatNumber(in.getValorBCPis()));
            p.append(this.separator + this.form.formatNumber(in.getValorAliqPis()));
            p.append(this.separator + this.form.formatNumber(in.getValorPis()));
            p.append(this.separator + in.getCodIncidenciaCofins());
            p.append(this.separator + this.form.formatNumber(in.getValorBCCofins()));
            p.append(this.separator + this.form.formatNumber(in.getValorAliqCofins()));
            p.append(this.separator + this.form.formatNumber(in.getValorCofins()));
            if (in.getCodContaAnalitica() != null) {
                p.append(this.separator + in.getCodContaAnalitica());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("A170");
        }
    }

    private void writterA010(PrintWriter p, String cnpj) {
        p.append(this.separator + "A010");
        p.append(this.separator + this.form.clearString(cnpj));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("A010");
    }

    private void writterC110(PrintWriter p, List<RegC110> obs, Empresa emp) {
        ArrayList<Reg450> dados = new ArrayList<Reg450>();
        Iterator<RegC110> iterator = obs.iterator();
        while (iterator.hasNext()) {
            RegC110 o;
            RegC110 r = o = iterator.next();
            p.append(this.separator + "C110");
            p.append(this.separator + this.form.formatNumberLong(r.getIdObservacao()));
            p.append(this.separator + this.form.formatString(r.getTexto(), 255));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C110");
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(r.getIdObservacao());
            reg450.setDescricao(r.getDescricao());
            dados.add(reg450);
        }
        this.putObservacoes(dados, emp);
    }

    private void gerarBlocoF100(PrintWriter p, BlocoF blocoF, Empresa emp) {
        if (blocoF != null) {
            Iterator<RegF100> iterator = blocoF.getRegistrosF100().iterator();
            while (iterator.hasNext()) {
                RegF100 o;
                RegF100 r = o = iterator.next();
                this.writterRegF100(p, r);
            }
            this.putParticpantes(blocoF.getParticipantes(), emp);
            this.putProdutos(blocoF.getProdutos(), emp);
            this.putUnidMedida(blocoF.getUnidadeMedidas(), emp);
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void writterRegF100(PrintWriter p, RegF100 r) {
        p.append(this.separator + "F100");
        p.append(this.separator + String.valueOf(r.getIndicadorTipoOperacao()));
        if (r.getIdParticipante() != null) {
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        } else {
            p.append(this.separator);
        }
        if (r.getIdProduto() != null) {
            p.append(this.separator + this.form.formatNumberLong(r.getIdProduto()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatDate(r.getDataOperacao()));
        p.append(this.separator + this.form.formatNumber(r.getVrOperacao(), 2));
        p.append(this.separator + r.getCodIncidenciaPis());
        p.append(this.separator + this.form.formatNumber(r.getVrBcPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
        p.append(this.separator + this.form.formatNumber(r.getVrPis(), 2));
        p.append(this.separator + r.getCodIncidenciaCofins());
        p.append(this.separator + this.form.formatNumber(r.getVrBcCofins(), 2));
        p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
        p.append(this.separator + this.form.formatNumber(r.getVrCofins(), 2));
        p.append(this.separator + r.getCodNatBCCredito());
        if (r.getIndicadorOrigemCredito() != null) {
            p.append(this.separator + String.valueOf(r.getIndicadorOrigemCredito()));
        } else {
            p.append(this.separator);
        }
        if (r.getCodPlanoConta() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getCodPlanoConta(), 60));
        } else {
            p.append(this.separator);
        }
        if (r.getCodCentroCusto() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getCodCentroCusto(), 60));
        } else {
            p.append(this.separator);
        }
        if (r.getDescricaoDocumento() != null) {
            p.append(this.separator + r.getDescricaoDocumento());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F100");
        this.writterRegF111ProcessosRef(p, r.getProcessosReferenciados());
    }

    private void writterRegF111ProcessosRef(PrintWriter p, List<RegF111> processosRef) {
        Iterator<RegF111> iterator = processosRef.iterator();
        while (iterator.hasNext()) {
            RegF111 o;
            RegF111 r = o = iterator.next();
            p.append(this.separator + "F111");
            p.append(this.separator + this.form.formatStringClear(r.getNumeroProcesso(), 60));
            p.append(this.separator + this.form.formatStringClear(r.getCodOrigem().toString()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("F111");
        }
    }

    private void gerarBlocoF120(PrintWriter p, BlocoF blocoF, Empresa emp) {
        if (blocoF != null) {
            Iterator<RegF120> iterator = blocoF.getRegistrosF120().iterator();
            while (iterator.hasNext()) {
                RegF120 o;
                RegF120 r = o = iterator.next();
                this.writterRegF120(p, r);
            }
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void writterRegF120(PrintWriter p, RegF120 r) {
        p.append(this.separator + "F120");
        p.append(this.separator + r.getCodNatBcCredito());
        p.append(this.separator + r.getCodIdenBemImobilizado());
        if (r.getCodIndOrigemCredito() != null) {
            p.append(this.separator + String.valueOf(r.getCodIndOrigemCredito()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + String.valueOf(r.getCodIndUtilizacaoBemImobilizado()));
        p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
        if (r.getParcelaOperNaoBcCred() != null) {
            p.append(this.separator + this.form.formatNumber(r.getParcelaOperNaoBcCred(), 2));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + r.getCodIncidenciaPis());
        p.append(this.separator + this.form.formatNumber(r.getValorBcPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
        p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
        p.append(this.separator + r.getCodIncidenciaCofins());
        p.append(this.separator + this.form.formatNumber(r.getValorBcCofins(), 2));
        p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
        if (r.getCodPlanoConta() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getCodPlanoConta(), 60));
        } else {
            p.append(this.separator);
        }
        if (r.getCodCentroCusto() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getCodCentroCusto()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + r.getDescricaoBemImobilizado());
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F120");
        this.writterRegF129ProcessosRef(p, r.getProcessosReferenciados());
    }

    private void writterRegF129ProcessosRef(PrintWriter p, List<RegF129> processosRef) {
        Iterator<RegF129> iterator = processosRef.iterator();
        while (iterator.hasNext()) {
            RegF129 o;
            RegF129 r = o = iterator.next();
            p.append(this.separator + "F129");
            p.append(this.separator + this.form.formatStringClear(r.getNumeroProcesso(), 60));
            p.append(this.separator + this.form.formatStringClear(r.getCodOrigem().toString()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("F129");
        }
    }

    private void gerarBlocoF130(PrintWriter p, BlocoF blocoF, Empresa emp) {
        if (blocoF != null) {
            Iterator<RegF130> iterator = blocoF.getRegistrosF130().iterator();
            while (iterator.hasNext()) {
                RegF130 o;
                RegF130 r = o = iterator.next();
                this.writterRegF130(p, r);
            }
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void writterRegF130(PrintWriter p, RegF130 r) {
        p.append(this.separator + "F130");
        p.append(this.separator + r.getCodNatBcCredito());
        p.append(this.separator + r.getCodIdenBemImobilizado());
        if (r.getCodIndOrigemCredito() != null) {
            p.append(this.separator + String.valueOf(r.getCodIndOrigemCredito()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + String.valueOf(r.getCodIndUtilizacaoBemImobilizado()));
        if (r.getMesAnoOperacao() != null) {
            Integer mes = DateUtil.monthFromDate(r.getMesAnoOperacao());
            Object temp = "";
            if (mes < 10) {
                temp = "0" + mes.toString();
            }
            Integer ano = DateUtil.yearFromDate(r.getMesAnoOperacao());
            p.append(this.separator + (String)temp + ano.toString());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
        if (r.getParcelaOperNaoBcCred() != null) {
            p.append(this.separator + this.form.formatNumber(r.getParcelaOperNaoBcCred(), 2));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumber(r.getVrBcCredito(), 2));
        p.append(this.separator + String.valueOf(r.getCodIndNrParcelas()));
        p.append(this.separator + r.getCodIncidenciaPis());
        p.append(this.separator + this.form.formatNumber(r.getValorBcPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
        p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
        p.append(this.separator + r.getCodIncidenciaCofins());
        p.append(this.separator + this.form.formatNumber(r.getValorBcCofins(), 2));
        p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
        if (r.getCodPlanoConta() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getCodPlanoConta(), 60));
        } else {
            p.append(this.separator);
        }
        if (r.getCodCentroCusto() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getCodCentroCusto(), 60));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + r.getDescricaoBemImobilizado());
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F130");
        this.writterRegF139ProcessosRef(p, r.getProcessosReferenciados());
    }

    private void writterRegF139ProcessosRef(PrintWriter p, List<RegF139> processosRef) {
        Iterator<RegF139> iterator = processosRef.iterator();
        while (iterator.hasNext()) {
            RegF139 o;
            RegF139 r = o = iterator.next();
            p.append(this.separator + "F139");
            p.append(this.separator + this.form.formatStringClear(r.getNumeroProcesso(), 60));
            p.append(this.separator + this.form.formatStringClear(r.getCodOrigem().toString()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("F139");
        }
    }

    private void gerarBlocoF150(PrintWriter p, BlocoF blocoF) {
        if (blocoF != null) {
            Iterator<RegF150> iterator = blocoF.getRegistrosF150().iterator();
            while (iterator.hasNext()) {
                RegF150 o;
                RegF150 r = o = iterator.next();
                this.writterRegF150(p, r);
            }
        }
    }

    private void writterRegF150(PrintWriter p, RegF150 r) {
        p.append(this.separator + "F150");
        p.append(this.separator + r.getCodNatBcCredito());
        p.append(this.separator + this.form.formatNumber(r.getValorTotalEstoque()));
        if (r.getParcelaEstoqueImp() != null) {
            p.append(this.separator + this.form.formatNumber(r.getParcelaEstoqueImp()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumber(r.getValorBcEstoque()));
        p.append(this.separator + this.form.formatNumber(r.getValorBcMensalEstoque()));
        p.append(this.separator + r.getCodIncidenciaPis());
        p.append(this.separator + this.form.formatNumber(r.getAliquotaPis(), 4));
        p.append(this.separator + this.form.formatNumber(r.getValorCredPis()));
        p.append(this.separator + r.getCodIncidenciaCofins());
        p.append(this.separator + this.form.formatNumber(r.getAliquotaCofins(), 4));
        p.append(this.separator + this.form.formatNumber(r.getValorCredCofins()));
        if (r.getDescricaoEstoque() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getDescricaoEstoque(), 100));
        } else {
            p.append(this.separator);
        }
        if (r.getPlanoConta() != null) {
            p.append(this.separator + this.form.formatStringClear(r.getPlanoConta().getCodigo(), 60));
            this.putPlanoContas(r.getPlanoConta());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F150");
    }

    private void gerarBlocoF600(PrintWriter p, BlocoF blocoF) {
        if (blocoF != null) {
            Iterator<RegF600> iterator = blocoF.getRegistrosF600().iterator();
            while (iterator.hasNext()) {
                RegF600 o;
                RegF600 r = o = iterator.next();
                this.writterRegF600(p, r);
            }
        }
    }

    private void writterRegF600(PrintWriter p, RegF600 r) {
        p.append(this.separator + "F600");
        p.append(this.separator + r.getCodIndNatRetencao());
        p.append(this.separator + this.form.formatDate(r.getDataRetencao()));
        p.append(this.separator + this.form.formatNumber(r.getVrBcRetencao(), 4));
        p.append(this.separator + this.form.formatNumber(r.getVrTotalRetencao(), 2));
        if (r.getCodReceita() != null) {
            p.append(this.separator + r.getCodReceita());
        } else {
            p.append(this.separator);
        }
        if (r.getCodIndNatReceita() != null) {
            p.append(this.separator + String.valueOf(r.getCodIndNatReceita()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.clearString(r.getCnpj()));
        p.append(this.separator + this.form.formatNumber(r.getValorRetidoPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorRetidoCofins(), 2));
        p.append(this.separator + String.valueOf(r.getIndDeclarante()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F600");
    }

    private void gerarBlocoF700(PrintWriter p, BlocoF blocoF) {
        if (blocoF != null) {
            Iterator<RegF700> iterator = blocoF.getRegistrosF700().iterator();
            while (iterator.hasNext()) {
                RegF700 o;
                RegF700 r = o = iterator.next();
                this.writterRegF700(p, r);
            }
        }
    }

    private void writterRegF700(PrintWriter p, RegF700 r) {
        p.append(this.separator + "F700");
        p.append(this.separator + r.getIndOrigDeducao());
        p.append(this.separator + String.valueOf(r.getIndNatDeducao()));
        p.append(this.separator + this.form.formatNumber(r.getValorDeducaoPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDeducaoCofins(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorBcOperacao(), 2));
        if (r.getCnpj() != null) {
            p.append(this.separator + this.form.clearString(r.getCnpj()));
        } else {
            p.append(this.separator);
        }
        if (r.getInformacoes() != null) {
            p.append(this.separator + r.getInformacoes());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("F700");
    }
}

