/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003;

import com.touchcomp.basementor.model.vo.AjusteContribuicaoPrevidenciaPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsStructureException;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsWritterException;
import mentorcore.service.impl.spedpiscofins.versao003.SpedFormat;
import mentorcore.service.impl.spedpiscofins.versao003.model.ContadorRegistros;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg450;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.bloco0.Reg0145;
import mentorcore.service.impl.spedpiscofins.versao003.model.bloco1.Bloco1;
import mentorcore.service.impl.spedpiscofins.versao003.model.bloco1.Reg1900;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA110;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC010;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC380;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC395;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD200;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF120;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF130;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF150;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF550;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF600;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF700;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocop.BlocoP;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocop.RegP200;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocop.RegP210;
import mentorcore.service.impl.spedpiscofins.versao003.util.bloco0.UtilBDBloco0;
import mentorcore.service.impl.spedpiscofins.versao003.util.bloco0.writter.UtilWritterBloco0;
import mentorcore.service.impl.spedpiscofins.versao003.util.bloco1.UtilBDBloco1900;
import mentorcore.service.impl.spedpiscofins.versao003.util.bloco1.writter.UtilWritterBloco1;
import mentorcore.service.impl.spedpiscofins.versao003.util.bloco9.writter.UtilWritterBloco9;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocoa.UtilBDBlocoA100NotaPropria;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocoa.UtilBDBlocoA100NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocoa.writter.UtilWritterBlocoA;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.UtilBDBlocoC100NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.UtilBDBlocoC100NotasPropria;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.UtilBDBlocoC380NotaPropria;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.UtilBDBlocoC395NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.UtilBDBlocoC400CupomFiscal;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.UtilBDBlocoC500NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao003.util.blococ.writter.UtilWritterBlocoC;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocod.UtilBDBlocoD100NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocod.UtilBDBlocoD200CTe;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocod.UtilBDBlocoD500NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocod.writter.UtilWritterBlocoD;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF100;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF120;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF130;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF150;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF550;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF600;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.UtilBDBlocoF700;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocof.writter.UtilWritterBlocoF;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocom.writter.UtilWritterBlocoM;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocop.UtilBDBlocoP;
import mentorcore.service.impl.spedpiscofins.versao003.util.blocop.writter.UtilWritterBlocoP;
import mentorcore.tools.DateUtil;

public class SpedPisCofinsWritter003 {
    private SpedFormat form = new SpedFormat();
    private String endOfRegister = "\r\n";
    private char separator = (char)124;
    private final TLogger logger = TLogger.get(this.getClass());
    private ContadorRegistros cont = new ContadorRegistros();
    private HashMap hashEmpresasProdutos = new HashMap();
    private HashMap hashEmpresasNaturezas = new HashMap();
    private HashMap hashEmpresasUnidades = new HashMap();
    private HashMap hashEmpresasParicipantes = new HashMap();
    private HashMap hashEmpresasObservacoes = new HashMap();
    private HashSet hashEmpresasPlanos = new HashSet();
    private HashSet hashEmpresasCentroCustos = new HashSet();

    public void spedPisCofinsWritter(SpedPisCofins vo, File directory) throws SpedPisCofinsWritterException, ExceptionDatabase, ExceptionService, SpedPisCofinsStructureException {
        Date dataIn = vo.getDataInicial();
        Date dataFim = vo.getDataFinal();
        String path = "";
        if (directory != null) {
            path = directory.getAbsolutePath();
        }
        try {
            Empresa emp = vo.getEmpresa();
            String perfil = emp.getEmpresaDados().getPerfilSpedFiscal().getCodigo();
            if (emp.getEmpresaDados().getIndicadorAtividade() == null) {
                throw new SpedPisCofinsWritterException("Primeiro, informe o Indicador de Atividade no cadastro de Empresa.");
            }
            List codigosAtivEc = new ArrayList();
            if (vo.getGerarBlocoP() == 1 && ((codigosAtivEc = new UtilBDBloco0().getCodigoAtividadeEcPisCofins(dataIn, dataFim)) == null || codigosAtivEc.isEmpty())) {
                throw new SpedPisCofinsWritterException("Primeiro informe os C\u00f3digos de Atividade Econ\u00f4mica.\nNecess\u00e1rio para gera\u00e7\u00e3o do Bloco P");
            }
            List empresas = vo.getGrupoEmpresa().getEmpresas();
            for (Object o : empresas) {
                Empresa e = (Empresa)o;
                this.hashEmpresasProdutos.put(e, new HashSet());
                this.hashEmpresasNaturezas.put(e, new HashSet());
                this.hashEmpresasUnidades.put(e, new HashSet());
                this.hashEmpresasParicipantes.put(e, new HashSet());
                this.hashEmpresasObservacoes.put(e, new HashSet());
            }
            HashMap h = this.getRegistrosGerados(vo);
            File blocoP = this.createWritterBlockP(dataIn, dataFim, empresas, h, vo, codigosAtivEc);
            File blocoA = this.createWritterBlockA(dataIn, dataFim, empresas, h);
            File blocoC = this.createWritterBlockC(dataIn, dataFim, empresas, h);
            File blocoD = this.createWritterBlockD(dataIn, dataFim, empresas, perfil.charAt(0), h);
            File blocoF = this.createWritterBlockF(dataIn, dataFim, empresas, vo);
            File blocoM = this.createWritterBlockM(dataIn, dataFim, emp);
            File bloco0 = this.createWritterBlock0(dataIn, dataFim, emp, vo, empresas, codigosAtivEc);
            File bloco1 = this.createWritterBlock1(dataIn, dataFim, emp, h);
            File bloco9 = this.createWritterBlock9();
            this.apendToSomeFile(path, dataIn, dataFim, bloco0, blocoA, blocoC, blocoD, blocoF, blocoM, bloco1, bloco9, blocoP);
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new SpedPisCofinsWritterException("Diret\u00f3rio n\u00e3o encontrado");
        }
    }

    private File getFilePath(String directory, Date dateIn, Date dateFim) {
        String fileName = "sped_piscofins";
        String dtIn = DateUtil.dateToStr(dateIn, "dd_MM_yyyy");
        String dtFim = DateUtil.dateToStr(dateFim, "dd_MM_yyyy");
        File f = new File(directory + File.separatorChar + fileName + dtIn + "_" + dtFim + ".txt");
        return f;
    }

    private File createWritterBlock0(Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo, List empresas, List codigoAtivEc) throws IOException, ExceptionDatabase, SpedPisCofinsWritterException {
        File f = File.createTempFile("sped_bloco_0", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco0 w = new UtilWritterBloco0();
        Reg0145 reg0145 = null;
        if (vo.getGerarBlocoP() == 1) {
            reg0145 = this.getRegistr0145(p, empresas, dataIn, dataFim, vo, w, codigoAtivEc);
        }
        this.gerarBloco0000(p, dataIn, dataFim, emp, vo, w);
        this.gerarBloco0001(p, w);
        this.gerarBloco0100(p, emp, w);
        this.gerarBloco0110(p, vo, w);
        this.gerarBloco0111(p, vo, w);
        this.gerarBloco0140(p, empresas, dataIn, dataFim, reg0145, w);
        this.gerarBloco0500(p, w);
        this.gerarBloco0600(p, w);
        this.gerarBloco0990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockA(Date dataIn, Date dataFim, List empresas, HashMap h) throws IOException {
        File f = File.createTempFile("sped_bloco_a", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoA w = new UtilWritterBlocoA();
        Boolean gerarBloco = (Boolean)h.get("BlocoA");
        if (gerarBloco.booleanValue()) {
            boolean flag = false;
            int contador = 1;
            int nrEmpresas = empresas.size();
            for (Object o : empresas) {
                Empresa emp = (Empresa)o;
                BlocoA notasServicoTercA100 = new UtilBDBlocoA100NotaTerceiros().getBlocoA100NotasTerceiros(dataIn, dataFim, emp);
                BlocoA notasServicoPropA100 = new UtilBDBlocoA100NotaPropria().getBlocoA100NotasServico(dataIn, dataFim, emp);
                boolean comDados = this.existeRegistrosBlocoA(notasServicoTercA100, notasServicoPropA100);
                if (!flag) {
                    flag = this.gerarBlocoA001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoA010(p, emp.getPessoa().getComplemento().getCnpj());
                    this.gerarBlocoA100NotaPropria(p, notasServicoPropA100, emp, w);
                    this.gerarBlocoA100NotaTerceiros(p, notasServicoTercA100, emp, w);
                }
                ++contador;
            }
        }
        this.gerarBlocoA990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockC(Date dataIn, Date dataFim, List empresas, HashMap h) throws IOException {
        File f = File.createTempFile("sped_bloco_c", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoC w = new UtilWritterBlocoC();
        Boolean gerarBloco = (Boolean)h.get("BlocoC");
        if (gerarBloco.booleanValue()) {
            int contador = 1;
            int nrEmpresas = empresas.size();
            boolean flag = false;
            for (Object o : empresas) {
                Empresa emp = (Empresa)o;
                BlocoC notasPropriasC100 = new UtilBDBlocoC100NotasPropria().getBlocoC100NotasProprias(dataIn, dataFim, emp, null);
                BlocoC notasTerceirosC100 = new UtilBDBlocoC100NotaTerceiros().getBlocoC100NotasTerceiros(dataIn, dataFim, emp, null);
                BlocoC notasPropriasC380 = new UtilBDBlocoC380NotaPropria().getBlocoC380NotasProprias(dataIn, dataFim, emp);
                BlocoC notasTerceirosC395 = new UtilBDBlocoC395NotaTerceiros().getBlocoC395NotasTerceiros(dataIn, dataFim, emp);
                BlocoC cuponsFiscaisC400 = new UtilBDBlocoC400CupomFiscal().getBlocoC400CuponsFiscais(dataIn, dataFim, emp);
                BlocoC notasTerceirosC500 = new UtilBDBlocoC500NotaTerceiros().getBlocoC500NotasTerceiros(dataIn, dataFim, emp);
                boolean comDados = this.existeRegistrosBlocoC(notasPropriasC100, notasTerceirosC100, notasPropriasC380, notasTerceirosC395, cuponsFiscaisC400, notasTerceirosC500);
                if (!flag) {
                    flag = this.gerarBlocoC001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoC010(p, emp.getPessoa().getComplemento().getCnpj(), w);
                    this.gerarBlocoC100NotaPropria(p, notasPropriasC100, emp, w);
                    this.gerarBlocoC100NotaTerceiros(p, notasTerceirosC100, emp, w);
                    this.gerarBlocoC380(p, notasPropriasC380, emp, w);
                    this.gerarBlocoC395(p, notasTerceirosC395, emp, w);
                    this.gerarBlocoC400(p, cuponsFiscaisC400, emp, w);
                    this.gerarBlocoC500(p, notasTerceirosC500, emp, w);
                }
                ++contador;
            }
        }
        this.gerarBlocoC990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockP(Date dataIn, Date dataFim, List empresas, HashMap h, SpedPisCofins vo, List codigosAtivEc) throws IOException {
        File f = File.createTempFile("sped_bloco_p", ".txt");
        if (vo.getGerarBlocoP() == 1) {
            PrintWriter p = new PrintWriter(f);
            UtilWritterBlocoP w = new UtilWritterBlocoP();
            int contador = 1;
            int nrEmpresas = empresas.size();
            boolean flag = false;
            for (Object o : empresas) {
                boolean comDados;
                Empresa emp = (Empresa)o;
                if (emp.getEmpresaDados().getMatriz() != 1) continue;
                BlocoP blocoP100 = new UtilBDBlocoP().getBlocoP100(dataIn, dataFim, emp, codigosAtivEc);
                boolean bl = comDados = blocoP100 != null && !blocoP100.getRegistrosP100().isEmpty();
                if (!flag) {
                    flag = this.gerarBlocoP001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoP010(p, emp.getPessoa().getComplemento().getCnpj(), w);
                    Double valorTotalApurado = this.gerarBlocoP100(p, blocoP100, w);
                    this.gerarBlocoP200(p, vo, valorTotalApurado, w);
                }
                ++contador;
            }
            this.gerarBlocoP990(p, w);
            p.flush();
            p.close();
        }
        return f;
    }

    private void gerarBlocoC100NotaPropria(PrintWriter p, BlocoC notasProprias, Empresa emp, UtilWritterBlocoC w) {
        if (notasProprias != null) {
            Iterator<RegC100> iterator = notasProprias.getRegistrosC100().iterator();
            while (iterator.hasNext()) {
                RegC100 o;
                RegC100 r = o = iterator.next();
                boolean docCancInut = this.getDocCanceladoOuInutilizado(r.getCodSituacaoDoc());
                w.writterC100NotasProprias(p, r, docCancInut, this.cont);
                if (docCancInut) continue;
                w.writterC110(p, r.getObservacoes(), emp, this.cont);
                this.setObservacoesC110(r.getObservacoes(), emp);
                w.writterC111(p, r.getProcessosReferenciados(), this.cont);
                w.writterC170(p, r.getItensDocumento(), this.cont, emp);
            }
            this.putParticpantes(notasProprias.getParticipantes(), emp);
            this.putProdutos(notasProprias.getProdutos(), emp);
            this.putNatOperacao(notasProprias.getNatOperacao(), emp);
            this.putUnidMedida(notasProprias.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
    }

    private void gerarBlocoC100NotaTerceiros(PrintWriter p, BlocoC notasTerceiros, Empresa emp, UtilWritterBlocoC w) {
        if (notasTerceiros != null) {
            Iterator<RegC010> iterator = notasTerceiros.getRegistrosC010().iterator();
            while (iterator.hasNext()) {
                RegC010 o;
                RegC010 rc = o = iterator.next();
                Iterator<RegC100> iterator2 = rc.getRegistrosC100().iterator();
                while (iterator2.hasNext()) {
                    RegC100 ob;
                    RegC100 r = ob = iterator2.next();
                    boolean docCancInut = this.getDocCanceladoOuInutilizado(r.getCodSituacaoDoc());
                    w.writterC100NotasTerceiros(p, r, docCancInut, this.cont);
                    if (docCancInut) continue;
                    w.writterC110(p, r.getObservacoes(), emp, this.cont);
                    this.setObservacoesC110(r.getObservacoes(), emp);
                    w.writterC111(p, r.getProcessosReferenciados(), this.cont);
                    w.writterC170(p, r.getItensDocumento(), this.cont, emp);
                }
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
            this.putProdutos(notasTerceiros.getProdutos(), emp);
            this.putNatOperacao(notasTerceiros.getNatOperacao(), emp);
            this.putUnidMedida(notasTerceiros.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoC380(PrintWriter p, BlocoC notasProprias, Empresa emp, UtilWritterBlocoC w) {
        if (notasProprias != null) {
            Iterator<RegC380> iterator = notasProprias.getRegistrosC380().iterator();
            while (iterator.hasNext()) {
                RegC380 o;
                RegC380 r = o = iterator.next();
                w.writterC380NotasPropriasTerceiros(p, r, this.cont);
            }
            this.putProdutos(notasProprias.getProdutos(), emp);
            this.putUnidMedida(notasProprias.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
    }

    private void putProdutos(List reg, Empresa emp) {
        HashSet produtos = (HashSet)this.hashEmpresasProdutos.get(emp);
        produtos.addAll(reg);
    }

    private void putParticpantes(List reg, Empresa emp) {
        HashSet participantes = (HashSet)this.hashEmpresasParicipantes.get(emp);
        participantes.addAll(reg);
    }

    private void putNatOperacao(List reg, Empresa emp) {
        HashSet naturOperacao = (HashSet)this.hashEmpresasNaturezas.get(emp);
        naturOperacao.addAll(reg);
    }

    private void putUnidMedida(List reg, Empresa emp) {
        HashSet unid = (HashSet)this.hashEmpresasUnidades.get(emp);
        unid.addAll(reg);
    }

    private void putObservacoes(List reg, Empresa emp) {
        HashSet obs = (HashSet)this.hashEmpresasObservacoes.get(emp);
        obs.addAll(reg);
    }

    private void putPlanoContas(List reg) {
        this.hashEmpresasPlanos.addAll(reg);
    }

    private void putPlanoContas(Reg500 reg500) {
        this.hashEmpresasPlanos.add(reg500);
    }

    private void putCentroCustos(List reg) {
        this.hashEmpresasCentroCustos.addAll(reg);
    }

    private void gerarBlocoC395(PrintWriter p, BlocoC notasTerceiros, Empresa emp, UtilWritterBlocoC w) {
        if (notasTerceiros != null) {
            Iterator<RegC395> iterator = notasTerceiros.getRegistrosC395().iterator();
            while (iterator.hasNext()) {
                RegC395 o;
                RegC395 r = o = iterator.next();
                w.writterC395NotasPropriasTerceiros(p, r, this.cont);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
            this.putProdutos(notasTerceiros.getProdutos(), emp);
            this.putUnidMedida(notasTerceiros.getUnidadeMedidas(), emp);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoC400(PrintWriter p, BlocoC cuponsFiscais, Empresa emp, UtilWritterBlocoC w) {
        if (cuponsFiscais != null) {
            w.writterRegC400CuponsFiscais(p, cuponsFiscais.getRegistrosC400(), this.cont);
            this.putProdutos(cuponsFiscais.getProdutos(), emp);
            this.putUnidMedida(cuponsFiscais.getUnidadeMedidas(), emp);
            this.putPlanoContas(cuponsFiscais.getPlanoContas());
        }
    }

    private void gerarBlocoC500(PrintWriter p, BlocoC notasTerceiros, Empresa emp, UtilWritterBlocoC w) {
        if (notasTerceiros != null) {
            Iterator<RegC500> iterator = notasTerceiros.getRegistrosC500().iterator();
            while (iterator.hasNext()) {
                RegC500 o;
                RegC500 regC500 = o = iterator.next();
                w.writterRegC500NotasTerceiros(p, regC500, emp, this.cont);
                this.setObservacoesC500(regC500.getObsFaturamento(), emp);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        }
    }

    private File createWritterBlockD(Date dataIn, Date dataFim, List empresas, char perfil, HashMap h) throws IOException {
        File f = File.createTempFile("sped_bloco_d", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoD w = new UtilWritterBlocoD();
        Boolean gerarBloco = (Boolean)h.get("BlocoD");
        if (gerarBloco.booleanValue()) {
            int contador = 1;
            int nrEmpresas = empresas.size();
            boolean flag = false;
            for (Object o : empresas) {
                Empresa emp = (Empresa)o;
                BlocoD notasTerceirosD100 = new UtilBDBlocoD100NotaTerceiros().getBlocoD100NotasTerceirosTransporte(emp, dataIn, dataFim);
                BlocoD conhecimentosD200 = new UtilBDBlocoD200CTe().getBlocoD200CTeSaida(emp, dataIn, dataFim);
                BlocoD notasTerceirosD500 = new UtilBDBlocoD500NotaTerceiros().getBlocoD500NotasTerceirosTelecomunicacao(emp, dataIn, dataFim);
                boolean comDados = this.existeRegistrosBlocoD(notasTerceirosD100, conhecimentosD200, notasTerceirosD500);
                if (!flag) {
                    flag = this.gerarBlocoD001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoD010(p, emp.getPessoa().getComplemento().getCnpj(), w);
                    this.gerarBlocoD100(p, notasTerceirosD100, emp, w);
                    this.gerarBlocoD200(p, conhecimentosD200, emp, w);
                    this.gerarBlocoD500(p, notasTerceirosD500, emp, w);
                }
                ++contador;
            }
        }
        this.gerarBlocoD990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private void gerarBlocoD100(PrintWriter p, BlocoD notasTerceiros, Empresa emp, UtilWritterBlocoD w) {
        if (notasTerceiros != null) {
            Iterator<RegD100> iterator = notasTerceiros.getRegistrosD100().iterator();
            while (iterator.hasNext()) {
                RegD100 o;
                RegD100 r = o = iterator.next();
                w.writterRegD100NotasTerceiros(p, r, emp, this.cont, this.hashEmpresasPlanos);
                this.setObservacoesC500(r.getObsFaturamento(), emp);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        }
    }

    private void gerarBlocoD200(PrintWriter p, BlocoD conhecimentos, Empresa emp, UtilWritterBlocoD w) {
        if (conhecimentos != null) {
            Iterator<RegD200> iterator = conhecimentos.getRegistrosD200().iterator();
            while (iterator.hasNext()) {
                RegD200 o;
                RegD200 r = o = iterator.next();
                w.writterRegD200Conhecimentos(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoD500(PrintWriter p, BlocoD notasTerceiros, Empresa emp, UtilWritterBlocoD w) {
        if (notasTerceiros != null) {
            Iterator<RegD500> iterator = notasTerceiros.getRegistrosD500().iterator();
            while (iterator.hasNext()) {
                RegD500 o;
                RegD500 r = o = iterator.next();
                w.writterRegD500NotasTerceiros(p, r, emp, this.cont);
                this.setObservacoesC500(r.getObsFaturamento(), emp);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
        }
    }

    private File createWritterBlock9() throws IOException {
        File f = File.createTempFile("sped_bloco_9", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco9 w = new UtilWritterBloco9();
        this.gerarBloco9001(p, w);
        this.gerarBloco9900(p, w);
        this.gerarBloco9990(p, w);
        this.gerarBloco9999(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlock1(Date dataIn, Date dataFim, Empresa emp, HashMap h) throws IOException {
        File f = File.createTempFile("sped_bloco_1", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco1 w = new UtilWritterBloco1();
        Bloco1 bloco1900 = null;
        Boolean gerarBloco = (Boolean)h.get("Registro1900");
        if (gerarBloco.booleanValue()) {
            bloco1900 = new UtilBDBloco1900().getBloco1Reg1900(dataIn, dataFim, emp);
        }
        boolean comDados = bloco1900 != null && bloco1900.getRegistros1900() != null && !bloco1900.getRegistros1900().isEmpty();
        this.gerarBloco1001(p, comDados, w);
        if (comDados) {
            this.gerarBloco1900(p, bloco1900, w);
        }
        this.gerarBloco1990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockF(Date dataIn, Date dataFim, List empresas, SpedPisCofins vo) throws IOException {
        File f = File.createTempFile("sped_bloco_f", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoF w = new UtilWritterBlocoF();
        boolean comDados = false;
        boolean flag = false;
        int contador = 1;
        int nrEmpresas = empresas.size();
        for (Object o : empresas) {
            Empresa emp = (Empresa)o;
            BlocoF blocoF100 = null;
            BlocoF blocoF120 = new UtilBDBlocoF120().getRegistrosBlocoF120(emp, dataIn, dataFim);
            BlocoF blocoF130 = new UtilBDBlocoF130().getRegistrosBlocoF130(emp, dataIn, dataFim);
            BlocoF blocoF150 = null;
            BlocoF blocoF550 = null;
            BlocoF blocoF500 = null;
            if (vo.getIndicadorRegimeCumulativo() != null && vo.getIndicadorRegimeCumulativo().getCodigo().equals("2")) {
                blocoF550 = new UtilBDBlocoF550().getRegistrosBlocoF550(emp, dataIn, dataFim);
            } else {
                blocoF100 = new UtilBDBlocoF100().getLancamentosBlocoF100(emp, dataIn, dataFim);
                blocoF150 = new UtilBDBlocoF150().getRegistrosBlocoF150(vo);
            }
            BlocoF blocoF600 = new UtilBDBlocoF600().getRegistrosBlocoF600(vo);
            BlocoF blocoF700 = new UtilBDBlocoF700().getRegistrosBlocoF700(vo);
            comDados = this.existeRegistrosBlocoF(blocoF100, blocoF120, blocoF130, blocoF150, blocoF550, blocoF500, blocoF600, blocoF700);
            if (!flag) {
                flag = this.gerarBlocoF001(p, comDados, flag, contador, nrEmpresas, w);
            }
            if (comDados) {
                this.gerarBlocoF010(p, emp.getPessoa().getComplemento().getCnpj(), w);
                this.gerarBlocoF100(p, blocoF100, emp, w);
                this.gerarBlocoF120(p, blocoF120, w);
                this.gerarBlocoF130(p, blocoF130, emp, w);
                this.gerarBlocoF150(p, blocoF150, w);
                this.gerarBlocoF500(p, blocoF500, w);
                this.gerarBlocoF550(p, blocoF550, w);
                this.gerarBlocoF600(p, blocoF600, w);
                this.gerarBlocoF700(p, blocoF700, w);
            }
            ++contador;
        }
        this.gerarBlocoF990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockM(Date dataIn, Date dataFim, Empresa emp) throws IOException {
        File f = File.createTempFile("sped_bloco_m", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoM w = new UtilWritterBlocoM();
        boolean comDados = false;
        this.gerarBlocoM001(p, comDados, w);
        this.gerarBlocoM990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private void apendToSomeFile(String path, Date dataIn, Date dataFim, File bloco0, File blocoA, File blocoC, File blocoD, File blocoF, File blocoM, File bloco1, File bloco9, File blocoP) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(this.getFilePath(path, dataIn, dataFim));
        this.copy(bloco0, out);
        this.copy(blocoA, out);
        this.copy(blocoC, out);
        this.copy(blocoD, out);
        this.copy(blocoF, out);
        this.copy(blocoM, out);
        this.copy(blocoP, out);
        this.copy(bloco1, out);
        this.copy(bloco9, out);
        bloco0.delete();
        blocoC.delete();
        bloco9.delete();
        ((OutputStream)out).close();
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private void gerarBlocoA100NotaTerceiros(PrintWriter p, BlocoA notasTerceiros, Empresa emp, UtilWritterBlocoA w) {
        if (notasTerceiros != null) {
            Iterator<RegA100> iterator = notasTerceiros.getRegistrosA100().iterator();
            while (iterator.hasNext()) {
                RegA100 o;
                RegA100 r = o = iterator.next();
                w.writterRegA100NotasPropriasTerceiros(p, r, emp, this.cont);
                this.setObservacoesNotaA110(r.getObservacoes(), emp);
            }
            this.putProdutos(notasTerceiros.getProdutos(), emp);
            this.putParticpantes(notasTerceiros.getParticipantes(), emp);
            this.putUnidMedida(notasTerceiros.getUnidMedidas(), emp);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoA100NotaPropria(PrintWriter p, BlocoA notasProprias, Empresa emp, UtilWritterBlocoA w) {
        if (notasProprias != null) {
            Iterator<RegA100> iterator = notasProprias.getRegistrosA100().iterator();
            while (iterator.hasNext()) {
                RegA100 o;
                RegA100 r = o = iterator.next();
                w.writterRegA100NotasPropriasTerceiros(p, r, emp, this.cont);
                this.setObservacoesNotaA110(r.getObservacoes(), emp);
            }
        }
        this.putProdutos(notasProprias.getProdutos(), emp);
        this.putParticpantes(notasProprias.getParticipantes(), emp);
        this.putUnidMedida(notasProprias.getUnidMedidas(), emp);
        this.putPlanoContas(notasProprias.getPlanoContas());
    }

    private void writterA010(PrintWriter p, String cnpj) {
        p.append(this.separator + "A010");
        p.append(this.separator + this.form.clearString(cnpj));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("A010");
    }

    private void gerarBlocoF100(PrintWriter p, BlocoF blocoF, Empresa emp, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF100> iterator = blocoF.getRegistrosF100().iterator();
            while (iterator.hasNext()) {
                RegF100 o;
                RegF100 r = o = iterator.next();
                w.writterRegF100(p, r, this.cont);
            }
            this.putParticpantes(blocoF.getParticipantes(), emp);
            this.putProdutos(blocoF.getProdutos(), emp);
            this.putUnidMedida(blocoF.getUnidadeMedidas(), emp);
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void gerarBlocoF120(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF120> iterator = blocoF.getRegistrosF120().iterator();
            while (iterator.hasNext()) {
                RegF120 o;
                RegF120 r = o = iterator.next();
                w.writterRegF120(p, r, this.cont);
            }
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void gerarBlocoF130(PrintWriter p, BlocoF blocoF, Empresa emp, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF130> iterator = blocoF.getRegistrosF130().iterator();
            while (iterator.hasNext()) {
                RegF130 o;
                RegF130 r = o = iterator.next();
                w.writterRegF130(p, r, this.cont);
            }
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void gerarBlocoF150(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF150> iterator = blocoF.getRegistrosF150().iterator();
            while (iterator.hasNext()) {
                RegF150 o;
                RegF150 r = o = iterator.next();
                w.writterRegF150(p, r, this.cont);
                if (r.getPlanoConta() == null) continue;
                this.putPlanoContas(r.getPlanoConta());
            }
        }
    }

    private void gerarBlocoF500(PrintWriter p, BlocoF blocoF500, UtilWritterBlocoF w) {
        if (blocoF500 != null) {
            Iterator<RegF500> iterator = blocoF500.getRegistrosF500().iterator();
            while (iterator.hasNext()) {
                RegF500 o;
                RegF500 r = o = iterator.next();
                w.writterRegF500(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoF550(PrintWriter p, BlocoF blocoF550, UtilWritterBlocoF w) {
        if (blocoF550 != null) {
            Iterator<RegF550> iterator = blocoF550.getRegistrosF550().iterator();
            while (iterator.hasNext()) {
                RegF550 o;
                RegF550 r = o = iterator.next();
                w.writterRegF550(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoF600(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF600> iterator = blocoF.getRegistrosF600().iterator();
            while (iterator.hasNext()) {
                RegF600 o;
                RegF600 r = o = iterator.next();
                w.writterRegF600(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoF700(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF700> iterator = blocoF.getRegistrosF700().iterator();
            while (iterator.hasNext()) {
                RegF700 o;
                RegF700 r = o = iterator.next();
                w.writterRegF700(p, r, this.cont);
            }
        }
    }

    private HashMap getRegistrosGerados(SpedPisCofins vo) throws SpedPisCofinsWritterException {
        HashMap<String, Boolean> h = new HashMap<String, Boolean>();
        h.put("Bloco0", true);
        h.put("Bloco1", true);
        h.put("Bloco9", true);
        h.put("BlocoA", true);
        h.put("BlocoC", true);
        h.put("BlocoD", true);
        h.put("BlocoF", true);
        h.put("BlocoM", true);
        h.put("Registro1900", false);
        if (vo.getIndicadorRegimeCumulativo() != null) {
            if (vo.getIndicadorRegimeCumulativo().getCodigo().equals("1")) {
                throw new SpedPisCofinsWritterException("O sistema n\u00e3o contempla o regime cumulativo: Lucro Presumido - Regime de Caixa.");
            }
            if (vo.getIndicadorRegimeCumulativo().getCodigo().equals("2")) {
                h.put("BlocoA", false);
                h.put("BlocoC", false);
                h.put("BlocoD", false);
                h.put("BlocoF", true);
                h.put("BlocoM", true);
                h.put("Registro1900", true);
            }
        }
        return h;
    }

    private void gerarBloco1900(PrintWriter p, Bloco1 bloco1900, UtilWritterBloco1 w) {
        if (!bloco1900.getRegistros1900().isEmpty()) {
            Iterator<Reg1900> iterator = bloco1900.getRegistros1900().iterator();
            while (iterator.hasNext()) {
                Reg1900 o;
                Reg1900 r = o = iterator.next();
                w.writerReg1900(p, r, this.cont);
            }
        }
    }

    private boolean existeRegistrosBlocoC(BlocoC notasPropriasC100, BlocoC notasTerceirosC100, BlocoC notasPropriasC380, BlocoC notasTerceirosC395, BlocoC cuponsFiscaisC400, BlocoC notasTerceirosC500) {
        return notasPropriasC100 != null && notasPropriasC100.getRegistrosC100() != null && !notasPropriasC100.getRegistrosC100().isEmpty() || notasTerceirosC100 != null && notasTerceirosC100.getRegistrosC010() != null && !notasTerceirosC100.getRegistrosC010().isEmpty() || notasPropriasC380 != null && notasPropriasC380.getRegistrosC380() != null && !notasPropriasC380.getRegistrosC380().isEmpty() || notasTerceirosC395 != null && notasTerceirosC395.getRegistrosC395() != null && !notasTerceirosC395.getRegistrosC395().isEmpty() || cuponsFiscaisC400 != null && cuponsFiscaisC400.getRegistrosC400() != null && !cuponsFiscaisC400.getRegistrosC400().isEmpty() || notasTerceirosC500 != null && notasTerceirosC500.getRegistrosC500() != null && !notasTerceirosC500.getRegistrosC500().isEmpty();
    }

    private void gerarBlocoC010(PrintWriter p, String cnpj, UtilWritterBlocoC w) {
        w.writterC010(p, cnpj, this.cont);
    }

    private boolean existeRegistrosBlocoA(BlocoA notasServicoTercA100, BlocoA notasServicoPropA100) {
        return notasServicoTercA100 != null && notasServicoTercA100.getRegistrosA100() != null && !notasServicoTercA100.getRegistrosA100().isEmpty() || notasServicoPropA100 != null && notasServicoPropA100.getRegistrosA100() != null && !notasServicoPropA100.getRegistrosA100().isEmpty();
    }

    private void gerarBlocoA010(PrintWriter p, String cnpj) {
        this.writterA010(p, cnpj);
    }

    private boolean existeRegistrosBlocoD(BlocoD notasTerceirosD100, BlocoD conhecimentosD200, BlocoD notasTerceirosD500) {
        return notasTerceirosD100 != null && notasTerceirosD100.getRegistrosD100() != null && !notasTerceirosD100.getRegistrosD100().isEmpty() || notasTerceirosD500 != null && notasTerceirosD500.getRegistrosD500() != null && !notasTerceirosD500.getRegistrosD500().isEmpty() || conhecimentosD200 != null && conhecimentosD200.getRegistrosD200() != null && !conhecimentosD200.getRegistrosD200().isEmpty();
    }

    private void gerarBlocoD010(PrintWriter p, String cnpj, UtilWritterBlocoD w) {
        w.writterD010(p, cnpj, this.cont);
    }

    private boolean existeRegistrosBlocoF(BlocoF blocoF100, BlocoF blocoF120, BlocoF blocoF130, BlocoF blocoF150, BlocoF blocoF550, BlocoF blocoF500, BlocoF blocoF600, BlocoF blocoF700) {
        return blocoF100 != null && blocoF100.getRegistrosF100() != null && !blocoF100.getRegistrosF100().isEmpty() || blocoF120 != null && blocoF120.getRegistrosF120() != null && !blocoF120.getRegistrosF120().isEmpty() || blocoF130 != null && blocoF130.getRegistrosF130() != null && !blocoF130.getRegistrosF130().isEmpty() || blocoF150 != null && blocoF150.getRegistrosF150() != null && !blocoF150.getRegistrosF150().isEmpty() || blocoF600 != null && blocoF600.getRegistrosF600() != null && !blocoF600.getRegistrosF600().isEmpty() || blocoF700 != null && blocoF700.getRegistrosF700() != null && !blocoF700.getRegistrosF700().isEmpty() || blocoF550 != null && blocoF550.getRegistrosF550() != null && !blocoF550.getRegistrosF550().isEmpty() || blocoF500 != null && blocoF500.getRegistrosF500() != null && !blocoF500.getRegistrosF500().isEmpty();
    }

    private void gerarBlocoF010(PrintWriter p, String cnpj, UtilWritterBlocoF w) {
        w.writterF010(p, cnpj, this.cont);
    }

    private void gerarBloco0100(PrintWriter p, Empresa emp, UtilWritterBloco0 writter) throws SpedPisCofinsWritterException {
        EmpresaContabilidade contabilidade = new UtilBDBloco0().getEmpresaContabilidade(emp);
        if (contabilidade.getPessoa() == null) {
            throw new SpedPisCofinsWritterException("Informe o Contador respons\u00e1vel pela empresa.");
        }
        writter.writterReg0100(p, emp, contabilidade, this.cont);
    }

    private void gerarBloco0110(PrintWriter p, SpedPisCofins vo, UtilWritterBloco0 writter) {
        writter.writterReg0110(p, vo, this.cont);
    }

    private void gerarBloco0111(PrintWriter p, SpedPisCofins vo, UtilWritterBloco0 w) {
        w.writterReg0111(p, vo, this.cont);
    }

    private void gerarBloco0140(PrintWriter p, List empresas, Date dataIn, Date dataFim, Reg0145 reg0145, UtilWritterBloco0 w) throws ExceptionDatabase {
        w.writterReg0140(p, empresas, dataIn, dataFim, reg0145, this.cont, this.hashEmpresasParicipantes, this.hashEmpresasUnidades, this.hashEmpresasProdutos, this.hashEmpresasNaturezas, this.hashEmpresasObservacoes);
    }

    private void gerarBloco0500(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0500(p, this.cont, this.hashEmpresasPlanos);
    }

    private void gerarBloco0600(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0600(p, this.cont, this.hashEmpresasCentroCustos);
    }

    private void gerarBloco0990(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0990(p, this.cont);
    }

    private void gerarBloco0000(PrintWriter p, Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo, UtilWritterBloco0 w) {
        w.writterReg0000(p, dataIn, dataFim, emp, vo, this.cont);
    }

    private void gerarBloco0001(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0001(p, this.cont);
    }

    private void setObservacoesNotaA110(List<RegA110> observacoes, Empresa emp) {
        if (observacoes != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Iterator<RegA110> iterator = observacoes.iterator();
            while (iterator.hasNext()) {
                RegA110 o;
                RegA110 reg = o = iterator.next();
                Reg450 r = new Reg450();
                r.setDescricao(reg.getDescricao());
                r.setIdObservacao(reg.getIdObservacao());
                dados.add(r);
            }
            this.putObservacoes(dados, emp);
        }
    }

    private boolean getDocCanceladoOuInutilizado(String sitDoc) {
        return sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
    }

    private void setObservacoesC110(List<RegC110> observacoes, Empresa emp) {
        if (observacoes != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Iterator<RegC110> iterator = observacoes.iterator();
            while (iterator.hasNext()) {
                RegC110 o;
                RegC110 reg = o = iterator.next();
                Reg450 r = new Reg450();
                r.setDescricao(reg.getDescricao());
                r.setIdObservacao(reg.getIdObservacao());
                dados.add(r);
            }
            this.putObservacoes(dados, emp);
        }
    }

    private void setObservacoesC500(ObsFaturamento obsFaturamento, Empresa emp) {
        if (obsFaturamento != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(obsFaturamento.getIdentificador());
            reg450.setDescricao(obsFaturamento.getNome());
            dados.add(reg450);
            this.putObservacoes(dados, emp);
        }
    }

    private boolean gerarBlocoF001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoF w) {
        return w.writterF001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBloco1001(PrintWriter p, boolean comDados, UtilWritterBloco1 w) {
        w.writter1001(p, comDados, this.cont);
    }

    private void gerarBloco1990(PrintWriter p, UtilWritterBloco1 w) {
        w.writter1990(p, this.cont);
    }

    private void gerarBlocoF990(PrintWriter p, UtilWritterBlocoF w) {
        w.writterF990(p, this.cont);
    }

    private void gerarBlocoM001(PrintWriter p, boolean comDados, UtilWritterBlocoM w) {
        w.writterM001(p, comDados, this.cont);
    }

    private void gerarBlocoM990(PrintWriter p, UtilWritterBlocoM w) {
        w.writterM990(p, this.cont);
    }

    private void gerarBloco9001(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9001(p, this.cont);
    }

    private void gerarBloco9900(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9900(p, this.cont);
    }

    private void gerarBloco9990(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9990(p, this.cont);
    }

    private void gerarBloco9999(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9999(p, this.cont);
    }

    private boolean gerarBlocoA001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoA w) {
        return w.writerA001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoA990(PrintWriter p, UtilWritterBlocoA w) {
        w.writterA990(p, this.cont);
    }

    private boolean gerarBlocoC001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoC w) {
        return w.writerC001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoC990(PrintWriter p, UtilWritterBlocoC w) {
        w.writterC990(p, this.cont);
    }

    private boolean gerarBlocoD001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoD w) {
        return w.writterRegD001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoD990(PrintWriter p, UtilWritterBlocoD w) {
        w.writterD990(p, this.cont);
    }

    private Reg0145 getRegistr0145(PrintWriter p, List empresas, Date dataIn, Date dataFim, SpedPisCofins vo, UtilWritterBloco0 w, List codigosAtivEc) throws SpedPisCofinsWritterException, ExceptionDatabase {
        Reg0145 r = new UtilBDBloco0().getBloco0145(codigosAtivEc, dataIn, dataFim, vo.getIncidenciaTribContrPrev());
        return r;
    }

    private boolean gerarBlocoP001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoP w) {
        return w.writerP001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoP010(PrintWriter p, String cnpj, UtilWritterBlocoP w) {
        w.writterP010(p, cnpj, this.cont);
    }

    private Double gerarBlocoP100(PrintWriter p, BlocoP blocoP100, UtilWritterBlocoP w) {
        Double valorTotalApurado = w.writterP100(p, blocoP100.getRegistrosP100(), this.cont, 0.0);
        return valorTotalApurado;
    }

    private void gerarBlocoP990(PrintWriter p, UtilWritterBlocoP w) {
        w.writterP990(p, this.cont);
    }

    private void gerarBlocoP200(PrintWriter p, SpedPisCofins vo, Double valorTotalApurado, UtilWritterBlocoP w) {
        Double valorAjusteReducao = 0.0;
        Double valorAjusteAcrescimo = 0.0;
        ArrayList<RegP210> registrosP210 = new ArrayList<RegP210>();
        for (Object o : vo.getRegistrosP210()) {
            AjusteContribuicaoPrevidenciaPisCofins ajuste = (AjusteContribuicaoPrevidenciaPisCofins)o;
            RegP210 regP210 = new RegP210();
            regP210.setIndicadorAjuste(ajuste.getIndicadorAjuste());
            regP210.setDataReferencia(ajuste.getDataAjuste());
            regP210.setCodigoAjuste(ajuste.getCodigoAjuste().getCodigo());
            regP210.setDescricaoAjuste(ajuste.getDescricaoAjuste());
            regP210.setNumDoc(ajuste.getNrProcesso());
            regP210.setValorAjuste(ajuste.getValorAjuste());
            registrosP210.add(regP210);
            if (ajuste.getIndicadorAjuste().equals((short)0)) {
                valorAjusteReducao = valorAjusteReducao + ajuste.getValorAjuste();
                continue;
            }
            valorAjusteAcrescimo = valorAjusteAcrescimo + ajuste.getValorAjuste();
        }
        RegP200 r = new RegP200();
        r.setPeriodoReferencia(DateUtil.dateToStr(vo.getDataInicial(), "MMyyyy"));
        r.setValorTotalContApurado(valorTotalApurado);
        r.setValorTotalAjustesReducao(valorAjusteReducao);
        r.setValorTotalAjustesAcrescimo(valorAjusteAcrescimo);
        r.setValorTotalContDev(r.getValorTotalContApurado() - r.getValorTotalAjustesReducao() + r.getValorTotalAjustesAcrescimo());
        r.setCodigoReceita(vo.getCodigoReceitaContribuicaoPrevidenciaria().getCodigo() + "01");
        r.setRegistrosP210(registrosP210);
        w.writterP200(p, r, this.cont);
    }
}

