/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.bloco0;

import com.touchcomp.basementor.model.vo.CodigoAtividadeEcPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.LogProduto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg205;
import mentorcore.service.impl.spedpiscofins.versao003.model.bloco0.Reg0145;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class UtilBDBloco0 {
    public EmpresaContabilidade getEmpresaContabilidade(Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getEmpresaContabilidadeDAO().getVOClass());
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.setMaxResults(1);
        return (EmpresaContabilidade)c.uniqueResult();
    }

    public List getAlteracoesProduto(Long idProduto, Date dataIn, Date dataFim) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LogProduto l where l.produto.identificador=:idProduto and l.dataFimUtilDesc  between :dataIn and :dataFim and l.identificador=(select max(lp.identificador) from LogProduto lp  where lp.produto.identificador=:idProduto and lp.dataFimUtilDesc between :dataIn and :dataFim)");
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", DateUtil.previousDays(dataFim, 1));
        List ret = q.list();
        ArrayList<Reg205> toRet = new ArrayList<Reg205>();
        for (Object o : ret) {
            LogProduto l = (LogProduto)o;
            if (l.getDataFimUtilDesc() == null) {
                l.setDataFimUtilDesc(dataFim);
                l = this.salvarAtualizarLogProduto(l);
            }
            Reg205 r = new Reg205();
            r.setDescricaoAnterior(l.getConteudoAnterior());
            r.setDataInicial(l.getDataIniUtilDesc());
            r.setDataFinal(l.getDataFimUtilDesc());
            toRet.add(r);
        }
        return toRet;
    }

    private LogProduto salvarAtualizarLogProduto(LogProduto l) throws ExceptionDatabase {
        return (LogProduto)CoreDAOFactory.getInstance().getDAOLogProduto().saveOrUpdate(l);
    }

    public Reg0145 getBloco0145(List codigosAtivEc, Date dataIn, Date dataFim, Short codIncTributaria) throws ExceptionDatabase {
        Double valorReceitaTotal = this.getValorTotalReceitaBloco0145(dataIn, dataFim);
        Double ValorReceitaAtiv = this.getValorReceitaAtivBloco0145(dataIn, dataFim, codigosAtivEc);
        Reg0145 r = new Reg0145();
        r.setCodIncidenciaTributaria(codIncTributaria.toString());
        r.setValorReceitaTotal(valorReceitaTotal);
        r.setValorReceitaAtividades(ValorReceitaAtiv);
        if (r.getCodIncidenciaTributaria().equals("2")) {
            r.setValorReceitaDemaisAtividades(valorReceitaTotal - ValorReceitaAtiv);
        }
        return r;
    }

    private Double getValorTotalReceitaBloco0145(Date dataIn, Date dataFim) {
        Double valor = this.getValorReceitaTotalNotasBloco0145(dataIn, dataFim);
        valor = valor + this.getValorReceitaTotalCuponsBloco0145(dataIn, dataFim);
        valor = valor + this.getValorReceitaTotalOutrosLancamentosBloco0145(dataIn, dataFim);
        return valor;
    }

    public Double getValorReceitaAtivBloco0145(Date dataIn, Date dataFim, List codigosAtivEc) {
        Double valor = this.getValorReceitaAtivNotasBloco0145(dataIn, dataFim, codigosAtivEc);
        valor = valor + this.getValorReceitaAtivCuponsBloco0145(dataIn, dataFim, codigosAtivEc);
        valor = valor + this.getValorReceitaAtivOutrosLancamentosBloco0145(dataIn, dataFim, codigosAtivEc);
        return valor;
    }

    public List getCodigoAtividadeEcPisCofins(Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "from CodigoAtividadeEcPisCofins c  where c.dataInicialEscrituracao <= :dataIn    and c.dataFinalEscrituracao   >= :dataFim";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        return q.list();
    }

    private Double getValorReceitaTotalNotasBloco0145(Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.itemNotaLivroFiscal.valorTotal)  -  sum(i.itemNotaLivroFiscal.vrIpiIndustria + i.itemNotaLivroFiscal.vrIpiComercio)  -  sum(i.itemNotaLivroFiscal.vrIcmsSt) from ItemNotaFiscalPropria i  where i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and i.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped = :cfopReceitaVendaSped and i.itemNotaLivroFiscal.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5)";
        Query q = s.createQuery(hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("cfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        Double valorReceitaTotal = (Double)q.uniqueResult();
        if (valorReceitaTotal != null) {
            return valorReceitaTotal;
        }
        return 0.0;
    }

    private Double getValorReceitaTotalCuponsBloco0145(Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.valorTotal)  from ItemCupomFiscal i  where      i.cupomFiscal.cupom.dataMovimentacao between :dataIn and :dataFim  and i.cfop.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.cfop.cfopReceitaVendaSped = :cfopReceitaVendaSped and i.cancelado = :naoCancelado and i.cupomFiscal.cancelado = :naoCancelado";
        Query q = s.createQuery(hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("naoCancelado", (short)0);
        Double valorReceitaTotal = (Double)q.uniqueResult();
        if (valorReceitaTotal != null) {
            return valorReceitaTotal;
        }
        return 0.0;
    }

    private Double getValorReceitaTotalOutrosLancamentosBloco0145(Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.vrOper)  from LancamentoSpedPisCofins i  where i.dataOper between :dataIn and :dataFim ";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        Double valorReceitaTotal = (Double)q.uniqueResult();
        if (valorReceitaTotal != null) {
            return valorReceitaTotal;
        }
        return 0.0;
    }

    private Double getValorReceitaAtivNotasBloco0145(Date dataIn, Date dataFim, List codigosAtivEc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select sum(i.itemNotaLivroFiscal.valorTotal)  - sum(coalesce(i.itemNotaLivroFiscal.vrIpiIndustria,0) + coalesce(i.itemNotaLivroFiscal.vrIpiComercio,0))  - sum(coalesce(i.itemNotaLivroFiscal.vrIcmsSt,0)) from ItemNotaFiscalPropria i  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped   = :cfopReceitaVendaSped  and i.itemNotaLivroFiscal.cfop.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and (";
        int cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            hql = cont != codigosAtivEc.size() ? (String)hql + " ( i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + ")  or" : (String)hql + " ( i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + "))";
            ++cont;
        }
        Query q = s.createQuery((String)hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            q.setString("cod" + cont, c.getCodigo() + "%");
            ++cont;
        }
        Double valorReceitaAtiva = (Double)q.uniqueResult();
        if (valorReceitaAtiva != null) {
            return valorReceitaAtiva;
        }
        return 0.0;
    }

    private Double getValorReceitaAtivCuponsBloco0145(Date dataIn, Date dataFim, List codigosAtivEc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select sum(i.valorTotal)  from ItemCupomFiscal i  where      i.cfop.cfopReceitaVendaSped = :cfopReceitaVendaSped  and i.cfop.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.cupomFiscal.cupom.dataMovimentacao between :dataIn and :dataFim  and i.cancelado = :naoCancelado and i.cupomFiscal.cancelado = :naoCancelado  and (";
        int cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            hql = cont != codigosAtivEc.size() ? (String)hql + " ( i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + ")  or" : (String)hql + " ( i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + "))";
            ++cont;
        }
        Query q = s.createQuery((String)hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("naoCancelado", (short)0);
        cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            q.setString("cod" + cont, c.getCodigo() + "%");
            ++cont;
        }
        Double valorReceitaAtiva = (Double)q.uniqueResult();
        if (valorReceitaAtiva != null) {
            return valorReceitaAtiva;
        }
        return 0.0;
    }

    private Double getValorReceitaAtivOutrosLancamentosBloco0145(Date dataIn, Date dataFim, List codigosAtivEc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select sum(i.vrOper)  from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim  and (";
        int cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            hql = cont != codigosAtivEc.size() ? (String)hql + " ( i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + ")  or" : (String)hql + " ( i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + "))";
            ++cont;
        }
        Query q = s.createQuery((String)hql);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            q.setString("cod" + cont, c.getCodigo() + "%");
            ++cont;
        }
        Double valorReceitaAtiva = (Double)q.uniqueResult();
        if (valorReceitaAtiva != null) {
            return valorReceitaAtiva;
        }
        return 0.0;
    }

    public Empresa findEmpresaPorEmpresaDados(EmpresaDados empresaDados) throws ExceptionService {
        Empresa empresa = (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empresaDados, 0);
        return empresa;
    }
}

