/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocoa;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.TokenObsIntFisco;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA110;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA170;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoA100NotaPropria {
    public BlocoA getBlocoA100NotasServico(Date dataIn, Date dataFim, Empresa emp) {
        BlocoA b = new BlocoA();
        b.setRegistrosA100(this.getNotasPropriasBloco100(dataIn, dataFim, emp));
        if (b.getRegistrosA100() != null && !b.getRegistrosA100().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotasPropriasBlocoA100Internal(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotaPropria(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaPropriaBlocoA100(dataIn, dataFim, emp));
            b.setUnidMedidas(this.getUnidMedidasNotasPropriasBlocoA100(dataIn, dataFim, emp));
        }
        return b;
    }

    private List getNotasPropriasBloco100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, n.naturezaOperacao.entradaSaida as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatCliente.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissaoNota as dataEmissao, n.dataEntradaSaida as dataEntSai, n.valoresNfPropria.valorTotal as valorTotal, cp.tpCondicao as tpCond, n.valoresNfPropria.valorDesconto as valorDesconto, n.valoresNfPropria.valorPis as valorPis, n.valoresNfPropria.valorCofins as valorCofins, n.valoresNfPropria.valorCofinsSt as valorCofinsST, n.valoresNfPropria.valorPisSt as valorPisST, n.valoresNfPropria.valorIss as valorIss from NotaFiscalPropria n  left join n.condicaoPagamento cp where (n.modeloDocFiscal.codigo=:cod1) and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2)  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA100> toRet = new ArrayList<RegA100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegA100 r = new RegA100();
            r.setIdentificador((Long)h.get("identificador"));
            r.setTipoOperacao(1);
            r.setIndTipoEmitente(0);
            Integer nrNota = (Integer)h.get("numNota");
            r.setNumeroDoc(nrNota.longValue());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorCofinsRetido((Double)h.get("valorCofinsST"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorPisRetido((Double)h.get("valorPisST"));
            r.setValorIss((Double)h.get("valorIss"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("valorTotal"));
            r.setObservacoes(this.getObservacoesNotaPropriaBlocoA110(r.getIdentificador()));
            r.setItensDocumento(this.getItensNotaPropriaBlocoA170(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List getParticipantesNotasPropriasBlocoA100Internal(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from NotaFiscalPropria n  inner join n.unidadeFatCliente u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        return participantes;
    }

    private List<RegA110> getObservacoesNotaPropriaBlocoA110(Long idNota) {
        ObservacaoIntFiscalNotaFiscalPropria ob;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select n.observacaoIntFiscalNotaFiscalPropria as obsIntFisco from NotaFiscalPropria n  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA110> toRet = new ArrayList<RegA110>();
        ArrayList<Long> temp = new ArrayList<Long>();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoIntFiscalNotaFiscalPropria)h.get("obsIntFisco");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            Object comp = "";
            for (Object obj : ob.getTokens()) {
                TokenObsIntFisco t = (TokenObsIntFisco)obj;
                comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
            }
            RegA110 r = new RegA110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto((String)comp);
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        hql = "select n.observacaoNota as obsEstNota from NotaFiscalPropria n  where n.identificador  = :idNota";
        q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoNotaPropria)h.get("obsEstNota");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            RegA110 r = new RegA110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto(ob.getConteudo());
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        return toRet;
    }

    private List<RegA170> getItensNotaPropriaBlocoA170(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, nat.codigo as codNatBcCredito, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, n.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalPropria n inner join n.itensNotaPropria p left join p.naturezaBCCredito nat left join p.planoContaCred pCred where n.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA170> toRet = new ArrayList<RegA170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA170 r = new RegA170();
            Long idProduto = (Long)h.get("idProduto");
            r.setCodigoItem(idProduto.toString());
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodBCCredito((String)h.get("codNatBcCredito"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((Double)h.get("BCGeral"));
            r.setValorAliqPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((Double)h.get("BCGeral"));
            r.setValorAliqCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setCodContaAnalitica((String)h.get("planoContaCred"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getProdutosNotaPropria(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaCred.identificador as idPlanoCred, i.planoContaCred.dataCadastro as dataCadastroCred, i.planoContaCred.marca as marcaCred, i.planoContaCred.codigo as codContaCred, i.planoContaCred.descricao as descricaoContaCred, i.planoContaCred.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoCred");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasPropriasBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }
}

