/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocoa;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.TokenObsIntFiscoNFTerceiros;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA110;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA111;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocoa.RegA170;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoA100NotaTerceiros {
    public BlocoA getBlocoA100NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoA b = new BlocoA();
        b.setRegistrosA100(this.getNotasTerceirosBlocoA100(dataIn, dataFim, emp));
        if (b.getRegistrosA100() != null && !b.getRegistrosA100().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotasTerceirosBlocoA100(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotasTerceirosBlocoA100(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoA100(dataIn, dataFim, emp));
            b.setUnidMedidas(this.getUnidMedidasNotaTerceirosBlocoA100(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegA100> getNotasTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador,0 as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, cp.tpCondicao as tpCond, n.valoresNfTerceiros.valorDesconto as valorDesconto, n.valoresNfTerceiros.valorPis as valorPis, n.valoresNfTerceiros.valorCofins as valorCofins, n.valoresNfTerceiros.valorCofinsST as valorCofinsST, n.valoresNfTerceiros.valorPisSt as valorPisST, n.valoresNfTerceiros.valorIss as valorIss from NotaFiscalTerceiros n  left join n.condicoesPagamento cp where (n.modeloDocFiscal.codigo=:cod1) and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2)  and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins > 0 )");
        q.setString("cod1", "99");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA100> toRet = new ArrayList<RegA100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegA100 r = new RegA100();
            r.setIdentificador((Long)h.get("identificador"));
            r.setTipoOperacao(0);
            r.setIndTipoEmitente(1);
            Integer nrNota = (Integer)h.get("numNota");
            r.setNumeroDoc(nrNota.longValue());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorCofinsRetido((Double)h.get("valorCofinsST"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorPisRetido((Double)h.get("valorPisST"));
            r.setValorIss((Double)h.get("valorIss"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("valorTotal"));
            r.setObservacoes(this.getObservacoesNotaTerceirosBlocoA110(r.getIdentificador()));
            r.setProcReferenciados(this.getProcReferenciadosBlocoA111(r.getIdentificador()));
            r.setItensDocumento(this.getItensNotaTerceirosBlocoA170(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins > 0 )");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        return participantes;
    }

    private List<RegA170> getItensNotaTerceirosBlocoA170(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, nat.codigo as codNatBcCredito, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pDeb.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p left join p.naturezaBCCredito nat left join p.planoContaDeb pDeb where n.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA170> toRet = new ArrayList<RegA170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA170 r = new RegA170();
            Long idProduto = (Long)h.get("idProduto");
            r.setCodigoItem(idProduto.toString());
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodBCCredito((String)h.get("codNatBcCredito"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((double)((Double)h.get("BCGeral")));
            r.setValorAliqPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((double)((Double)h.get("vrPis")));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((double)((Double)h.get("BCGeral")));
            r.setValorAliqCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((double)((Double)h.get("vrCofins")));
            r.setCodContaAnalitica((String)h.get("planoContaDeb"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1)  and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa = :empresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins > 0 )");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaCred.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins > 0 )");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaTerceirosBlocoA100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEntrada between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa = :empresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins > 0 )");
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "99");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegA110> getObservacoesNotaTerceirosBlocoA110(Long idNota) {
        ObservacaoIntFiscoNFTerceiros ob;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select n.observacoesIntFisco as obsIntFisco from NotaFiscalTerceiros n  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA110> toRet = new ArrayList<RegA110>();
        ArrayList<Long> temp = new ArrayList<Long>();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoIntFiscoNFTerceiros)h.get("obsIntFisco");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            Object comp = "";
            for (Object obj : ob.getTokens()) {
                TokenObsIntFiscoNFTerceiros t = (TokenObsIntFiscoNFTerceiros)obj;
                comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
            }
            RegA110 r = new RegA110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto((String)comp);
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        hql = "select n.observacaoNotaTerceiros as obsEstNota from NotaFiscalTerceiros n  where n.identificador  = :idNota";
        q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoNotaTerceiros)h.get("obsEstNota");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            RegA110 r = new RegA110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto(ob.getConteudo());
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        return toRet;
    }

    private List<RegA111> getProcReferenciadosBlocoA111(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalTerceiros n  inner join n.processosReferenciados p where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA111> toRet = new ArrayList<RegA111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA111 r = new RegA111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        return toRet;
    }
}

