/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.TokenObsIntFiscoNFTerceiros;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg140;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.RegCNPJ;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC010;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC111;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC170;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC100NotaTerceiros {
    public BlocoC getBlocoC100NotasTerceiros(Date dataIn, Date dataFim, Empresa emp, List<IncidenciaPisCofins> incidenciasExcluidas) {
        BlocoC b = new BlocoC();
        b.setRegistrosC010(this.getCnpjFornecedoresNotaTerceirosBlocoC100(dataIn, dataFim, emp, incidenciasExcluidas));
        if (b.getRegistrosC010() != null && !b.getRegistrosC010().isEmpty()) {
            this.getParticipantesNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp, b);
            b.setProdutos(this.getProdutosNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp));
            b.setNatOperacao(this.getNatOperacaoNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp));
            b.setUnidadeMedidas(this.getUnidMedidasNotasTerceirosBlocoC100(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoC100(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegC010> getCnpjFornecedoresNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<IncidenciaPisCofins> incidenciasExcluidas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct n.unidadeFatFornecedor.pessoa.complemento.cnpj as cnpj from NotaFiscalTerceiros n  where n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or (n.modeloDocFiscal.codigo=:cod4 and (not exists(select it.identificador from ItemNotaTerceiros it  where it.notaFiscalTerceiros = n  and it.itemNotaLivroFiscal.cfop.cfopEnergiaEletrica = :sim  ";
        int count = 1;
        if (incidenciasExcluidas != null && !incidenciasExcluidas.isEmpty()) {
            hql = (String)hql + "and (";
            for (IncidenciaPisCofins i : incidenciasExcluidas) {
                hql = count == 1 ? (String)hql + " it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'" : (String)hql + " and it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'";
                ++count;
            }
            hql = (String)hql + ")";
        }
        hql = (String)hql + "))))";
        Query q = s.createQuery((String)hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC010> toRet = new ArrayList<RegC010>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC010 r = new RegC010();
            r.setCnpj((String)h.get("cnpj"));
            r.setRegistrosC100(this.getNotasFiscaisTerceirosBlocoC100(dataIn, dataFim, emp, r.getCnpj()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC100> getNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select 0 as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as cnpj, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfTerceiros.valorFrete as vlrFrete, n.valoresNfTerceiros.valorSeguro as vlrSeguro, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorDespAcess as vlrDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorIcmsSt as vlrIcmsSt, n.valoresNfTerceiros.bcIcmsSt as bcIcmsSt, n.valoresNfTerceiros.valorIpiIndustria as vlrIpi, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, n.valoresNfTerceiros.valorCofinsST as vlrCofinsST, n.valoresNfTerceiros.valorPisSt as vlrPisST, n.identificador as identificador from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.condicoesPagamento cp where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4)and  n.dataEntrada between :dataIn and :dataFim and  n.empresa=:empresa and  n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj = :cnpj  and (n.valoresNfTerceiros.valorCofins > 0 or n.valoresNfTerceiros.valorPis > 0)");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("cnpj", cnpj);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        ArrayList<String> temp = new ArrayList<String>();
        ArrayList<RegCNPJ> listaCNPJ = new ArrayList<RegCNPJ>();
        for (Object o : ret) {
            String sitDoc;
            boolean docCancInut;
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Terceiros: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setEntSaiNatOP(0);
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(1);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setCnpj((String)h.get("cnpj"));
            if (!temp.contains(r.getCnpj())) {
                temp.add(r.getCnpj());
                RegCNPJ rc = new RegCNPJ();
                rc.setCnpj(r.getCnpj());
                listaCNPJ.add(rc);
            }
            boolean bl = docCancInut = (sitDoc = r.getCodSituacaoDoc()).equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (!docCancInut) {
                r.setObservacoes(this.getObservacoesBlocoC100(r.getIdentificador()));
                r.setProcessosReferenciados(this.getProcessosReferenciadosBlocoC100(r.getIdentificador()));
                r.setItensDocumento(this.getItensDocumentoNotaTerceirosBlocoC100(r.getIdentificador()));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC111> getProcessosReferenciadosBlocoC100(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getParticipantesNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp, BlocoC b) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        ArrayList<Reg140> estabelecimentos = new ArrayList<Reg140>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        b.setParticipantes(participantes);
        b.setEstabelecimentos(estabelecimentos);
    }

    private List<RegC170> getItensDocumentoNotaTerceirosBlocoC100(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.quantidadeTotal as quantidade, p.unidadeMedida.sigla as sigla, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, p.modeloFiscal.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, p.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrBCPis as bcPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrBCCofins as bcCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, pDeb.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p  left join p.planoContaCred pCred left join p.planoContaDeb pDeb where n.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setMovimentacaoFisica((Short)h.get("movimentacaoFisica"));
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            if (r.getAliqPis() > 0.0) {
                r.setVlrBCPis((Double)h.get("bcPis"));
            }
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            if (r.getAliqCofins() > 0.0) {
                r.setBcCofins((Double)h.get("bcCofins"));
            }
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotasFiscaisTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.naturezaOperacao.identificador as idNatOperacao, i.naturezaOperacao.descricao as descNatOperacao from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC110> getObservacoesBlocoC100(Long idNota) {
        ObservacaoIntFiscoNFTerceiros ob;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct n.observacoesIntFisco as obsIntFisco from NotaFiscalTerceiros n  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        ArrayList<Long> temp = new ArrayList<Long>();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoIntFiscoNFTerceiros)h.get("obsIntFisco");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            Object comp = "";
            for (Object obj : ob.getTokens()) {
                TokenObsIntFiscoNFTerceiros t = (TokenObsIntFiscoNFTerceiros)obj;
                comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
            }
            RegC110 r = new RegC110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto((String)comp);
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        hql = "select distinct n.observacaoNotaTerceiros as obsEstNota from NotaFiscalTerceiros n  where n.identificador  = :idNota";
        q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoNotaTerceiros)h.get("obsEstNota");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            RegC110 r = new RegC110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto(ob.getConteudo());
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

