/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.TokenObsIntFisco;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC111;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC170;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC100NotasPropria {
    public BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, Empresa emp, List<IncidenciaPisCofins> incidenciasExcluidas) {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp, incidenciasExcluidas));
        if (b.getRegistrosC100() != null && !b.getRegistrosC100().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
            b.setNatOperacao(this.getNatOperacaoNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
            b.setUnidadeMedidas(this.getUnidMedidasNotasPropriasBlocoC100(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaPropriaBlocoC100(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegC100> getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<IncidenciaPisCofins> incidenciasExcluidas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select n.naturezaOperacao.entradaSaida as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatCliente.pessoa.identificador as idPessoa, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissaoNota as dataEmissao, n.dataEntradaSaida as dataEntSai, n.valoresNfPropria.valorTotal as valorTotal, n.valoresNfPropria.valorProduto + n.valoresNfPropria.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfPropria.valorFrete as vlrFrete, n.valoresNfPropria.valorSeguro as vlrSeguro, n.valoresNfPropria.valorDesconto as vlrDesconto, n.valoresNfPropria.valorDespAcess as vlrDespAcess, n.valoresNfPropria.valorIcmsTributado as bcIcms, n.valoresNfPropria.valorIcms as vlrIcms, n.valoresNfPropria.valorIcmsSt as vlrIcmsSt, n.valoresNfPropria.bcIcmsSt as bcIcmsSt, n.valoresNfPropria.valorIpiIndustria as vlrIpi, n.valoresNfPropria.valorPis as vlrPis, n.valoresNfPropria.valorCofins as vlrCofins, n.valoresNfPropria.valorCofinsSt as vlrCofinsST, n.valoresNfPropria.valorPisSt as vlrPisST, n.identificador as identificador from NotaFiscalPropria n  inner join n.dadosTransNfPropria d left join d.tipoFrete tf left join n.condicaoPagamento cp where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped  ";
        int count = 1;
        if (incidenciasExcluidas != null && !incidenciasExcluidas.isEmpty()) {
            hql = (String)hql + "and (";
            for (IncidenciaPisCofins i : incidenciasExcluidas) {
                hql = count == 1 ? (String)hql + " it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'" : (String)hql + " and it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'";
                ++count;
            }
            hql = (String)hql + ")";
        }
        hql = (String)hql + "))";
        Query q = s.createQuery((String)hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            boolean docCancInut;
            HashMap h = (HashMap)o;
            Short entradaSaida = (Short)h.get("entSai");
            Double valorPis = (Double)h.get("vlrPis");
            Double valorCofins = (Double)h.get("vlrCofins");
            if (!entradaSaida.equals((short)1) && (!entradaSaida.equals((short)2) || !(valorPis > 0.0) && !(valorCofins > 0.0))) continue;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Propria: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            if (entradaSaida.equals((short)2)) {
                r.setEntSaiNatOP(0);
            } else {
                r.setEntSaiNatOP(1);
            }
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            if ((Date)h.get("dataEntSai") != null) {
                r.setDataEntSaida((Date)h.get("dataEntSai"));
            } else {
                r.setDataEntSaida(r.getDataEmissao());
            }
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            String sitDoc = r.getCodSituacaoDoc();
            boolean bl = docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (!docCancInut) {
                r.setObservacoes(this.getObservacoesBlocoC100(r.getIdentificador()));
                r.setProcessosReferenciados(this.getProcessosReferenciadosBlocoC100(r.getIdentificador()));
                r.setItensDocumento(this.getItensDocumentoNotaPropriaBlocoC100(r.getIdentificador()));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalPropria n  inner join n.unidadeFatCliente u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped )) ");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC111> getProcessosReferenciadosBlocoC100(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalPropria n inner join n.grupoDocumentosRefPR g  inner join g.processosReferenciados d  inner join d.processoFiscal p  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC170> getItensDocumentoNotaPropriaBlocoC100(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.quantidadeTotal as quantidade, p.unidadeMedida.sigla as sigla, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, p.modeloFiscal.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, n.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrBCPis as bcPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrBCCofins as bcCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, pDeb.codigo as planoContaDeb, n.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalPropria n inner join n.itensNotaPropria p left join p.planoContaCred pCred left join p.planoContaDeb pDeb where n.identificador  = :idNota order by p.numeroItem");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            if (h.get("movimentacaoFisica") != null) {
                Short movimentacaoFisica = (Short)h.get("movimentacaoFisica");
                if (movimentacaoFisica.equals((short)1)) {
                    r.setMovimentacaoFisica((short)0);
                } else {
                    r.setMovimentacaoFisica((short)1);
                }
            } else {
                r.setMovimentacaoFisica((short)1);
            }
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            if (r.getAliqPis() > 0.0) {
                r.setVlrBCPis((Double)h.get("bcPis"));
            }
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            if (r.getAliqCofins() > 0.0) {
                r.setBcCofins((Double)h.get("bcCofins"));
            }
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g where  (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped )) ");
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.naturezaOperacao.identificador as idNatOperacao, n.naturezaOperacao.descricao as descNatOperacao from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped )) ");
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped )) ");
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        ArrayList<Reg500> obj = new ArrayList<Reg500>();
        obj.addAll(this.getPlanoContasNotaPropriaFatEntBlocoC100(dataIn, dataFim, emp));
        obj.addAll(this.getPlanoContasNotaPropriaFatSaiBlocoC100(dataIn, dataFim, emp));
        return obj;
    }

    private List<Reg500> getPlanoContasNotaPropriaFatEntBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.naturezaOperacao.entradaSaida=:ent and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped )) ");
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setShort("ent", (short)2);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaFatSaiBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaCred.identificador as idPlanoCred, i.planoContaCred.dataCadastro as dataCadastroCred, i.planoContaCred.marca as marcaCred, i.planoContaCred.codigo as codContaCred, i.planoContaCred.descricao as descricaoContaCred, i.planoContaCred.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.naturezaOperacao.entradaSaida=:sai and (exists(select it.identificador from ItemNotaFiscalPropria it  where it.notaFiscalPropria = n  and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :cfopReceitaVendaSped )) ");
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setShort("sai", (short)1);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC110> getObservacoesBlocoC100(Long idNota) {
        ObservacaoIntFiscalNotaFiscalPropria ob;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct n.observacaoIntFiscalNotaFiscalPropria as obsIntFisco from NotaFiscalPropria n  where n.identificador  = :idNota";
        Query q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        ArrayList<Long> temp = new ArrayList<Long>();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoIntFiscalNotaFiscalPropria)h.get("obsIntFisco");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            Object comp = "";
            for (Object obj : ob.getTokens()) {
                TokenObsIntFisco t = (TokenObsIntFisco)obj;
                comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
            }
            RegC110 r = new RegC110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto((String)comp);
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        hql = "select distinct n.observacaoNota as obsEstNota from NotaFiscalPropria n  where n.identificador  = :idNota";
        q = s.createQuery(hql);
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object o : ret) {
            h = (HashMap)o;
            ob = (ObservacaoNotaPropria)h.get("obsEstNota");
            if (temp.contains(ob.getObsFaturamento().getIdentificador())) continue;
            RegC110 r = new RegC110();
            r.setDescricao(ob.getObsFaturamento().getNome());
            r.setIdObservacao(ob.getObsFaturamento().getIdentificador());
            r.setTexto(ob.getConteudo());
            toRet.add(r);
            temp.add(ob.getObsFaturamento().getIdentificador());
        }
        return toRet;
    }
}

