/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC395;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC396;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC395NotaTerceiros {
    public BlocoC getBlocoC395NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC395(this.getNotasFiscaisTerceirosBlocoC395(dataIn, dataFim, emp));
        if (b.getRegistrosC395() != null && !b.getRegistrosC395().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotasTerceirosBlocoC395(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotasFiscaisTerceirosBlocoC395(dataIn, dataFim, emp));
            b.setUnidadeMedidas(this.getUnidMedidasNotasFiscaisTerceirosBlocoC395(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasNotaTerceirosBlocoC395(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegC395> getNotasFiscaisTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.identificador as idNota, n.modeloDocFiscal.codigo as codModDocFiscal, n.unidadeFatFornecedor.pessoa.identificador as idPessoa, n.serie as serie, n.numeroNota as numeroNota, n.dataEmissao as dataEmissao, n.valoresNfTerceiros.valorTotal as valorTotal from NotaFiscalTerceiros n  where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or  n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4) and  n.dataEmissao between :dataIn and :dataFim and  n.empresa=:empresa and   (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC395> toRet = new ArrayList<RegC395>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC395 r = new RegC395();
            r.setIdentificador((Long)h.get("idNota"));
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setSerie((String)h.get("serie"));
            r.setNumeroNota((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setItensNota(this.getItensNotaTerceirosBlocoC396(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC396> getItensNotaTerceirosBlocoC396(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.produto.identificador as idProduto, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.vrBCPis as vrBCPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, p.itemNotaLivroFiscal.vrBCCofins as vrBCCofins, pc.codigo as planoContaCred, pd.codigo as planoContaDeb, p.naturezaOperacao.entradaSaida as entSaida, nat.codigo as codBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p left join p.planoContaCred pc left join p.planoContaDeb pd left join p.naturezaBCCredito nat where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC396> toRet = new ArrayList<RegC396>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC396 r = new RegC396();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((Double)h.get("vrBCPis"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((Double)h.get("vrBCCofins"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            r.setEntSaiNatOperacao((Short)h.get("entSaida"));
            r.setCodBCCred((String)h.get("codBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg150> getParticipantesNotasTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasFiscaisTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            if (r.getIdUnidMedida().equals((Long)h.get("idUnidMedidaProd"))) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBlocoC395(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setString("cod3", "2E");
        q.setString("cod4", "59");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

