/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC400;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC405;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC481;
import mentorcore.service.impl.spedpiscofins.versao003.model.blococ.RegC485;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC400CupomFiscal {
    public BlocoC getBlocoC400CuponsFiscais(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC400(this.getEquipamentosFiscaisBlocoC400(dataIn, dataFim, emp));
        if (b.getRegistrosC400() != null && !b.getRegistrosC400().isEmpty()) {
            this.getReducoesZBlocoC405(b.getRegistrosC400(), dataIn, dataFim, emp);
            b.setProdutos(this.getProdutosReducoesC400(dataIn, dataFim, emp));
            b.setUnidadeMedidas(this.getUnidMedidasReducoesC400(dataIn, dataFim, emp));
            b.setPlanoContas(this.getPlanoContasReducoesC400(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegC400> getEquipamentosFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c.modeloDocFiscal.codigo as codModDocFiscal, c.cupom.impressoraFiscal.modeloEcf as modeloImpressora, c.cupom.impressoraFiscal.serie as serieImpressora, c.cupom.impressoraFiscal.identificador as idImpressora from CupomFiscal c where c.cupom.dataEmissao between :dataIn and :dataFim  and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and c.cupom.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC400> toRet = new ArrayList<RegC400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC400 r = new RegC400();
            r.setModeloDocFiscal((String)h.get("codModDocFiscal"));
            r.setModeloECF((String)h.get("modeloImpressora"));
            r.setSerieECF((String)h.get("serieImpressora"));
            r.setIdImpressora((Long)h.get("idImpressora"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getReducoesZBlocoC405(List<RegC400> registrosC400, Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC400> iterator = registrosC400.iterator();
        while (iterator.hasNext()) {
            RegC400 o;
            RegC400 r = o = iterator.next();
            Long idImpressora = r.getIdImpressora();
            Query q = s.createQuery("select distinct p.dataEmissao as dataEmissao, p.contadorReinicio as contadorReinicio,  p.contadorCRZ as contadorCRZ,  p.ultimoCOO as ultimoCOO, p.valorTotalGeral as valorTotal, p.valorVendaBruta as valorVendaBruta, p.identificador as idReducaoZ,  p.valorCancelamentoICMS as vrCanc, p.valorDescontoICMS as vrDesc, p.valorAcrescimoICMS as vrAcres from ReducaoZ p where p.dataEmissao between :dataIn and :dataFim and p.empresa=:empresa and p.impressoraFiscal.identificador = :idImpressora");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setLong("idImpressora", idImpressora.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegC405> toRet = new ArrayList<RegC405>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegC405 rC405 = new RegC405();
                rC405.setDataMovimento((Date)h.get("dataEmissao"));
                rC405.setContadorCRZ((Long)h.get("contadorCRZ"));
                rC405.setUltimoCOO((Long)h.get("ultimoCOO"));
                rC405.setContadorReinicio((Long)h.get("contadorReinicio"));
                rC405.setValorTotalGeral((Double)h.get("valorTotal"));
                rC405.setValorVendaBruta((Double)h.get("valorVendaBruta"));
                rC405.setIdReducaoZ((Long)h.get("idReducaoZ"));
                rC405.setVrCancelamentoIcms((Double)h.get("vrCanc"));
                rC405.setVrDescontoIcms((Double)h.get("vrDesc"));
                rC405.setVrAcrescimoIcms((Double)h.get("vrAcres"));
                System.out.println("Bloco C... Cupons Fiscais do dia: " + DateUtil.dateToStr(rC405.getDataMovimento()));
                this.getPisCofinsBlocoC481_485(idImpressora, rC405.getDataMovimento(), rC405);
                toRet.add(rC405);
            }
            r.setReducoes(toRet);
        }
    }

    private void getPisCofinsBlocoC481_485(Long idImpressora, Date dataReducao, RegC405 rC405) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  i.incidPisCofins.codigo as codIncidenciaPisCofins, sum(i.bcPis) as BcPis, sum(i.bcCofins) as BcCofins, sum(i.valorFinal) as valorTotal, i.aliqPis as aliquotaPis, i.aliqCofins as aliquotaCofins, sum(i.vrPis) as valorPis, sum(i.vrCofins) as valorCofins, p.identificador as idProduto, pc.codigo as planoConta from ItemCupomFiscal i inner join i.produto p left  join p.planoConta pc  where i.cupomFiscal.cupom.dataEmissao = :dataReducao and i.cupomFiscal.cupom.impressoraFiscal.identificador = :idImpressora and (i.cupomFiscal.modeloDocFiscal.codigo = :cod1 or i.cupomFiscal.modeloDocFiscal.codigo = :cod2) and i.cancelado = :cancelado and i.cupomFiscal.cancelado = :cancelado group by  i.incidPisCofins.codigo,  i.aliqPis, i.aliqCofins, p.identificador, pc.codigo";
        Query q = s.createQuery(hql);
        q.setLong("idImpressora", idImpressora.longValue());
        q.setDate("dataReducao", dataReducao);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC481> toRetPis = new ArrayList<RegC481>();
        ArrayList<RegC485> toRetCofins = new ArrayList<RegC485>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC481 r1 = new RegC481();
            RegC485 r2 = new RegC485();
            r1.setCodItem((Long)h.get("idProduto"));
            r2.setCodItem((Long)h.get("idProduto"));
            r1.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r2.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r1.setAliquotaPis((Double)h.get("aliquotaPis"));
            r2.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r1.setValorPis((Double)h.get("valorPis"));
            r2.setValorCofins((Double)h.get("valorCofins"));
            r1.setValorItem((Double)h.get("valorTotal"));
            r2.setValorItem((Double)h.get("valorTotal"));
            r1.setValoBCPis((Double)h.get("BcPis"));
            r2.setValoBCCofins((Double)h.get("BcCofins"));
            if ((String)h.get("planoConta") != null) {
                r1.setPlanoCred((String)h.get("planoConta"));
                r2.setPlanoCred((String)h.get("planoConta"));
            }
            toRetPis.add(r1);
            toRetCofins.add(r2);
        }
        rC405.setPis(toRetPis);
        rC405.setCofins(toRetCofins);
    }

    private List<RegC481> getPisBlocoC481(Long idImpressora, Date dataReducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  i.incidPisCofins.codigo as codIncidenciaPis, sum(i.bcPis) as BcPis, sum(i.valorTotal) as valorTotal, i.aliqPis as aliquotaPis, sum(i.vrPis) as valorPis, p.identificador as idProduto, pc.codigo as planoConta from CupomFiscal c inner join c.itemCupomFiscal i inner join i.produto p left  join p.planoConta pc  where c.cupom.dataEmissao = :dataReducao and c.cupom.impressoraFiscal.identificador = :idImpressora and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and i.cancelado = :cancelado and c.cancelado = :cancelado group by  i.incidPisCofins.codigo,  i.aliqPis, p.identificador, pc.codigo";
        Query q = s.createQuery(hql);
        q.setLong("idImpressora", idImpressora.longValue());
        q.setDate("dataReducao", dataReducao);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC481> toRet = new ArrayList<RegC481>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC481 r = new RegC481();
            r.setCodItem((Long)h.get("idProduto"));
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCPis((Double)h.get("BcPis"));
            if ((String)h.get("planoConta") != null) {
                r.setPlanoCred((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC485> getCofinsBlocoC481(Long idImpressora, Date dataReducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select i.incidPisCofins.codigo as codIncidenciaCofins, sum(i.bcCofins) as BcCofins, sum(i.valorTotal) as valorTotal, i.aliqCofins as aliquotaCofins, sum(i.vrCofins) as valorCofins, p.identificador as idProduto, pc.codigo as planoConta from CupomFiscal c inner join c.itemCupomFiscal i  inner join i.produto p left  join p.planoConta pc where c.cupom.dataEmissao = :dataReducao and c.cupom.impressoraFiscal.identificador = :idImpressora and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and i.cancelado = :cancelado and c.cancelado = :cancelado group by i.incidPisCofins.codigo,  i.aliqCofins, p.identificador, pc.codigo";
        Query q = s.createQuery(hql);
        q.setLong("idImpressora", idImpressora.longValue());
        q.setDate("dataReducao", dataReducao);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC485> toRet = new ArrayList<RegC485>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC485 r = new RegC485();
            r.setCodItem((Long)h.get("idProduto"));
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCCofins((Double)h.get("BcCofins"));
            if ((String)h.get("planoConta") != null) {
                r.setPlanoCred((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosReducoesC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  distinct p.identificador as ID_PRODUTO, p.nome as NOME_PRODUTO, p.unidadeMedida.sigla as SIGLA, t.codigo as COD_TIPO_ITEM_SPED, n.codigo as COD_NCM, g.codigo as COD_GENERO, p.aliquotaIcms as ALIQUOTA_ICMS from ItemCupomFiscal i inner join i.produto p left join p.ncm n left join p.genero g left join p.tipoIemSped t where (i.cupomFiscal.modeloDocFiscal.codigo=:cod1 or i.cupomFiscal.modeloDocFiscal.codigo=:cod2) and i.cupomFiscal.cupom.dataEmissao between :dataIn and :dataFim and i.cupomFiscal.cupom.empresa =:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("NOME_PRODUTO"));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setTipoItem((String)h.get("COD_TIPO_ITEM_SPED"));
            r.setCodNcm((String)h.get("COD_NCM"));
            r.setCodGenero((String)h.get("COD_GENERO"));
            r.setAliquotaIcms((Double)h.get("ALIQUOTA_ICMS"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasReducoesC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao from CupomFiscal n  inner join n.itemCupomFiscal i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2) and n.cupom.dataEmissao between :dataIn and :dataFim and n.cupom.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasReducoesC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct  pc.identificador as idPlanoConta, pc.codigo as codigo, pc.descricao as descricao, pc.marca as marca, pc.dataCadastro as dataCadastro, pc.naturezaOperacaoPC.codigo as natOpPC from CupomFiscal c inner join c.itemCupomFiscal i  inner join i.produto p left  join p.planoConta pc where c.cupom.dataEmissao between :dataIn and :dataFim and c.cupom.empresa =  :emp and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2)";
        Query q = s.createQuery(hql);
        q.setEntity("emp", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg500 r = new Reg500();
            r.setIdPlanoContas((Long)h.get("idPlanoConta"));
            r.setCodigo((String)h.get("codigo"));
            r.setDescricao((String)h.get("descricao"));
            r.setMarca((Integer)h.get("marca"));
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

