/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocod;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD101;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD105;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD111;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoD100NotaTerceiros {
    public BlocoD getBlocoD100NotasTerceirosTransporte(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD100(this.getNotasTerceirosTransporteBlocoD100(dataIn, dataFim, emp, b));
        if (b.getRegistrosD100() != null && !b.getRegistrosD100().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotasTerceirosTransporteD100(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegD100> getNotasTerceirosTransporteBlocoD100(Date dataIn, Date dataFim, Empresa emp, BlocoD blocoD) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct n.identificador as identificador, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, tc.codigo as codigoTipoCte, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, tf.opcao as codTpFrete, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.tipoCte tc where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4 or   n.modeloDocFiscal.codigo=:cod5 or  n.modeloDocFiscal.codigo=:cod6 or   n.modeloDocFiscal.codigo=:cod7 or  n.modeloDocFiscal.codigo=:cod8 or   n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa ");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD100> toRet = new ArrayList<RegD100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD100 r = new RegD100();
            r.setNumeroDoc(((Integer)h.get("numNota")).longValue());
            System.out.println("Nr Nota Terceiros de Transporte: " + r.getNumeroDoc().toString());
            r.setChaveNfe((String)h.get("chaveNfe"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("codigoTipoCte") != null) {
                r.setCodTipoCTe((Short)h.get("codigoTipoCte"));
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete((Short)h.get("codTpFrete"));
            } else {
                r.setIndicadorTipoFrete((short)9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            Reg500 pc = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(pc);
            String codPlanoConta = "";
            if (pc != null && pc.getCodigo() != null) {
                codPlanoConta = pc.getCodigo();
                blocoD.getPlanosContas().add(pc);
            }
            r.setPis(this.getPisBlocoD101(r.getIdentificador(), codPlanoConta));
            r.setCofins(this.getCofinsBlocoD105(r.getIdentificador(), codPlanoConta));
            r.setProcessosReferenciados(this.getProcessosRefBlocoD111(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private Reg500 getPlanoContaNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select lv.planoConta as planoConta from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            PlanoConta pc = (PlanoConta)h.get("planoConta");
            if (pc == null) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(pc.getIdentificador());
            r.setCodigo(pc.getCodigo());
            r.setDescricao(pc.getDescricao());
            r.setDataInclusao(pc.getDataCadastro());
            r.setMarca(pc.getMarca());
            r.setCodNaturezaContaSped(pc.getNaturezaOperacaoPC().getCodigo());
            return r;
        }
        return null;
    }

    List getParticipantesNotasTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD101> getPisBlocoD101(Long idNota, String codPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select n.naturezaFrete.codigo as codNatFrete, i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.itemNotaLivroFiscal.vrBCPis) as BCGeral,  i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis, nat.codigo as natBcCred from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaPis,  n.naturezaFrete.codigo,nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD101> toRet = new ArrayList<RegD101>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD101 r = new RegD101();
            r.setIndicadorNaturezaFrete((String)h.get("codNatFrete"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPis"));
            r.setNatBcCred((String)h.get("natBcCred"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((Double)h.get("valorPis"));
            r.setPlanoDeb(codPlanoConta);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD105> getCofinsBlocoD105(Long idNota, String codPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select n.naturezaFrete.codigo as codNatFrete, i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.itemNotaLivroFiscal.vrBCCofins) as BCGeral,  i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, nat.codigo as natBcCred from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaCofins, n.naturezaFrete.codigo, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD105> toRet = new ArrayList<RegD105>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD105 r = new RegD105();
            r.setNatBcCred((String)h.get("natBcCred"));
            r.setIndicadorNaturezaFrete((String)h.get("codNatFrete"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaCofins"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setPlanoDeb(codPlanoConta);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD111> getProcessosRefBlocoD111(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as origProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD111> toRet = new ArrayList<RegD111>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD111 r = new RegD111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("origProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }
}

