/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocod;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD200;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD201;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD205;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoD200CTe {
    public BlocoD getBlocoD200CTeSaida(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD200(this.getConhecimentosSaidaD200(dataIn, dataFim, emp));
        b.setPlanosContas(this.getPlanosContasPisCofinsCTe(dataIn, dataFim, emp));
        return b;
    }

    private List<RegD200> getConhecimentosSaidaD200(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.situacaoDocumento.codigo as situacaoDocumento, n.modeloDocFiscal.codigo as codModDocFiscal, sum(n.cteVlrImpostos.vrReceber) as valorTotal, sum(n.cteVlrImpostos.vrDesconto) as valorDesconto, min(n.numero) as numeroIn, max(n.numero) as numeroFim, lv.cfop.codigo as cfop, n.serie as serie,  (cast(n.dataEmissao as date)) as dataEmissao, planoPis.codigo as planoPis,  planoCofins.codigo as planoCofins from Cte n  inner join n.modeloFiscalCte m left join m.planoContaPisDevedor planoPis left join m.planoContaCofinsDevedor planoCofins inner join n.livrosFiscais lv where      (cast(n.dataEmissao as date)) between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5) group by n.situacaoDocumento.codigo,  n.modeloDocFiscal.codigo, lv.cfop.codigo,  n.serie, (cast(n.dataEmissao as date)), planoPis.codigo, planoCofins.codigo");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD200> toRet = new ArrayList<RegD200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD200 r = new RegD200();
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setCodSituacaoDocumento((String)h.get("situacaoDocumento"));
            r.setSerie((String)h.get("serie"));
            r.setNumeroInicial((Long)h.get("numeroIn"));
            r.setNumeroFinal((Long)h.get("numeroFim"));
            r.setCfop((String)h.get("cfop"));
            r.setDataRef((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorDescontos((Double)h.get("valorDesconto"));
            String codigoPlanoContaPis = (String)h.get("planoPis");
            String codigoPlanoContaCofins = (String)h.get("planoCofins");
            this.getPisCofinsConhecimentosSaidaD201D205(r.getDataRef(), emp, r, codigoPlanoContaPis, codigoPlanoContaCofins);
            toRet.add(r);
        }
        return toRet;
    }

    private void getPisCofinsConhecimentosSaidaD201D205(Date dataRef, Empresa emp, RegD200 regD200, String codigoPlanoPis, String codigoPlanoCofins) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  n.cteVlrImpostos.incidenciaPis.codigo as codIncidenciaPis, n.cteVlrImpostos.incidenciaCofins.codigo as codIncidenciaCofins, sum(n.cteVlrImpostos.baseCalcPis) as vrBCPis, sum(n.cteVlrImpostos.baseCalcCofins) as vrBCCofins, sum(n.cteVlrImpostos.vrPis) as vrPis, sum(n.cteVlrImpostos.vrCofins) as vrCofins, n.cteVlrImpostos.aliqPis as aliqPis, n.cteVlrImpostos.aliqCofins as aliqCofins, sum(n.cteVlrImpostos.vrReceber) as vrTotal  from Cte n inner join n.livrosFiscais lv where  (cast(n.dataEmissao as date)) = :dataIn  and n.empresa=:empresa  and lv.cfop.codigo = :codCfop and n.situacaoDocumento.codigo  = :codSitDoc and n.serie = :serie  group by  n.cteVlrImpostos.incidenciaPis.codigo, n.cteVlrImpostos.incidenciaCofins.codigo, n.cteVlrImpostos.aliqPis, n.cteVlrImpostos.aliqCofins ";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataRef);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc", regD200.getCodSituacaoDocumento());
        q.setString("codCfop", regD200.getCfop());
        q.setString("serie", regD200.getSerie());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD201> toRetPis = new ArrayList<RegD201>();
        for (Object o : ret) {
            RegD201 r = new RegD201();
            HashMap h = (HashMap)o;
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPis"));
            r.setValorTotal((double)((Double)h.get("vrTotal")));
            r.setValorPis((double)((Double)h.get("vrPis")));
            r.setValorBcPis((double)((Double)h.get("vrBCPis")));
            r.setAliquotaPis((Double)h.get("aliqPis"));
            r.setPlanoConta(codigoPlanoPis);
            toRetPis.add(r);
        }
        regD200.setPis(toRetPis);
        ArrayList<RegD205> toRetCofins = new ArrayList<RegD205>();
        for (Object o : ret) {
            RegD205 r = new RegD205();
            HashMap h = (HashMap)o;
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaCofins"));
            r.setValorTotal((double)((Double)h.get("vrTotal")));
            r.setValorCofins((double)((Double)h.get("vrCofins")));
            r.setValorBcCofins((double)((Double)h.get("vrBCCofins")));
            r.setAliquotaCofins((Double)h.get("aliqCofins"));
            r.setPlanoConta(codigoPlanoCofins);
            toRetCofins.add(r);
        }
        regD200.setCofins(toRetCofins);
    }

    private List<Reg500> getPlanosContasPisCofinsCTe(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  planoPis.identificador as idPlanoPis, planoPis.dataCadastro as dataCadastroPis, planoPis.marca as marcaPis, planoPis.codigo as codContaPis, planoPis.descricao as descricaoContaPis, planoPis.naturezaOperacaoPC.codigo as natOpPCPis, planoCofins.identificador as idPlanoCofins, planoCofins.dataCadastro as dataCadastroCofins, planoCofins.marca as marcaCofins, planoCofins.codigo as codContaCofins, planoCofins.descricao as descricaoContaCofins, planoCofins.naturezaOperacaoPC.codigo as natOpPCCofins from Cte n  inner join n.modeloFiscalCte m inner join m.planoContaPisDevedor planoPis inner join m.planoContaCofinsDevedor planoCofins where      (cast(n.dataEmissao as date)) between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            Long idPlanoContaCofins;
            HashMap h = (HashMap)o;
            Long idPlanoContaPis = (Long)h.get("idPlanoPis");
            if (idPlanoContaPis != null && idPlanoContaPis > 0L) {
                Reg500 r = new Reg500();
                r.setIdPlanoContas(idPlanoContaPis);
                r.setDataInclusao((Date)h.get("dataCadastroPis"));
                r.setDescricao((String)h.get("descricaoContaPis"));
                r.setMarca((Integer)h.get("marcaPis"));
                r.setCodigo((String)h.get("codContaPis"));
                r.setCodNaturezaContaSped((String)h.get("natOpPCPis"));
                toRet.add(r);
            }
            if ((idPlanoContaCofins = (Long)h.get("idPlanoCofins")) == null || idPlanoContaCofins <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCofins);
            r.setDataInclusao((Date)h.get("dataCadastroCofins"));
            r.setDescricao((String)h.get("descricaoContaCofins"));
            r.setMarca((Integer)h.get("marcaCofins"));
            r.setCodigo((String)h.get("codContaCofins"));
            r.setCodNaturezaContaSped((String)h.get("natOpPCCofins"));
            toRet.add(r);
        }
        return toRet;
    }
}

