/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocod;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD501;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD505;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocod.RegD509;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoD500NotaTerceiros {
    public BlocoD getBlocoD500NotasTerceirosTelecomunicacao(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD500(this.getNotasTerceirosTelecomunicacaoBlocoD500(dataIn, dataFim, emp));
        if (b.getRegistrosD500() != null && !b.getRegistrosD500().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotasTerceirosTelecomunicacaoD500(dataIn, dataFim, emp));
        }
        return b;
    }

    private List<RegD500> getNotasTerceirosTelecomunicacaoBlocoD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = null;
        String hql = " select distinct n.id_nota_terceiros from nota_terceiros n  inner join item_nota_terceiros i on i.id_nota_terceiros = n.id_nota_terceiros inner join incidencia_pis_cofins inc on inc.id_incidencia_pis_cofins = i.id_incidencia_pis_cofins inner join modelo_doc_fiscal m on m.id_modelo_doc_fiscal  = n.id_modelo_doc_fiscal where (m.codigo=:cod1 or m.codigo=:cod2) and n.data_entrada_saida between :dataIn and :dataFim and n.id_empresa =:empresa and inc.codigo between :codInicial and :codFinal";
        q = s.createSQLQuery(hql);
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setLong("empresa", emp.getIdentificador().longValue());
        q.setString("codInicial", "50");
        q.setString("codFinal", "56");
        List ret = q.list();
        ArrayList<RegD500> toRet = new ArrayList<RegD500>();
        if (ret != null) {
            for (Object ob : ret) {
                Long idNota = ((Integer)ob).longValue();
                q = s.createQuery("select distinct n.identificador as identificador, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorDesconto as valorDesconto, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, n.valoresNfTerceiros.valorDespAcess as valorDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as valorIcms, n.valoresNfTerceiros.valorPis as valorPis, n.valoresNfTerceiros.valorCofins as valorCofins from NotaFiscalTerceiros n where  n.identificador = :idNota and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins >0)");
                q.setLong("idNota", idNota.longValue());
                q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                ret = q.list();
                for (Object o : ret) {
                    HashMap h = (HashMap)o;
                    RegD500 r = new RegD500();
                    r.setIdentificador((Long)h.get("identificador"));
                    r.setIdParticipante((Long)h.get("idPessoa"));
                    r.setCodModDocFiscal((String)h.get("codModFiscal"));
                    r.setCodSituacaoDoc((String)h.get("sitDoc"));
                    r.setSerie((String)h.get("serie"));
                    r.setDataEmissao((Date)h.get("dataEmissao"));
                    r.setDataEntSaida((Date)h.get("dataEntSai"));
                    r.setNumeroDoc((Integer)h.get("numNota"));
                    r.setValorDoc((Double)h.get("valorTotal"));
                    r.setValorDesconto((Double)h.get("valorDesconto"));
                    r.setValorTotalMercadorias((Double)h.get("valorProdServ"));
                    r.setValorDespAcess((Double)h.get("valorDespAcess"));
                    r.setValorBcIcms((Double)h.get("bcIcms"));
                    r.setValorICMS((Double)h.get("valorIcms"));
                    r.setValorPis((Double)h.get("valorPis"));
                    r.setValorCofins((Double)h.get("valorCofins"));
                    r.setPis(this.getPisBlocoD501(r.getIdentificador()));
                    r.setCofins(this.getCofinsBlocoD505(r.getIdentificador()));
                    r.setProcessosReferenciados(this.getProcessosRefBlocoD509(r.getIdentificador()));
                    ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
                    r.setObsFaturamento(obs);
                    toRet.add(r);
                }
            }
        }
        return toRet;
    }

    private List<RegD501> getPisBlocoD501(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.itemNotaLivroFiscal.vrBCPis) as BCGeral,  i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis, nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaPis, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD501> toRet = new ArrayList<RegD501>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD501 r = new RegD501();
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPis"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("BCGeral"));
            r.setAliquotaPis((double)((Double)h.get("aliquotaPis")));
            r.setValorPis((Double)h.get("valorPis"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD505> getCofinsBlocoD505(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, sum(i.itemNotaLivroFiscal.vrBCCofins) as BCGeral,  i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaCofins, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD505> toRet = new ArrayList<RegD505>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD505 r = new RegD505();
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaCofins"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("BCGeral"));
            r.setAliquotaCofins((double)((Double)h.get("aliquotaCofins")));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD509> getProcessosRefBlocoD509(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as origProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD509> toRet = new ArrayList<RegD509>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD509 r = new RegD509();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("origProcesso"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getParticipantesNotasTerceirosTelecomunicacaoD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins >0)");
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }
}

