/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocof;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoSpedPisCofins;
import com.touchcomp.basementor.model.vo.ProcessoFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg600;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF100;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF111;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoF100 {
    public BlocoF getLancamentosBlocoF100(Empresa emp, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF100(this.getLancamentosBlocoF100(dataIn, dataFim, emp));
        if (f.getRegistrosF100() != null && !f.getRegistrosF100().isEmpty()) {
            f.setParticipantes(this.getParticipantesLancamentosF100(dataIn, dataFim, emp));
            f.setProdutos(this.getProdutosLancamentosF100(dataIn, dataFim, emp));
            f.setUnidadeMedidas(this.getUnidadeMedidaLancamentosF100(dataIn, dataFim, emp));
            f.setCentroCustos(this.getCentroCustosLancamentosF100(dataIn, dataFim, emp));
            f.setPlanoContas(this.getPlanoContasLancamentosF100(dataIn, dataFim, emp));
        }
        return f;
    }

    private List<RegF100> getLancamentosBlocoF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LancamentoSpedPisCofins l where l.dataOper between :dataIn and :dataFim and l.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        List ret = q.list();
        ArrayList<RegF100> toRet = new ArrayList<RegF100>();
        for (Object o : ret) {
            LancamentoSpedPisCofins l = (LancamentoSpedPisCofins)o;
            RegF100 r = new RegF100();
            r.setIndicadorTipoOperacao(l.getIndOper());
            if (l.getParticipante() != null) {
                r.setIdParticipante(l.getParticipante().getIdentificador());
            }
            if (l.getProduto() != null) {
                r.setIdProduto(l.getProduto().getIdentificador());
            }
            r.setDataOperacao(l.getDataOper());
            r.setVrOperacao(l.getVrOper());
            r.setCodIncidenciaPis(l.getCstPis().getCodigo());
            r.setCodIncidenciaCofins(l.getCstCofins().getCodigo());
            r.setVrPis(l.getVrPis());
            r.setVrCofins(l.getVrCofins());
            r.setVrBcPis(l.getVrBcPis());
            r.setVrBcCofins(l.getVrBcCofins());
            r.setAliquotaCofins(l.getAliqCofins());
            r.setAliquotaPis(l.getAliqPis());
            r.setCodNatBCCredito(l.getNatBcCredito().getCodigo());
            r.setIndicadorOrigemCredito(l.getIndOrigCred());
            r.setDescricaoDocumento(l.getDescDocOper());
            r.setIdentificador(l.getIdentificador());
            r.setProcessosReferenciados(this.getProcessosReferenciadosF100(l.getProcessoFiscal()));
            if (l.getPlanoConta() != null) {
                r.setCodPlanoConta(l.getPlanoConta().getCodigo());
            }
            if (l.getCentroCusto() != null) {
                r.setCodCentroCusto(l.getCentroCusto().getCodigo());
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List getProcessosReferenciadosF100(ProcessoFiscal p) {
        ArrayList<RegF111> toRet = new ArrayList<RegF111>();
        if (p != null) {
            RegF111 r = new RegF111();
            r.setCodOrigem(p.getTipoProcesso().getCodigo());
            r.setNumeroProcesso(p.getNrProcesso());
            toRet.add(r);
        }
        return toRet;
    }

    List getParticipantesLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from LancamentoSpedPisCofins n  inner join n.participante p where  n.dataOper between :dataIn and :dataFim and n.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.identificador as idProduto, i.nome as nomeProduto, i.unidadeMedida.sigla as unidadeMedida, i.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.aliquotaIcms as aliquotaIcms from LancamentoSpedPisCofins n  inner join n.produto i left join i.ncm nc left join i.genero g where  n.dataOper between :dataIn and :dataFim and n.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("ID_PRODUTO");
            r.setIdProduto(idProduto.toString());
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoConta.identificador as idPlano, i.planoConta.dataCadastro as dataCadastro, i.planoConta.marca as marca, i.planoConta.codigo as codConta, i.planoConta.descricao as descricaoConta, i.planoConta.naturezaOperacaoPC.codigo as natOpPC from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim and i.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlano");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoConta"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codConta"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg600> getCentroCustosLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.centroCusto.identificador as idCentroCusto, i.centroCusto.dataCadastro as dataCadastro, i.centroCusto.codigo as codCentroCusto, i.centroCusto.nome as descricaoCentroCusto from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim and i.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg600> toRet = new ArrayList<Reg600>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCentroCusto = (Long)h.get("idCentroCusto");
            if (idCentroCusto == null || idCentroCusto <= 0L) continue;
            Reg600 r = new Reg600();
            r.setIdCentroCusto(idCentroCusto);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoCentroCusto"));
            r.setCodigo((String)h.get("codCentroCusto"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidadeMedidaLancamentosF100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao from LancamentoSpedPisCofins i  where  i.dataOper between :dataIn and :dataFim and i.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }
}

