/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocof;

import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BaixaTituloSpedCofins;
import com.touchcomp.basementor.model.vo.BaixaTituloSpedPis;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import java.util.ArrayList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocof.RegF600;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilBDBlocoF600 {
    public BlocoF getRegistrosBlocoF600(SpedPisCofins vo) {
        BlocoF b = new BlocoF();
        b.setRegistrosF600(this.getRegBlocoF600(vo));
        return b;
    }

    private List<RegF600> getRegBlocoF600(SpedPisCofins vo) {
        ArrayList<RegF600> dados = new ArrayList();
        dados = this.getRegBlocoF600Pis(vo, dados);
        dados = this.getRegBlocoF600Cofins(vo, dados);
        return dados;
    }

    private List<RegF600> getRegBlocoF600Pis(SpedPisCofins vo, List dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from BaixaTituloSpedPis b where b.spedPisCofins = :spedPisCofins";
        Query q = s.createQuery(hql);
        q.setEntity("spedPisCofins", (Object)vo);
        List reg600 = q.list();
        if (reg600 != null) {
            for (Object o : reg600) {
                BaixaTituloSpedPis b = (BaixaTituloSpedPis)o;
                boolean exists = false;
                for (Object ob : dados) {
                    RegF600 rr = (RegF600)ob;
                    if (!rr.getCodIndNatRetencao().equals(b.getIndicadorNaturezaRetencaoFonte().getCodigo()) || !rr.getCodReceita().equals(b.getCodRec()) || !rr.getCodIndNatReceita().equals(b.getIndNatRec()) || !rr.getIndDeclarante().equals(b.getIndDec()) || !rr.getCnpj().equals(b.getCnpj())) continue;
                    rr.setVrBcRetencao(rr.getVrBcRetencao() + b.getBaixaTitulo().getValor());
                    rr.setValorRetidoPis(rr.getValorRetidoPis() + b.getBaixaTitulo().getVrPis());
                    rr.setVrTotalRetencao(rr.getVrTotalRetencao() + b.getBaixaTitulo().getVrPis());
                    exists = true;
                    rr.getBaixas().add(b.getBaixaTitulo());
                    break;
                }
                if (exists) continue;
                RegF600 r = new RegF600();
                r.setCodIndNatRetencao(b.getIndicadorNaturezaRetencaoFonte().getCodigo());
                r.setDataRetencao(vo.getDataFinal());
                r.setVrBcRetencao(b.getBaixaTitulo().getValor());
                r.setVrTotalRetencao(b.getBaixaTitulo().getVrPis());
                r.setValorRetidoPis(b.getBaixaTitulo().getVrPis());
                r.setCodReceita(b.getCodRec());
                r.setCodIndNatReceita(b.getIndNatRec());
                r.setIndDeclarante(b.getIndDec());
                r.setCnpj(b.getCnpj());
                r.getBaixas().add(b.getBaixaTitulo());
                dados.add(r);
            }
        }
        return dados;
    }

    private List<RegF600> getRegBlocoF600Cofins(SpedPisCofins vo, List dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from BaixaTituloSpedCofins b where b.spedPisCofins = :spedPisCofins";
        Query q = s.createQuery(hql);
        q.setEntity("spedPisCofins", (Object)vo);
        List reg600 = q.list();
        if (reg600 != null) {
            for (Object o : reg600) {
                BaixaTituloSpedCofins b = (BaixaTituloSpedCofins)o;
                boolean exists = false;
                for (Object ob : dados) {
                    RegF600 rr = (RegF600)ob;
                    if (!rr.getCodIndNatRetencao().equals(b.getIndicadorNaturezaRetencaoFonte().getCodigo()) || !rr.getCodReceita().equals(b.getCodRec()) || !rr.getCodIndNatReceita().equals(b.getIndNatRec()) || !rr.getIndDeclarante().equals(b.getIndDec()) || !rr.getCnpj().equals(b.getCnpj())) continue;
                    if (!this.existeBaixas(rr.getBaixas(), b.getBaixaTitulo())) {
                        rr.setVrBcRetencao(rr.getVrBcRetencao() + b.getBaixaTitulo().getValor());
                    }
                    rr.setValorRetidoCofins(rr.getValorRetidoCofins() + b.getBaixaTitulo().getVrConfins());
                    rr.setVrTotalRetencao(rr.getVrTotalRetencao() + b.getBaixaTitulo().getVrConfins());
                    exists = true;
                    break;
                }
                if (exists) continue;
                RegF600 r = new RegF600();
                r.setCodIndNatRetencao(b.getIndicadorNaturezaRetencaoFonte().getCodigo());
                r.setDataRetencao(vo.getDataFinal());
                r.setVrBcRetencao(b.getBaixaTitulo().getValor());
                r.setVrTotalRetencao(b.getBaixaTitulo().getVrConfins());
                r.setValorRetidoCofins(b.getBaixaTitulo().getVrConfins());
                r.setCodReceita(b.getCodRec());
                r.setCodIndNatReceita(b.getIndNatRec());
                r.setIndDeclarante(b.getIndDec());
                r.setCnpj(b.getCnpj());
                dados.add(r);
            }
        }
        return dados;
    }

    private boolean existeBaixas(List baixas, BaixaTitulo baixaTitulo) {
        for (Object o : baixas) {
            BaixaTitulo b = (BaixaTitulo)o;
            if (!b.getIdentificador().equals(baixaTitulo.getIdentificador())) continue;
            return true;
        }
        return false;
    }
}

