/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocom;

import com.touchcomp.basementor.model.vo.ApuracaoPisCofins;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoM {
    public ApuracaoPisCofins getApuracaoPisCofinsPorPeridoAndGrupoEmpresa(Date periodo, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct a from ApuracaoPisCofins a where a.periodo = :periodo and a.grupoEmpresa = :grupoEmpresa");
        q.setDate("periodo", periodo);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setMaxResults(1);
        return (ApuracaoPisCofins)q.uniqueResult();
    }

    public List<Reg500> findPlanoContas(Date dataIn, GrupoEmpresa grupoEmpresa) {
        ArrayList<Reg500> planosContas = new ArrayList<Reg500>();
        planosContas.addAll(this.findPlanoContasM400(dataIn, grupoEmpresa));
        planosContas.addAll(this.findPlanoContasM410(dataIn, grupoEmpresa));
        planosContas.addAll(this.findPlanoContasM800(dataIn, grupoEmpresa));
        planosContas.addAll(this.findPlanoContasM810(dataIn, grupoEmpresa));
        return planosContas;
    }

    private List<Reg500> findPlanoContasM400(Date dataIn, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  a.planoConta.identificador as idPlanoDeb, a.planoConta.dataCadastro as dataCadastroDeb, a.planoConta.marca as marcaDeb, a.planoConta.codigo as codContaDeb, a.planoConta.descricao as descricaoContaDeb, a.planoConta.naturezaOperacaoPC.codigo as natOpPC from ApuracaoPisM400 a  where a.apuracaoPis.apuracaoPisCofins.periodo = :periodo and a.apuracaoPis.apuracaoPisCofins.grupoEmpresa = :grupoEmpresa");
        q.setDate("periodo", dataIn);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> findPlanoContasM410(Date dataIn, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  a.planoConta.identificador as idPlanoDeb, a.planoConta.dataCadastro as dataCadastroDeb, a.planoConta.marca as marcaDeb, a.planoConta.codigo as codContaDeb, a.planoConta.descricao as descricaoContaDeb, a.planoConta.naturezaOperacaoPC.codigo as natOpPC from ApuracaoPisM410 a  where a.apuracaoPisM400.apuracaoPis.apuracaoPisCofins.periodo = :periodo and a.apuracaoPisM400.apuracaoPis.apuracaoPisCofins.grupoEmpresa = :grupoEmpresa");
        q.setDate("periodo", dataIn);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> findPlanoContasM800(Date dataIn, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  a.planoConta.identificador as idPlanoDeb, a.planoConta.dataCadastro as dataCadastroDeb, a.planoConta.marca as marcaDeb, a.planoConta.codigo as codContaDeb, a.planoConta.descricao as descricaoContaDeb, a.planoConta.naturezaOperacaoPC.codigo as natOpPC from ApuracaoCofinsM800 a  where a.apuracaoCofins.apuracaoPisCofins.periodo = :periodo and a.apuracaoCofins.apuracaoPisCofins.grupoEmpresa = :grupoEmpresa");
        q.setDate("periodo", dataIn);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> findPlanoContasM810(Date dataIn, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  a.planoConta.identificador as idPlanoDeb, a.planoConta.dataCadastro as dataCadastroDeb, a.planoConta.marca as marcaDeb, a.planoConta.codigo as codContaDeb, a.planoConta.descricao as descricaoContaDeb, a.planoConta.naturezaOperacaoPC.codigo as natOpPC from ApuracaoCofinsM810 a  where a.apuracaoCofinsM800.apuracaoCofins.apuracaoPisCofins.periodo = :periodo and a.apuracaoCofinsM800.apuracaoCofins.apuracaoPisCofins.grupoEmpresa = :grupoEmpresa");
        q.setDate("periodo", dataIn);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

