/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao003.util.blocop;

import com.touchcomp.basementor.model.vo.CodigoAtividadeEcPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao003.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocop.BlocoP;
import mentorcore.service.impl.spedpiscofins.versao003.model.blocop.RegP100;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoP {
    public BlocoP getBlocoP100(Date dataIn, Date dataFim, Empresa emp, List codigosAtivEc) {
        BlocoP b = new BlocoP();
        b.setRegistrosP100(this.getRegistrosP100(dataIn, dataFim, emp, codigosAtivEc));
        b.setPlanoContas(this.getPlanosContasRegistrosP100(dataIn, dataFim, emp, codigosAtivEc));
        return b;
    }

    private List<RegP100> getRegistrosP100(Date dataIn, Date dataFim, Empresa emp, List codigosAtivEc) {
        ArrayList<RegP100> registros = new ArrayList<RegP100>();
        registros.addAll(this.getRegistrosNotasProprias(dataIn, dataFim, emp, codigosAtivEc));
        registros.addAll(this.getRegistrosCuponsFiscais(dataIn, dataFim, emp, codigosAtivEc));
        return registros;
    }

    private Collection getRegistrosNotasProprias(Date dataIn, Date dataFim, Empresa emp, List codigosAtivEc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select i.produto.ncm.codigo as COD_NCM, sum(i.itemNotaLivroFiscal.valorTotal)  - (sum(i.itemNotaLivroFiscal.vrIpiIndustria + i.itemNotaLivroFiscal.vrIpiComercio) + sum(i.itemNotaLivroFiscal.vrIcmsSt)  + sum(i.valorDesconto)) as VR_RECEITA_BRUTA, i.produto.ncm.codigoAtividadeEcPisCofins.aliquota as ALIQUOTA, p.codigo as COD_CONTA_CONTABIL from ItemNotaFiscalPropria i  inner join i.planoContaCred p  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped = :cfopReceitaVendaSped  and i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and(";
        int cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            hql = cont != codigosAtivEc.size() ? (String)hql + " i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + "  or" : (String)hql + " i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + ")";
            ++cont;
        }
        hql = (String)hql + " group by i.produto.ncm.codigo,  i.produto.ncm.codigoAtividadeEcPisCofins.aliquota, p.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            q.setString("cod" + cont, c.getCodigo() + "%");
            ++cont;
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegP100> toRet = new ArrayList<RegP100>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            RegP100 r = new RegP100();
            r.setDataInicial(dataIn);
            r.setDataFinal(dataFim);
            r.setCodAtividadeEconomica((String)h.get("COD_NCM"));
            Double vrDevolucao = this.getVrDevolucaoNotasProprias(r.getDataInicial(), r.getDataFinal(), r.getCodAtividadeEconomica());
            r.setValorExclusao(vrDevolucao);
            Double vrReceitaBruta = (Double)h.get("VR_RECEITA_BRUTA");
            r.setValorReceitaBruta(vrReceitaBruta + r.getValorExclusao());
            r.setValorReceitaBrutaTotal(vrReceitaBruta + r.getValorExclusao());
            r.setValorBaseCalculo(vrReceitaBruta);
            r.setAliquota((Double)h.get("ALIQUOTA"));
            r.setValorApurado(r.getValorBaseCalculo() * (r.getAliquota() / 100.0));
            r.setContaContabil((String)h.get("COD_CONTA_CONTABIL"));
            toRet.add(r);
        }
        return toRet;
    }

    private Collection getRegistrosCuponsFiscais(Date dataIn, Date dataFim, Empresa emp, List codigosAtivEc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select i.produto.ncm.codigo as COD_NCM, sum(i.valorTotal) as VR_RECEITA_BRUTA, i.produto.ncm.codigoAtividadeEcPisCofins.aliquota as ALIQUOTA from ItemCupomFiscal i  where (i.cfop.cfopReceitaVendaSped = :cfopReceitaVendaSped)  and i.cfop.codigo.cfopDevolucaoVenda = :cfopDevolucaoVenda and i.cupomFiscal.cupom.dataMovimentacao between :dataIn and :dataFim  and i.cancelado = :naoCancelado  and i.cupomFiscal.cancelado = :naoCancelado  and(";
        int cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            hql = cont != codigosAtivEc.size() ? (String)hql + " i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + "  or" : (String)hql + " i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + ")";
            ++cont;
        }
        hql = (String)hql + " group by i.produto.ncm.codigo,  i.produto.ncm.codigoAtividadeEcPisCofins.aliquota";
        Query q = s.createQuery((String)hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("cfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("naoCancelado", (short)0);
        cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            q.setString("cod" + cont, c.getCodigo() + "%");
            ++cont;
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegP100> toRet = new ArrayList<RegP100>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            RegP100 r = new RegP100();
            r.setDataInicial(dataIn);
            r.setDataFinal(dataFim);
            r.setCodAtividadeEconomica((String)h.get("COD_NCM"));
            Double vrDevolucao = this.getVrDevolucaoNotasProprias(r.getDataInicial(), r.getDataFinal(), r.getCodAtividadeEconomica());
            r.setValorExclusao(vrDevolucao);
            Double vrReceitaBruta = (Double)h.get("VR_RECEITA_BRUTA");
            r.setValorReceitaBruta(vrReceitaBruta + r.getValorExclusao());
            r.setValorReceitaBrutaTotal(vrReceitaBruta + r.getValorExclusao());
            r.setValorBaseCalculo(vrReceitaBruta);
            r.setAliquota((Double)h.get("ALIQUOTA"));
            r.setValorApurado(r.getValorBaseCalculo() * (r.getAliquota() / 100.0));
            toRet.add(r);
        }
        return toRet;
    }

    private Double getVrDevolucaoNotasProprias(Date dataIn, Date dataFim, String codNCM) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select coalesce(sum(i.itemNotaLivroFiscal.valorTotal),0)  from ItemNotaFiscalPropria i  where      i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :cfopDevolucaoVenda and i.itemNotaLivroFiscal.cfop.codigo.cfopReceitaVendaSped   = :naoCfopReceitaVendaSped and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and i.produto.ncm.codigo = :codigoNCM and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5)";
        Query q = s.createQuery(hql);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setShort("naoCfopReceitaVendaSped", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codigoNCM", codNCM);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        Double vrDevolucao = (Double)q.uniqueResult();
        return vrDevolucao;
    }

    private List<Reg500> getPlanosContasRegistrosP100(Date dataIn, Date dataFim, Empresa emp, List codigosAtivEc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select distinct  i.planoContaCred.identificador as idPlanoCred, i.planoContaCred.dataCadastro as dataCadastroCred, i.planoContaCred.marca as marcaCred, i.planoContaCred.codigo as codContaCred, i.planoContaCred.descricao as descricaoContaCred, i.planoContaCred.naturezaOperacaoPC.codigo as natOpPC from ItemNotaFiscalPropria i  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped = :cfopReceitaVendaSped  and i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and(";
        int cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            hql = cont != codigosAtivEc.size() ? (String)hql + " i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + "  or" : (String)hql + " i.produto.ncm.codigoAtividadeEcPisCofins.codigo like :cod" + cont + ")";
            ++cont;
        }
        Query q = s.createQuery((String)hql);
        q.setShort("cfopReceitaVendaSped", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        cont = 1;
        for (Object o : codigosAtivEc) {
            CodigoAtividadeEcPisCofins c = (CodigoAtividadeEcPisCofins)o;
            q.setString("cod" + cont, c.getCodigo() + "%");
            ++cont;
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

