/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006;

import com.touchcomp.basementor.model.vo.AjusteContribuicaoPrevidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ApuracaoPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IndicadorIncidenciaTributaria;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsStructureException;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsWritterException;
import mentorcore.service.impl.spedpiscofins.versao006.SpedFormat;
import mentorcore.service.impl.spedpiscofins.versao006.model.ContadorRegistros;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg450;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco0.Reg0145;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco1.Bloco1;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco1.Reg1100;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco1.Reg1500;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco1.Reg1900;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocoa.RegA110;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC010;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC380;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC395;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocod.BlocoD;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocod.RegD100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocod.RegD200;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocod.RegD500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF120;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF130;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF150;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF525;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF550;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF600;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF700;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocop.BlocoP;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocop.RegP200;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocop.RegP210;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco0.UtilBDBloco0;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco0.writter.UtilWritterBloco0;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco1.UtilBDBloco1100;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco1.UtilBDBloco1500;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco1.UtilBDBloco1900;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco1.writter.UtilWritterBloco1;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco9.writter.UtilWritterBloco9;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocoa.UtilBDBlocoA100NotaPropria;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocoa.UtilBDBlocoA100NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocoa.UtilBDBlocoA100RpsEntrada;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocoa.UtilBDBlocoA100RpsSaida;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocoa.writter.UtilWritterBlocoA;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC100NFCe;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC100NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC100NotasPropria;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC100NotasPropriaV2;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC380NotaPropria;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC395NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.UtilBDBlocoC500NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao006.util.blococ.writter.UtilWritterBlocoC;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocod.UtilBDBlocoD100NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocod.UtilBDBlocoD200CTe;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocod.UtilBDBlocoD500NotaTerceiros;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocod.writter.UtilWritterBlocoD;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF100;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF120;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF130;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF150;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF500;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF550;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF600;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.UtilBDBlocoF700;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.writter.UtilBDBlocoF525;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocof.writter.UtilWritterBlocoF;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocom.UtilBDBlocoM;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocom.writter.UtilWritterBlocoM;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocop.UtilBDBlocoP;
import mentorcore.service.impl.spedpiscofins.versao006.util.blocop.writter.UtilWritterBlocoP;
import mentorcore.tools.DateUtil;

public class SpedPisCofinsWritter006 {
    private SpedFormat form = new SpedFormat();
    private String endOfRegister = "\r\n";
    private char separator = (char)124;
    private final TLogger logger = TLogger.get(this.getClass());
    private ContadorRegistros cont = new ContadorRegistros();
    private HashMap hashEmpresasProdutos = new HashMap();
    private HashMap hashEmpresasNaturezas = new HashMap();
    private HashMap hashEmpresasUnidades = new HashMap();
    private HashMap hashEmpresasParicipantes = new HashMap();
    private HashMap hashEmpresasObservacoes = new HashMap();
    private HashSet hashEmpresasPlanos = new HashSet();
    private HashSet hashEmpresasCentroCustos = new HashSet();
    private PlanoConta planoConta;
    private IndicadorIncidenciaTributaria indicadorIncidenciaTrib;
    private Double vrReceitaBrutaTotal = 0.0;
    private Boolean novaVersaoArquivo = false;

    public void spedPisCofinsWritter(SpedPisCofins vo, File file, Boolean novaVersaoArquivo) throws SpedPisCofinsWritterException, ExceptionDatabase, ExceptionService, SpedPisCofinsStructureException {
        Date dataIn = vo.getDataInicial();
        Date dataFim = vo.getDataFinal();
        this.indicadorIncidenciaTrib = vo.getIndicadorIncidenciaTributaria();
        this.planoConta = vo.getPlanoConta();
        if (novaVersaoArquivo != null) {
            this.novaVersaoArquivo = novaVersaoArquivo;
        }
        try {
            Empresa emp = vo.getEmpresa();
            String perfil = emp.getEmpresaDados().getPerfilSpedFiscal().getCodigo();
            if (emp.getEmpresaDados().getIndicadorAtividade() == null) {
                throw new SpedPisCofinsWritterException("Primeiro, informe o Indicador de Atividade no cadastro de Empresa.");
            }
            List codigosAtivEc = new ArrayList();
            if (vo.getGerarBlocoP() == 1 && ((codigosAtivEc = new UtilBDBloco0().getCodigoAtividadeEcPisCofins(dataIn, dataFim)) == null || codigosAtivEc.isEmpty())) {
                throw new SpedPisCofinsWritterException("Primeiro informe os C\u00f3digos de Atividade Econ\u00f4mica.\nNecess\u00e1rio para gera\u00e7\u00e3o do Bloco P");
            }
            List empresasDados = vo.getGrupoEmpresa().getEmpresas();
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            for (Object o : empresasDados) {
                EmpresaDados empDados = (EmpresaDados)o;
                Empresa e = new UtilBDBloco0().findEmpresaPorEmpresaDados(empDados);
                if (e == null || !ToolMethods.isStrWithData((String)e.getPessoa().getComplemento().getCnpj()) || !ToolMethods.isStrWithDataLength((String)e.getPessoa().getComplemento().getCnpj(), (int)14)) continue;
                this.hashEmpresasProdutos.put(e.getPessoa().getComplemento().getCnpj(), new HashSet());
                this.hashEmpresasNaturezas.put(e.getPessoa().getComplemento().getCnpj(), new HashSet());
                this.hashEmpresasUnidades.put(e.getPessoa().getComplemento().getCnpj(), new HashSet());
                this.hashEmpresasParicipantes.put(e.getPessoa().getComplemento().getCnpj(), new HashSet());
                this.hashEmpresasObservacoes.put(e.getPessoa().getComplemento().getCnpj(), new HashSet());
                empresas.add(e);
            }
            HashMap h = this.getRegistrosGerados(vo);
            Boolean gerarBloco = (Boolean)h.get("Registro1900");
            Bloco1 bloco1900 = null;
            if (gerarBloco.booleanValue() && (bloco1900 = new UtilBDBloco1900().getBloco1Reg1900(dataIn, dataFim, emp.getEmpresaDados().getGrupoEmpresa())) != null && bloco1900.getPlanoContas() != null) {
                this.putPlanoContas(bloco1900.getPlanoContas());
            }
            Bloco1 bloco1100 = new UtilBDBloco1100().getBloco1Reg1100(vo);
            Bloco1 bloco1500 = new UtilBDBloco1500().getBloco1Reg1500(vo);
            File blocoA = this.createWritterBlockA(dataIn, dataFim, empresas, h, vo);
            File blocoC = this.createWritterBlockC(dataIn, dataFim, empresas, h, vo);
            File blocoD = this.createWritterBlockD(dataIn, dataFim, empresas, h);
            File blocoF = this.createWritterBlockF(dataIn, dataFim, empresas, vo);
            File blocoM = this.createWritterBlockM(dataIn, dataFim, vo.getGrupoEmpresa(), vo);
            File bloco0 = this.createWritterBlock0(dataIn, dataFim, emp, vo, empresas, codigosAtivEc);
            File blocoP = this.createWritterBlockP(dataIn, dataFim, empresas, h, vo, codigosAtivEc);
            File bloco1 = this.writterBlock1(bloco1900, bloco1100, bloco1500);
            File bloco9 = this.createWritterBlock9();
            this.apendToSomeFile(file, bloco0, blocoA, blocoC, blocoD, blocoF, blocoM, bloco1, bloco9, blocoP);
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new SpedPisCofinsWritterException("Diret\u00f3rio n\u00e3o encontrado");
        }
    }

    private File createWritterBlock0(Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo, List empresas, List codigoAtivEc) throws IOException, ExceptionDatabase, SpedPisCofinsWritterException {
        File f = File.createTempFile("sped_bloco_0", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco0 w = new UtilWritterBloco0();
        this.vrReceitaBrutaTotal = 0.0;
        Reg0145 reg0145 = null;
        if (vo.getGerarBlocoP() == 1) {
            reg0145 = this.getRegistr0145(p, dataIn, dataFim, vo, w, codigoAtivEc);
            this.vrReceitaBrutaTotal = reg0145.getValorReceitaTotal();
        }
        this.gerarBloco0000(p, dataIn, dataFim, emp, vo, w);
        this.gerarBloco0001(p, w);
        this.gerarBloco0035(p, emp, vo, w);
        this.gerarBloco0100(p, emp, w);
        this.gerarBloco0110(p, vo, w);
        this.gerarBloco0111(p, vo, w);
        this.gerarBloco0140(p, empresas, dataIn, dataFim, reg0145, w);
        this.gerarBloco0500(p, w);
        this.gerarBloco0600(p, w);
        this.gerarBloco0990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockA(Date dataIn, Date dataFim, List<Empresa> empresas, HashMap h, SpedPisCofins vo) throws IOException {
        File f = File.createTempFile("sped_bloco_a", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoA w = new UtilWritterBlocoA();
        Boolean gerarBloco = (Boolean)h.get("BlocoA");
        if (gerarBloco.booleanValue()) {
            boolean flag = false;
            int contador = 1;
            ArrayList<String> cnpjEmpresas = new ArrayList<String>();
            for (Empresa empresa : empresas) {
                if (cnpjEmpresas.contains(empresa.getPessoa().getComplemento().getCnpj())) continue;
                cnpjEmpresas.add(empresa.getPessoa().getComplemento().getCnpj());
            }
            int nrEmpresas = cnpjEmpresas.size();
            for (String cnpjEmpresa : cnpjEmpresas) {
                Boolean utilizaCodAux = this.getEmpresaUtilizaCodigoAuxiliar(vo);
                BlocoA notasServicoTercA100 = null;
                BlocoA notasServicoPropA100 = null;
                if (!this.indicadorIncidenciaTrib.getCodigo().equals("2")) {
                    notasServicoTercA100 = vo.getTipoPesqNotaServicoEnt() != null && vo.getTipoPesqNotaServicoEnt() == 1 ? new UtilBDBlocoA100RpsEntrada().getBlocoA100NotasServico(dataIn, dataFim, cnpjEmpresa) : new UtilBDBlocoA100NotaTerceiros().getBlocoA100NotasTerceiros(dataIn, dataFim, cnpjEmpresa, utilizaCodAux);
                }
                notasServicoPropA100 = vo.getTipoPesqNotaServicoSai() != null && vo.getTipoPesqNotaServicoSai() == 1 ? new UtilBDBlocoA100RpsSaida().getBlocoA100NotasServico(dataIn, dataFim, cnpjEmpresa) : new UtilBDBlocoA100NotaPropria().getBlocoA100NotasServico(dataIn, dataFim, cnpjEmpresa, utilizaCodAux);
                boolean comDados = this.existeRegistrosBlocoA(notasServicoTercA100, notasServicoPropA100);
                if (!flag) {
                    flag = this.gerarBlocoA001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoA010(p, cnpjEmpresa);
                    this.gerarBlocoA100NotaPropria(p, notasServicoPropA100, cnpjEmpresa, w);
                    this.gerarBlocoA100NotaTerceiros(p, notasServicoTercA100, cnpjEmpresa, w);
                }
                ++contador;
            }
        }
        this.gerarBlocoA990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockC(Date dataIn, Date dataFim, List<Empresa> empresas, HashMap h, SpedPisCofins vo) throws IOException {
        File f = File.createTempFile("sped_bloco_c", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoC w = new UtilWritterBlocoC();
        Boolean gerarBloco = (Boolean)h.get("BlocoC");
        if (gerarBloco.booleanValue()) {
            int contador = 1;
            boolean flag = false;
            ArrayList<String> cnpjEmpresas = new ArrayList<String>();
            for (Empresa empresa : empresas) {
                if (cnpjEmpresas.contains(empresa.getPessoa().getComplemento().getCnpj())) continue;
                cnpjEmpresas.add(empresa.getPessoa().getComplemento().getCnpj());
            }
            int nrEmpresas = cnpjEmpresas.size();
            for (String cnpjEmpresa : cnpjEmpresas) {
                Short indicadorApuracaoIpi = this.getIndicadorApuracaoIpiPorCnpj(cnpjEmpresa, empresas);
                Boolean utilizaCodAux = this.getEmpresaUtilizaCodigoAuxiliar(vo);
                BlocoC notasTerceirosC100 = null;
                BlocoC notasTerceirosC395 = null;
                BlocoC notasTerceirosC500 = null;
                BlocoC notasPropriasC100 = null;
                notasPropriasC100 = this.novaVersaoArquivo != false ? new UtilBDBlocoC100NotasPropriaV2().getBlocoC100NotasProprias(dataIn, dataFim, cnpjEmpresa, vo.getIncidenciaPisCofinsExcluidas(), utilizaCodAux, vo.getIncidenciasMonofasico()) : new UtilBDBlocoC100NotasPropria().getBlocoC100NotasProprias(dataIn, dataFim, cnpjEmpresa, vo.getIncidenciaPisCofinsExcluidas(), utilizaCodAux, vo.getIncidenciasMonofasico());
                BlocoC notasPropriasC380 = new UtilBDBlocoC380NotaPropria().getBlocoC380NotasProprias(dataIn, dataFim, cnpjEmpresa, utilizaCodAux);
                BlocoC nfceC100 = new UtilBDBlocoC100NFCe().getBlocoC100NFCe(dataIn, dataFim, cnpjEmpresa, vo.getIncidenciaPisCofinsExcluidas(), vo.getIncidenciasMonofasico());
                if (!this.indicadorIncidenciaTrib.getCodigo().equals("2")) {
                    notasTerceirosC395 = new UtilBDBlocoC395NotaTerceiros().getBlocoC395NotasTerceiros(dataIn, dataFim, cnpjEmpresa, utilizaCodAux);
                    notasTerceirosC100 = new UtilBDBlocoC100NotaTerceiros().getBlocoC100NotasTerceiros(dataIn, dataFim, cnpjEmpresa, vo.getIncidenciaPisCofinsExcluidas(), utilizaCodAux);
                    notasTerceirosC500 = new UtilBDBlocoC500NotaTerceiros().getBlocoC500NotasTerceiros(dataIn, dataFim, cnpjEmpresa);
                }
                boolean comDados = this.existeRegistrosBlocoC(notasPropriasC100, notasTerceirosC100, notasPropriasC380, notasTerceirosC395, notasTerceirosC500, nfceC100);
                if (!flag) {
                    flag = this.gerarBlocoC001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoC010(p, cnpjEmpresa, w);
                    this.gerarBlocoC100NotaPropria(p, notasPropriasC100, cnpjEmpresa, w, indicadorApuracaoIpi);
                    this.gerarBlocoC100NFCe(p, nfceC100, cnpjEmpresa, w, indicadorApuracaoIpi);
                    this.gerarBlocoC100NotaTerceiros(p, notasTerceirosC100, cnpjEmpresa, w, indicadorApuracaoIpi);
                    this.gerarBlocoC380(p, notasPropriasC380, cnpjEmpresa, w);
                    this.gerarBlocoC395(p, notasTerceirosC395, cnpjEmpresa, w);
                    this.gerarBlocoC500(p, notasTerceirosC500, cnpjEmpresa, w);
                }
                ++contador;
            }
        }
        this.gerarBlocoC990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockP(Date dataIn, Date dataFim, List empresas, HashMap h, SpedPisCofins vo, List codigosAtivEc) throws IOException {
        File f = File.createTempFile("sped_bloco_p", ".txt");
        if (vo.getGerarBlocoP() == 1) {
            PrintWriter p = new PrintWriter(f);
            UtilWritterBlocoP w = new UtilWritterBlocoP();
            int contador = 1;
            int nrEmpresas = empresas.size();
            boolean flag = false;
            for (Object o : empresas) {
                boolean comDados;
                Empresa emp = (Empresa)o;
                if (emp.getEmpresaDados().getMatriz() != 1) continue;
                BlocoP blocoP100 = new UtilBDBlocoP().getBlocoP100(dataIn, dataFim, codigosAtivEc);
                boolean bl = comDados = blocoP100 != null && !blocoP100.getRegistrosP100().isEmpty();
                if (!flag) {
                    flag = this.gerarBlocoP001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoP010(p, emp.getPessoa().getComplemento().getCnpj(), w);
                    Double valorTotalApurado = this.gerarBlocoP100(p, blocoP100, w);
                    this.gerarBlocoP200(p, vo, valorTotalApurado, w);
                }
                ++contador;
            }
            this.gerarBlocoP990(p, w);
            p.flush();
            p.close();
        }
        return f;
    }

    private void gerarBlocoC100NotaPropria(PrintWriter p, BlocoC notasProprias, String cnpjEmpresa, UtilWritterBlocoC w, Short indicadorApuracaoIpi) {
        if (notasProprias != null) {
            Iterator<RegC100> iterator = notasProprias.getRegistrosC100().iterator();
            while (iterator.hasNext()) {
                RegC100 o;
                RegC100 r = o = iterator.next();
                boolean docCancInut = this.getDocCanceladoOuInutilizado(r.getCodSituacaoDoc());
                w.writterC100NotasProprias(p, r, docCancInut, this.cont);
                if (docCancInut) continue;
                w.writterC110(p, r.getObservacoes(), this.cont);
                this.setObservacoesC110(r.getObservacoes(), cnpjEmpresa);
                w.writterC111(p, r.getProcessosReferenciados(), this.cont);
                w.writterC170(p, r.getItensDocumento(), this.cont, cnpjEmpresa, this.planoConta, indicadorApuracaoIpi);
            }
            this.putParticpantes(notasProprias.getParticipantes(), cnpjEmpresa);
            this.putProdutos(notasProprias.getProdutos(), cnpjEmpresa);
            this.putNatOperacao(notasProprias.getNatOperacao(), cnpjEmpresa);
            this.putUnidMedida(notasProprias.getUnidadeMedidas(), cnpjEmpresa);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
    }

    private void gerarBlocoC100NotaTerceiros(PrintWriter p, BlocoC notasTerceiros, String cnpjEmpresa, UtilWritterBlocoC w, Short indicadorApuracaoIpi) {
        if (notasTerceiros != null) {
            Iterator<RegC010> iterator = notasTerceiros.getRegistrosC010().iterator();
            while (iterator.hasNext()) {
                RegC010 o;
                RegC010 rc = o = iterator.next();
                Iterator<RegC100> iterator2 = rc.getRegistrosC100().iterator();
                while (iterator2.hasNext()) {
                    RegC100 ob;
                    RegC100 r = ob = iterator2.next();
                    boolean docCancInut = this.getDocCanceladoOuInutilizado(r.getCodSituacaoDoc());
                    w.writterC100NotasTerceiros(p, r, docCancInut, this.cont);
                    if (docCancInut) continue;
                    w.writterC110(p, r.getObservacoes(), this.cont);
                    this.setObservacoesC110(r.getObservacoes(), cnpjEmpresa);
                    w.writterC111(p, r.getProcessosReferenciados(), this.cont);
                    w.writterC170(p, r.getItensDocumento(), this.cont, cnpjEmpresa, this.planoConta, indicadorApuracaoIpi);
                }
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), cnpjEmpresa);
            this.putProdutos(notasTerceiros.getProdutos(), cnpjEmpresa);
            this.putNatOperacao(notasTerceiros.getNatOperacao(), cnpjEmpresa);
            this.putUnidMedida(notasTerceiros.getUnidadeMedidas(), cnpjEmpresa);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoC380(PrintWriter p, BlocoC notasProprias, String cnpjEmpresa, UtilWritterBlocoC w) {
        if (notasProprias != null) {
            Iterator<RegC380> iterator = notasProprias.getRegistrosC380().iterator();
            while (iterator.hasNext()) {
                RegC380 o;
                RegC380 r = o = iterator.next();
                w.writterC380NotasPropriasTerceiros(p, r, this.cont, this.planoConta);
            }
            this.putProdutos(notasProprias.getProdutos(), cnpjEmpresa);
            this.putUnidMedida(notasProprias.getUnidadeMedidas(), cnpjEmpresa);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
    }

    private void putProdutos(List reg, String cnpjEmpresa) {
        HashSet produtos = (HashSet)this.hashEmpresasProdutos.get(cnpjEmpresa);
        if (ToolMethods.isWithData((Collection)reg)) {
            produtos.addAll(reg);
        }
    }

    private void putParticpantes(List reg, String cnpjEmpresa) {
        HashSet participantes = (HashSet)this.hashEmpresasParicipantes.get(cnpjEmpresa);
        if (ToolMethods.isWithData((Collection)reg)) {
            participantes.addAll(reg);
        }
    }

    private void putNatOperacao(List reg, String cnpjEmpresa) {
        HashSet naturOperacao = (HashSet)this.hashEmpresasNaturezas.get(cnpjEmpresa);
        if (ToolMethods.isWithData((Collection)reg)) {
            naturOperacao.addAll(reg);
        }
    }

    private void putUnidMedida(List reg, String cnpjEmpresa) {
        HashSet unid = (HashSet)this.hashEmpresasUnidades.get(cnpjEmpresa);
        if (ToolMethods.isWithData((Collection)reg)) {
            unid.addAll(reg);
        }
    }

    private void putObservacoes(List reg, String cnpjEmpresa) {
        HashSet obs = (HashSet)this.hashEmpresasObservacoes.get(cnpjEmpresa);
        if (ToolMethods.isWithData((Collection)reg)) {
            obs.addAll(reg);
        }
    }

    private void putPlanoContas(List reg) {
        if (ToolMethods.isWithData((Collection)reg)) {
            this.hashEmpresasPlanos.addAll(reg);
        }
    }

    private void putPlanoContas(Reg500 reg500) {
        if (reg500 != null) {
            this.hashEmpresasPlanos.add(reg500);
        }
    }

    private void putCentroCustos(List reg) {
        if (ToolMethods.isWithData((Collection)reg)) {
            this.hashEmpresasCentroCustos.addAll(reg);
        }
    }

    private void gerarBlocoC395(PrintWriter p, BlocoC notasTerceiros, String cnpjEmpresa, UtilWritterBlocoC w) {
        if (notasTerceiros != null) {
            Iterator<RegC395> iterator = notasTerceiros.getRegistrosC395().iterator();
            while (iterator.hasNext()) {
                RegC395 o;
                RegC395 r = o = iterator.next();
                w.writterC395NotasPropriasTerceiros(p, r, this.cont, this.planoConta);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), cnpjEmpresa);
            this.putProdutos(notasTerceiros.getProdutos(), cnpjEmpresa);
            this.putUnidMedida(notasTerceiros.getUnidadeMedidas(), cnpjEmpresa);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoC500(PrintWriter p, BlocoC notasTerceiros, String cnpjEmpresa, UtilWritterBlocoC w) {
        if (notasTerceiros != null) {
            Iterator<RegC500> iterator = notasTerceiros.getRegistrosC500().iterator();
            while (iterator.hasNext()) {
                RegC500 o;
                RegC500 regC500 = o = iterator.next();
                w.writterRegC500NotasTerceiros(p, regC500, this.cont, this.planoConta);
                this.setObservacoesC500(regC500.getObsFaturamento(), cnpjEmpresa);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), cnpjEmpresa);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private File createWritterBlockD(Date dataIn, Date dataFim, List<Empresa> empresas, HashMap h) throws IOException {
        File f = File.createTempFile("sped_bloco_d", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoD w = new UtilWritterBlocoD();
        Boolean gerarBloco = (Boolean)h.get("BlocoD");
        if (gerarBloco.booleanValue()) {
            int contador = 1;
            boolean flag = false;
            ArrayList<String> cnpjEmpresas = new ArrayList<String>();
            for (Empresa empresa : empresas) {
                if (cnpjEmpresas.contains(empresa.getPessoa().getComplemento().getCnpj())) continue;
                cnpjEmpresas.add(empresa.getPessoa().getComplemento().getCnpj());
            }
            int nrEmpresas = cnpjEmpresas.size();
            for (String cnpjEmpresa : cnpjEmpresas) {
                BlocoD notasTerceirosD100 = null;
                BlocoD notasTerceirosD500 = null;
                BlocoD conhecimentosD200 = new UtilBDBlocoD200CTe().getBlocoD200CTeSaida(cnpjEmpresa, dataIn, dataFim);
                if (!this.indicadorIncidenciaTrib.getCodigo().equals("2")) {
                    notasTerceirosD100 = new UtilBDBlocoD100NotaTerceiros().getBlocoD100NotasTerceirosTransporte(cnpjEmpresa, dataIn, dataFim);
                    notasTerceirosD500 = new UtilBDBlocoD500NotaTerceiros().getBlocoD500NotasTerceirosTelecomunicacao(cnpjEmpresa, dataIn, dataFim);
                }
                boolean comDados = this.existeRegistrosBlocoD(notasTerceirosD100, conhecimentosD200, notasTerceirosD500);
                if (!flag) {
                    flag = this.gerarBlocoD001(p, comDados, flag, contador, nrEmpresas, w);
                }
                if (comDados) {
                    this.gerarBlocoD010(p, cnpjEmpresa, w);
                    this.gerarBlocoD100(p, notasTerceirosD100, cnpjEmpresa, w);
                    this.gerarBlocoD200(p, conhecimentosD200, w);
                    this.gerarBlocoD500(p, notasTerceirosD500, cnpjEmpresa, w);
                }
                ++contador;
            }
        }
        this.gerarBlocoD990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private void gerarBlocoD100(PrintWriter p, BlocoD notasTerceiros, String cnpjEmpresa, UtilWritterBlocoD w) {
        if (notasTerceiros != null) {
            Iterator<RegD100> iterator = notasTerceiros.getRegistrosD100().iterator();
            while (iterator.hasNext()) {
                RegD100 o;
                RegD100 r = o = iterator.next();
                w.writterRegD100NotasTerceiros(p, r, this.cont, this.hashEmpresasPlanos, this.planoConta);
                this.setObservacoesC500(r.getObsFaturamento(), cnpjEmpresa);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), cnpjEmpresa);
            this.putPlanoContas(notasTerceiros.getPlanosContas());
        }
    }

    private void gerarBlocoD200(PrintWriter p, BlocoD conhecimentos, UtilWritterBlocoD w) {
        if (conhecimentos != null) {
            Iterator<RegD200> iterator = conhecimentos.getRegistrosD200().iterator();
            while (iterator.hasNext()) {
                RegD200 o;
                RegD200 r = o = iterator.next();
                w.writterRegD200Conhecimentos(p, r, this.cont, this.planoConta);
            }
            this.putPlanoContas(conhecimentos.getPlanosContas());
        }
    }

    private void gerarBlocoD500(PrintWriter p, BlocoD notasTerceiros, String cnpjEmpresa, UtilWritterBlocoD w) {
        if (notasTerceiros != null) {
            Iterator<RegD500> iterator = notasTerceiros.getRegistrosD500().iterator();
            while (iterator.hasNext()) {
                RegD500 o;
                RegD500 r = o = iterator.next();
                w.writterRegD500NotasTerceiros(p, r, this.cont, this.planoConta);
                this.setObservacoesC500(r.getObsFaturamento(), cnpjEmpresa);
            }
            this.putParticpantes(notasTerceiros.getParticipantes(), cnpjEmpresa);
        }
    }

    private File createWritterBlock9() throws IOException {
        File f = File.createTempFile("sped_bloco_9", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco9 w = new UtilWritterBloco9();
        this.gerarBloco9001(p, w);
        this.gerarBloco9900(p, w);
        this.gerarBloco9990(p, w);
        this.gerarBloco9999(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File writterBlock1(Bloco1 bloco1900, Bloco1 bloco1100, Bloco1 bloco1500) throws IOException {
        File f = File.createTempFile("sped_bloco_1", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco1 w = new UtilWritterBloco1();
        boolean comDados = bloco1900 != null && bloco1900.getRegistros1900() != null && !bloco1900.getRegistros1900().isEmpty() || bloco1100 != null && bloco1100.getRegistros1100() != null && !bloco1100.getRegistros1100().isEmpty() || bloco1500 != null && bloco1500.getRegistros1500() != null && !bloco1500.getRegistros1500().isEmpty();
        this.gerarBloco1001(p, comDados, w);
        if (comDados) {
            this.gerarBloco1100(p, bloco1100, w);
            this.gerarBloco1500(p, bloco1500, w);
            this.gerarBloco1900(p, bloco1900, w);
        }
        this.gerarBloco1990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockF(Date dataIn, Date dataFim, List<Empresa> empresas, SpedPisCofins vo) throws IOException {
        File f = File.createTempFile("sped_bloco_f", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoF w = new UtilWritterBlocoF();
        boolean comDados = false;
        boolean flag = false;
        int contador = 1;
        ArrayList<String> cnpjEmpresas = new ArrayList<String>();
        for (Empresa empresa : empresas) {
            if (cnpjEmpresas.contains(empresa.getPessoa().getComplemento().getCnpj())) continue;
            cnpjEmpresas.add(empresa.getPessoa().getComplemento().getCnpj());
        }
        int nrEmpresas = cnpjEmpresas.size();
        for (String cnpjEmpresa : cnpjEmpresas) {
            Boolean utilizaCodAux = this.getEmpresaUtilizaCodigoAuxiliar(vo);
            BlocoF blocoF100 = null;
            BlocoF blocoF120 = new UtilBDBlocoF120().getRegistrosBlocoF120(cnpjEmpresa, dataIn, dataFim);
            BlocoF blocoF130 = new UtilBDBlocoF130().getRegistrosBlocoF130(cnpjEmpresa, dataIn, dataFim);
            BlocoF blocoF150 = null;
            BlocoF blocoF550 = null;
            BlocoF blocoF500 = null;
            BlocoF blocoF525 = null;
            if (vo.getIndicadorRegimeCumulativo() != null && vo.getIndicadorRegimeCumulativo().getCodigo().equals("1")) {
                blocoF500 = new UtilBDBlocoF500().getRegistrosBlocoF500(vo);
                blocoF525 = new UtilBDBlocoF525().getRegistrosBlocoF525(vo);
            } else if (vo.getIndicadorRegimeCumulativo() != null && vo.getIndicadorRegimeCumulativo().getCodigo().equals("2")) {
                blocoF550 = new UtilBDBlocoF550().getRegistrosBlocoF550(cnpjEmpresa, dataIn, dataFim);
            } else {
                blocoF100 = new UtilBDBlocoF100().getLancamentosBlocoF100(cnpjEmpresa, dataIn, dataFim, utilizaCodAux);
                blocoF150 = new UtilBDBlocoF150().getRegistrosBlocoF150(vo, cnpjEmpresa);
            }
            BlocoF blocoF600 = new UtilBDBlocoF600().getRegistrosBlocoF600(vo);
            BlocoF blocoF700 = new UtilBDBlocoF700().getRegistrosBlocoF700(vo, cnpjEmpresa);
            comDados = this.existeRegistrosBlocoF(blocoF100, blocoF120, blocoF130, blocoF150, blocoF550, blocoF500, blocoF525, blocoF600, blocoF700);
            if (!flag) {
                flag = this.gerarBlocoF001(p, comDados, flag, contador, nrEmpresas, w);
            }
            if (comDados) {
                this.gerarBlocoF010(p, cnpjEmpresa, w);
                this.gerarBlocoF100(p, blocoF100, cnpjEmpresa, w);
                this.gerarBlocoF120(p, blocoF120, w);
                this.gerarBlocoF130(p, blocoF130, w);
                this.gerarBlocoF150(p, blocoF150, w);
                this.gerarBlocoF500(p, blocoF500, w);
                this.gerarBlocoF525(p, blocoF525, w);
                this.gerarBlocoF550(p, blocoF550, w);
                this.gerarBlocoF600(p, blocoF600, w);
                this.gerarBlocoF700(p, blocoF700, w);
            }
            ++contador;
        }
        this.gerarBlocoF990(p, w);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlockM(Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa, SpedPisCofins vo) throws IOException {
        File f = File.createTempFile("sped_bloco_m", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoM w = new UtilWritterBlocoM();
        boolean comDados = false;
        ApuracaoPisCofins apuracaoPisCofins = new UtilBDBlocoM().getApuracaoPisCofinsPorPeridoAndGrupoEmpresa(dataIn, grupoEmpresa);
        List<Reg500> planosContas = new UtilBDBlocoM().findPlanoContas(dataIn, grupoEmpresa);
        if (vo.getGerarBlocoM() == 1 && apuracaoPisCofins != null) {
            comDados = true;
            if (vo.getGerarBlocoM400M800() == 1) {
                this.gerarBlocoM001(p, comDados, w);
                this.gerarBlocoM400(p, w, apuracaoPisCofins);
                this.gerarBlocoM800(p, w, apuracaoPisCofins);
                this.gerarBlocoM990(p, w);
            } else {
                this.gerarBlocoM001(p, comDados, w);
                this.gerarBlocoM100(p, w, apuracaoPisCofins);
                this.gerarBlocoM200(p, w, apuracaoPisCofins);
                this.gerarBlocoM350(p, w, apuracaoPisCofins);
                this.gerarBlocoM400(p, w, apuracaoPisCofins);
                this.gerarBlocoM500(p, w, apuracaoPisCofins);
                this.gerarBlocoM600(p, w, apuracaoPisCofins);
                this.gerarBlocoM800(p, w, apuracaoPisCofins);
                this.gerarBlocoM990(p, w);
            }
            this.putPlanoContas(planosContas);
        } else {
            this.gerarBlocoM001(p, comDados, w);
            this.gerarBlocoM990(p, w);
        }
        p.flush();
        p.close();
        return f;
    }

    private void apendToSomeFile(File file, File bloco0, File blocoA, File blocoC, File blocoD, File blocoF, File blocoM, File bloco1, File bloco9, File blocoP) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.copy(bloco0, out);
        this.copy(blocoA, out);
        this.copy(blocoC, out);
        this.copy(blocoD, out);
        this.copy(blocoF, out);
        this.copy(blocoM, out);
        this.copy(blocoP, out);
        this.copy(bloco1, out);
        this.copy(bloco9, out);
        bloco0.delete();
        blocoC.delete();
        bloco9.delete();
        ((OutputStream)out).close();
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private void gerarBlocoA100NotaTerceiros(PrintWriter p, BlocoA notasTerceiros, String cnpjEmpresa, UtilWritterBlocoA w) {
        if (notasTerceiros != null) {
            Iterator<RegA100> iterator = notasTerceiros.getRegistrosA100().iterator();
            while (iterator.hasNext()) {
                RegA100 o;
                RegA100 r = o = iterator.next();
                w.writterRegA100NotasPropriasTerceiros(p, r, this.cont, this.planoConta);
                this.setObservacoesNotaA110(r.getObservacoes(), cnpjEmpresa);
            }
            this.putProdutos(notasTerceiros.getProdutos(), cnpjEmpresa);
            this.putParticpantes(notasTerceiros.getParticipantes(), cnpjEmpresa);
            this.putUnidMedida(notasTerceiros.getUnidMedidas(), cnpjEmpresa);
            this.putPlanoContas(notasTerceiros.getPlanoContas());
        }
    }

    private void gerarBlocoA100NotaPropria(PrintWriter p, BlocoA notasProprias, String cnpjEmpresa, UtilWritterBlocoA w) {
        if (notasProprias != null) {
            Iterator<RegA100> iterator = notasProprias.getRegistrosA100().iterator();
            while (iterator.hasNext()) {
                RegA100 o;
                RegA100 r = o = iterator.next();
                w.writterRegA100NotasPropriasTerceiros(p, r, this.cont, this.planoConta);
                this.setObservacoesNotaA110(r.getObservacoes(), cnpjEmpresa);
            }
            this.putProdutos(notasProprias.getProdutos(), cnpjEmpresa);
            this.putParticpantes(notasProprias.getParticipantes(), cnpjEmpresa);
            this.putUnidMedida(notasProprias.getUnidMedidas(), cnpjEmpresa);
            this.putPlanoContas(notasProprias.getPlanoContas());
        }
    }

    private void writterA010(PrintWriter p, String cnpj) {
        p.append(this.separator + "A010");
        p.append(this.separator + this.form.clearString(cnpj));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("A010");
    }

    private void gerarBlocoF100(PrintWriter p, BlocoF blocoF, String cnpjEmpresa, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF100> iterator = blocoF.getRegistrosF100().iterator();
            while (iterator.hasNext()) {
                RegF100 o;
                RegF100 r = o = iterator.next();
                w.writterRegF100(p, r, this.cont, this.planoConta);
            }
            this.putParticpantes(blocoF.getParticipantes(), cnpjEmpresa);
            this.putProdutos(blocoF.getProdutos(), cnpjEmpresa);
            this.putUnidMedida(blocoF.getUnidadeMedidas(), cnpjEmpresa);
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void gerarBlocoF120(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF120> iterator = blocoF.getRegistrosF120().iterator();
            while (iterator.hasNext()) {
                RegF120 o;
                RegF120 r = o = iterator.next();
                w.writterRegF120(p, r, this.cont, this.planoConta);
            }
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void gerarBlocoF130(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF130> iterator = blocoF.getRegistrosF130().iterator();
            while (iterator.hasNext()) {
                RegF130 o;
                RegF130 r = o = iterator.next();
                w.writterRegF130(p, r, this.cont, this.planoConta);
            }
            this.putCentroCustos(blocoF.getCentroCustos());
            this.putPlanoContas(blocoF.getPlanoContas());
        }
    }

    private void gerarBlocoF150(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF150> iterator = blocoF.getRegistrosF150().iterator();
            while (iterator.hasNext()) {
                RegF150 o;
                RegF150 r = o = iterator.next();
                w.writterRegF150(p, r, this.cont, this.planoConta);
                if (r.getPlanoConta() == null) continue;
                this.putPlanoContas(r.getPlanoConta());
            }
        }
    }

    private void gerarBlocoF500(PrintWriter p, BlocoF blocoF500, UtilWritterBlocoF w) {
        if (blocoF500 != null) {
            Iterator<RegF500> iterator = blocoF500.getRegistrosF500().iterator();
            while (iterator.hasNext()) {
                RegF500 o;
                RegF500 r = o = iterator.next();
                w.writterRegF500(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoF525(PrintWriter p, BlocoF blocoF525, UtilWritterBlocoF w) {
        if (blocoF525 != null) {
            Iterator<RegF525> iterator = blocoF525.getRegistrosF525().iterator();
            while (iterator.hasNext()) {
                RegF525 o;
                RegF525 r = o = iterator.next();
                w.writterRegF525(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoF550(PrintWriter p, BlocoF blocoF550, UtilWritterBlocoF w) {
        if (blocoF550 != null) {
            Iterator<RegF550> iterator = blocoF550.getRegistrosF550().iterator();
            while (iterator.hasNext()) {
                RegF550 o;
                RegF550 r = o = iterator.next();
                w.writterRegF550(p, r, this.cont);
            }
            this.putPlanoContas(blocoF550.getPlanoContas());
        }
    }

    private void gerarBlocoF600(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF600> iterator = blocoF.getRegistrosF600().iterator();
            while (iterator.hasNext()) {
                RegF600 o;
                RegF600 r = o = iterator.next();
                w.writterRegF600(p, r, this.cont);
            }
        }
    }

    private void gerarBlocoF700(PrintWriter p, BlocoF blocoF, UtilWritterBlocoF w) {
        if (blocoF != null) {
            Iterator<RegF700> iterator = blocoF.getRegistrosF700().iterator();
            while (iterator.hasNext()) {
                RegF700 o;
                RegF700 r = o = iterator.next();
                w.writterRegF700(p, r, this.cont);
            }
        }
    }

    private HashMap getRegistrosGerados(SpedPisCofins vo) throws SpedPisCofinsWritterException {
        HashMap<String, Boolean> h = new HashMap<String, Boolean>();
        h.put("Bloco0", true);
        h.put("Bloco1", true);
        h.put("Bloco9", true);
        h.put("BlocoA", true);
        h.put("BlocoC", true);
        h.put("BlocoD", true);
        h.put("BlocoF", true);
        h.put("BlocoM", true);
        h.put("Registro1900", false);
        if (vo.getIndicadorRegimeCumulativo() != null) {
            if (vo.getIndicadorRegimeCumulativo().getCodigo().equals("1")) {
                h.put("BlocoA", false);
                h.put("BlocoC", false);
                h.put("BlocoD", false);
                h.put("BlocoF", true);
                h.put("BlocoM", true);
                h.put("Registro1900", true);
            } else if (vo.getIndicadorRegimeCumulativo().getCodigo().equals("2")) {
                h.put("BlocoA", false);
                h.put("BlocoC", false);
                h.put("BlocoD", false);
                h.put("BlocoF", true);
                h.put("BlocoM", true);
                h.put("Registro1900", true);
            }
        }
        return h;
    }

    private void gerarBloco1900(PrintWriter p, Bloco1 bloco1900, UtilWritterBloco1 w) {
        if (bloco1900 != null && !bloco1900.getRegistros1900().isEmpty()) {
            Iterator<Reg1900> iterator = bloco1900.getRegistros1900().iterator();
            while (iterator.hasNext()) {
                Reg1900 o;
                Reg1900 r = o = iterator.next();
                w.writerReg1900(p, r, this.cont);
            }
        }
    }

    private boolean existeRegistrosBlocoC(BlocoC notasPropriasC100, BlocoC notasTerceirosC100, BlocoC notasPropriasC380, BlocoC notasTerceirosC395, BlocoC notasTerceirosC500, BlocoC nfceC100) {
        return notasPropriasC100 != null && notasPropriasC100.getRegistrosC100() != null && !notasPropriasC100.getRegistrosC100().isEmpty() || nfceC100 != null && nfceC100.getRegistrosC100() != null && !nfceC100.getRegistrosC100().isEmpty() || notasTerceirosC100 != null && notasTerceirosC100.getRegistrosC010() != null && !notasTerceirosC100.getRegistrosC010().isEmpty() || notasPropriasC380 != null && notasPropriasC380.getRegistrosC380() != null && !notasPropriasC380.getRegistrosC380().isEmpty() || notasTerceirosC395 != null && notasTerceirosC395.getRegistrosC395() != null && !notasTerceirosC395.getRegistrosC395().isEmpty() || notasTerceirosC500 != null && notasTerceirosC500.getRegistrosC500() != null && !notasTerceirosC500.getRegistrosC500().isEmpty();
    }

    private void gerarBlocoC010(PrintWriter p, String cnpj, UtilWritterBlocoC w) {
        w.writterC010(p, cnpj, this.cont);
    }

    private boolean existeRegistrosBlocoA(BlocoA notasServicoTercA100, BlocoA notasServicoPropA100) {
        return notasServicoTercA100 != null && notasServicoTercA100.getRegistrosA100() != null && !notasServicoTercA100.getRegistrosA100().isEmpty() || notasServicoPropA100 != null && notasServicoPropA100.getRegistrosA100() != null && !notasServicoPropA100.getRegistrosA100().isEmpty();
    }

    private void gerarBlocoA010(PrintWriter p, String cnpj) {
        this.writterA010(p, cnpj);
    }

    private boolean existeRegistrosBlocoD(BlocoD notasTerceirosD100, BlocoD conhecimentosD200, BlocoD notasTerceirosD500) {
        return notasTerceirosD100 != null && notasTerceirosD100.getRegistrosD100() != null && !notasTerceirosD100.getRegistrosD100().isEmpty() || notasTerceirosD500 != null && notasTerceirosD500.getRegistrosD500() != null && !notasTerceirosD500.getRegistrosD500().isEmpty() || conhecimentosD200 != null && conhecimentosD200.getRegistrosD200() != null && !conhecimentosD200.getRegistrosD200().isEmpty();
    }

    private void gerarBlocoD010(PrintWriter p, String cnpj, UtilWritterBlocoD w) {
        w.writterD010(p, cnpj, this.cont);
    }

    private boolean existeRegistrosBlocoF(BlocoF blocoF100, BlocoF blocoF120, BlocoF blocoF130, BlocoF blocoF150, BlocoF blocoF550, BlocoF blocoF500, BlocoF blocoF525, BlocoF blocoF600, BlocoF blocoF700) {
        return blocoF100 != null && blocoF100.getRegistrosF100() != null && !blocoF100.getRegistrosF100().isEmpty() || blocoF120 != null && blocoF120.getRegistrosF120() != null && !blocoF120.getRegistrosF120().isEmpty() || blocoF130 != null && blocoF130.getRegistrosF130() != null && !blocoF130.getRegistrosF130().isEmpty() || blocoF150 != null && blocoF150.getRegistrosF150() != null && !blocoF150.getRegistrosF150().isEmpty() || blocoF600 != null && blocoF600.getRegistrosF600() != null && !blocoF600.getRegistrosF600().isEmpty() || blocoF700 != null && blocoF700.getRegistrosF700() != null && !blocoF700.getRegistrosF700().isEmpty() || blocoF550 != null && blocoF550.getRegistrosF550() != null && !blocoF550.getRegistrosF550().isEmpty() || blocoF500 != null && blocoF500.getRegistrosF500() != null && !blocoF500.getRegistrosF500().isEmpty() || blocoF525 != null && blocoF525.getRegistrosF525() != null && !blocoF525.getRegistrosF525().isEmpty();
    }

    private void gerarBlocoF010(PrintWriter p, String cnpj, UtilWritterBlocoF w) {
        w.writterF010(p, cnpj, this.cont);
    }

    private void gerarBloco0100(PrintWriter p, Empresa emp, UtilWritterBloco0 writter) throws SpedPisCofinsWritterException {
        EmpresaContabilidade contabilidade = new UtilBDBloco0().getEmpresaContabilidade(emp);
        if (contabilidade.getPessoa() == null) {
            throw new SpedPisCofinsWritterException("Informe o Contador respons\u00e1vel pela empresa.");
        }
        writter.writterReg0100(p, emp, contabilidade, this.cont);
    }

    private void gerarBloco0110(PrintWriter p, SpedPisCofins vo, UtilWritterBloco0 writter) {
        writter.writterReg0110(p, vo, this.cont);
    }

    private void gerarBloco0111(PrintWriter p, SpedPisCofins vo, UtilWritterBloco0 w) {
        w.writterReg0111(p, vo, this.cont);
    }

    private void gerarBloco0140(PrintWriter p, List empresas, Date dataIn, Date dataFim, Reg0145 reg0145, UtilWritterBloco0 w) throws ExceptionDatabase {
        w.writterReg0140(p, empresas, dataIn, dataFim, reg0145, this.cont, this.hashEmpresasParicipantes, this.hashEmpresasUnidades, this.hashEmpresasProdutos, this.hashEmpresasNaturezas, this.hashEmpresasObservacoes);
    }

    private void gerarBloco0500(PrintWriter p, UtilWritterBloco0 w) {
        this.criarReg0500Padrao();
        w.writterReg0500(p, this.cont, this.hashEmpresasPlanos);
    }

    private void gerarBloco0600(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0600(p, this.cont, this.hashEmpresasCentroCustos);
    }

    private void gerarBloco0990(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0990(p, this.cont);
    }

    private void gerarBloco0000(PrintWriter p, Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo, UtilWritterBloco0 w) {
        w.writterReg0000(p, dataIn, dataFim, emp, vo, this.cont);
    }

    private void gerarBloco0001(PrintWriter p, UtilWritterBloco0 w) {
        w.writterReg0001(p, this.cont);
    }

    private void gerarBloco0035(PrintWriter p, Empresa emp, SpedPisCofins vo, UtilWritterBloco0 w) {
        w.writterReg0035(p, vo, this.cont);
    }

    private void setObservacoesNotaA110(List<RegA110> observacoes, String cnpjEmpresa) {
        if (observacoes != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Iterator<RegA110> iterator = observacoes.iterator();
            while (iterator.hasNext()) {
                RegA110 o;
                RegA110 reg = o = iterator.next();
                Reg450 r = new Reg450();
                r.setDescricao(reg.getDescricao());
                r.setIdObservacao(reg.getIdObservacao());
                dados.add(r);
            }
            this.putObservacoes(dados, cnpjEmpresa);
        }
    }

    private boolean getDocCanceladoOuInutilizado(String sitDoc) {
        return sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
    }

    private void setObservacoesC110(List<RegC110> observacoes, String cnpjEmpresa) {
        if (observacoes != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Iterator<RegC110> iterator = observacoes.iterator();
            while (iterator.hasNext()) {
                RegC110 o;
                RegC110 reg = o = iterator.next();
                Reg450 r = new Reg450();
                r.setDescricao(reg.getDescricao());
                r.setIdObservacao(reg.getIdObservacao());
                dados.add(r);
            }
            this.putObservacoes(dados, cnpjEmpresa);
        }
    }

    private void setObservacoesC500(ObsFaturamento obsFaturamento, String cnpjEmpresa) {
        if (obsFaturamento != null) {
            ArrayList<Reg450> dados = new ArrayList<Reg450>();
            Reg450 reg450 = new Reg450();
            reg450.setIdObservacao(obsFaturamento.getIdentificador());
            reg450.setDescricao(obsFaturamento.getNome());
            dados.add(reg450);
            this.putObservacoes(dados, cnpjEmpresa);
        }
    }

    private boolean gerarBlocoF001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoF w) {
        return w.writterF001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBloco1001(PrintWriter p, boolean comDados, UtilWritterBloco1 w) {
        w.writter1001(p, comDados, this.cont);
    }

    private void gerarBloco1990(PrintWriter p, UtilWritterBloco1 w) {
        w.writter1990(p, this.cont);
    }

    private void gerarBlocoF990(PrintWriter p, UtilWritterBlocoF w) {
        w.writterF990(p, this.cont);
    }

    private void gerarBlocoM001(PrintWriter p, boolean comDados, UtilWritterBlocoM w) {
        w.writterM001(p, comDados, this.cont);
    }

    private void gerarBlocoM990(PrintWriter p, UtilWritterBlocoM w) {
        w.writterM990(p, this.cont);
    }

    private void gerarBloco9001(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9001(p, this.cont);
    }

    private void gerarBloco9900(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9900(p, this.cont);
    }

    private void gerarBloco9990(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9990(p, this.cont);
    }

    private void gerarBloco9999(PrintWriter p, UtilWritterBloco9 w) {
        w.writterReg9999(p, this.cont);
    }

    private boolean gerarBlocoA001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoA w) {
        return w.writerA001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoA990(PrintWriter p, UtilWritterBlocoA w) {
        w.writterA990(p, this.cont);
    }

    private boolean gerarBlocoC001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoC w) {
        return w.writerC001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoC990(PrintWriter p, UtilWritterBlocoC w) {
        w.writterC990(p, this.cont);
    }

    private boolean gerarBlocoD001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoD w) {
        return w.writterRegD001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoD990(PrintWriter p, UtilWritterBlocoD w) {
        w.writterD990(p, this.cont);
    }

    private Reg0145 getRegistr0145(PrintWriter p, Date dataIn, Date dataFim, SpedPisCofins vo, UtilWritterBloco0 w, List codigosAtivEc) throws SpedPisCofinsWritterException, ExceptionDatabase {
        Reg0145 r = new UtilBDBloco0().getBloco0145(codigosAtivEc, dataIn, dataFim, vo.getIncidenciaTribContrPrev());
        return r;
    }

    private boolean gerarBlocoP001(PrintWriter p, boolean comDados, boolean flag, int contador, int nrEmpresas, UtilWritterBlocoP w) {
        return w.writerP001(p, comDados, flag, contador, nrEmpresas, this.cont);
    }

    private void gerarBlocoP010(PrintWriter p, String cnpj, UtilWritterBlocoP w) {
        w.writterP010(p, cnpj, this.cont);
    }

    private Double gerarBlocoP100(PrintWriter p, BlocoP blocoP100, UtilWritterBlocoP w) {
        Double valorTotalApurado = w.writterP100(p, blocoP100.getRegistrosP100(), this.cont, this.vrReceitaBrutaTotal);
        this.putPlanoContas(blocoP100.getPlanoContas());
        return valorTotalApurado;
    }

    private void gerarBlocoP990(PrintWriter p, UtilWritterBlocoP w) {
        w.writterP990(p, this.cont);
    }

    private void gerarBlocoP200(PrintWriter p, SpedPisCofins vo, Double valorTotalApurado, UtilWritterBlocoP w) {
        Double valorAjusteReducao = 0.0;
        Double valorAjusteAcrescimo = 0.0;
        ArrayList<RegP210> registrosP210 = new ArrayList<RegP210>();
        for (Object o : vo.getRegistrosP210()) {
            AjusteContribuicaoPrevidenciaPisCofins ajuste = (AjusteContribuicaoPrevidenciaPisCofins)o;
            RegP210 regP210 = new RegP210();
            regP210.setIndicadorAjuste(ajuste.getIndicadorAjuste());
            regP210.setDataReferencia(ajuste.getDataAjuste());
            regP210.setCodigoAjuste(ajuste.getCodigoAjuste().getCodigo());
            regP210.setDescricaoAjuste(ajuste.getDescricaoAjuste());
            regP210.setNumDoc(ajuste.getNrProcesso());
            regP210.setValorAjuste(ajuste.getValorAjuste());
            registrosP210.add(regP210);
            if (ajuste.getIndicadorAjuste().equals((short)0)) {
                valorAjusteReducao = valorAjusteReducao + ajuste.getValorAjuste();
                continue;
            }
            valorAjusteAcrescimo = valorAjusteAcrescimo + ajuste.getValorAjuste();
        }
        RegP200 r = new RegP200();
        r.setPeriodoReferencia(DateUtil.dateToStr(vo.getDataInicial(), "MMyyyy"));
        r.setValorTotalContApurado(valorTotalApurado);
        r.setValorTotalAjustesReducao(valorAjusteReducao);
        r.setValorTotalAjustesAcrescimo(valorAjusteAcrescimo);
        r.setValorTotalContDev(r.getValorTotalContApurado() - r.getValorTotalAjustesReducao() + r.getValorTotalAjustesAcrescimo());
        r.setCodigoReceita(vo.getCodigoReceitaContribuicaoPrevidenciaria().getCodigo() + "01");
        r.setRegistrosP210(registrosP210);
        w.writterP200(p, r, this.cont);
    }

    private void gerarBlocoM100(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM100(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoM200(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM200(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoM350(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM350(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoM400(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM400(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoM500(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM500(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoM600(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM600(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoM800(PrintWriter p, UtilWritterBlocoM w, ApuracaoPisCofins apuracaoPisCofins) {
        w.writterM800(p, this.cont, apuracaoPisCofins);
    }

    private void gerarBlocoC100NFCe(PrintWriter p, BlocoC nfces, String cnpjEmpresa, UtilWritterBlocoC w, Short indicadorApuracaoIpi) {
        if (nfces != null) {
            Iterator<RegC100> iterator = nfces.getRegistrosC100().iterator();
            while (iterator.hasNext()) {
                RegC100 o;
                RegC100 r = o = iterator.next();
                boolean docCancInut = this.getDocCanceladoOuInutilizado(r.getCodSituacaoDoc());
                w.writterC100NotasProprias(p, r, docCancInut, this.cont);
                if (docCancInut) continue;
                w.writterC110(p, r.getObservacoes(), this.cont);
                this.setObservacoesC110(r.getObservacoes(), cnpjEmpresa);
                w.writterC111(p, r.getProcessosReferenciados(), this.cont);
                w.writterC170(p, r.getItensDocumento(), this.cont, cnpjEmpresa, this.planoConta, indicadorApuracaoIpi);
                w.writterC175(p, r.getItensNFCe(), this.cont);
            }
            this.putParticpantes(nfces.getParticipantes(), cnpjEmpresa);
            this.putProdutos(nfces.getProdutos(), cnpjEmpresa);
            this.putNatOperacao(nfces.getNatOperacao(), cnpjEmpresa);
            this.putUnidMedida(nfces.getUnidadeMedidas(), cnpjEmpresa);
            this.putPlanoContas(nfces.getPlanoContas());
        }
    }

    private OpcoesFaturamento getOpcoesFaturamento(Empresa empresa) throws ExceptionService {
        return (OpcoesFaturamento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getOpcoesFaturamentoDAO(), "empresa", empresa, 0);
    }

    private Boolean getEmpresaUtilizaCodigoAuxiliar(SpedPisCofins vo) {
        if (vo != null && ToolMethods.isEquals((Object)vo.getUtilizarCodAuxProduto(), (Object)1)) {
            return true;
        }
        return false;
    }

    private void criarReg0500Padrao() {
        if (this.planoConta != null) {
            Reg500 r = new Reg500();
            r.setCodigo(this.planoConta.getCodigo());
            r.setIdPlanoContas(this.planoConta.getIdentificador());
            r.setDataInclusao(this.planoConta.getDataCadastro());
            r.setDescricao(this.planoConta.getDescricao());
            r.setMarca(this.planoConta.getMarca());
            if (this.planoConta.getNaturezaOperacaoPC() != null) {
                r.setCodNaturezaContaSped(this.planoConta.getNaturezaOperacaoPC().getCodigo());
            }
            this.putPlanoContas(r);
        }
    }

    private Short getIndicadorApuracaoIpiPorCnpj(String cnpjEmpresa, List<Empresa> empresas) {
        for (Empresa empresa : empresas) {
            if (!ToolMethods.isEquals((Object)cnpjEmpresa, (Object)empresa.getPessoa().getComplemento().getCnpj())) continue;
            return empresa.getEmpresaDados().getIndicadorApuracaoIpi();
        }
        return null;
    }

    private void gerarBloco1100(PrintWriter p, Bloco1 bloco1100, UtilWritterBloco1 w) {
        if (bloco1100 != null && !bloco1100.getRegistros1100().isEmpty()) {
            Iterator<Reg1100> iterator = bloco1100.getRegistros1100().iterator();
            while (iterator.hasNext()) {
                Reg1100 o;
                Reg1100 r = o = iterator.next();
                w.writerReg1100(p, r, this.cont);
            }
        }
    }

    private void gerarBloco1500(PrintWriter p, Bloco1 bloco1500, UtilWritterBloco1 w) {
        if (bloco1500 != null && !bloco1500.getRegistros1500().isEmpty()) {
            Iterator<Reg1500> iterator = bloco1500.getRegistros1500().iterator();
            while (iterator.hasNext()) {
                Reg1500 o;
                Reg1500 r = o = iterator.next();
                w.writerReg1500(p, r, this.cont);
            }
        }
    }
}

