/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.bloco0.writter;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SpedPisCofins;
import com.touchcomp.basementor.model.vo.SpedPisCofinsSCP;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedpiscofins.exceptions.SpedPisCofinsWritterException;
import mentorcore.service.impl.spedpiscofins.versao006.SpedFormat;
import mentorcore.service.impl.spedpiscofins.versao006.model.ContadorRegistros;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg205;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg450;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg600;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco0.Reg0145;
import mentorcore.service.impl.spedpiscofins.versao006.util.bloco0.UtilBDBloco0;
import mentorcore.utilities.impl.planoconta.UtilityPlanoConta;

public class UtilWritterBloco0 {
    private SpedFormat form = new SpedFormat();
    private String endOfRegister = "\r\n";
    private char separator = (char)124;

    public void writterReg0000(PrintWriter p, Date dataIn, Date dataFim, Empresa emp, SpedPisCofins vo, ContadorRegistros cont) {
        p.append(this.separator + "0000");
        p.append(this.separator + vo.getVersaoPisCofins().getCodigo());
        p.append(this.separator + String.valueOf(vo.getTipoEscrituracao()));
        if (vo.getIndicadorSituacaoEspecial() != null) {
            p.append(this.separator + String.valueOf(vo.getIndicadorSituacaoEspecial().getCodigo()));
        } else {
            p.append(this.separator);
        }
        if (vo.getReciboAnterior() != null) {
            p.append(this.separator + this.form.formatStringClear(vo.getReciboAnterior(), 41));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatDate(dataIn));
        p.append(this.separator + this.form.formatDate(dataFim));
        p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 100));
        String cnpjCpf = emp.getPessoa().getComplemento().getCnpj();
        cnpjCpf = this.form.clearString(cnpjCpf);
        p.append(this.separator + cnpjCpf);
        p.append(this.separator + emp.getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(this.separator + emp.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + emp.getPessoa().getEndereco().getCidade().getCodIbge());
        p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getSuframa(), 9));
        p.append(this.separator + String.valueOf(vo.getIndicadorNaturezaPessoaJuridica().getCodigo()));
        p.append(this.separator + String.valueOf(emp.getEmpresaDados().getIndicadorAtividade().getCodigo()));
        p.append(this.separator + this.endOfRegister);
        cont.soma1("0000");
    }

    public void writterReg0001(PrintWriter p, ContadorRegistros cont) {
        p.append(this.separator + "0001");
        p.append(this.separator + String.valueOf(0));
        p.append(this.separator + this.endOfRegister);
        cont.soma1("0001");
    }

    public void writterReg0035(PrintWriter p, SpedPisCofins vo, ContadorRegistros cont) {
        if (ToolMethods.isEquals((Object)vo.getIndicadorNaturezaPessoaJuridica().getCodigo(), (Object)"03") || ToolMethods.isEquals((Object)vo.getIndicadorNaturezaPessoaJuridica().getCodigo(), (Object)"04") || ToolMethods.isEquals((Object)vo.getIndicadorNaturezaPessoaJuridica().getCodigo(), (Object)"05")) {
            for (SpedPisCofinsSCP s : vo.getRegistros0035()) {
                p.append(this.separator + "0035");
                String cnpjCpf = s.getCnpjSCP();
                cnpjCpf = this.form.clearString(cnpjCpf);
                p.append(this.separator + cnpjCpf);
                p.append(this.separator + this.form.clearString(s.getDescricaoSCP()));
                p.append(this.separator + this.form.clearString(s.getInformacaoComplementar()));
                p.append(this.separator + this.endOfRegister);
                cont.soma1("0035");
            }
        }
    }

    public void writterReg0100(PrintWriter p, Empresa emp, EmpresaContabilidade contabilidade, ContadorRegistros cont) throws SpedPisCofinsWritterException {
        Pessoa contador = contabilidade.getPessoa();
        p.append(this.separator + "0100");
        p.append(this.separator + this.form.formatString(contador.getNome(), 100));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getCnpj(), 11));
        p.append(this.separator + this.form.formatStringClear(contabilidade.getCrc(), 15));
        p.append(this.separator);
        p.append(this.separator + this.form.formatStringClear(contador.getEndereco().getCep(), 8));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getLogradouro(), 60));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getNumero(), 10));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getComplemento(), 60));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getBairro(), 60));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getFone1(), 10));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getFax1(), 10));
        p.append(this.separator + this.form.formatString(this.getEmailAtivo(contador.getComplemento().getEmails())));
        p.append(this.separator + this.form.formatStringClear(contador.getEndereco().getCidade().getUf().getCodIbge() + contador.getEndereco().getCidade().getCodIbge(), 7));
        p.append(this.separator + this.endOfRegister);
        cont.soma1("0100");
    }

    public void writterReg0110(PrintWriter p, SpedPisCofins vo, ContadorRegistros cont) {
        p.append(this.separator + "0110");
        p.append(this.separator + vo.getIndicadorIncidenciaTributaria().getCodigo());
        if (vo.getIndicadorMetodoAprCredito() != null) {
            p.append(this.separator + vo.getIndicadorMetodoAprCredito().getCodigo());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + vo.getIndicadorTipoContribApurada().getCodigo());
        if (vo.getIndicadorRegimeCumulativo() != null) {
            p.append(this.separator + vo.getIndicadorRegimeCumulativo().getCodigo());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        cont.soma1("0110");
    }

    public void writterReg0111(PrintWriter p, SpedPisCofins vo, ContadorRegistros cont) {
        if (vo.getIndicadorMetodoAprCredito() != null && vo.getIndicadorMetodoAprCredito().getCodigo().equals("2")) {
            p.append(this.separator + "0111");
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruNcumTribMi()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruNcumNtMi()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruNcumExp()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruCum()));
            p.append(this.separator + this.form.formatNumber(vo.getSpedPisCofinsReceitaBrutaRateio().getRecBruTotal()));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0111");
        }
    }

    public void writterReg0140(PrintWriter p, List empresas, Date dataIn, Date dataFim, Reg0145 reg0145, ContadorRegistros cont, HashMap hashEmpresasParicipantes, HashMap hashEmpresasUnidades, HashMap hashEmpresasProdutos, HashMap hashEmpresasNaturezas, HashMap hashEmpresasObservacoes) throws ExceptionDatabase {
        HashMap empresasComMaisDeUmCNPJ = this.getHashEmpresasComMaisDeUmCNPJ(empresas);
        ArrayList<String> cnpjs = new ArrayList<String>();
        for (Object o : empresas) {
            Empresa emp = (Empresa)o;
            if (cnpjs.contains(emp.getPessoa().getComplemento().getCnpj())) continue;
            p.append(this.separator + "0140");
            p.append(this.separator + emp.getIdentificador().toString());
            p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 100));
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getCnpj(), 14));
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getEndereco().getCidade().getUf().getSigla(), 2));
            String cnpj = (String)empresasComMaisDeUmCNPJ.get(emp.getPessoa().getComplemento().getCnpj());
            if (ToolMethods.isStrWithData((String)cnpj)) {
                p.append(this.separator);
            } else {
                p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getInscEst(), 14));
            }
            p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + emp.getPessoa().getEndereco().getCidade().getCodIbge(), 14));
            if (emp.getPessoa().getComplemento().getInscricaoMunicipal() != null) {
                p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getInscricaoMunicipal()));
            } else {
                p.append(this.separator);
            }
            if (emp.getPessoa().getComplemento().getSuframa() != null) {
                p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getSuframa(), 9));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0140");
            if (emp.getEmpresaDados().getMatriz() == 1) {
                this.writterReg0145(p, reg0145, cont);
            }
            this.writterReg0150(p, emp.getPessoa().getComplemento().getCnpj(), cont, hashEmpresasParicipantes);
            this.writterReg0190(p, emp.getPessoa().getComplemento().getCnpj(), cont, hashEmpresasUnidades);
            this.writterReg0200(p, emp.getPessoa().getComplemento().getCnpj(), dataIn, dataFim, cont, hashEmpresasProdutos);
            this.writterReg0400(p, emp.getPessoa().getComplemento().getCnpj(), cont, hashEmpresasNaturezas);
            this.writterReg0450(p, emp.getPessoa().getComplemento().getCnpj(), cont, hashEmpresasObservacoes);
            cnpjs.add(emp.getPessoa().getComplemento().getCnpj());
        }
    }

    private String getEmailAtivo(List<EmailPessoa> emails) {
        String firstEmail = "";
        String activeEmail = "";
        boolean count = false;
        for (EmailPessoa e : emails) {
            if (!count) {
                firstEmail = e.getEmail();
            }
            if (e.getAtivo() == null || e.getAtivo() != 1) continue;
            activeEmail = e.getEmail();
            break;
        }
        if (activeEmail == null) {
            return firstEmail;
        }
        return activeEmail;
    }

    private void writterReg0150(PrintWriter p, String emp, ContadorRegistros cont, HashMap hashEmpresasParicipantes) {
        HashSet h = (HashSet)hashEmpresasParicipantes.get(emp);
        for (Object o : h) {
            Reg150 r = (Reg150)o;
            p.append(this.separator + "0150");
            p.append(this.separator + this.form.formatString(r.getIdPessoa().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getNomePessoa(), 100));
            p.append(this.separator + this.form.formatStringClear(r.getCodPais(), 5));
            if (r.getCodPais().equals("1058") || r.getCodPais().equals("01058")) {
                String cnpjCpf = r.getCnpj();
                if ((cnpjCpf = this.form.clearString(cnpjCpf)).trim().length() > 11) {
                    p.append(this.separator + cnpjCpf);
                    p.append(this.separator);
                } else {
                    p.append(this.separator);
                    p.append(this.separator + cnpjCpf);
                }
            } else {
                p.append(this.separator);
                p.append(this.separator);
            }
            if (r.getInscricaoEstadual() != null && r.getInscricaoEstadual().trim().length() > 0 && !r.getInscricaoEstadual().trim().equalsIgnoreCase("isento")) {
                if (ToolMethods.isEquals((Object)r.getCodUf(), (Object)"31") && r.getInscricaoEstadual().trim().length() < 13) {
                    p.append(this.separator + this.form.formatClearStringComp0Esquerda(r.getInscricaoEstadual(), 13));
                } else {
                    p.append(this.separator + this.form.formatStringClear(r.getInscricaoEstadual(), 14));
                }
            } else {
                p.append(this.separator);
            }
            if (r.getCodPais().equals("1058") || r.getCodPais().equals("01058")) {
                p.append(this.separator + this.form.formatStringClear(r.getCodUf() + r.getCodigoMunicipio(), 7));
            } else {
                p.append(this.separator);
            }
            if (r.getSuframa() != null && this.form.formatStringClear(r.getSuframa()).trim().length() == 9) {
                p.append(this.separator + this.form.formatStringClear(r.getSuframa(), 9));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatString(r.getEndereco(), 60));
            p.append(this.separator + this.form.formatString(r.getNumero(), 10));
            p.append(this.separator + this.form.formatString(r.getComplemento(), 60));
            p.append(this.separator + this.form.formatString(r.getBairro(), 60));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0150");
        }
    }

    private void writterReg0190(PrintWriter p, String emp, ContadorRegistros cont, HashMap hashEmpresasUnidades) {
        HashSet h = (HashSet)hashEmpresasUnidades.get(emp);
        for (Object o : h) {
            Reg190 r = (Reg190)o;
            p.append(this.separator + "0190");
            p.append(this.separator + this.form.formatStringClear(r.getCodUnidMedida(), 6));
            p.append(this.separator + this.form.formatString(r.getDescUnidMedida()));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0190");
        }
    }

    private void writterReg0200(PrintWriter p, String emp, Date dataIn, Date dataFim, ContadorRegistros cont, HashMap hashEmpresasProdutos) throws ExceptionDatabase {
        HashSet h = (HashSet)hashEmpresasProdutos.get(emp);
        for (Object o : h) {
            Reg200 pr = (Reg200)o;
            p.append(this.separator + "0200");
            p.append(this.separator + pr.getIdCodAuxProduto().toString());
            p.append(this.separator + this.form.formatString(pr.getDescricao()));
            p.append("" + this.separator);
            p.append("" + this.separator);
            p.append(this.separator + this.form.formatString(pr.getUnidadeMedida(), 6));
            if (pr.getTipoItem() != null) {
                p.append(this.separator + pr.getTipoItem());
            } else {
                p.append(this.separator);
            }
            if (pr.getCodNcm() != null) {
                p.append(this.separator + pr.getCodNcm());
            } else {
                p.append(this.separator);
            }
            if (pr.getCodEx() != null) {
                p.append(this.separator + pr.getCodEx());
            } else {
                p.append(this.separator);
            }
            if (pr.getCodGenero() != null && !pr.getCodGenero().equalsIgnoreCase("0")) {
                p.append(this.separator + pr.getCodGenero());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(pr.getAliquotaIcms(), 2));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0200");
            if (pr.getTipoItemProdServ() == null || pr.getTipoItemProdServ() != 0) continue;
            this.writterReg0205(p, Long.valueOf(pr.getIdentificador()), dataIn, dataFim, cont);
        }
    }

    private void writterReg0205(PrintWriter p, Long idProduto, Date dataIn, Date dataFim, ContadorRegistros cont) throws ExceptionDatabase {
        List log = new UtilBDBloco0().getAlteracoesProduto(idProduto, dataIn, dataFim);
        for (Object o : log) {
            Reg205 l = (Reg205)o;
            if (l.getDataFinal() == null) {
                l.setDataFinal(dataFim);
            }
            p.append(this.separator + "0205");
            p.append(this.separator + this.form.formatString(l.getDescricaoAnterior()));
            p.append(this.separator + this.form.formatDate(l.getDataInicial()));
            p.append(this.separator + this.form.formatDate(l.getDataFinal()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0205");
        }
    }

    private void writterReg0400(PrintWriter p, String emp, ContadorRegistros cont, HashMap hashEmpresasNaturezas) {
        HashSet h = (HashSet)hashEmpresasNaturezas.get(emp);
        for (Object o : h) {
            Reg400 r = (Reg400)o;
            p.append(this.separator + "0400");
            p.append(this.separator + this.form.formatStringClear(r.getIdNatOperacao().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getDescricaoNatOperacao()));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0400");
        }
    }

    private void writterReg0450(PrintWriter p, String emp, ContadorRegistros cont, HashMap hashEmpresasObservacoes) {
        HashSet h = (HashSet)hashEmpresasObservacoes.get(emp);
        for (Object o : h) {
            Reg450 r = (Reg450)o;
            p.append(this.separator + "0450");
            p.append(this.separator + this.form.formatStringClear(r.getIdObservacao().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getDescricao()));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0450");
        }
    }

    public void writterReg0500(PrintWriter p, ContadorRegistros cont, HashSet hashEmpresasPlanos) {
        for (Object o : hashEmpresasPlanos) {
            Reg500 pc = (Reg500)o;
            p.append(this.separator + "0500");
            p.append(this.separator + this.form.formatDate(pc.getDataInclusao()));
            p.append(this.separator + pc.getCodNaturezaContaSped());
            if (pc.getMarca().intValue() == EnumConstSinteticoAnalitico.SINTETICO.getValueInt()) {
                p.append(this.separator + "S");
            } else {
                p.append(this.separator + "A");
            }
            p.append(this.separator + UtilityPlanoConta.getNivelPlanoConta(pc.getCodigo()).toString());
            p.append(this.separator + this.form.formatStringClear(pc.getCodigo()));
            p.append(this.separator + this.form.formatString(pc.getDescricao(), 60));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0500");
        }
    }

    public void writterReg0600(PrintWriter p, ContadorRegistros cont, HashSet hashEmpresasCentroCustos) {
        for (Object o : hashEmpresasCentroCustos) {
            Reg600 pc = (Reg600)o;
            p.append(this.separator + "0600");
            p.append(this.separator + this.form.formatDate(pc.getDataInclusao()));
            p.append(this.separator + this.form.formatStringClear(pc.getCodigo()));
            p.append(this.separator + this.form.formatString(pc.getDescricao(), 60));
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0600");
        }
    }

    public void writterReg0990(PrintWriter p, ContadorRegistros cont) {
        cont.soma1("0990");
        p.append(this.separator + "0990");
        p.append(this.separator + this.form.formatNumberLong(cont.getNrLinhas('0')));
        p.append(this.separator + this.endOfRegister);
    }

    public void writterReg0145(PrintWriter p, Reg0145 r, ContadorRegistros cont) {
        if (r != null) {
            p.append(this.separator + "0145");
            p.append(this.separator + r.getCodIncidenciaTributaria());
            p.append(this.separator + this.form.formatNumber(r.getValorReceitaTotal()));
            p.append(this.separator + this.form.formatNumber(r.getValorReceitaAtividades()));
            p.append(this.separator + this.form.formatNumber(r.getValorReceitaDemaisAtividades()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            cont.soma1("0145");
        }
    }

    private HashMap getHashEmpresasComMaisDeUmCNPJ(List<Empresa> empresas) {
        HashMap<String, String> h = new HashMap<String, String>();
        ArrayList<String> cnpjs = new ArrayList<String>();
        for (Empresa empresa : empresas) {
            if (cnpjs.contains(empresa.getPessoa().getComplemento().getCnpj())) {
                h.put(empresa.getPessoa().getComplemento().getCnpj(), empresa.getPessoa().getComplemento().getCnpj());
                continue;
            }
            cnpjs.add(empresa.getPessoa().getComplemento().getCnpj());
        }
        return h;
    }
}

