/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.bloco1;

import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco1.Bloco1;
import mentorcore.service.impl.spedpiscofins.versao006.model.bloco1.Reg1900;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBloco1900 {
    public Bloco1 getBloco1Reg1900(Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa) {
        Bloco1 b = new Bloco1();
        b.getRegistros1900().addAll(this.getRegistros1900NotaPropria(dataIn, dataFim, grupoEmpresa));
        b.getRegistros1900().addAll(this.getRegistros1900Conhecimentos(dataIn, dataFim, grupoEmpresa));
        b.getPlanoContas().addAll(this.getPlanoContas1900NotaPropria(dataIn, dataFim, grupoEmpresa));
        b.getPlanoContas().addAll(this.getPlanoContas1900Conhecimentos(dataIn, dataFim, grupoEmpresa));
        return b;
    }

    private List<Reg1900> getRegistros1900NotaPropria(Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct n.empresa.pessoa.complemento.cnpj as CNPJ_EMITENTE, lv.cancelado as COD_SIT_DOCUMENTO, n.serie as SERIE, n.modeloDocFiscal.codigo as COD_MODELO_DOC_FISCAL, sum(lv.valorTotal) as VALOR_TOTAL, lv.cfop.codigo as COD_CFOP, lv.incidenciaPis.codigo as COD_INCIDENCIA_PIS, lv.incidenciaCofins.codigo as COD_INCIDENCIA_COFINS, pc.codigo as PLANO_CONTA from NotaFiscalPropria  n inner join n.livrosFiscais lv left join lv.planoConta pc where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cfop.cfopReceitaVendaSped  = :sim and (lv.incidenciaPis.codigo <> :outrasSaidas and lv.incidenciaPis.codigo <> :outrasEntradas) and (lv.incidenciaCofins.codigo <> :outrasSaidas and lv.incidenciaCofins.codigo <> :outrasEntradas) group by  n.empresa.pessoa.complemento.cnpj, lv.cancelado, n.serie, n.modeloDocFiscal.codigo, lv.cfop.codigo, lv.incidenciaPis.codigo, lv.incidenciaCofins.codigo, pc.codigo ";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("sim", (short)1);
        q.setString("outrasSaidas", "49");
        q.setString("outrasEntradas", "98");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg1900> toRet = new ArrayList<Reg1900>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Double valorTotalReceita = (Double)h.get("VALOR_TOTAL");
            Short codSituacaoDocumento = (Short)h.get("COD_SIT_DOCUMENTO");
            if (!(valorTotalReceita > 0.0) && !codSituacaoDocumento.equals((short)1)) continue;
            Reg1900 r = new Reg1900();
            r.setCnpj((String)h.get("CNPJ_EMITENTE"));
            r.setModDocFiscal((String)h.get("COD_MODELO_DOC_FISCAL"));
            r.setSerie((String)h.get("SERIE"));
            r.setCodSituacaoDocumento(this.getSituacaoDocumentoRegistro1900(codSituacaoDocumento));
            r.setValorTotalReceita((Double)h.get("VALOR_TOTAL"));
            r.setCfop((String)h.get("COD_CFOP"));
            r.setCodIncidenciaPis((String)h.get("COD_INCIDENCIA_PIS"));
            r.setCodIncidenciaCofins((String)h.get("COD_INCIDENCIA_COFINS"));
            r.setQuantidadeDoc(this.getQteDocumentosRegistros1900(r, dataIn, dataFim, grupoEmpresa));
            r.setContaAnalitica((String)h.get("PLANO_CONTA"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg1900> getRegistros1900Conhecimentos(Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct n.empresa.pessoa.complemento.cnpj as CNPJ_EMITENTE, n.situacaoDocumento.codigo as COD_SIT_DOCUMENTO, n.serie as SERIE, n.modeloDocFiscal.codigo as COD_MODELO_DOC_FISCAL, sum(lv.valorTotal) as VALOR_TOTAL, lv.cfop.codigo as COD_CFOP, lv.incidenciaPis.codigo as COD_INCIDENCIA_PIS, lv.incidenciaCofins.codigo as COD_INCIDENCIA_COFINS, pc.codigo as PLANO_CONTA from Cte  n inner join n.livrosFiscais lv left join lv.planoConta pc where n.dataEmissao between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa =:grupoEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cfop.cfopReceitaVendaSped = :sim group by  n.empresa.pessoa.complemento.cnpj, n.situacaoDocumento.codigo, n.serie, n.modeloDocFiscal.codigo, lv.cfop.codigo, lv.incidenciaPis.codigo, lv.incidenciaCofins.codigo, pc.codigo";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg1900> toRet = new ArrayList<Reg1900>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg1900 r = new Reg1900();
            r.setCnpj((String)h.get("CNPJ_EMITENTE"));
            r.setModDocFiscal((String)h.get("COD_MODELO_DOC_FISCAL"));
            r.setSerie((String)h.get("SERIE"));
            r.setCodSituacaoDocumento((String)h.get("COD_SIT_DOCUMENTO"));
            r.setValorTotalReceita((Double)h.get("VALOR_TOTAL"));
            r.setCfop((String)h.get("COD_CFOP"));
            r.setCodIncidenciaPis((String)h.get("COD_INCIDENCIA_PIS"));
            r.setCodIncidenciaCofins((String)h.get("COD_INCIDENCIA_COFINS"));
            r.setQuantidadeDoc(this.getQteDocumentosRegistros1900(r, dataIn, dataFim, grupoEmpresa));
            r.setContaAnalitica((String)h.get("CONTA_ANALITICA"));
            toRet.add(r);
        }
        return toRet;
    }

    private Integer getQteDocumentosRegistros1900(Reg1900 r, Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select count(n.identificador) as QTDE from NotaFiscalPropria  n inner join n.livrosFiscais lv where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and n.situacaoDocumento.codigo = :codSitDoc and n.serie = :serie and n.modeloDocFiscal.codigo = :codModDocFiscal and lv.cfop.codigo = :codCfop and lv.incidenciaPis.codigo = :codIncidenciaPis and lv.incidenciaCofins.codigo = :codIncidenciaCofins and lv.cfop.cfopReceitaVendaSped = :sim";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("codSitDoc", r.getCodSituacaoDocumento());
        q.setString("codIncidenciaPis", r.getCodIncidenciaPis());
        q.setString("codIncidenciaCofins", r.getCodIncidenciaCofins());
        q.setString("serie", r.getSerie());
        q.setString("codModDocFiscal", r.getModDocFiscal());
        q.setString("codCfop", r.getCfop());
        q.setShort("sim", (short)1);
        Long qtde = (Long)q.uniqueResult();
        return qtde.intValue();
    }

    private String getSituacaoDocumentoRegistro1900(Short codSituacaoDocumento) {
        if (codSituacaoDocumento.equals((short)0)) {
            return "00";
        }
        return "02";
    }

    private Collection<? extends Reg500> getPlanoContas1900NotaPropria(Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct  pc.identificador as idPlanoDeb, pc.dataCadastro as dataCadastroDeb, pc.marca as marcaDeb, pc.codigo as codContaDeb, pc.descricao as descricaoContaDeb, pc.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria  n inner join n.livrosFiscais lv left join lv.planoConta pc where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cfop.cfopReceitaVendaSped  = :sim and (lv.incidenciaPis.codigo <> :outrasSaidas and lv.incidenciaPis.codigo <> :outrasEntradas) and (lv.incidenciaCofins.codigo <> :outrasSaidas and lv.incidenciaCofins.codigo <> :outrasEntradas)";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("sim", (short)1);
        q.setString("outrasSaidas", "49");
        q.setString("outrasEntradas", "98");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private Collection<? extends Reg500> getPlanoContas1900Conhecimentos(Date dataIn, Date dataFim, GrupoEmpresa grupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct  pc.identificador as idPlanoDeb, pc.dataCadastro as dataCadastroDeb, pc.marca as marcaDeb, pc.codigo as codContaDeb, pc.descricao as descricaoContaDeb, pc.naturezaOperacaoPC.codigo as natOpPC from Cte  n inner join n.livrosFiscais lv left join lv.planoConta pc where n.dataEmissao between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cfop.cfopReceitaVendaSped = :sim";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

