/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blocoa;

import com.touchcomp.basementor.constants.enums.entsaida.EnumConstEntSaida;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocoa.BlocoA;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocoa.RegA100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocoa.RegA170;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoA100RpsEntrada {
    public BlocoA getBlocoA100NotasServico(Date dataIn, Date dataFim, String cnpjEmpresa) {
        BlocoA b = new BlocoA();
        b.setRegistrosA100(this.getRPSBloco100(dataIn, dataFim, cnpjEmpresa));
        if (b.getRegistrosA100() != null && !b.getRegistrosA100().isEmpty()) {
            b.setParticipantes(this.getParticipantesRpsBlocoA100Internal(dataIn, dataFim, cnpjEmpresa));
            b.setProdutos(this.getProdutosRps(dataIn, dataFim, cnpjEmpresa));
            b.setPlanoContas(this.getPlanoContasRPSBlocoA100(dataIn, dataFim, cnpjEmpresa));
        }
        return b;
    }

    private List getProdutosRps(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.servicoRPS.codigoAuxiliarServico as idProduto, n.servicoRPS.discriminacao as nomeProduto, n.servicoRPS.tipoItemSped.codigo as codTipoItemSped from Rps n  where n.dataEmissao between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj = :cnpjEmpresa and n.modeloRps.entradaSaida = :entrada");
        q.setShort("entrada", EnumConstEntSaida.ENTRADA.getValue());
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdCodAuxProduto((String)h.get("idProduto"));
            r.setIdentificador((String)h.get("idProduto"));
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasRPSBlocoA100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.planoContaCred.identificador as idPlanoCred, n.planoContaCred.dataCadastro as dataCadastroCred, n.planoContaCred.marca as marcaCred, n.planoContaCred.codigo as codContaCred, n.planoContaCred.descricao as descricaoContaCred, n.planoContaCred.naturezaOperacaoPC.codigo as natOpPC from Rps n  where n.dataEmissao between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2) and n.empresa.pessoa.complemento.cnpj = :cnpjEmpresa and n.modeloRps.entradaSaida = :entrada");
        q.setShort("entrada", EnumConstEntSaida.ENTRADA.getValue());
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoCred");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getRPSBloco100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, n.modeloRps.entradaSaida as entSai, n.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numero as numNota, n.dataEmissao as dataEmissao, n.dataEmissao as dataEntSai, n.valorLiquidoNfse as valorTotal, cp.tpCondicao as tpCond, n.valorDescontoIncondicionado+ n.valorDescontoCondicionado as valorDesconto, n.valorPis as valorPis, n.valorCofins as valorCofins, n.valorCofinsST as valorCofinsST, n.valorPisST as valorPisST, n.valorIss as valorIss from Rps n  left join n.condicoesPagamento cp where (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2)  and n.dataEmissao between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj = :cnpjEmpresa and n.modeloRps.entradaSaida = :entrada");
        q.setShort("entrada", EnumConstEntSaida.ENTRADA.getValue());
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA100> toRet = new ArrayList<RegA100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegA100 r = new RegA100();
            r.setIdentificador((Long)h.get("identificador"));
            r.setTipoOperacao(1);
            r.setIndTipoEmitente(0);
            r.setNumeroDoc((Long)h.get("numNota"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorCofinsRetido((Double)h.get("valorCofinsST"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorPisRetido((Double)h.get("valorPisST"));
            r.setValorIss((Double)h.get("valorIss"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorBcCofins((Double)h.get("valorTotal"));
            r.setValorBcPis((Double)h.get("valorTotal"));
            r.setItensDocumento(this.getItensRPSBlocoA170(r.getIdentificador()));
            toRet.add(r);
        }
        return toRet;
    }

    private List getParticipantesRpsBlocoA100Internal(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade, p.endereco.cidade.uf.sigla as siglaUF,  p.complemento.inscricaoMunicipal as inscMun from Rps n  inner join n.unidadeTomPrestRPS u inner join u.tomadorPrestadorRPS c inner join c.pessoa p where n.dataEmissao between :dataIn and :dataFim and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 ) and n.empresa.pessoa.complemento.cnpj = :cnpjEmpresa and n.modeloRps.entradaSaida = :entrada");
        q.setShort("entrada", EnumConstEntSaida.ENTRADA.getValue());
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> participantes = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            participantes.add(r);
        }
        return participantes;
    }

    private List<RegA170> getItensRPSBlocoA170(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   n.servicoRPS.codigoAuxiliarServico as idProduto, 1 as numeroItem, n.servicoRPS.discriminacao as nomeProduto, n.valorLiquidoNfse as valorTotal, n.valorDescontoIncondicionado + n.valorDescontoCondicionado as valorDesconto, n.incidenciaPisCofins.codigo as codIncidenciaPisCofins, n.valorBaseCalculo as BCGeral,  n.aliquotaPis as aliquotaPis, n.valorPis as vrPis, n.aliquotaCofins as aliquotaCofins, n.valorCofins as vrCofins, pCred.codigo as planoContaCred, n.modeloRps.entradaSaida as natEntSaida from Rps n inner join n.modeloRps m left join n.planoContaCred pCred where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegA170> toRet = new ArrayList<RegA170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegA170 r = new RegA170();
            r.setCodigoItem((String)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCodIncidenciaPis((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCPis((Double)h.get("BCGeral"));
            r.setValorAliqPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setCodIncidenciaCofins((String)h.get("codIncidenciaPisCofins"));
            r.setValorBCCofins((Double)h.get("BCGeral"));
            r.setValorAliqCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setCodContaAnalitica((String)h.get("planoContaCred"));
            toRet.add(r);
        }
        return toRet;
    }
}

