/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blococ;

import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.SpedPisCofinsIncMonofasico;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC175;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC100NFCe {
    public BlocoC getBlocoC100NFCe(Date dataIn, Date dataFim, String cnpjEmpresa, List<IncidenciaPisCofins> incidenciasExcluidas, List<SpedPisCofinsIncMonofasico> incidenciasMonofasico) {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, cnpjEmpresa, incidenciasExcluidas));
        if (b.getRegistrosC100() != null && !b.getRegistrosC100().isEmpty()) {
            if (ToolMethods.isWithData(incidenciasMonofasico)) {
                this.getItensDocumentoNFCeBlocoC100AgrupadosMonofasico(dataIn, dataFim, cnpjEmpresa, b.getRegistrosC100(), incidenciasMonofasico);
            } else {
                this.getItensDocumentoNFCeBlocoC100Agrupados(dataIn, dataFim, cnpjEmpresa, b.getRegistrosC100());
            }
            b.setNatOperacao(this.getNatOperacaoNFCeBlocoC100(dataIn, dataFim, cnpjEmpresa));
            b.setPlanoContas(this.getPlanoContasNFCeBlocoC100(dataIn, dataFim, cnpjEmpresa));
        }
        return b;
    }

    private List<RegC100> getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa, List<IncidenciaPisCofins> incidenciasExcluidas) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select n.naturezaOperacao.entradaSaida as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numero as numNota, n.chaveNFCe as chaveNfe, n.dataEmissao as dataEmissao, n.dataEmissao as dataEntSai, n.totalizadores.valorTotalNFe as valorTotal, n.totalizadores.valorTotalDosProdutosServicos as valorProdServ, cp.tpCondicao as tpCond, n.totalizadores.valorTotalFrete as vlrFrete, n.totalizadores.valorTotalSeguro as vlrSeguro, n.totalizadores.valorTotalDesconto as vlrDesconto, n.totalizadores.valorTotalDespAcessorias as vlrDespAcess, n.totalizadores.baseCalculoICMS as bcIcms, n.totalizadores.valorTotalICMS as vlrIcms, n.totalizadores.valorTotalPIS as vlrPis, n.totalizadores.valorTotalCOFINS as vlrCofins, n.identificador as identificador from NFCe n  left join n.condicoesPagamento cp where  n.dataEmissao between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and n.status <> 102";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Short entradaSaida = (Short)h.get("entSai");
            Double valorPis = (Double)h.get("vlrPis");
            Double valorCofins = (Double)h.get("vlrCofins");
            if (!entradaSaida.equals((short)1) && (!entradaSaida.equals((short)2) || !(valorPis > 0.0) && !(valorCofins > 0.0))) continue;
            RegC100 r = new RegC100();
            r.setNumeroDoc(((Long)h.get("numNota")).intValue());
            System.out.println("NFCe: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            if (entradaSaida.equals((short)2)) {
                r.setEntSaiNatOP(0);
            } else {
                r.setEntSaiNatOP(1);
            }
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            r.setIndicadorTipoFrete(9);
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST(0.0);
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt(0.0);
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST(0.0);
            r.setValorIpi(0.0);
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt(0.0);
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getItensDocumentoNFCeBlocoC100AgrupadosMonofasico(Date dataIn, Date dataFim, String cnpjEmpresa, List<RegC100> notas, List<SpedPisCofinsIncMonofasico> incidenciasMonofasico) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select   sum(p.valorTotal) as valorTotal, sum(p.valorDesconto) as valorDesconto, p.cfop.codigo as cfop, pp.incidenciaPisCofins.codigo as codIncidenciaPis, pp.aliquota as aliquotaPis, sum(pp.valorBaseCalculo) as bcPis, sum(pp.valor) as vrPis, cc.incidenciaPisCofins.codigo as codIncidenciaCofins, cc.aliquota as aliquotaCofins, sum(cc.valorBaseCalculo) as bcCofins, sum(cc.valor) as vrCofins, n.nfCeCaixa.contaValorCaixa.planoConta.codigo as codPlanoConta, n.identificador as idNota, nat.codigo as codNatReceitaPisCofins, p.produto.aliquotaPis as aliquotaPisProduto, p.produto.aliquotaCofins as aliquotaCofinsProduto from NFCe n inner join n.itens p inner join p.pis pp  inner join p.cofins cc left join pp.natReceitaPisCofins nat  where  n.dataEmissao between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and n.status <> 102 and p.status = :ativo group by p.cfop.codigo, pp.incidenciaPisCofins.codigo, pp.aliquota, cc.incidenciaPisCofins.codigo, cc.aliquota, n.nfCeCaixa.contaValorCaixa.planoConta.codigo,  n.identificador, nat.codigo, p.produto.aliquotaPis, p.produto.aliquotaCofins";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setLong("ativo", 1L);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC175> itens = new ArrayList<RegC175>();
        for (Object ob : ret) {
            String codPlanoConta;
            HashMap h = (HashMap)ob;
            RegC175 r = new RegC175();
            r.setIdNota((Long)h.get("idNota"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCfop((String)h.get("cfop"));
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            String codNatRecPisCofins = (String)h.get("codNatReceitaPisCofins");
            for (SpedPisCofinsIncMonofasico cstMonofasico : incidenciasMonofasico) {
                if (!ToolMethods.isEquals((Object)cstMonofasico.getIncidenciaPisCofins().getCodigo(), (Object)r.getCstPis()) || !ToolMethods.isEquals((Object)cstMonofasico.getNatReceitaPisCofins().getCodigo(), (Object)codNatRecPisCofins)) continue;
                r.setAliqPis((Double)h.get("aliquotaPisProduto"));
                r.setAliqCofins((Double)h.get("aliquotaCofinsProduto"));
            }
            if (r.getAliqPis() > 0.0) {
                r.setVlrBCPis((Double)h.get("bcPis"));
            }
            if (r.getAliqCofins() > 0.0) {
                r.setBcCofins((Double)h.get("bcCofins"));
            }
            if ((codPlanoConta = (String)h.get("codPlanoConta")) != null) {
                r.setCodContaContabil(codPlanoConta);
            }
            itens.add(r);
        }
        ArrayList<RegC175> itensAgrupados = new ArrayList<RegC175>();
        for (RegC175 i : itens) {
            boolean achou = false;
            for (RegC175 ii : itensAgrupados) {
                if (!ToolMethods.isEquals((Object)i.getIdNota(), (Object)ii.getIdNota()) || !ToolMethods.isEquals((Object)i.getCfop(), (Object)ii.getCfop()) || !ToolMethods.isEquals((Object)i.getAliqPis(), (Object)ii.getAliqPis()) || !ToolMethods.isEquals((Object)i.getAliqCofins(), (Object)ii.getAliqCofins()) || !ToolMethods.isEquals((Object)i.getCstPis(), (Object)ii.getCstPis()) || !ToolMethods.isEquals((Object)i.getCstCofins(), (Object)ii.getCstCofins()) || !ToolMethods.isEquals((Object)i.getCodContaContabil(), (Object)ii.getCodContaContabil())) continue;
                ii.setValorDesconto(ii.getValorDesconto() + i.getValorDesconto());
                ii.setValorItem(ii.getValorItem() + i.getValorItem());
                ii.setBcCofins(ii.getBcCofins() + i.getBcCofins());
                ii.setVlrBCPis(ii.getVlrBCPis() + i.getVlrBCPis());
                ii.setVlrPis(ii.getVlrPis() + i.getVlrPis());
                ii.setVlrCofins(ii.getVlrCofins() + i.getVlrCofins());
                achou = true;
                break;
            }
            if (achou) continue;
            itensAgrupados.add(i);
        }
        for (RegC100 r : notas) {
            String sitDoc = r.getCodSituacaoDoc();
            boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (docCancInut) continue;
            for (RegC175 item : itensAgrupados) {
                if (!ToolMethods.isEquals((Object)r.getIdentificador(), (Object)item.getIdNota())) continue;
                r.getItensNFCe().add(item);
            }
        }
    }

    private void getItensDocumentoNFCeBlocoC100Agrupados(Date dataIn, Date dataFim, String cnpjEmpresa, List<RegC100> notas) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select   sum(p.valorTotal) as valorTotal, sum(p.valorDesconto) as valorDesconto, p.cfop.codigo as cfop, pp.incidenciaPisCofins.codigo as codIncidenciaPis, pp.aliquota as aliquotaPis, sum(pp.valorBaseCalculo) as bcPis, sum(pp.valor) as vrPis, cc.incidenciaPisCofins.codigo as codIncidenciaCofins, cc.aliquota as aliquotaCofins, sum(cc.valorBaseCalculo) as bcCofins, sum(cc.valor) as vrCofins, n.nfCeCaixa.contaValorCaixa.planoConta.codigo as codPlanoConta, n.identificador as idNota from NFCe n inner join n.itens p inner join p.pis pp  inner join p.cofins cc left join pp.natReceitaPisCofins nat  where  n.dataEmissao between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and n.status <> 102 and p.status = :ativo group by p.cfop.codigo, pp.incidenciaPisCofins.codigo, pp.aliquota, cc.incidenciaPisCofins.codigo, cc.aliquota, n.nfCeCaixa.contaValorCaixa.planoConta.codigo,  n.identificador";
        Query q = s.createQuery(query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setLong("ativo", 1L);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC175> itens = new ArrayList<RegC175>();
        for (Object ob : ret) {
            String codPlanoConta;
            HashMap h = (HashMap)ob;
            RegC175 r = new RegC175();
            r.setIdNota((Long)h.get("idNota"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setCfop((String)h.get("cfop"));
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            if (r.getAliqPis() > 0.0) {
                r.setVlrBCPis((Double)h.get("bcPis"));
            }
            if (r.getAliqCofins() > 0.0) {
                r.setBcCofins((Double)h.get("bcCofins"));
            }
            if ((codPlanoConta = (String)h.get("codPlanoConta")) != null) {
                r.setCodContaContabil(codPlanoConta);
            }
            itens.add(r);
        }
        for (RegC100 r : notas) {
            String sitDoc = r.getCodSituacaoDoc();
            boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (docCancInut) continue;
            for (RegC175 item : itens) {
                if (!ToolMethods.isEquals((Object)r.getIdentificador(), (Object)item.getIdNota())) continue;
                r.getItensNFCe().add(item);
            }
        }
    }

    private List<Reg400> getNatOperacaoNFCeBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.naturezaOperacao.identificador as idNatOperacao, n.naturezaOperacao.descricao as descNatOperacao from NFCe n  where n.dataEmissao between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.status <> 102");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNFCeBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.nfCeCaixa.contaValorCaixa.planoConta.identificador as idPlanoCred, n.nfCeCaixa.contaValorCaixa.planoConta.dataCadastro as dataCadastroCred, n.nfCeCaixa.contaValorCaixa.planoConta.marca as marcaCred, n.nfCeCaixa.contaValorCaixa.planoConta.codigo as codContaCred, n.nfCeCaixa.contaValorCaixa.planoConta.descricao as descricaoContaCred, n.nfCeCaixa.contaValorCaixa.planoConta.naturezaOperacaoPC.codigo as natOpPC from NFCe n  where  n.dataEmissao between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.status <> 102");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

