/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blococ;

import com.touchcomp.basementor.model.vo.DocumentosRefProcessosPR;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.SpedPisCofinsIncMonofasico;
import com.touchcomp.basementor.model.vo.TokenObsIntFisco;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg400;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC100;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC110;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC111;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC170;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC100NotasPropriaV2 {
    private Boolean utilizaCodAux = false;

    public BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, String cnpjEmpresa, List<IncidenciaPisCofins> incidenciasExcluidas, Boolean utilizaCodAux, List<SpedPisCofinsIncMonofasico> incidenciasMonofasico) {
        this.utilizaCodAux = utilizaCodAux;
        List<Long> idsNotasProcessadas = this.getIdsNotasProcessadas(dataIn, dataFim, cnpjEmpresa, incidenciasExcluidas);
        List<ObservacaoNotaPropria> observacoes = this.getObservacoesBlocoC100(dataIn, dataFim, cnpjEmpresa);
        List<ObservacaoIntFiscalNotaFiscalPropria> observacoesIntFisco = this.getObservacoesIntFiscoBlocoC100(dataIn, dataFim, cnpjEmpresa);
        List<DocumentosRefProcessosPR> processosFiscais = this.getProcessosReferenciadosBlocoC100(dataIn, dataFim, cnpjEmpresa);
        BlocoC blocoC = new BlocoC();
        blocoC.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, cnpjEmpresa, idsNotasProcessadas, observacoes, observacoesIntFisco, processosFiscais));
        if (blocoC.getRegistrosC100() != null && !blocoC.getRegistrosC100().isEmpty()) {
            this.getItensDocumentoNotaPropriaBlocoC100Agrupados(dataIn, dataFim, cnpjEmpresa, blocoC.getRegistrosC100(), incidenciasMonofasico);
            blocoC.setParticipantes(this.getParticipantesNotasFiscaisPropriasBlocoC100(dataIn, dataFim, cnpjEmpresa, idsNotasProcessadas));
            blocoC.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC100(dataIn, dataFim, cnpjEmpresa, idsNotasProcessadas));
            blocoC.setNatOperacao(this.getNatOperacaoNotasFiscaisPropriasBlocoC100(dataIn, dataFim, cnpjEmpresa, idsNotasProcessadas));
            blocoC.setUnidadeMedidas(this.getUnidMedidasNotasPropriasBlocoC100(dataIn, dataFim, cnpjEmpresa, idsNotasProcessadas));
            blocoC.setPlanoContas(this.getPlanoContasNotaPropriaBlocoC100(dataIn, dataFim, cnpjEmpresa));
        }
        return blocoC;
    }

    private List<Long> getIdsNotasProcessadas(Date dataIn, Date dataFim, String cnpjEmpresa, List<IncidenciaPisCofins> incidenciasExcluidas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct n.identificador as idNota from NotaFiscalPropria n  inner join n.itensNotaPropria it where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj =:cnpjEmpresa and ((n.naturezaOperacao.entradaSaida = :faturamentoSaida and it.itemNotaLivroFiscal.cfop.cfopReceitaVendaSped= :sim  ";
        int count = 1;
        if (incidenciasExcluidas != null && !incidenciasExcluidas.isEmpty()) {
            hql = (String)hql + "and (";
            for (IncidenciaPisCofins i : incidenciasExcluidas) {
                hql = count == 1 ? (String)hql + " it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'" : (String)hql + " and it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'";
                ++count;
            }
            hql = (String)hql + ")";
        }
        hql = (String)hql + ") or (n.naturezaOperacao.entradaSaida = :faturamentoEntrada and it.itemNotaLivroFiscal.cfop.cfopGeradorCredito= :sim  ";
        count = 1;
        if (incidenciasExcluidas != null && !incidenciasExcluidas.isEmpty()) {
            hql = (String)hql + "and (";
            for (IncidenciaPisCofins i : incidenciasExcluidas) {
                hql = count == 1 ? (String)hql + " it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'" : (String)hql + " and it.incidenciaPisCofins.codigo != '" + i.getCodigo() + "'";
                ++count;
            }
            hql = (String)hql + ")";
        }
        hql = (String)hql + "))";
        Query q = s.createQuery((String)hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setShort("sim", (short)1);
        q.setShort("faturamentoEntrada", (short)2);
        q.setShort("faturamentoSaida", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Long> toRet = new ArrayList<Long>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idNota = (Long)h.get("idNota");
            toRet.add(idNota);
        }
        return toRet;
    }

    private List<RegC100> getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa, List<Long> idsNotasProcessadas, List<ObservacaoNotaPropria> observacoes, List<ObservacaoIntFiscalNotaFiscalPropria> observacoesIntFisco, List<DocumentosRefProcessosPR> processosFiscais) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select n.naturezaOperacao.entradaSaida as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatCliente.pessoa.identificador as idPessoa, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissaoNota as dataEmissao, n.dataEntradaSaida as dataEntSai, n.valoresNfPropria.valorTotal as valorTotal, n.valoresNfPropria.valorProduto + n.valoresNfPropria.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfPropria.valorFrete as vlrFrete, n.valoresNfPropria.valorSeguro as vlrSeguro, n.valoresNfPropria.valorDesconto as vlrDesconto, n.valoresNfPropria.valorDespAcess as vlrDespAcess, n.valoresNfPropria.valorIcmsTributado as bcIcms, n.valoresNfPropria.valorIcms as vlrIcms, n.valoresNfPropria.valorIcmsSt as vlrIcmsSt, n.valoresNfPropria.bcIcmsSt as bcIcmsSt, n.valoresNfPropria.valorIpiIndustria as vlrIpi, n.valoresNfPropria.valorPis as vlrPis, n.valoresNfPropria.valorCofins as vlrCofins, n.valoresNfPropria.valorCofinsSt as vlrCofinsST, n.valoresNfPropria.valorPisSt as vlrPisST, n.identificador as identificador from NotaFiscalPropria n  inner join n.dadosTransNfPropria d left join d.tipoFrete tf left join n.condicaoPagamento cp where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa";
        Query q = s.createQuery(hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            boolean docCancInut;
            HashMap h = (HashMap)o;
            Long idNota = (Long)h.get("identificador");
            if (!this.existeNota(idNota, idsNotasProcessadas)) continue;
            Short entradaSaida = (Short)h.get("entSai");
            Double valorPis = (Double)h.get("vlrPis");
            Double valorCofins = (Double)h.get("vlrCofins");
            if (!entradaSaida.equals((short)1) && (!entradaSaida.equals((short)2) || !(valorPis > 0.0) && !(valorCofins > 0.0))) continue;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Propria: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            if (entradaSaida.equals((short)2)) {
                r.setEntSaiNatOP(0);
            } else {
                r.setEntSaiNatOP(1);
            }
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            if ((Date)h.get("dataEntSai") != null) {
                r.setDataEntSaida((Date)h.get("dataEntSai"));
            } else {
                r.setDataEntSaida(r.getDataEmissao());
            }
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            String sitDoc = r.getCodSituacaoDoc();
            boolean bl = docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (!docCancInut) {
                r.setObservacoes(this.getObservacoesBlocoC100(r.getIdentificador(), observacoes, observacoesIntFisco));
                r.setProcessosReferenciados(this.getProcessosReferenciadosBlocoC100(r.getIdentificador(), processosFiscais));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private void getItensDocumentoNotaPropriaBlocoC100Agrupados(Date dataIn, Date dataFim, String cnpjEmpresa, List<RegC100> notas, List<SpedPisCofinsIncMonofasico> aliquotasProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   p.produto.identificador as idProduto, p.produto.codigoAuxiliar as codAux, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, p.quantidadeTotal as quantidade, p.unidadeMedida.sigla as sigla, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, p.modeloFiscal.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, n.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.produto.aliquotaPis as aliquotaPisProduto, p.itemNotaLivroFiscal.vrBCPis as bcPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.produto.aliquotaCofins as aliquotaCofinsProduto, p.itemNotaLivroFiscal.vrBCCofins as bcCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, pCred.codigo as planoContaCred, pDeb.codigo as planoContaDeb, n.naturezaOperacao.entradaSaida as natEntSaida, n.identificador as idNota, nat.codigo as codNatReceitaPisCofins  from NotaFiscalPropria n inner join n.itensNotaPropria p left join p.planoContaCred pCred left join p.planoContaDeb pDeb left join p.natReceitaPisCofins nat where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa order by n.identificador, p.numeroItem");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> itens = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setIdNota((Long)h.get("idNota"));
            Long idProduto = (Long)h.get("idProduto");
            r.setCodigoItem(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setCodigoItem(codAux);
            }
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            if (h.get("movimentacaoFisica") != null) {
                Short movimentacaoFisica = (Short)h.get("movimentacaoFisica");
                if (movimentacaoFisica.equals((short)1)) {
                    r.setMovimentacaoFisica((short)0);
                } else {
                    r.setMovimentacaoFisica((short)1);
                }
            } else {
                r.setMovimentacaoFisica((short)1);
            }
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            String codNatRecPisCofins = (String)h.get("codNatReceitaPisCofins");
            for (SpedPisCofinsIncMonofasico cstMonofasico : aliquotasProduto) {
                if (!ToolMethods.isEquals((Object)cstMonofasico.getIncidenciaPisCofins().getCodigo(), (Object)r.getCstPis()) || !ToolMethods.isEquals((Object)cstMonofasico.getNatReceitaPisCofins().getCodigo(), (Object)codNatRecPisCofins)) continue;
                r.setAliqPis((Double)h.get("aliquotaPisProduto"));
                r.setAliqCofins((Double)h.get("aliquotaCofinsProduto"));
            }
            if (r.getAliqPis() > 0.0) {
                r.setVlrBCPis((Double)h.get("bcPis"));
            }
            if (r.getAliqCofins() > 0.0) {
                r.setBcCofins((Double)h.get("bcCofins"));
            }
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((String)h.get("planoContaCred"));
            r.setPlanoDeb((String)h.get("planoContaDeb"));
            itens.add(r);
        }
        for (RegC100 r : notas) {
            String sitDoc = r.getCodSituacaoDoc();
            boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
            if (docCancInut) continue;
            for (RegC170 item : itens) {
                if (!ToolMethods.isEquals((Object)r.getIdentificador(), (Object)item.getIdNota())) continue;
                r.getItensDocumento().add(item);
            }
        }
    }

    private List<Reg150> getParticipantesNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa, List<Long> notasProcessadas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf,  p.endereco.cidade.codIbge as codCidade  from NotaFiscalPropria n  inner join n.unidadeFatCliente u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idNota = (Long)h.get("identificador");
            Long idPessoa = (Long)h.get("idPessoa");
            if (!this.existeNota(idNota, notasProcessadas) || !this.pessoaNaoCadastrada(idPessoa, toRet)) continue;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC111> getProcessosReferenciadosBlocoC100(Long idNota, List<DocumentosRefProcessosPR> processos) {
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (DocumentosRefProcessosPR p : processos) {
            if (!ToolMethods.isEquals((Object)p.getGrupoDocumentosRefPR().getNotaFiscalPropria().getIdentificador(), (Object)idNota)) continue;
            RegC111 r = new RegC111();
            r.setNumeroProcesso(p.getProcessoFiscal().getNrProcesso());
            r.setCodOrigem(p.getProcessoFiscal().getTipoProcesso().getCodigo());
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa, List<Long> notasProcessadas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.codigoAuxiliar as codAux, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms, n.identificador as identificador, r.codigo as codEx from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g left join i.produto.regraExcecaoNCM r where  (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idNota = (Long)h.get("identificador");
            Long idProduto = (Long)h.get("idProduto");
            if (!this.existeNota(idNota, notasProcessadas) || !this.produtoNaoCadastrado(idProduto, toRet)) continue;
            Reg200 r = new Reg200();
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodEx((String)h.get("codEx"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa, List<Long> notasProcessadas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  n.naturezaOperacao.identificador as idNatOperacao, n.naturezaOperacao.descricao as descNatOperacao, n.identificador as identificador from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idNatOperacao = (Long)h.get("idNatOperacao");
            Long idNota = (Long)h.get("identificador");
            if (!this.existeNota(idNota, notasProcessadas) || !this.naturezaNaoCadastrada(idNatOperacao, toRet)) continue;
            Reg400 r = new Reg400();
            r.setIdNatOperacao(idNatOperacao);
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasPropriasBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa, List<Long> notasProcessadas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd, n.identificador as identificador from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            Reg190 r;
            HashMap h = (HashMap)o;
            Long idNotaPropria = (Long)h.get("identificador");
            Long idUnidMedida = (Long)h.get("idUnidMedida");
            Long idUnidMedidaProd = (Long)h.get("idUnidMedidaProd");
            if (!this.existeNota(idNotaPropria, notasProcessadas)) continue;
            if (this.unidadeNaoCadastrada(idUnidMedida, toRet)) {
                r = new Reg190();
                r.setIdUnidMedida(idUnidMedida);
                r.setCodUnidMedida((String)h.get("sigla"));
                r.setDescUnidMedida((String)h.get("descricao"));
                toRet.add(r);
            }
            if (!this.unidadeNaoCadastrada(idUnidMedidaProd, toRet)) continue;
            r = new Reg190();
            r.setIdUnidMedida(idUnidMedidaProd);
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        ArrayList<Reg500> obj = new ArrayList<Reg500>();
        obj.addAll(this.getPlanoContasNotaPropriaFatEntBlocoC100(dataIn, dataFim, cnpjEmpresa));
        obj.addAll(this.getPlanoContasNotaPropriaFatSaiBlocoC100(dataIn, dataFim, cnpjEmpresa));
        return obj;
    }

    private List<Reg500> getPlanoContasNotaPropriaFatEntBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.naturezaOperacao.entradaSaida=:ent");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setShort("ent", (short)2);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaFatSaiBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaCred.identificador as idPlanoCred, i.planoContaCred.dataCadastro as dataCadastroCred, i.planoContaCred.marca as marcaCred, i.planoContaCred.codigo as codContaCred, i.planoContaCred.descricao as descricaoContaCred, i.planoContaCred.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 ) and n.naturezaOperacao.entradaSaida=:sai");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setShort("sai", (short)1);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private boolean existeNota(Long idNota, List<Long> idsNotasProcessadas) {
        for (Long id : idsNotasProcessadas) {
            if (!ToolMethods.isEquals((Object)idNota, (Object)id)) continue;
            return true;
        }
        return false;
    }

    private boolean pessoaNaoCadastrada(Long idPessoa, List<Reg150> toRet) {
        for (Reg150 reg150 : toRet) {
            if (!ToolMethods.isEquals((Object)idPessoa, (Object)reg150.getIdPessoa())) continue;
            return false;
        }
        return true;
    }

    private boolean produtoNaoCadastrado(Long idProduto, List<Reg200> toRet) {
        for (Reg200 reg200 : toRet) {
            if (!ToolMethods.isEquals((Object)idProduto, (Object)reg200.getIdentificador())) continue;
            return false;
        }
        return true;
    }

    private boolean naturezaNaoCadastrada(Long idNatOperacao, List<Reg400> toRet) {
        for (Reg400 reg400 : toRet) {
            if (!ToolMethods.isEquals((Object)idNatOperacao, (Object)reg400.getIdNatOperacao())) continue;
            return false;
        }
        return true;
    }

    private boolean unidadeNaoCadastrada(Long idUnidMedida, List<Reg190> toRet) {
        for (Reg190 reg190 : toRet) {
            if (!ToolMethods.isEquals((Object)idUnidMedida, (Object)reg190.getIdUnidMedida())) continue;
            return false;
        }
        return true;
    }

    private List<ObservacaoIntFiscalNotaFiscalPropria> getObservacoesIntFiscoBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct ob from ObservacaoIntFiscalNotaFiscalPropria ob  inner join ob.notaFiscalPropria n  where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4)  and n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa";
        Query q = s.createQuery(hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        List ret = q.list();
        return ret;
    }

    private List<ObservacaoNotaPropria> getObservacoesBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct ob  from ObservacaoNotaPropria ob  inner join ob.notaFiscalPropria n  where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4)  and n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa";
        Query q = s.createQuery(hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        List ret = q.list();
        return ret;
    }

    private List<RegC110> getObservacoesBlocoC100(Long idNota, List<ObservacaoNotaPropria> observacoes, List<ObservacaoIntFiscalNotaFiscalPropria> observacoesIntFisco) {
        ArrayList<Long> temp = new ArrayList<Long>();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        for (ObservacaoIntFiscalNotaFiscalPropria observacaoIntFiscalNotaFiscalPropria : observacoesIntFisco) {
            if (!ToolMethods.isEquals((Object)observacaoIntFiscalNotaFiscalPropria.getNotaFiscalPropria().getIdentificador(), (Object)idNota) || temp.contains(observacaoIntFiscalNotaFiscalPropria.getObsFaturamento().getIdentificador())) continue;
            Object comp = "";
            for (Object obj : observacaoIntFiscalNotaFiscalPropria.getTokens()) {
                TokenObsIntFisco t = (TokenObsIntFisco)obj;
                comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
            }
            RegC110 r = new RegC110();
            r.setDescricao(observacaoIntFiscalNotaFiscalPropria.getObsFaturamento().getNome());
            r.setIdObservacao(observacaoIntFiscalNotaFiscalPropria.getObsFaturamento().getIdentificador());
            r.setTexto((String)comp);
            toRet.add(r);
            temp.add(observacaoIntFiscalNotaFiscalPropria.getObsFaturamento().getIdentificador());
        }
        for (ObservacaoNotaPropria observacaoNotaPropria : observacoes) {
            if (!ToolMethods.isEquals((Object)observacaoNotaPropria.getNotaFiscalPropria().getIdentificador(), (Object)idNota) || temp.contains(observacaoNotaPropria.getObsFaturamento().getIdentificador())) continue;
            RegC110 r = new RegC110();
            r.setDescricao(observacaoNotaPropria.getObsFaturamento().getNome());
            r.setIdObservacao(observacaoNotaPropria.getObsFaturamento().getIdentificador());
            r.setTexto(observacaoNotaPropria.getConteudo());
            toRet.add(r);
            temp.add(observacaoNotaPropria.getObsFaturamento().getIdentificador());
        }
        return toRet;
    }

    private List<DocumentosRefProcessosPR> getProcessosReferenciadosBlocoC100(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct d  from DocumentosRefProcessosPR d inner join d.grupoDocumentosRefPR g  inner join g.notaFiscalPropria n  where  (n.modeloDocFiscal.codigo=:cod1 or  n.modeloDocFiscal.codigo=:cod2 or   n.modeloDocFiscal.codigo=:cod3 or  n.modeloDocFiscal.codigo=:cod4)  and n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa";
        Query q = s.createQuery(hql);
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        List ret = q.list();
        return ret;
    }
}

