/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blococ;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg190;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg200;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC380;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC381;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC385;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC380NotaPropria {
    private Boolean utilizaCodAux = false;

    public BlocoC getBlocoC380NotasProprias(Date dataIn, Date dataFim, String cnpjEmpresa, Boolean utilizaCodAux) {
        this.utilizaCodAux = utilizaCodAux;
        BlocoC b = new BlocoC();
        b.setRegistrosC380(this.getNotasFiscaisPropriasBlocoC380(dataIn, dataFim, cnpjEmpresa));
        if (b.getRegistrosC380() != null && !b.getRegistrosC380().isEmpty()) {
            b.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC380(dataIn, dataFim, cnpjEmpresa));
            b.setUnidadeMedidas(this.getUnidMedidasNotasFiscaisPropriasBlocoC380(dataIn, dataFim, cnpjEmpresa));
            b.setPlanoContas(this.getPlanoContasNotasFiscaisPropriasBlocoC380(dataIn, dataFim, cnpjEmpresa));
        }
        return b;
    }

    private List<RegC380> getNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select n.situacaoDocumento.codigo as situacaoDocumento, sum(n.valoresNfPropria.valorTotal) as valorTotal, max(n.numeroNota) as numeroNotaFim, min(n.numeroNota) as numeroNotaIn from NotaFiscalPropria n  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa group by n.situacaoDocumento.codigo");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC380> toRet = new ArrayList<RegC380>();
        Double valorTotal = 0.0;
        Double valorCancelado = 0.0;
        Integer numInicial = 9999999;
        Integer numFinal = 0;
        for (Object o : ret) {
            boolean cancelado;
            HashMap h = (HashMap)o;
            String codSitDoc = (String)h.get("situacaoDocumento");
            boolean bl = cancelado = codSitDoc.equals("02") || codSitDoc.equals("03");
            if (cancelado) {
                valorCancelado = valorCancelado + (Double)h.get("valorTotal");
            } else {
                valorTotal = valorTotal + (Double)h.get("valorTotal");
            }
            if ((Integer)h.get("numeroNotaIn") < numInicial) {
                numInicial = (Integer)h.get("numeroNotaIn");
            }
            if ((Integer)h.get("numeroNotaFim") <= numFinal) continue;
            numFinal = (Integer)h.get("numeroNotaFim");
        }
        if (ret != null && !ret.isEmpty()) {
            RegC380 r = new RegC380();
            r.setCodModDocFiscal("02");
            r.setDataInicial(dataIn);
            r.setDataFinal(dataFim);
            r.setNumDocInicial(numInicial);
            r.setNumDocFinal(numFinal);
            r.setValorCancelado(valorCancelado);
            r.setValorTotal(valorTotal);
            r.setPis(this.getPisNotasFiscaisBlocoC381(dataIn, dataFim, cnpjEmpresa));
            r.setCofins(this.getCofinsNotasFiscaisBlocoC385(dataIn, dataFim, cnpjEmpresa));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC381> getPisNotasFiscaisBlocoC381(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  p.identificador as idProduto, p.codigoAuxiliar as codAux, i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorItem, sum(i.itemNotaLivroFiscal.vrBCPis) as valorBcPis, i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis, pc.codigo as planoConta from NotaFiscalPropria n inner join n.itensNotaPropria i inner join i.produto p left join p.planoConta pc  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa  and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)  group by i.incidenciaPisCofins.codigo,  i.itemNotaLivroFiscal.aliquotaPis, p.identificador, pc.codigo, p.codigoAuxiliar";
        Query q = s.createQuery(hql);
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC381> toRet = new ArrayList<RegC381>();
        ArrayList planos = new ArrayList();
        for (Object o : ret) {
            RegC381 r = new RegC381();
            HashMap h = (HashMap)o;
            r.setCstPis((String)h.get("codIncidenciaPis"));
            Long idProduto = (Long)h.get("idProduto");
            r.setCodItem(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setCodItem(codAux);
            }
            r.setValorItem((Double)h.get("valorItem"));
            r.setValoBCPis((Double)h.get("valorBcPis"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("valorPis"));
            if ((String)h.get("planoConta") != null) {
                r.setCodContaAnalitica((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC385> getCofinsNotasFiscaisBlocoC385(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select  p.identificador as idProduto, p.codigoAuxiliar as codAux, i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorItem, sum(i.itemNotaLivroFiscal.vrBCCofins) as valorBcCofins, i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, pc.codigo as planoConta from NotaFiscalPropria n inner join n.itensNotaPropria i  inner join i.produto p  left  join p.planoConta pc where (n.modeloDocFiscal.codigo=:cod1) and  n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa  and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)  group by i.incidenciaPisCofins.codigo,  i.itemNotaLivroFiscal.aliquotaCofins, p.identificador,  pc.codigo, p.codigoAuxiliar";
        Query q = s.createQuery(hql);
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC385> toRet = new ArrayList<RegC385>();
        for (Object o : ret) {
            RegC385 r = new RegC385();
            HashMap h = (HashMap)o;
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            Long idProduto = (Long)h.get("idProduto");
            r.setCodItem(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setCodItem(codAux);
            }
            r.setValorItem((double)((Double)h.get("valorItem")));
            r.setValoBCCofins((double)((Double)h.get("valorBcCofins")));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((double)((Double)h.get("valorCofins")));
            if ((String)h.get("planoConta") != null) {
                r.setCodContaAnalitica((String)h.get("planoConta"));
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.codigoAuxiliar as codAux, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms, r.codigo as codEx from NotaFiscalPropria n  inner join n.itensNotaPropria i left join i.produto.ncm nc left join i.produto.genero g left join i.produto.regraExcecaoNCM r where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)");
        q.setString("cod1", "02");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            Long idProduto = (Long)h.get("idProduto");
            r.setIdCodAuxProduto(idProduto.toString());
            r.setIdentificador(idProduto.toString());
            String codAux = (String)h.get("codAux");
            if (this.utilizaCodAux.booleanValue() && codAux != null && !codAux.isEmpty()) {
                r.setIdCodAuxProduto(codAux);
            }
            r.setTipoItemProdServ((short)0);
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setCodEx((String)h.get("codEx"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao from NotaFiscalPropria n  inner join n.itensNotaPropria i where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.situacaoDocumento.codigo = :codSitDoc1 or n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5)");
        q.setString("cod1", "02");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotasFiscaisPropriasBlocoC380(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct pc.identificador as idPlanoConta, pc.marca as marca, pc.descricao as descricao, pc.codigo as codigo, pc.dataCadastro as dataCadastro, pc.naturezaOperacaoPC.codigo as natOpPC from NotaFiscalPropria n inner join n.itensNotaPropria i inner join i.produto p inner join p.planoConta pc  where (n.modeloDocFiscal.codigo=:cod1) and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa  and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5) ";
        Query q = s.createQuery(hql);
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            Reg500 r = new Reg500();
            HashMap h = (HashMap)o;
            r.setIdPlanoContas((Long)h.get("idPlanoConta"));
            r.setDescricao((String)h.get("descricao"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codigo"));
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

