/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blococ;

import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg150;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.BlocoC;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC501;
import mentorcore.service.impl.spedpiscofins.versao006.model.blococ.RegC505;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoC500NotaTerceiros {
    public BlocoC getBlocoC500NotasTerceiros(Date dataIn, Date dataFim, String cnpjEmpresa) {
        BlocoC b = new BlocoC();
        b.setRegistrosC500(this.getNotasFiscaisTerceirosBlocoC500(dataIn, dataFim, cnpjEmpresa, b));
        if (b.getRegistrosC500() != null && !b.getRegistrosC500().isEmpty()) {
            b.setParticipantes(this.getParticipantesNotaTerceirosBlocoC500(dataIn, dataFim, cnpjEmpresa));
        }
        return b;
    }

    private List<RegC500> getNotasFiscaisTerceirosBlocoC500(Date dataIn, Date dataFim, String cnpjEmpresa, BlocoC blocoC) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.unidadeFatFornecedor.pessoa.identificador as idPessoa, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNFe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorIcms as valorIcms, n.valoresNfTerceiros.valorPis as valorPis, n.valoresNfTerceiros.valorCofins as valorCofins, n.identificador as identificador from NotaFiscalTerceiros n inner join n.livrosFiscais lv  where  n.dataEntrada between :dataIn and :dataFim  and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.valoresNfTerceiros.valorPis > 0 or n.valoresNfTerceiros.valorCofins >0) and (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2  or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or (n.modeloDocFiscal.codigo=:cod5 and (exists(select it.identificador from ItemNotaTerceiros it  where it.notaFiscalTerceiros = n  and it.itemNotaLivroFiscal.cfop.cfopEnergiaEletrica = :sim )))) ");
        q.setString("cod1", "06");
        q.setString("cod2", "29");
        q.setString("cod3", "28");
        q.setString("cod4", "66");
        q.setString("cod5", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC500> toRet = new ArrayList<RegC500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC500 r = new RegC500();
            r.setIdentificador((Long)h.get("identificador"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setSerie((String)h.get("serie"));
            r.setChaveNFe((String)h.get("chaveNFe"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setNumeroDoc((Integer)h.get("numNota"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("valorIcms"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorCofins((Double)h.get("valorCofins"));
            Reg500 pc = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(pc);
            String codPlanoConta = "";
            if (pc != null && pc.getCodigo() != null) {
                codPlanoConta = pc.getCodigo();
                blocoC.getPlanoContas().add(pc);
            }
            r.setPis(this.getPisBlocoC501(r.getIdentificador(), codPlanoConta));
            r.setCofins(this.getCofinsBlocoC505(r.getIdentificador(), codPlanoConta));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC501> getPisBlocoC501(Long idNota, String codPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select i.incidenciaPisCofins.codigo as codIncidenciaPis, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, i.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, sum(i.itemNotaLivroFiscal.vrPis) as valorPis,  sum(i.itemNotaLivroFiscal.vrBCPis) as valorBCPis,  nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaPis, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC501> toRet = new ArrayList<RegC501>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC501 r = new RegC501();
            r.setCstPis((String)h.get("codIncidenciaPis"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCPis((Double)h.get("valorBCPis"));
            r.setAliquotaPis((Double)h.get("aliquotaPis"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            r.setPlanoDeb(codPlanoConta);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC505> getCofinsBlocoC505(Long idNota, String codPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select i.incidenciaPisCofins.codigo as codIncidenciaCofins, sum(i.itemNotaLivroFiscal.valorTotal) as valorTotal, i.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, sum(i.itemNotaLivroFiscal.vrCofins) as valorCofins, sum(i.itemNotaLivroFiscal.vrBCCofins) as valorBCCofins, nat.codigo as natBCCredito from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i left join i.naturezaBCCredito nat where n.identificador  = :idNota group by i.incidenciaPisCofins.codigo, i.itemNotaLivroFiscal.aliquotaCofins, nat.codigo");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC505> toRet = new ArrayList<RegC505>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC505 r = new RegC505();
            r.setCstCofins((String)h.get("codIncidenciaCofins"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValoBCCofins((Double)h.get("valorBCCofins"));
            r.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setNatBCCredito((String)h.get("natBCCredito"));
            r.setPlanoDeb(codPlanoConta);
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }

    private List<Reg150> getParticipantesNotaTerceirosBlocoC500(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3  or n.modeloDocFiscal.codigo=:cod4)  and n.dataEntrada between :dataIn and :dataFim and n.empresa.pessoa.complemento.cnpj=:cnpjEmpresa and (n.valoresNfTerceiros.valorPis >0 or n.valoresNfTerceiros.valorCofins > 0)");
        q.setString("cod1", "06");
        q.setString("cod2", "28");
        q.setString("cod3", "29");
        q.setString("cod4", "66");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private Reg500 getPlanoContaNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select lv.planoConta as planoConta from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            PlanoConta pc = (PlanoConta)h.get("planoConta");
            if (pc == null) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(pc.getIdentificador());
            r.setCodigo(pc.getCodigo());
            r.setDescricao(pc.getDescricao());
            r.setDataInclusao(pc.getDataCadastro());
            r.setMarca(pc.getMarca());
            r.setCodNaturezaContaSped(pc.getNaturezaOperacaoPC().getCodigo());
            return r;
        }
        return null;
    }
}

