/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blocof;

import com.touchcomp.basementor.model.vo.BemSpedPisCofins;
import com.touchcomp.basementor.model.vo.MovBemSpedPisCofins;
import com.touchcomp.basementor.model.vo.ProcessoFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg600;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF120;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF129;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoF120 {
    public BlocoF getRegistrosBlocoF120(String cnpjEmpresa, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF120(this.getRegistrosBlocoF120(dataIn, dataFim, cnpjEmpresa));
        if (f.getRegistrosF120() != null && !f.getRegistrosF120().isEmpty()) {
            f.setCentroCustos(this.getCentroCustosRegistrosF120(dataIn, dataFim, cnpjEmpresa));
            f.setPlanoContas(this.getPlanoContasRegistrosF120(dataIn, dataFim, cnpjEmpresa));
        }
        return f;
    }

    private List<RegF120> getRegistrosBlocoF120(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct m as MOV_BEM_PIS_COFINS from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.periodo between :dataIn and :dataFim and c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa.pessoa.complemento.cnpj = :cnpjEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegF120> toRet = new ArrayList<RegF120>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            MovBemSpedPisCofins m = (MovBemSpedPisCofins)h.get("MOV_BEM_PIS_COFINS");
            BemSpedPisCofins b = m.getBemSpedPisCofins();
            RegF120 r = new RegF120();
            r.setCodNatBcCredito(b.getNaturezaBCCredito().getCodigo());
            r.setCodIdenBemImobilizado(b.getIdenBemImobilizado().getCodigo());
            r.setCodIndUtilizacaoBemImobilizado(b.getIndUtilBemImobilizado().getCodigo());
            r.setCodIndOrigemCredito(b.getIndOrigCredBemPisCofins().getCodigo());
            r.setValorOperacao(m.getVrOperDep());
            r.setParcelaOperNaoBcCred(m.getParcOperNaoBcCred());
            r.setCodIncidenciaPis(b.getCstPis().getCodigo());
            r.setValorBcPis(m.getVrBcPis());
            r.setValorPis(m.getVrPis());
            r.setAliquotaPis(b.getAliquotaPis());
            r.setCodIncidenciaCofins(b.getCstCofins().getCodigo());
            r.setValorBcCofins(m.getVrBcCofins());
            r.setValorCofins(m.getVrCofins());
            r.setAliquotaCofins(b.getAliquotaCofins());
            if (b.getPlanoConta() != null) {
                r.setCodPlanoConta(b.getPlanoConta().getCodigo());
            }
            if (b.getBem().getCentroCusto() != null) {
                r.setCodCentroCusto(b.getBem().getCentroCusto().getCodigo());
            }
            r.setDescricaoBemImobilizado(b.getDescricaoBemImobilizado());
            r.setProcessosReferenciados(this.getProcessosReferenciadosF129(b.getProcessoFiscal()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasRegistrosF120(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.planoConta.identificador as idPlano, m.bemSpedPisCofins.planoConta.dataCadastro as dataCadastro, m.bemSpedPisCofins.planoConta.marca as marca, m.bemSpedPisCofins.planoConta.codigo as codConta, m.bemSpedPisCofins.planoConta.descricao as descricaoConta, m.bemSpedPisCofins.planoConta.naturezaOperacaoPC.codigo as natOpPC from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.periodo between :dataIn and :dataFim and c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa.pessoa.complemento.cnpj = :cnpjEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlano");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoConta"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codConta"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg600> getCentroCustosRegistrosF120(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.bem.centroCusto.identificador as idCentroCusto, m.bemSpedPisCofins.bem.centroCusto.dataCadastro as dataCadastro, m.bemSpedPisCofins.bem.centroCusto.codigo as codCentroCusto, m.bemSpedPisCofins.bem.centroCusto.nome as descricaoCentroCusto from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.periodo between :dataIn and :dataFim and c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa.pessoa.complemento.cnpj = :cnpjEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg600> toRet = new ArrayList<Reg600>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCentroCusto = (Long)h.get("idCentroCusto");
            if (idCentroCusto == null || idCentroCusto <= 0L) continue;
            Reg600 r = new Reg600();
            r.setIdCentroCusto(idCentroCusto);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoCentroCusto"));
            r.setCodigo((String)h.get("codCentroCusto"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getProcessosReferenciadosF129(ProcessoFiscal processoFiscal) {
        ArrayList<RegF129> lista = new ArrayList<RegF129>();
        if (processoFiscal != null) {
            RegF129 r = new RegF129();
            r.setCodOrigem(processoFiscal.getTipoProcesso().getCodigo());
            r.setNumeroProcesso(processoFiscal.getNrProcesso());
            lista.add(r);
        }
        return lista;
    }
}

