/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blocof;

import com.touchcomp.basementor.model.vo.BemSpedPisCofins;
import com.touchcomp.basementor.model.vo.MovBemSpedPisCofins;
import com.touchcomp.basementor.model.vo.ProcessoFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg600;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF130;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF139;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoF130 {
    public BlocoF getRegistrosBlocoF130(String cnpjEmpresa, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF130(this.getRegistrosBlocoF130(dataIn, dataFim, cnpjEmpresa));
        if (f.getRegistrosF130() != null && !f.getRegistrosF130().isEmpty()) {
            f.setPlanoContas(this.getPlanoContasRegistrosF130(dataIn, dataFim, cnpjEmpresa));
            f.setCentroCustos(this.getCentroCustosRegistrosF130(dataIn, dataFim, cnpjEmpresa));
        }
        return f;
    }

    private List<RegF130> getRegistrosBlocoF130(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct m as MOV_BEM_PIS_COFINS from DepreciacaoCiap c  inner join c.itemCiapDepreciacaoBaixaBem i inner join i.movBemSpedPisCofins m where c.periodo between :dataIn and :dataFim and c.empresa.pessoa.complemento.cnpj=:cnpjEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegF130> toRet = new ArrayList<RegF130>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            MovBemSpedPisCofins m = (MovBemSpedPisCofins)h.get("MOV_BEM_PIS_COFINS");
            BemSpedPisCofins b = m.getBemSpedPisCofins();
            RegF130 r = new RegF130();
            r.setCodNatBcCredito(b.getNaturezaBCCredito().getCodigo());
            r.setCodIdenBemImobilizado(b.getIdenBemImobilizado().getCodigo());
            r.setCodIndUtilizacaoBemImobilizado(b.getIndUtilBemImobilizado().getCodigo());
            r.setCodIndOrigemCredito(b.getIndOrigCredBemPisCofins().getCodigo());
            r.setValorOperacao(b.getVrOperAquis());
            r.setMesAnoOperacao(b.getMesOperAquis());
            r.setParcelaOperNaoBcCred(m.getParcOperNaoBcCred());
            r.setVrBcCredito(m.getVrBcCred());
            if (b.getIndNrParcela() != null) {
                r.setCodIndNrParcelas(b.getIndNrParcela().getCodigo());
            }
            r.setCodIncidenciaPis(b.getCstPis().getCodigo());
            r.setValorBcPis(m.getVrBcPis());
            r.setValorPis(m.getVrPis());
            r.setAliquotaPis(b.getAliquotaPis());
            r.setCodIncidenciaCofins(b.getCstCofins().getCodigo());
            r.setValorBcCofins(m.getVrBcCofins());
            r.setValorCofins(m.getVrCofins());
            r.setAliquotaCofins(b.getAliquotaCofins());
            r.setDescricaoBemImobilizado(b.getDescricaoBemImobilizado());
            r.setProcessosReferenciados(this.getProcessosReferenciadosF139(b.getProcessoFiscal()));
            if (b.getPlanoConta() != null) {
                r.setCodPlanoConta(b.getPlanoConta().getCodigo());
            }
            if (b.getBem().getCentroCusto() != null) {
                r.setCodCentroCusto(b.getBem().getCentroCusto().getCodigo());
            }
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasRegistrosF130(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.planoConta.identificador as idPlano, m.bemSpedPisCofins.planoConta.dataCadastro as dataCadastro, m.bemSpedPisCofins.planoConta.marca as marca, m.bemSpedPisCofins.planoConta.codigo as codConta, m.bemSpedPisCofins.planoConta.descricao as descricaoConta, m.bemSpedPisCofins.planoConta.naturezaOperacaoPC.codigo as natOpPC from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.periodo between :dataIn and :dataFim and c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa.pessoa.complemento.cnpj = :cnpjEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlano");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoConta"));
            r.setMarca((Integer)h.get("marca"));
            r.setCodigo((String)h.get("codConta"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg600> getCentroCustosRegistrosF130(Date dataIn, Date dataFim, String cnpjEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  m.bemSpedPisCofins.bem.centroCusto.identificador as idCentroCusto, m.bemSpedPisCofins.bem.centroCusto.dataCadastro as dataCadastro, m.bemSpedPisCofins.bem.centroCusto.codigo as codCentroCusto, m.bemSpedPisCofins.bem.centroCusto.nome as descricaoCentroCusto from DepreciacaoBem c inner join c.movBemSpedPisCofins m where c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.periodo between :dataIn and :dataFim and c.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa.pessoa.complemento.cnpj = :cnpjEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg600> toRet = new ArrayList<Reg600>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCentroCusto = (Long)h.get("idCentroCusto");
            if (idCentroCusto == null || idCentroCusto <= 0L) continue;
            Reg600 r = new Reg600();
            r.setIdCentroCusto(idCentroCusto);
            r.setDataInclusao((Date)h.get("dataCadastro"));
            r.setDescricao((String)h.get("descricaoCentroCusto"));
            r.setCodigo((String)h.get("codCentroCusto"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getProcessosReferenciadosF139(ProcessoFiscal processoFiscal) {
        ArrayList<RegF139> lista = new ArrayList<RegF139>();
        if (processoFiscal != null) {
            RegF139 r = new RegF139();
            r.setCodOrigem(processoFiscal.getTipoProcesso().getCodigo());
            r.setNumeroProcesso(processoFiscal.getNrProcesso());
            lista.add(r);
        }
        return lista;
    }
}

