/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedpiscofins.versao006.util.blocof;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedpiscofins.versao006.model.Reg500;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.BlocoF;
import mentorcore.service.impl.spedpiscofins.versao006.model.blocof.RegF550;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDBlocoF550 {
    public BlocoF getRegistrosBlocoF550(String cnpjEmpresa, Date dataIn, Date dataFim) {
        BlocoF f = new BlocoF();
        f.setRegistrosF550(this.getRegistrosF550(cnpjEmpresa, dataIn, dataFim));
        f.setPlanoContas(this.getPlanoContasRegF550(cnpjEmpresa, dataIn, dataFim));
        return f;
    }

    private List<RegF550> getRegistrosF550(String cnpjEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorTotal) as VALOR_REC_AUFERIDA, lv.incidenciaPis.codigo as COD_INC_PIS, sum(lv.valorPis) as VALOR_PIS,  sum(lv.vrBCPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS, lv.incidenciaCofins.codigo as COD_INC_COFINS, sum(lv.valorCofins) as VALOR_COFINS,  sum(lv.vrBCCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS,  pc.codigo as PLANO_CONTA from LivroFiscal lv  left join lv.planoConta pc where lv.dataLivro between :dataIn and :dataFim and lv.empresa.pessoa.complemento.cnpj = :cnpjEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :nao and lv.cfop.cfopReceitaVendaSped = :sim and (lv.incidenciaPis.codigo <> :outrasSaidas and lv.incidenciaPis.codigo <> :outrasEntradas) and (lv.incidenciaCofins.codigo <> :outrasSaidas and lv.incidenciaCofins.codigo <> :outrasEntradas) group by lv.incidenciaPis.codigo, lv.aliquotaPis, lv.incidenciaCofins.codigo, lv.aliquotaCofins, pc.codigo");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cancelado", (short)0);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setString("outrasSaidas", "49");
        q.setString("outrasEntradas", "98");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegF550> toRet = new ArrayList<RegF550>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegF550 r = new RegF550();
            r.setValorReceitaAuferida((Double)h.get("VALOR_REC_AUFERIDA"));
            r.setCstPis((String)h.get("COD_INC_PIS"));
            r.setValorPis((Double)h.get("VALOR_PIS"));
            r.setValorBCPis((Double)h.get("VALOR_BC_PIS"));
            r.setAliqPis((Double)h.get("ALIQ_PIS"));
            r.setCstCofins((String)h.get("COD_INC_COFINS"));
            r.setValorCofins((Double)h.get("VALOR_COFINS"));
            r.setValorBCCofins((Double)h.get("VALOR_BC_COFINS"));
            r.setAliqCofins((Double)h.get("ALIQ_COFINS"));
            r.setValorDescontoCofins(0.0);
            r.setValorDescontoPis(0.0);
            r.setCodConta((String)h.get("PLANO_CONTA"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasRegF550(String cnpjEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  pc.identificador as idPlanoDeb, pc.dataCadastro as dataCadastroDeb, pc.marca as marcaDeb, pc.codigo as codContaDeb, pc.descricao as descricaoContaDeb, pc.naturezaOperacaoPC.codigo as natOpPC from LivroFiscal lv  inner join lv.planoConta pc   where lv.dataLivro between :dataIn and :dataFim and lv.empresa.pessoa.complemento.cnpj = :cnpjEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :nao and (lv.incidenciaPis.codigo <> :outrasSaidas and lv.incidenciaPis.codigo <> :outrasEntradas) and (lv.incidenciaCofins.codigo <> :outrasSaidas and lv.incidenciaCofins.codigo <> :outrasEntradas)");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setString("cnpjEmpresa", cnpjEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cancelado", (short)0);
        q.setShort("nao", (short)0);
        q.setString("outrasSaidas", "49");
        q.setString("outrasEntradas", "98");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoDeb");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNaturezaContaSped((String)h.get("natOpPC"));
            toRet.add(r);
        }
        return toRet;
    }
}

